/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ReTransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dao.SysActEntrustMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dto.TransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.impl.ActivityRedisTimerServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysActEntrustServiceImpl
extends ServiceImpl<SysActEntrustMapper, SysActEntrust>
implements ISysActEntrustService {
    private static final Logger logger = LoggerFactory.getLogger(SysActEntrustServiceImpl.class);
    @Resource
    SysActEntrustMapper sysActEntrustMapper;
    @Resource
    ISysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;
    @Autowired
    private ActivityRedisTimerServiceImpl activityRedisTimerService;
    @Autowired
    private BpmMsgPushService msgPushService;
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    public ApiResponse<IPage<SysActEntrust>> initList(Page<SysActEntrust> pages, String userId, String processKey, String state, Date startTime, Date endTime) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BpmException(BpmExceptionCodeEnum.USER_ID_NULL);
        }
        this.queryEntrustByPage(pages, userId, processKey, state);
        return ApiResponse.success(pages);
    }

    public BpmResponseResult list(Page<SysActEntrust> pages, String userId, String processKey, String state) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)"\u7528\u6237ID\u4e3a\u7a7a", null);
        }
        this.queryEntrustByPage(pages, userId, processKey, state);
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)pages.getRecords());
        jsonArray.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private void queryEntrustByPage(Page<SysActEntrust> pages, String userId, String processKey, String state) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = "";
        Date date = new Date();
        if (HussarUtils.isNotEmpty((Object)date)) {
            now = sdf.format(date);
        }
        List<Object> sysActEntrustList = new ArrayList();
        sysActEntrustList = "0".equals(state) ? this.sysActEntrustMapper.getListByState(pages, userId, processKey, state, now) : ("1".equals(state) ? this.sysActEntrustMapper.getListByStateOne(pages, userId, processKey, state, now) : ((Page)this.sysActEntrustService.page(pages, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(HussarUtils.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey)).eq(SysActEntrust::getMandator, (Object)userId)).eq(HussarUtils.isNotEmpty((Object)state), SysActEntrust::getState, (Object)state))).getRecords());
        ArrayList<String> userName = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        HashMap<String, List<String>> taskDefinitionKey = new HashMap<String, List<String>>();
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            userName.add(sysActEntrust.getMandator());
            userName.add(sysActEntrust.getMandatary());
            processKeys.add(sysActEntrust.getProcessKey());
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            if (!taskDefinitionKey.containsKey(sysActEntrust.getProcessKey())) {
                taskDefinitionKey.put(sysActEntrust.getProcessKey(), new ArrayList());
            }
            ((List)taskDefinitionKey.get(sysActEntrust.getProcessKey())).add(sysActEntrust.getTaskDefinitionKey());
        }
        Map userMap = this.assigneeChooseService.getUserListByUserId(userName);
        Map map = this.modelService.selectModelNames(processKeys);
        map.put("hussar_entire_process", "\u5168\u90e8");
        Map<String, Map<String, String>> nodeMap = this.getTaskDefinitionNames(taskDefinitionKey);
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            sysActEntrust.setMandatorName((String)userMap.get(sysActEntrust.getMandator()));
            sysActEntrust.setMandataryName((String)userMap.get(sysActEntrust.getMandatary()));
            sysActEntrust.setProcessName((String)map.get(sysActEntrust.getProcessKey()));
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            sysActEntrust.setTaskDefinitionName(nodeMap.get(sysActEntrust.getProcessKey()).get(sysActEntrust.getTaskDefinitionKey()));
        }
        pages.setRecords(sysActEntrustList);
    }

    public BpmResponseResult add(String processKey, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask, String messageType) {
        return this.add(processKey, null, mandator, mandatary, state, startTime, endTime, isTransferTask, messageType);
    }

    public BpmResponseResult add(String processKey, String taskDefKey, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask, String messageType) {
        SysActEntrust sysActEntrust = new SysActEntrust(processKey, mandator, mandatary, state, startTime, endTime);
        HashSet<String> taskDefinitionKey = null;
        if (HussarUtils.isNotEmpty((Object)taskDefKey)) {
            taskDefinitionKey = new HashSet<String>(Arrays.asList(taskDefKey.split(",")));
        }
        LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey())).lt(SysActEntrust::getStartTime, (Object)sysActEntrust.getEndTime())).gt(SysActEntrust::getEndTime, (Object)sysActEntrust.getStartTime());
        if ("1".equals(sysActEntrust.getState())) {
            ew.eq(SysActEntrust::getState, (Object)"1");
        }
        if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
            ew.in(SysActEntrust::getTaskDefinitionKey, taskDefinitionKey);
        } else {
            ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        }
        List list = this.sysActEntrustService.list((Wrapper)ew);
        if (HussarUtils.isEmpty(taskDefinitionKey)) {
            if (!list.isEmpty()) {
                return InstallResult.fail((String)this.bpmConstantProperties.getExistMandatary());
            }
            this.pushEntrustMessage(startTime, endTime, mandatary, messageType, Collections.singletonList(processKey));
            this.sysActEntrustService.save((Object)sysActEntrust.setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType));
            if (isTransferTask) {
                this.transferTask(mandatary, mandator, processKey, taskDefinitionKey);
            }
        } else {
            HashSet<String> illegalTaskDefKey = new HashSet<String>();
            for (SysActEntrust sysActEntrust1 : list) {
                if (!taskDefinitionKey.remove(sysActEntrust1.getTaskDefinitionKey())) continue;
                illegalTaskDefKey.add(sysActEntrust1.getTaskDefinitionKey());
            }
            if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
                ArrayList<SysActEntrust> sysActEntrustList = new ArrayList<SysActEntrust>();
                for (String taskDefKeyStr : taskDefinitionKey) {
                    SysActEntrust entrust = new SysActEntrust(sysActEntrust).setTaskDefinitionKey(taskDefKeyStr).setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType);
                    sysActEntrustList.add(entrust);
                }
                this.pushEntrustMessage(startTime, endTime, mandatary, messageType, Collections.singletonList(processKey));
                this.saveBatch(sysActEntrustList);
                if (isTransferTask) {
                    this.transferTask(mandatary, mandator, processKey, taskDefinitionKey);
                }
            }
            if (HussarUtils.isNotEmpty(illegalTaskDefKey)) {
                String illegalTaskDefKeyStr = String.join((CharSequence)",", this.getTaskDefinitionName(processKey, illegalTaskDefKey).values());
                return InstallResult.fail((String)("\u8282\u70b9" + illegalTaskDefKeyStr + this.bpmConstantProperties.getActiveEntrustExist()));
            }
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public BpmResponseResult addBatch(String processKeys, String mandator, String mandatary, String state, String startTime, String endTime, boolean isTransferTask, String messageType, String companyCode, String companyName, String mandatorName, String mandataryName) {
        if (HussarUtils.isEmpty((Object)processKeys)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (mandator.equals(mandatary)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getEntrustOneselfFail());
        }
        HashSet<String> processIds = new HashSet<String>(Arrays.asList(processKeys.split(",")));
        Date now = new Date();
        LambdaQueryWrapper entrustWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)mandator)).eq(SysActEntrust::getCompanyCode, (Object)companyCode)).eq(SysActEntrust::getCompanyName, (Object)companyName)).in(SysActEntrust::getProcessKey, processIds)).eq("1".equals(state), SysActEntrust::getState, (Object)"1")).gt(SysActEntrust::getEndTime, (Object)now);
        List actEntrusts = this.list((Wrapper)entrustWrapper);
        if (HussarUtils.isNotEmpty((Object)actEntrusts)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getActiveProcessEntrustExist());
        }
        Timestamp startTimeStamp = Timestamp.valueOf(startTime);
        Timestamp endTimeStamp = Timestamp.valueOf(endTime);
        LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)mandator)).eq(SysActEntrust::getCompanyCode, (Object)companyCode)).eq(SysActEntrust::getCompanyName, (Object)companyName)).in(SysActEntrust::getProcessKey, processIds)).lt(SysActEntrust::getStartTime, (Object)endTimeStamp)).gt(SysActEntrust::getEndTime, (Object)startTimeStamp)).eq("1".equals(state), SysActEntrust::getState, (Object)"1")).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        List sysActEntrustList = this.list((Wrapper)ew);
        ArrayList<String> illegalProcessKey = new ArrayList<String>();
        for (Object sysActEntrust : sysActEntrustList) {
            if (!processIds.remove(sysActEntrust.getProcessKey())) continue;
            illegalProcessKey.add(sysActEntrust.getProcessKey());
        }
        if (HussarUtils.isNotEmpty(processIds)) {
            ArrayList<SysActEntrust> sysActEntrusts = new ArrayList<SysActEntrust>();
            for (String processKeyStr : processIds) {
                SysActEntrust sysActEntrust = new SysActEntrust(processKeyStr, mandator, mandatary, state, startTime, endTime).setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType).setCompanyCode(companyCode).setCompanyName(companyName).setMandatorName(mandatorName).setMandataryName(mandataryName).setProcessName(this.sysActEntrustMapper.getProcessName(processKeyStr));
                sysActEntrusts.add(sysActEntrust);
            }
            this.saveBatch(sysActEntrusts);
            this.pushEntrustMessage(startTime, endTime, mandatary, messageType, new ArrayList<String>(processIds));
            if (isTransferTask) {
                this.transferProcessTask(mandatary, mandator, processIds);
            }
        }
        if (HussarUtils.isNotEmpty(illegalProcessKey)) {
            Map map = this.modelService.selectModelNames(illegalProcessKey);
            String illegalProcessName = String.join((CharSequence)",", map.values());
            return InstallResult.fail((String)("\u6d41\u7a0b" + illegalProcessName + this.bpmConstantProperties.getActiveEntrustExist()));
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public BpmResponseResult addBatchEntrust(SaveEntrustDto saveEntrustDto) {
        String mandatary;
        String processKeys = saveEntrustDto.getProcessKey();
        String mandator = saveEntrustDto.getMandator();
        if (mandator.equals(mandatary = saveEntrustDto.getMandatary())) {
            return InstallResult.fail((String)this.bpmConstantProperties.getEntrustOneselfFail());
        }
        Date now = new Date();
        LambdaQueryWrapper entrustWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)mandator)).eq(SysActEntrust::getCompanyCode, (Object)saveEntrustDto.getCompanyCode())).eq(SysActEntrust::getCompanyName, (Object)saveEntrustDto.getCompanyName())).eq(SysActEntrust::getProcessKey, (Object)saveEntrustDto.getProcessKey())).eq(SysActEntrust::getState, (Object)"1")).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process")).gt(SysActEntrust::getEndTime, (Object)now);
        List actEntrusts = this.list((Wrapper)entrustWrapper);
        if (HussarUtils.isNotEmpty((Object)actEntrusts)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getActiveProcessEntrustExist());
        }
        String state = "1";
        String startTime = saveEntrustDto.getStartTime().concat(" 00:00:00");
        String endTime = saveEntrustDto.getEndTime().concat(" 23:59:59");
        String messageType = saveEntrustDto.getMessageType();
        Timestamp startTimeStamp = Timestamp.valueOf(startTime);
        Timestamp endTimeStamp = Timestamp.valueOf(endTime);
        boolean isTransferTask = saveEntrustDto.getIsTransferTask();
        LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)mandator)).lt(SysActEntrust::getStartTime, (Object)endTimeStamp)).gt(SysActEntrust::getEndTime, (Object)startTimeStamp)).eq("1".equals(state), SysActEntrust::getState, (Object)"1");
        if (!processKeys.contains(",") && !"hussar_entire_process".equals(processKeys)) {
            ew.in(SysActEntrust::getProcessKey, new Object[]{processKeys});
            SysActEntrust sysActEntrust = new SysActEntrust(processKeys, mandator, mandatary, state, startTime, endTime);
            HashSet<String> taskDefinitionKey = null;
            if (HussarUtils.isNotEmpty((Object)saveEntrustDto.getTaskDefinitionKey())) {
                taskDefinitionKey = new HashSet<String>(Arrays.asList(saveEntrustDto.getTaskDefinitionKey().split(",")));
            }
            if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
                ew.in(SysActEntrust::getTaskDefinitionKey, taskDefinitionKey);
            } else {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
            }
            List list = this.sysActEntrustService.list((Wrapper)ew);
            if (HussarUtils.isEmpty(taskDefinitionKey)) {
                if (!list.isEmpty()) {
                    return InstallResult.fail((String)this.bpmConstantProperties.getExistMandatary());
                }
                this.pushEntrustMessage(startTime, endTime, mandatary, messageType, Collections.singletonList(processKeys));
                this.sysActEntrustService.save((Object)sysActEntrust.setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType).setCompanyCode(saveEntrustDto.getCompanyCode()).setCompanyName(saveEntrustDto.getCompanyName()));
                if (isTransferTask) {
                    this.transferTask(mandatary, mandator, processKeys, taskDefinitionKey);
                }
            } else {
                HashSet<String> illegalTaskDefKey = new HashSet<String>();
                for (SysActEntrust sysActEntrust2 : list) {
                    if (!taskDefinitionKey.remove(sysActEntrust2.getTaskDefinitionKey())) continue;
                    illegalTaskDefKey.add(sysActEntrust2.getTaskDefinitionKey());
                }
                if (HussarUtils.isNotEmpty(taskDefinitionKey)) {
                    ArrayList<SysActEntrust> sysActEntrustList = new ArrayList<SysActEntrust>();
                    for (String taskDefKeyStr : taskDefinitionKey) {
                        SysActEntrust entrust = new SysActEntrust(sysActEntrust).setTaskDefinitionKey(taskDefKeyStr).setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType).setCompanyCode(saveEntrustDto.getCompanyCode()).setCompanyName(saveEntrustDto.getCompanyName());
                        sysActEntrustList.add(entrust);
                    }
                    this.pushEntrustMessage(startTime, endTime, mandatary, messageType, Collections.singletonList(processKeys));
                    this.saveBatch(sysActEntrustList);
                    if (isTransferTask) {
                        this.transferTask(mandatary, mandator, processKeys, taskDefinitionKey);
                    }
                }
                if (HussarUtils.isNotEmpty(illegalTaskDefKey)) {
                    String illegalTaskDefKeyStr = String.join((CharSequence)",", this.getTaskDefinitionName(processKeys, illegalTaskDefKey).values());
                    return InstallResult.fail((String)("\u8282\u70b9" + illegalTaskDefKeyStr + this.bpmConstantProperties.getActiveEntrustExist()));
                }
            }
            return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
        }
        ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        ArrayList<Object> processIds = new ArrayList<String>();
        if ("hussar_entire_process".equals(processKeys)) {
            ew.eq(SysActEntrust::getProcessKey, (Object)"hussar_entire_process");
            processIds.add("hussar_entire_process");
        } else {
            processIds = new ArrayList<String>(Arrays.asList(processKeys.split(",")));
            ew.in(SysActEntrust::getProcessKey, processIds);
        }
        List sysActEntrustList = this.list((Wrapper)ew);
        ArrayList<String> illegalProcessKey = new ArrayList<String>();
        for (Object sysActEntrust : sysActEntrustList) {
            if ("hussar_entire_process".equals(sysActEntrust.getProcessKey())) {
                if (!processIds.remove(sysActEntrust.getProcessKey())) break;
                illegalProcessKey.add(sysActEntrust.getProcessKey());
                break;
            }
            if (!processIds.remove(sysActEntrust.getProcessKey())) continue;
            illegalProcessKey.add(sysActEntrust.getProcessKey());
        }
        if (HussarUtils.isNotEmpty(processIds)) {
            ArrayList<SysActEntrust> sysActEntrusts = new ArrayList<SysActEntrust>();
            for (String string : processIds) {
                SysActEntrust sysActEntrust = new SysActEntrust(string, mandator, mandatary, state, startTime, endTime).setTaskDefinitionKey("hussar_all_process").setIsTransferTask(isTransferTask ? "1" : "0").setMessageType(messageType).setCompanyCode(saveEntrustDto.getCompanyCode()).setMandataryName(saveEntrustDto.getCompanyName());
                sysActEntrusts.add(sysActEntrust);
            }
            this.saveBatch(sysActEntrusts);
            this.pushEntrustMessage(startTime, endTime, mandatary, messageType, new ArrayList<Object>(processIds));
            if (isTransferTask) {
                this.transferProcessTask(mandatary, mandator, processIds);
            }
        }
        if (HussarUtils.isNotEmpty(illegalProcessKey)) {
            Map map = this.modelService.selectModelNames(illegalProcessKey);
            String illegalProcessName = String.join((CharSequence)",", map.values());
            return InstallResult.fail((String)("\u6d41\u7a0b" + illegalProcessName + this.bpmConstantProperties.getActiveEntrustExist()));
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public Map<String, String> queryByUsers(Collection<String> users, String processKey, int entrustType) {
        return this.queryByUsers(users, processKey, null, entrustType);
    }

    public Map<String, String> queryByUsers(List<String> users, String processId, String companyCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(formatter.format(currentTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)ew.in((Object)"MANDATOR", users)).eq(companyCode != null, (Object)"COMPANY_CODE", (Object)companyCode)).isNull(companyCode == null, (Object)"COMPANY_CODE")).eq(HussarUtils.isNotEmpty((Object)processId), (Object)"PROCESS_KEY", (Object)processId)).eq((Object)"state", (Object)"1")).le((Object)"START_TIME", (Object)date)).ge((Object)"END_TIME", (Object)date);
        List list = this.list((Wrapper)ew);
        if (HussarUtils.isNotEmpty((Object)list)) {
            for (SysActEntrust t : list) {
                map.put(t.getMandator(), t.getMandatary());
            }
        }
        return map;
    }

    public Map<String, String> queryByUsers(Collection<String> users, String processKey, String taskDefinitionKey, int entrustType) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(formatter.format(currentTime));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (String userIds : users) {
            List<String> userList = Arrays.asList(userIds.split(","));
            if (userList.size() <= 0) continue;
            userIdList.addAll(userList);
        }
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysActEntrust::getMandator, userIdList)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActEntrust::getProcessKey, (Object)processKey)).or()).eq(SysActEntrust::getProcessKey, (Object)"hussar_entire_process");
        })).eq(SysActEntrust::getState, (Object)"1")).le(SysActEntrust::getStartTime, (Object)date)).ge(SysActEntrust::getEndTime, (Object)date)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActEntrust::getTaskDefinitionKey, (Object)taskDefinitionKey)).or()).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
        }));
        if (entrustType >= 0) {
            list = list.stream().filter(sysActEntrust -> sysActEntrust.isTaskEntrustType(entrustType)).collect(Collectors.toList());
        }
        list.sort((o1, o2) -> {
            if ("hussar_entire_process".equals(o1.getProcessKey()) || !"hussar_all_process".equals(o2.getTaskDefinitionKey())) {
                return -1;
            }
            if (!"hussar_all_process".equals(o1.getTaskDefinitionKey()) || "hussar_entire_process".equals(o2.getProcessKey())) {
                return 1;
            }
            return 0;
        });
        Map<String, String> map = list.stream().collect(Collectors.toMap(SysActEntrust::getMandator, SysActEntrust::getMandatary, (k1, k2) -> k2));
        for (SysActEntrust sysActEntrust2 : list) {
            map.put(sysActEntrust2.getMandator(), sysActEntrust2.getMandatary());
        }
        return map;
    }

    public BpmResponseResult updateState(String tEntrustId, String state) {
        SysActEntrust sysActEntrust;
        if ("1".equals(state)) {
            sysActEntrust = (SysActEntrust)this.getById(Long.valueOf(Long.parseLong(tEntrustId)));
            if (sysActEntrust == null) {
                return InstallResult.fail((String)this.bpmConstantProperties.getErrorUpdate());
            }
            Date now = new Date();
            LambdaQueryWrapper entrustWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getCompanyCode, (Object)sysActEntrust.getCompanyCode())).eq(SysActEntrust::getCompanyName, (Object)sysActEntrust.getCompanyName())).eq(SysActEntrust::getState, (Object)"1")).eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process")).gt(SysActEntrust::getEndTime, (Object)now);
            List actEntrusts = this.list((Wrapper)entrustWrapper);
            if (HussarUtils.isNotEmpty((Object)actEntrusts)) {
                return InstallResult.fail((String)this.bpmConstantProperties.getActiveProcessEntrustExist());
            }
            LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysActEntrust::getId, (Object)Long.parseLong(tEntrustId))).eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey())).lt(SysActEntrust::getStartTime, (Object)sysActEntrust.getEndTime())).gt(SysActEntrust::getEndTime, (Object)sysActEntrust.getStartTime())).eq(SysActEntrust::getState, (Object)"1");
            if (!"hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)sysActEntrust.getTaskDefinitionKey());
            } else {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
            }
            List sysActEntrustList = this.list((Wrapper)ew);
            if (HussarUtils.isNotEmpty((Object)sysActEntrustList)) {
                return InstallResult.fail((String)this.bpmConstantProperties.getActiveEntrustExist());
            }
        }
        this.sysActEntrustMapper.updateState(Long.parseLong(tEntrustId), state);
        if ("1".equals(state) && "1".equals((sysActEntrust = (SysActEntrust)this.sysActEntrustService.getById((Serializable)Long.valueOf(Long.parseLong(tEntrustId)))).getIsTransferTask())) {
            this.transferTask(sysActEntrust.getMandatary(), sysActEntrust.getMandator(), sysActEntrust.getProcessKey(), "hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey()) ? null : Collections.singletonList(sysActEntrust.getTaskDefinitionKey()));
        }
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessUpdate());
    }

    public BpmResponseResult update(Long tEntrustId, String mandatary, Date startTime, Date endTime, String messageType) {
        SysActEntrust entrust = (SysActEntrust)this.getById(tEntrustId);
        if (entrust == null) {
            return InstallResult.fail((String)this.bpmConstantProperties.getErrorUpdate());
        }
        if ("1".equals(entrust.getState())) {
            LambdaQueryWrapper ew = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysActEntrust::getId, (Object)entrust.getId())).eq(SysActEntrust::getMandator, (Object)entrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)entrust.getProcessKey())).lt(SysActEntrust::getStartTime, (Object)endTime)).gt(SysActEntrust::getEndTime, (Object)startTime)).eq(SysActEntrust::getState, (Object)"1");
            if (!"hussar_all_process".equals(entrust.getTaskDefinitionKey())) {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)entrust.getTaskDefinitionKey());
            } else {
                ew.eq(SysActEntrust::getTaskDefinitionKey, (Object)"hussar_all_process");
            }
            List sysActEntrustList = this.list((Wrapper)ew);
            if (HussarUtils.isNotEmpty((Object)sysActEntrustList)) {
                return InstallResult.fail((String)this.bpmConstantProperties.getActiveEntrustExist());
            }
        }
        SysActEntrust oldSysActEntrust = (SysActEntrust)this.getById(tEntrustId);
        String addMessageType = null;
        if (HussarUtils.isNotEmpty((Object)messageType)) {
            if (HussarUtils.isEmpty((Object)oldSysActEntrust.getMessageType())) {
                addMessageType = messageType;
            } else {
                List<String> oldMessageTypes = Arrays.asList(oldSysActEntrust.getMessageType().split(","));
                addMessageType = Arrays.stream(messageType.split(",")).filter(o -> !oldMessageTypes.contains(o)).collect(Collectors.joining(","));
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!(oldSysActEntrust.getEndTime().equals(endTime) && oldSysActEntrust.getStartTime().equals(startTime) && oldSysActEntrust.getMandatary().equals(mandatary))) {
            this.pushEntrustMessage(formatter.format(startTime), formatter.format(endTime), mandatary, messageType, Collections.singletonList(oldSysActEntrust.getProcessKey()));
        } else if (HussarUtils.isNotEmpty((Object)addMessageType)) {
            this.pushEntrustMessage(formatter.format(startTime), formatter.format(endTime), mandatary, addMessageType, Collections.singletonList(oldSysActEntrust.getProcessKey()));
        }
        String mandataryName = this.sysActEntrustMapper.getMandataryName(mandatary);
        SysActEntrust sysActEntrust = new SysActEntrust(tEntrustId, null, null, mandatary, null, startTime, endTime).setMessageType(messageType).setMandataryName(mandataryName);
        this.sysActEntrustService.updateById((Object)sysActEntrust);
        return InstallResult.success((String)this.bpmConstantProperties.getSuccessUpdate());
    }

    public SysActEntrust selectById(Long id) {
        SysActEntrust sysActEntrust = (SysActEntrust)this.sysActEntrustMapper.selectById(id);
        ArrayList<String> userName = new ArrayList<String>();
        userName.add(sysActEntrust.getMandatary());
        sysActEntrust.setMandataryName(this.assigneeChooseService.getUserNames(userName));
        ArrayList<String> processKeys = new ArrayList<String>();
        processKeys.add(sysActEntrust.getProcessKey());
        Map modelNameMap = this.modelService.selectModelNames(processKeys);
        sysActEntrust.setProcessName((String)modelNameMap.get(sysActEntrust.getProcessKey()));
        if (!"hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) {
            ArrayList<String> taskDefinitionKey = new ArrayList<String>();
            taskDefinitionKey.add(sysActEntrust.getTaskDefinitionKey());
            Map<String, String> taskNameMap = this.getTaskDefinitionName(sysActEntrust.getProcessKey(), taskDefinitionKey);
            sysActEntrust.setTaskDefinitionName(sysActEntrust.getTaskDefinitionKey() != null ? taskNameMap.get(sysActEntrust.getTaskDefinitionKey()) : null);
        }
        return sysActEntrust;
    }

    public SysActEntrust selectById(String id) {
        return this.selectById(Long.parseLong(id));
    }

    public BpmResponseResult queryCommissionedInfo(String userId, String processKey, String mandator, Date startTime, Date endTime, String page, String size) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return InstallResult.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        Page pages = new Page(HussarUtils.isNotEmpty((Object)page) ? Long.parseLong(page) : 1L, HussarUtils.isNotEmpty((Object)size) ? Long.parseLong(size) : 10L);
        List sysActEntrustList = ((Page)this.page((IPage)pages, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActEntrust::getMandatary, (Object)userId)).eq(HussarUtils.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey)).eq(HussarUtils.isNotEmpty((Object)mandator), SysActEntrust::getMandator, (Object)mandator)).lt(HussarUtils.isNotEmpty((Object)endTime), SysActEntrust::getStartTime, (Object)endTime)).gt(HussarUtils.isNotEmpty((Object)startTime), SysActEntrust::getEndTime, (Object)startTime))).getRecords();
        ArrayList<String> userName = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        HashMap<String, List<String>> taskDefinitionKey = new HashMap<String, List<String>>();
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            userName.add(sysActEntrust.getMandator());
            processKeys.add(sysActEntrust.getProcessKey());
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            if (!taskDefinitionKey.containsKey(sysActEntrust.getProcessKey())) {
                taskDefinitionKey.put(sysActEntrust.getProcessKey(), new ArrayList());
            }
            ((List)taskDefinitionKey.get(sysActEntrust.getProcessKey())).add(sysActEntrust.getTaskDefinitionKey());
        }
        Map userMap = this.assigneeChooseService.getUserListByUserId(userName);
        Map processMap = this.modelService.selectModelNames(processKeys);
        Map<String, Map<String, String>> nodeMap = this.getTaskDefinitionNames(taskDefinitionKey);
        for (SysActEntrust sysActEntrust : sysActEntrustList) {
            sysActEntrust.setMandatorName((String)userMap.get(sysActEntrust.getMandator()));
            sysActEntrust.setProcessName((String)processMap.get(sysActEntrust.getProcessKey()));
            if ("hussar_all_process".equals(sysActEntrust.getTaskDefinitionKey())) continue;
            sysActEntrust.setTaskDefinitionName(nodeMap.get(sysActEntrust.getProcessKey()).get(sysActEntrust.getTaskDefinitionKey()));
        }
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        result.put("count", (Object)pages.getTotal());
        result.put("data", (Object)pages.getRecords());
        jsonArray.add((Object)result);
        return InstallResult.success((JSONArray)jsonArray);
    }

    private void transferTask(final String userId, final String mandator, final String processKey, final Collection<String> taskDefKey) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> taskIds = new ArrayList<String>();
                HashSet<String> processInsIds = new HashSet<String>();
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                List<TransferTaskDto> transferTaskDtoList = SysActEntrustServiceImpl.this.sysActEntrustMapper.getTransferTask(mandator, processKey, taskDefKey);
                if (HussarUtils.isNotEmpty(transferTaskDtoList)) {
                    ArrayList<Long> longTaskIds = new ArrayList<Long>();
                    for (TransferTaskDto transferTaskDto : transferTaskDtoList) {
                        taskIds.add(transferTaskDto.getTaskId());
                        processInsIds.add(transferTaskDto.getProcessInsId());
                        longTaskIds.add(Long.parseLong(transferTaskDto.getTaskId()));
                        Task task2 = (Task)((TaskQuery)SysActEntrustServiceImpl.this.taskService.createTaskQuery().taskId(transferTaskDto.getTaskId())).singleResult();
                        String processDefinitionId = task2.getProcessDefinitionId();
                        processDefinitionIdList.add(processDefinitionId);
                    }
                    SysActEntrustServiceImpl.this.sysActEntrustMapper.transferTask(userId, mandator, longTaskIds);
                }
                List tasks = ((TaskQuery)((TaskQuery)SysActEntrustServiceImpl.this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKey(processKey)).list();
                tasks.removeIf(task -> !taskDefKey.contains(task.getTaskDefinitionKey()));
                SysActEntrustServiceImpl.this.processEngine.getManagementService().executeCommand(commandContext -> {
                    for (Task task : tasks) {
                        processInsIds.add(task.getProcessInstanceId());
                        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                        taskEntity.setAssignee(null);
                        ((TaskEntity)task).addCandidateUser(userId, mandator, "1", null);
                        taskIds.add(task.getId());
                    }
                    for (String processInsId : processInsIds) {
                        new ProcessActionCmd(processInsId).execute(commandContext);
                    }
                    return null;
                });
                SysActEntrustServiceImpl.this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).eq(SysActUrgeTask::getProcDefKey, (Object)processKey)).in(HussarUtils.isNotEmpty((Object)taskDefKey), SysActUrgeTask::getTaskDefKey, taskDefKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
                taskIds.forEach(taskId -> SysActEntrustServiceImpl.this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
                if (SysActEntrustServiceImpl.this.dataPushService.isDataPush(processDefinitionIdList)) {
                    SysActEntrustServiceImpl.this.dataPushService.transferTask(new DataPush().setProcessKey(processKey).setTaskIds(taskIds).setUserId(userId).setConsignor(mandator).setTaskState("1"));
                }
            }
        });
    }

    private void transferProcessTask(final String userId, final String mandator, final Collection<String> processKey) {
        if (HussarUtils.isEmpty(processKey)) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> taskIds = new ArrayList<String>();
                HashSet<String> processInsIds = new HashSet<String>();
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                List<TransferTaskDto> transferTaskDtoList = SysActEntrustServiceImpl.this.sysActEntrustMapper.getTransferProcessTask(mandator, processKey);
                if (!transferTaskDtoList.isEmpty()) {
                    ArrayList<Long> longTaskIds = new ArrayList<Long>();
                    for (TransferTaskDto transferTaskDto : transferTaskDtoList) {
                        taskIds.add(transferTaskDto.getTaskId());
                        processInsIds.add(transferTaskDto.getProcessInsId());
                        longTaskIds.add(Long.parseLong(transferTaskDto.getTaskId()));
                        Task task = (Task)((TaskQuery)SysActEntrustServiceImpl.this.taskService.createTaskQuery().taskId(transferTaskDto.getTaskId())).singleResult();
                        String processDefinitionId = task.getProcessDefinitionId();
                        processDefinitionIdList.add(processDefinitionId);
                    }
                    SysActEntrustServiceImpl.this.sysActEntrustMapper.transferTask(userId, mandator, longTaskIds);
                }
                List tasks = ((TaskQuery)((TaskQuery)SysActEntrustServiceImpl.this.taskService.createTaskQuery().taskAssignee(mandator)).processDefinitionKeyIn(new ArrayList(processKey))).list();
                SysActEntrustServiceImpl.this.processEngine.getManagementService().executeCommand(commandContext -> {
                    for (Task task : tasks) {
                        processInsIds.add(task.getProcessInstanceId());
                        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(task.getId());
                        taskEntity.setAssignee(null);
                        ((TaskEntity)task).addCandidateUser(userId, mandator, "1");
                        taskIds.add(task.getId());
                    }
                    for (String processInsId : processInsIds) {
                        new ProcessActionCmd(processInsId).execute(commandContext);
                    }
                    return null;
                });
                SysActEntrustServiceImpl.this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, (Object)"1")).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, (Object)mandator)).eq(SysActUrgeTask::getReceiveUser, (Object)mandator)).in(SysActUrgeTask::getProcDefKey, processKey)).isNull(SysActUrgeTask::getTaskState)).isNull(SysActUrgeTask::getOwner));
                taskIds.forEach(taskId -> SysActEntrustServiceImpl.this.activityRedisTimerService.updateTimeOutModel((String)taskId, userId, mandator, 1));
                if (SysActEntrustServiceImpl.this.dataPushService.isDataPush(processDefinitionIdList)) {
                    DataPush dataPush = new DataPush();
                    dataPush.setTaskIds(taskIds);
                    dataPush.setUserId(userId);
                    dataPush.setConsignor(mandator);
                    dataPush.setTaskState("1");
                    dataPush.setProcessKeys(new ArrayList(processKey));
                    SysActEntrustServiceImpl.this.dataPushService.transferTask(dataPush);
                }
            }
        });
    }

    public BpmResponseResult reTransferTask(final ReTransferTaskDto reTransferTaskDto) {
        if (HussarUtils.isEmpty((Object)reTransferTaskDto.getTaskIds()) || HussarUtils.isEmpty((Object)reTransferTaskDto.getUserId())) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        final String userId = reTransferTaskDto.getUserId();
        final List taskIds = Arrays.stream(reTransferTaskDto.getTaskIds().split(",")).map(o -> o.split(":")[0]).collect(Collectors.toList());
        executor.execute(new Runnable(){

            @Override
            public void run() {
                HashSet processInsIds = new HashSet();
                SysActEntrustServiceImpl.this.processEngine.getManagementService().executeCommand(commandContext -> {
                    for (String taskId : taskIds) {
                        TaskEntity taskEntity = commandContext.getTaskEntityManager().findTaskById(taskId);
                        processInsIds.add(taskEntity.getProcessInstanceId());
                        if (taskEntity.getDueDate() == null) continue;
                        taskEntity.getCandidates().forEach(identityLink -> {
                            if (userId.equals(identityLink.getMandator())) {
                                SysActEntrustServiceImpl.this.activityRedisTimerService.updateTimeOutModel(taskId, userId, identityLink.getUserId(), 1);
                            }
                        });
                    }
                    return null;
                });
                List<Long> longList = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                HashSet<String> processdefinitionIdList = new HashSet<String>();
                String taskId = (String)taskIds.get(0);
                List identityLinks = SysActEntrustServiceImpl.this.taskService.getIdentityLinksType(taskId);
                Task task = (Task)((TaskQuery)SysActEntrustServiceImpl.this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                String processDefinitionId = task.getProcessDefinitionId();
                processdefinitionIdList.add(processDefinitionId);
                String processKey = null;
                processKey = task.getProcessDefinitionId().split(":")[0];
                String consignor = null;
                for (IdentityLink identityLink : identityLinks) {
                    if (!HussarUtils.isNotEmpty((Object)identityLink.getMandator()) || !userId.equals(identityLink.getMandator())) continue;
                    consignor = identityLink.getUserId();
                    break;
                }
                SysActEntrustServiceImpl.this.sysActEntrustMapper.reTransferTask(longList, reTransferTaskDto.getUserId());
                SysActEntrustServiceImpl.this.processEngine.getManagementService().executeCommand(commandContext -> {
                    for (String processInsId : processInsIds) {
                        new ProcessActionCmd(processInsId).execute(commandContext);
                    }
                    return null;
                });
                SysActEntrustServiceImpl.this.urgeTaskService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysActUrgeTask::getTaskState, null)).set(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getOwner, null)).in(SysActUrgeTask::getTaskId, longList));
                if (SysActEntrustServiceImpl.this.dataPushService.isDataPush(processdefinitionIdList)) {
                    SysActEntrustServiceImpl.this.dataPushService.reTransferTask(new DataPush().setProcessKey(processKey).setTaskId(taskId).setUserId(userId).setConsignor(consignor).setTaskState("1"));
                }
            }
        });
        return InstallResult.success();
    }

    private Map<String, String> getTaskDefinitionName(String processKey, Collection<String> taskDefinitionKey) {
        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, null);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        HashMap<String, String> map = new HashMap<String, String>();
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof UserTask && taskDefinitionKey.contains(flowElement.getId())) {
                    map.put(flowElement.getId(), flowElement.getName());
                    continue;
                }
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof UserTask) || !taskDefinitionKey.contains(element.getId())) continue;
                    map.put(element.getId(), element.getName());
                }
            }
        }
        return map;
    }

    private Map<String, Map<String, String>> getTaskDefinitionNames(Map<String, List<String>> taskDefinitionKey) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<String>> entry : taskDefinitionKey.entrySet()) {
            map.put(entry.getKey(), this.getTaskDefinitionName(entry.getKey(), (Collection<String>)entry.getValue()));
        }
        return map;
    }

    private void pushEntrustMessage(String startTime, String endTime, String mandatary, String messageType, List<String> processKeys) {
        if (HussarUtils.isEmpty((Object)messageType)) {
            return;
        }
        Map processName = this.modelService.selectModelNames(new ArrayList<String>(processKeys));
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        HashMap<String, String> messageData = new HashMap<String, String>();
        for (String processkey : processKeys) {
            BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
            bpmActMsgDetail.setProcessKey(processkey);
            bpmActMsgDetail.setReceive(Collections.singletonList(mandatary));
            bpmActMsgDetail.setChannelType(messageType);
            bpmActMsgDetail.setSceneCode("entrust");
            if (processkey.equals("hussar_entire_process")) {
                messageData.put("hussar_entire_process", "\u5168\u90e8\u6d41\u7a0b\u59d4\u6258");
            } else {
                messageData.put("processName", (String)processName.get(processkey));
            }
            messageData.put("startTime", startTime);
            messageData.put("endTime", endTime);
            bpmActMsgDetail.setMessageData(messageData);
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
            }
            bpmActMsgDetailList.add(bpmActMsgDetail);
        }
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }
}

