/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.overdue.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.overdue.dao.NewTimeOutModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.overdue.model.NewTimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.overdue.service.INewTimeOutService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewTimeOutServiceImpl
extends ServiceImpl<NewTimeOutModelMapper, NewTimeOutModel>
implements INewTimeOutService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewTimeOutServiceImpl.class);
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimer;
    @Autowired
    private NewTimeOutModelMapper newTimeOutModelMapper;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private INewTimeOutService newTimeOutService;

    public BpmResponseResult getNodeConfigByProcDefId(String procDefId, Integer page, Integer limit) {
        if (ToolUtil.isEmpty((Object)procDefId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessKeyError(), null);
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        LinkedHashMap<String, String> nodeMap = new LinkedHashMap<String, String>();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
        Process process = bpmnModel.getMainProcess();
        for (FlowNode flowNode : process.findFlowElementsOfType(FlowNode.class)) {
            if (!(flowNode instanceof UserTask)) continue;
            nodeMap.put(flowNode.getId(), flowNode.getName());
        }
        List<NewTimeOutModel> configs = this.newTimeOutModelMapper.getNodeConfigByProcDefId(procDefId, new ArrayList<String>(nodeMap.keySet()));
        List newNodes = configs.stream().map(NewTimeOutModel::getTaskDefKey).collect(Collectors.toList());
        ArrayList<Object> result = new ArrayList<Object>();
        for (String node : nodeMap.keySet()) {
            if (!newNodes.contains(node)) {
                NewTimeOutModel newTimeOutModel = new NewTimeOutModel();
                newTimeOutModel.setTaskDefKey(node);
                newTimeOutModel.setTaskDefName((String)nodeMap.get(node));
                result.add(newTimeOutModel);
                continue;
            }
            result.add(configs.stream().filter(a -> a.getTaskDefKey().equals(node)).collect(Collectors.toList()).get(0));
        }
        int a2 = result.size() / limit;
        if (a2 + 1 == page) {
            object.put("data", result.subList((page - 1) * limit, result.size()));
        } else {
            object.put("data", result.subList((page - 1) * limit, page * limit));
        }
        object.put("count", (Object)result.size());
        jsonArray.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getVersionConfig(String procDefId, String nodeId, Integer page, Integer limit) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        LambdaQueryWrapper lambdaQueryWrap = new LambdaQueryWrapper();
        lambdaQueryWrap.eq(NewTimeOutModel::getProcDefId, (Object)procDefId);
        lambdaQueryWrap.eq(NewTimeOutModel::getTaskDefKey, (Object)nodeId);
        lambdaQueryWrap.eq(NewTimeOutModel::getDelFlag, (Object)0);
        Page result = (Page)this.newTimeOutModelMapper.selectPage((IPage)pages, (Wrapper)lambdaQueryWrap);
        if (result.getSize() > 0L) {
            object.put("data", (Object)result.getRecords());
            object.put("count", (Object)result.getTotal());
        }
        jsonArray.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult addTimeOutConfig(String procDefId, String nodeId, String nodeName, Integer overDueTime, Integer closeOverDueTime, String overDueStyle, String closeOverDueStyle, String overdueUrl, String closeOverdueUrl) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<NewTimeOutModel> result = this.query(procDefId, nodeId, null);
        NewTimeOutModel newTimeOutModel = new NewTimeOutModel();
        newTimeOutModel.setProcDefId(procDefId);
        newTimeOutModel.setTaskDefKey(nodeId);
        newTimeOutModel.setTaskDefName(nodeName);
        newTimeOutModel.setOverdueTime(overDueTime);
        newTimeOutModel.setCloseOverdueTime(closeOverDueTime);
        newTimeOutModel.setOverdueStyle(overDueStyle);
        newTimeOutModel.setCloseOverdueStyle(closeOverDueStyle);
        newTimeOutModel.setOverdueUrl(overdueUrl);
        newTimeOutModel.setCloseOverdueUrl(closeOverdueUrl);
        newTimeOutModel.setIsMain(Integer.valueOf(0));
        newTimeOutModel.setDelFlag(Integer.valueOf(0));
        if (!result.isEmpty()) {
            result.sort(Comparator.comparingInt(NewTimeOutModel::getVersion).reversed());
            newTimeOutModel.setVersion(Integer.valueOf(result.get(0).getVersion() + 1));
        } else {
            newTimeOutModel.setVersion(Integer.valueOf(1));
        }
        boolean save = this.save(newTimeOutModel);
        if (save) {
            return InstallResult.getResult((String)"1", (String)"\u4fdd\u5b58\u6210\u529f", null);
        }
        return InstallResult.getResult((String)"0", (String)"\u4fdd\u5b58\u5931\u8d25", null);
    }

    public BpmResponseResult editTimeOutConfig(String procDefId, String nodeId, String nodeName, Integer overDueTime, Integer closeOverDueTime, String overDueStyle, String closeOverDueStyle, String overdueUrl, String closeOverdueUrl, Integer version) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId) || ToolUtil.isEmpty((Object)version)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<NewTimeOutModel> result = this.query(procDefId, nodeId, version);
        if (result.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)"\u4fee\u6539\u67e5\u8be2\u5931\u8d25", null);
        }
        NewTimeOutModel newTimeOutModel = result.get(0);
        newTimeOutModel.setOverdueTime(overDueTime);
        newTimeOutModel.setCloseOverdueTime(closeOverDueTime);
        newTimeOutModel.setOverdueStyle(overDueStyle);
        newTimeOutModel.setCloseOverdueStyle(closeOverDueStyle);
        newTimeOutModel.setOverdueUrl(overdueUrl);
        newTimeOutModel.setCloseOverdueUrl(closeOverdueUrl);
        boolean update = this.newTimeOutService.saveOrUpdate((Object)newTimeOutModel);
        if (update) {
            return InstallResult.getResult((String)"1", (String)"\u4fee\u6539\u6210\u529f", null);
        }
        return InstallResult.getResult((String)"0", (String)"\u4fee\u6539\u5931\u8d25", null);
    }

    public BpmResponseResult setOrUnsetMajorVersion(String procDefId, String nodeId, Integer version) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId) || ToolUtil.isEmpty((Object)version)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<NewTimeOutModel> result = this.query(procDefId, nodeId, version);
        if (result.isEmpty()) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        ArrayList<NewTimeOutModel> updateList = new ArrayList<NewTimeOutModel>();
        NewTimeOutModel newTimeOutModel = result.get(0);
        if (newTimeOutModel.getIsMain() == 1) {
            newTimeOutModel.setIsMain(Integer.valueOf(0));
        } else {
            LambdaQueryWrapper lambdaQueryWrap = new LambdaQueryWrapper();
            lambdaQueryWrap.eq(NewTimeOutModel::getProcDefId, (Object)procDefId);
            lambdaQueryWrap.eq(NewTimeOutModel::getTaskDefKey, (Object)nodeId);
            lambdaQueryWrap.eq(NewTimeOutModel::getDelFlag, (Object)0);
            lambdaQueryWrap.eq(NewTimeOutModel::getIsMain, (Object)1);
            List oldConfig = this.list((Wrapper)lambdaQueryWrap);
            if (!oldConfig.isEmpty()) {
                NewTimeOutModel oldModel = (NewTimeOutModel)oldConfig.get(0);
                oldModel.setIsMain(Integer.valueOf(0));
                updateList.add(oldModel);
            }
            newTimeOutModel.setIsMain(Integer.valueOf(1));
        }
        updateList.add(newTimeOutModel);
        boolean edit = this.updateBatchById(updateList);
        if (edit) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)"error", null);
    }

    public BpmResponseResult delTimeOutConfig(String procDefId, String nodeId, Integer version, boolean isLogicalDel) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId) || ToolUtil.isEmpty((Object)version)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        LambdaQueryWrapper lambdaQueryWrap = new LambdaQueryWrapper();
        lambdaQueryWrap.eq(NewTimeOutModel::getProcDefId, (Object)procDefId);
        lambdaQueryWrap.eq(NewTimeOutModel::getTaskDefKey, (Object)nodeId);
        lambdaQueryWrap.eq(NewTimeOutModel::getVersion, (Object)version);
        lambdaQueryWrap.eq(NewTimeOutModel::getDelFlag, (Object)0);
        boolean remove = false;
        if (isLogicalDel) {
            List list = this.list((Wrapper)lambdaQueryWrap);
            if (list.isEmpty()) {
                return InstallResult.getResult((String)"0", (String)"error", null);
            }
            NewTimeOutModel newTimeOutModel = (NewTimeOutModel)list.get(0);
            newTimeOutModel.setDelFlag(Integer.valueOf(1));
            remove = this.updateById(newTimeOutModel);
        } else {
            remove = this.remove((Wrapper)lambdaQueryWrap);
        }
        if (remove) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)"error", null);
    }

    public BpmResponseResult timeOutList(String userId, String processDefinitionKey, String message, String startUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId, String category, String taskDefKey) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
            flowTaskQueryModel.setUserId(userId);
            flowTaskQueryModel.setTodoConfiguration(message);
            flowTaskQueryModel.setProcessStartUserId(startUserId);
            if (HussarUtils.isNotEmpty((Object)startTime)) {
                flowTaskQueryModel.setStartTime(format.parse(startTime));
            }
            if (HussarUtils.isNotEmpty((Object)endTime)) {
                flowTaskQueryModel.setEndTime(format.parse(endTime));
            }
            flowTaskQueryModel.setCategory(category);
            flowTaskQueryModel.setDefinitionKey(taskDefKey);
            flowTaskQueryModel.setTimeOutList(Boolean.valueOf(true));
            flowTaskQueryModel.setProcessKey(processDefinitionKey);
            Page pages = new Page((long)page.intValue(), (long)limit.intValue());
            IPage lists = (IPage)this.flowTaskService.todoList(pages, flowTaskQueryModel).getData();
            JSONArray jsonArray = new JSONArray();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", lists.getRecords());
            data.put("count", lists.getTotal());
            jsonArray.add(data);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BpmException(e.getMessage());
        }
    }

    public NewTimeOutModel getConfigByProcDefIdAndNodeId(String procDefId, String nodeId) {
        if (ToolUtil.isEmpty((Object)procDefId) || ToolUtil.isEmpty((Object)nodeId)) {
            throw new HussarException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        LambdaQueryWrapper lambdaQueryWrap = new LambdaQueryWrapper();
        lambdaQueryWrap.eq(NewTimeOutModel::getProcDefId, (Object)procDefId);
        lambdaQueryWrap.eq(NewTimeOutModel::getTaskDefKey, (Object)nodeId);
        lambdaQueryWrap.eq(NewTimeOutModel::getDelFlag, (Object)0);
        lambdaQueryWrap.orderByDesc(NewTimeOutModel::getIsMain);
        lambdaQueryWrap.orderByDesc(NewTimeOutModel::getVersion);
        List list = this.list((Wrapper)lambdaQueryWrap);
        if (!list.isEmpty()) {
            return (NewTimeOutModel)list.get(0);
        }
        return null;
    }

    public void addTaskTimeOutConfig(TaskEntity task, String tenantId, Map<String, Object> map) {
        NewTimeOutModel config = this.getConfigByProcDefIdAndNodeId(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (config != null) {
            Date date;
            TimeOutModel timeOutModel;
            Integer overdueTime = config.getOverdueTime();
            Integer closeOverdueTime = config.getCloseOverdueTime();
            GregorianCalendar calendar = new GregorianCalendar();
            if (closeOverdueTime != null) {
                timeOutModel = new TimeOutModel();
                timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                timeOutModel.setCreateTime(task.getCreateTime());
                timeOutModel.setTimeOutType("colorStyle");
                timeOutModel.setTenantId(tenantId);
                timeOutModel.setIsClose(Integer.valueOf(2));
                timeOutModel.setMessageType("2");
                date = new Date();
                calendar.setTime(date);
                ((Calendar)calendar).add(5, closeOverdueTime);
                date = calendar.getTime();
                timeOutModel.setDueTime(date);
                if (ToolUtil.isNotEmpty((Object)config.getCloseOverdueUrl())) {
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimer.addTimeOutModel(timeOutModel);
            }
            if (overdueTime != null) {
                timeOutModel = new TimeOutModel();
                timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
                timeOutModel.setCreateTime(task.getCreateTime());
                timeOutModel.setTimeOutType("colorStyle");
                timeOutModel.setTenantId(tenantId);
                timeOutModel.setIsClose(Integer.valueOf(1));
                timeOutModel.setMessageType("1");
                date = new Date();
                calendar.setTime(date);
                ((Calendar)calendar).add(5, overdueTime);
                date = calendar.getTime();
                timeOutModel.setDueTime(date);
                if (ToolUtil.isNotEmpty((Object)config.getOverdueUrl())) {
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimer.addTimeOutModel(timeOutModel);
            }
        }
    }

    private List<NewTimeOutModel> query(String procDefId, String nodeId, Integer version) {
        LambdaQueryWrapper lambdaQueryWrap = new LambdaQueryWrapper();
        lambdaQueryWrap.eq(NewTimeOutModel::getProcDefId, (Object)procDefId);
        lambdaQueryWrap.eq(NewTimeOutModel::getTaskDefKey, (Object)nodeId);
        lambdaQueryWrap.eq(NewTimeOutModel::getDelFlag, (Object)0);
        if (version != null) {
            lambdaQueryWrap.eq(NewTimeOutModel::getVersion, (Object)version);
        }
        return this.list((Wrapper)lambdaQueryWrap);
    }
}

