/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ImportDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationServiceImpl
implements IWorkflowMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActHandleAuthService handleAuthService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;

    public List<WorkflowDumpVo> dump(List<WorkflowDumpDto> workflowDumpDtos) {
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            processKeys.add(workflowDumpDto.getProcessKey());
        }
        List<ExportModel> list = this.modelMapper.selectModelNames(processKeys);
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        for (ExportModel exportModel : list) {
            serviceNameMap.put(exportModel.getBusinessId(), exportModel.getCategory());
        }
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            WorkflowDumpVo workflowDumpVo;
            String processKey = workflowDumpDto.getProcessKey();
            int version = workflowDumpDto.getVersion();
            if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
                List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActAssignees), "\u53c2\u4e0e\u8005.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
                List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).eq(SysActFormAuth::getProcessVersion, (Object)version));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActFormAuths), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getWorkflowData().booleanValue()) {
                List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
                WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActExtendProperties), "\u62d3\u5c55.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(extendPropertiesDumpVo);
                List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
                WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActProcessFiles), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(sysActProcessFilesDumpVo);
                InputStream resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
                String xmlByteString = null;
                try {
                    int temp;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    while ((temp = resourceAsStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, temp);
                    }
                    byte[] finalBytes = outputStream.toByteArray();
                    xmlByteString = new String(finalBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(xmlDumpVo);
            }
            if (!workflowDumpDto.getExportData().getHandleAuthData().booleanValue()) continue;
            List handleAuthList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.handleAuthService.lambdaQuery().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).list();
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)handleAuthList), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo);
        }
        return workflowDumpVoList;
    }

    public List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            processKeys.add(workflowPreloadDto.getProcessKey());
        }
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DefinitionModel definitionModel : list) {
            map.put(definitionModel.getMykey(), Integer.parseInt(definitionModel.getVersion()));
        }
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, (Integer)map.get(workflowPreloadDto.getProcessKey()));
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    public List<WorkflowLoadVo> load(WorkflowLoadDto workflowLoadDto) {
        this.importAssignee(workflowLoadDto);
        this.importFormAuth(workflowLoadDto);
        this.importHandleAuth(workflowLoadDto);
        this.importExtendProperties(workflowLoadDto);
        Map importMap = workflowLoadDto.getImportMsgMap();
        Map serviceNameMap = workflowLoadDto.getServiceNameMap();
        if (importMap != null) {
            for (String processKey : importMap.keySet()) {
                Map workflowFile = (Map)workflowLoadDto.getWorkflowFiles().get(processKey);
                if (workflowFile == null) continue;
                String lcpbBpmFile = (String)workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
                String xml = (String)workflowFile.get("bpmn20.xml");
                String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
                if ("unable".equals(type)) continue;
                this.importModel(xml, lcpbBpmFile, (String)serviceNameMap.get(processKey), "override".equals(type));
            }
        }
        ArrayList<WorkflowLoadVo> workflowLoadVos = new ArrayList<WorkflowLoadVo>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgs()) {
            workflowLoadVos.add(new WorkflowLoadVo(workflowMigrationPreloadVo));
        }
        return workflowLoadVos;
    }

    private void importAssignee(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importAssignee = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getAssigneeData().booleanValue()) continue;
            importAssignee.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importAssignee.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.sysActAssigneeService.lambdaUpdate();
            for (Map.Entry entry : importAssignee.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActAssignee::getProcDefKey, formAuthImport.getKey())).eq(SysActAssignee::getProcessVersion, formAuthImport.getValue());
                });
            }
            removeWrapper.remove();
            if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
                ArrayList actAssignees = new ArrayList();
                for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                    actAssignees.addAll(JSON.parseArray((String)assignee, SysActAssignee.class));
                }
                if (!actAssignees.isEmpty()) {
                    for (SysActAssignee sysActAssignee : actAssignees) {
                        sysActAssignee.setId(null);
                    }
                    this.sysActAssigneeService.saveBatch(actAssignees);
                }
            }
        }
    }

    private void importFormAuth(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importFormAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue()) continue;
            importFormAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importFormAuth.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.sysActFormAuthService.lambdaUpdate();
            for (Map.Entry entry : importFormAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActFormAuth::getProcessKey, formAuthImport.getKey())).eq(SysActFormAuth::getProcessVersion, formAuthImport.getValue());
                });
            }
            removeWrapper.remove();
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    formAuths.addAll(JSON.parseArray((String)formAuth, SysActFormAuth.class));
                }
                if (!formAuths.isEmpty()) {
                    for (String formAuth : formAuths) {
                        formAuth.setId(null);
                    }
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    private void importHandleAuth(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importHandleAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getHandleAuthData().booleanValue()) continue;
            importHandleAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importHandleAuth.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.handleAuthService.lambdaUpdate();
            for (Map.Entry entry : importHandleAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActHandleAuth::getProcessKey, formAuthImport.getKey())).eq(SysActHandleAuth::getProcessVersion, formAuthImport.getValue());
                });
            }
            if (!workflowLoadDto.getHandleAuthMsgs().isEmpty()) {
                ArrayList handleAuths = new ArrayList();
                for (String handleAuth : workflowLoadDto.getHandleAuthMsgs()) {
                    handleAuths.addAll(JSON.parseArray((String)handleAuth, SysActHandleAuth.class));
                }
                if (!handleAuths.isEmpty()) {
                    this.handleAuthService.saveBatch(handleAuths);
                }
            }
        }
    }

    private void importExtendProperties(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList<Map<String, Object>> process = new ArrayList<Map<String, Object>>();
        ArrayList newSysActExtendProperties = new ArrayList();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties)) continue;
            String processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
            String processKey = processId.split(":")[0];
            String version = processId.split(":")[1];
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = (WorkflowMigrationPreloadVo)importMap.get(processKey);
            String importType = workflowMigrationPreloadVo.getImportType();
            if (!"override".equals(importType)) continue;
            HashMap<String, Object> processMap = new HashMap<String, Object>();
            processMap.put("processKey", processKey);
            processMap.put("version", workflowMigrationPreloadVo.getTenantVersion());
            process.add(processMap);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (!process.isEmpty()) {
            List<ImportDefinitionModel> newProcessMap = this.processDefinitionsMapper.getProcessDefinitions(process);
            for (ImportDefinitionModel importDefinitionModelMap : newProcessMap) {
                map.put(importDefinitionModelMap.getProcessKey(), importDefinitionModelMap.getProcessDefinition());
            }
        }
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            String procDefId;
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties)) continue;
            String processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
            String proDefKey = processId.split(":")[0];
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = (WorkflowMigrationPreloadVo)importMap.get(proDefKey);
            String importType = workflowMigrationPreloadVo.getImportType();
            if ("override".equals(importType)) {
                procDefId = (String)map.get(proDefKey);
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setProcDefId((String)map.get(proDefKey));
                    sysActExtendProperties.setId(null);
                }
            } else {
                procDefId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
                importProcessIds.add(procDefId);
                for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                    sysActExtendProperties.setId(null);
                }
            }
            newSysActExtendProperties.addAll(extendProperties);
        }
        if (newSysActExtendProperties.isEmpty()) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, importProcessIds);
        this.sysActExtendPropertiesService.remove((Wrapper)lambdaQueryWrapper);
        this.sysActExtendPropertiesService.saveBatch(newSysActExtendProperties);
    }

    private Boolean importModel(String xml, String lcdpbpm, String serviceName, boolean isOverride) {
        List oldSysActProcessFiles;
        String processKey;
        BpmnModel bpmnModel = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String identityId = this.modelMapper.getIdByIdentity(modelKey);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        String processId = null;
        if (!isOverride) {
            List oldSysActProcessFiles2 = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles2)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles2) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            if (HussarUtils.isEmpty((Object)identityId)) {
                Model modelData = this.repositoryService.newModel();
                ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                modelObjectNode.put("name", impModelName);
                modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                modelObjectNode.put("revision", 1);
                modelData.setMetaInfo(modelObjectNode.toString());
                modelData.setName(impModelName);
                modelData.setKey(modelKey);
                modelData.setCategory(serviceName);
                this.repositoryService.saveModel(modelData);
                identityId = modelData.getId();
            }
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            processId = this.modelService.deployModel(Long.valueOf(Long.parseLong(identityId)));
        } else {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            int highestVersion = Integer.parseInt(this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys).get(0).getVersion());
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)highestVersion)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            int overVersion = Integer.parseInt(this.processDefinitionsMapper.getMainOrNew(processKey).get(0).getVersion());
            needModify = overVersion == highestVersion;
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(highestVersion));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(highestVersion));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                workFlowName = workFlow.getName();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(highestVersion, processKey)) ? Long.valueOf(this.bpm2XMLMapper.getModelId(highestVersion, processKey)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
        }
        if (needModify) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> metas = new ArrayList<SysActProcessFile>();
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        metas.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                metas.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metas) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(metas);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, null, processKey);
        }
        return true;
    }

    public BpmResponseResult selectByName(WorkflowQueryDto workflowQueryDto) {
        List<WorkflowQueryVo> list = this.queryModelList((Page<WorkflowQueryVo>)workflowQueryDto.getPage(), workflowQueryDto.getName());
        if (!list.isEmpty()) {
            int i;
            ArrayList<String> processKeys = new ArrayList<String>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String a = list.get(i2).getProcessKey();
                processKeys.add(a);
            }
            List<ProcessDefinitionModel> processDefinitionModels = this.workflowMigrationMapper.queryProcessDefList(processKeys);
            ArrayList<String> processDefinitonKeys = new ArrayList<String>();
            HashMap versionMap = new HashMap();
            for (int i3 = 0; i3 < processKeys.size(); ++i3) {
                ArrayList list1 = new ArrayList();
                for (int j = 0; j < processDefinitionModels.size(); ++j) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String pd = processDefinitionModels.get(j).getId();
                    String version = processDefinitionModels.get(j).getVersion();
                    String[] arr = pd.split(":");
                    if (!((String)processKeys.get(i3)).equals(arr[0])) continue;
                    map.put("key", version);
                    map.put("value", pd);
                    int index = 0;
                    for (Map map2 : list1) {
                        if (Integer.parseInt((String)map2.get("key")) <= Integer.parseInt(version)) continue;
                        ++index;
                    }
                    list1.add(index, map);
                }
                versionMap.put(processKeys.get(i3), list1);
            }
            for (int j = 0; j < processDefinitionModels.size(); ++j) {
                String pd = processDefinitionModels.get(j).getId();
                processDefinitonKeys.add(pd);
            }
            HashMap map = new HashMap();
            for (i = 0; i < processKeys.size(); ++i) {
                ArrayList list2 = new ArrayList();
                for (int j = 0; j < processDefinitonKeys.size(); ++j) {
                    String[] arr = ((String)processDefinitonKeys.get(j)).split(":");
                    if (!((String)processKeys.get(i)).equals(arr[0])) continue;
                    list2.add(processDefinitonKeys.get(j));
                }
                map.put(processKeys.get(i), list2);
            }
            for (i = 0; i < list.size(); ++i) {
                list.get(i).setVersionMap((List)versionMap.get(list.get(i).getProcessKey()));
            }
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)workflowQueryDto.getPage().setRecords(list));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public List<WorkflowQueryVo> queryModelList(Page<WorkflowQueryVo> page, String processName) {
        return this.workflowMigrationMapper.queryModelList(page, processName);
    }
}

