/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.DataPushUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(TaskCreateListener.class);
    @Resource
    private DataPushService dataPushService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Lazy
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public void onEvent(ActivitiEvent activitiEvent) {
        HistoricProcessInstanceEntity historicProcessInstance;
        String taskSourceFlag;
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String userId = (String)taskEntity.getVariable("startUser");
        if (HussarUtils.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        if (HussarUtils.isEmpty((Object)taskEntity.getSendUser())) {
            taskEntity.setSendUser((String)BpmAttribute.getContextAttribute("sendUser"));
        }
        if (TaskSourceFlag.PROCESS_START.contains(taskSourceFlag = BpmAttribute.getTaskSourceFlag(taskEntity)) && (historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(taskEntity.getProcessInstanceId())).getFirstUserTaskActivityId() == null) {
            historicProcessInstance.setFirstUserTaskActivityId(taskEntity.getTaskDefinitionKey());
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            String taskAssignee = this.getAssigneeByTaskId(taskEntity);
            String string = userId = HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee;
            if (HussarUtils.isNotEmpty((Object)userId)) {
                taskEntity.removeVariable("startUser");
            }
            DataPush dataPush = this.dataPush(taskEntity);
            dataPush.setUserId(HussarUtils.isEmpty((Object)taskAssignee) ? userId : taskAssignee);
            List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
            if (taskAssigneeMap.isEmpty()) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", userId);
                taskAssigneeMap.add(assigneeMap);
            }
            dataPush.setUserMaps(taskAssigneeMap);
            dataPush.setTaskType(taskEntity.getTaskType());
            List ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(taskEntity.getId())));
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                dataPush.setCcUrl(((SysActCcTask)ccTasks.get(0)).getFormKey());
            } else {
                List ccFormKeyList;
                Map ccFormKeyMap;
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(taskEntity.getProcessDefinitionId());
                Iterator ccElement = (List)bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                String formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                dataPush.setCcUrl(formKey);
            }
            this.dataPushService.addDataPush(dataPush);
            if (HussarUtils.isNotEmpty((Object)ccTasks)) {
                ArrayList<String> ccUsers = new ArrayList<String>();
                for (SysActCcTask sysActCcTask : ccTasks) {
                    ccUsers.add(sysActCcTask.getReceiveUser());
                }
                dataPush.setUserId(String.join((CharSequence)",", ccUsers));
                dataPush.setCcMoment("0");
                dataPush.setStartDate((Date)((SysActCcTask)ccTasks.get(0)).getSendTime());
                this.dataPushService.addCcTask(dataPush);
            }
        }
        if (this.lcdpBpmProperties.isPushIhn()) {
            String processInstanceId = taskEntity.getProcessInstanceId();
            ExecutionEntity processInstance = taskEntity.getProcessInstance();
            ExecutionEntity mainProcessInstance = this.getSuperProcess(processInstance);
            List identityLinks = processInstance.getIdentityLinks();
            if (processInstance != mainProcessInstance) {
                identityLinks.clear();
                identityLinks = mainProcessInstance.getIdentityLinks();
            }
            Object starter = null;
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                if (!"starter".equals(identityLinkEntity.getType())) continue;
                starter = identityLinkEntity.getUserId();
                break;
            }
            HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            Date date = new Date();
            if (HussarUtils.isNotEmpty((Object)processInst)) {
                date = processInst.getStartTime();
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("startUser", starter);
            map1.put("start_time", date.getTime() / 1000L);
            map1.put("processid", processInstanceId);
            map1.put("process_name", processInstance.getProcessDefinition().getName());
            map1.put("title", taskEntity.getTodoConfiguration());
            ArrayList tasks = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)userId)) {
                taskEntity.removeVariable("startUser");
            }
            String assignee = taskEntity.getAssignee() == null ? this.getAssigneeByTaskId(taskEntity) : taskEntity.getAssignee();
            String string = userId = HussarUtils.isEmpty((Object)assignee) ? userId : assignee;
            if (HussarUtils.isNotEmpty((Object)userId)) {
                List<String> userIdList = Arrays.asList(userId.split(","));
                for (String id : userIdList) {
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("taskid", taskEntity.getId());
                    taskMap.put("task_name", taskEntity.getName());
                    taskMap.put("touser", id);
                    taskMap.put("groupid", taskEntity.getId());
                    String formKey = taskEntity.getFormKey();
                    String jumpUrl = null;
                    String pcJumpUrl = null;
                    if (HussarUtils.isNotEmpty((Object)formKey)) {
                        String webUrl;
                        Map formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                        String mobileUrl = (String)formKeyMap.get("mobile");
                        if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                            jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInstance.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                        if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                            pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInstance.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                        }
                    }
                    taskMap.put("jump_url", jumpUrl);
                    taskMap.put("pc_jump_url", pcJumpUrl);
                    taskMap.put("level", 0);
                    taskMap.put("isnotify", 1);
                    taskMap.put("task_status", 0);
                    if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                        taskMap.put("countersign", 0);
                    } else {
                        taskMap.put("countersign", null);
                    }
                    taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
                    tasks.add(taskMap);
                }
            } else {
                HashMap<String, Object> taskMap = new HashMap<String, Object>();
                taskMap.put("taskid", taskEntity.getId());
                taskMap.put("task_name", taskEntity.getName());
                taskMap.put("touser", "noAssignee");
                taskMap.put("groupid", taskEntity.getId());
                String formKey = taskEntity.getFormKey();
                String jumpUrl = null;
                String pcJumpUrl = null;
                if (HussarUtils.isNotEmpty((Object)formKey)) {
                    String webUrl;
                    Map formKeyMap = (Map)JSON.parseObject((String)formKey, Map.class);
                    String mobileUrl = (String)formKeyMap.get("mobile");
                    if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                        jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInstance.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                    }
                    if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                        pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), taskEntity.getId(), processInstance.getProcessDefinitionKey(), taskEntity.getTaskDefinitionKey());
                    }
                }
                taskMap.put("jump_url", jumpUrl);
                taskMap.put("pc_jump_url", pcJumpUrl);
                taskMap.put("level", 0);
                taskMap.put("isnotify", 1);
                taskMap.put("task_status", 0);
                if (CommonCodeUtil.isMulti((Task)taskEntity)) {
                    taskMap.put("countersign", 0);
                } else {
                    taskMap.put("countersign", null);
                }
                taskMap.put("assign_start_time", taskEntity.getCreateTime().getTime() / 1000L);
                tasks.add(taskMap);
            }
            map1.put("tasks", tasks);
            CommonCodeUtil.taskDataPush(taskEntity.getTenantId(), map1, false);
        }
        if (this.lcdpBpmProperties.isPushTaskCenter() && HussarUtils.isNotEmpty((Object)this.lcdpBpmProperties.getTaskCenterDatapushAddress())) {
            ExecutionEntity processInstance = taskEntity.getProcessInstance();
            ExecutionEntity mainProcessInstance = this.getSuperProcess(processInstance);
            List identityLinks = processInstance.getIdentityLinks();
            if (processInstance != mainProcessInstance) {
                identityLinks.clear();
                identityLinks = mainProcessInstance.getIdentityLinks();
            }
            String starter = null;
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                if (!"starter".equals(identityLinkEntity.getType())) continue;
                starter = identityLinkEntity.getUserId();
                break;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("taskId", taskEntity.getId());
            data.put("businessKey", taskEntity.getBusinessKey());
            data.put("startUserId", starter);
            data.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
            data.put("processDefinitionId", taskEntity.getProcessDefinitionId());
            data.put("processDefinitionKey", processInstance.getProcessDefinitionId());
            data.put("taskName", taskEntity.getName());
            String assignee = taskEntity.getAssignee() == null ? this.getAssigneeByTaskId(taskEntity) : taskEntity.getAssignee();
            userId = HussarUtils.isEmpty((Object)assignee) ? userId : assignee;
            data.put("userId", userId);
            data.put("sendUser", taskEntity.getSendUser());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("startDate", simpleDateFormat.format(taskEntity.getCreateTime()));
            data.put("endDate", null);
            data.put("url", taskEntity.getFormKey());
            data.put("description", taskEntity.getTodoConfiguration());
            data.put("comment", null);
            data.put("processName", processInstance.getName());
            data.put("processInstanceId", processInstance.getId());
            String dataPushAddress = this.lcdpBpmProperties.getTaskCenterDatapushAddress();
            DataPushUtil.addData(data);
            DataPushUtil.dataPushReal(dataPushAddress);
        }
    }

    private ExecutionEntity getSuperProcess(ExecutionEntity processInstance) {
        ExecutionEntity supProcess = processInstance;
        if (HussarUtils.isNotEmpty((Object)processInstance.getSuperExecution())) {
            supProcess = processInstance.getSuperExecution().getProcessInstance();
            return this.getSuperProcess(supProcess);
        }
        return supProcess;
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u521b\u5efa\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private DataPush dataPush(TaskEntity task) {
        String processInstanceId = task.getProcessInstanceId();
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId);
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        } else {
            dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
            dataPush.setStartUserId(task.getSendUser());
        }
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(null);
        dataPush.setTaskDueTime(task.getDueDate());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setComment(null);
        dataPush.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
        dataPush.setProcessInsId(processInstanceId);
        dataPush.setTaskType(task.getTaskType());
        return dataPush;
    }
}

