/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudServiceTaskListener")
public class DefaultServiceTaskListener
implements JavaDelegate {
    private Logger logger = LogManager.getLogger(DefaultServiceTaskListener.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    private <T> T getTempVar(DelegateExecution execution, String varName) {
        return (T)((ExecutionEntity)execution).getLocalTempVariable(varName);
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String beanId = (String)this.getTempVar(delegateExecution, "beanId");
        String listenerModel = (String)this.getTempVar(delegateExecution, "listenerModel");
        String requestMethod = (String)this.getTempVar(delegateExecution, "requestMethod");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> map = new HashMap<String, Object>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        map.put("nodeName", delegateExecution.getCurrentActivityName());
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        if (beanId != null) {
            String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
            try {
                WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, map, serviceName);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_SERVICE_LISTENER);
            }
        }
    }
}

