/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.FireEvent;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpNodeLeaveAddCcTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class ParallelJumpTaskCmd
extends AddAttributeCmd<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    private String taskId;
    protected String userId;
    private String executionId;
    protected String comment;
    private String subProcessKey;
    private JumpModel jumpModel;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String processEventType;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)SpringContextHolder.getBean(SysActCcTaskMapper.class);
    private FireEvent fireEvent = (FireEvent)SpringContextHolder.getBean(FireEvent.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private TaskManagerService taskManagerService = (TaskManagerService)SpringContextHolder.getBean(TaskManagerService.class);
    private static final String DELETE_REASON = "ParallelJumpTaskCmd-Completed";

    public ParallelJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
        this.taskRejectModel = taskRejectModel;
        this.taskId = taskRejectModel.getTaskId();
    }

    public ParallelJumpTaskCmd(String taskId, String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String subProcessKey, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.taskId = taskId;
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.subProcessKey = subProcessKey;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.mandator = mandator;
    }

    public ParallelJumpTaskCmd setProcessEventType(String processEventType) {
        this.processEventType = processEventType;
        return this;
    }

    public ParallelJumpTaskCmd addParam(String str, Object obj) {
        this.paramMap.put(str, obj);
        return this;
    }

    public Void execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        HistoryManager historyManager = commandContext.getHistoryManager();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity execution = executionEntityManager.findExecutionById(this.executionId);
        this.addExecutionAttribute(execution);
        String type = BpmAttribute.getTaskSourceFlag((ActivityExecution)execution);
        boolean reject = TaskSourceFlag.isReject((String)type);
        ParamModel paramModel = this.getParamModel(execution, this.taskRejectModel, type);
        commandContext.addAttribute("listenerParam", (Object)paramModel);
        this.fireEvent.fireEvent(execution, this.processEventType, (String)this.paramMap.get("sub_process"));
        List list = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(execution.getProcessInstanceId());
        ExecutionEntity executionEntity = null;
        for (ExecutionEntity entity : list) {
            if ((this.subProcessKey == null || !this.subProcessKey.equals(entity.getSubProcessKey())) && (this.subProcessKey != null || entity.getParentId() != null)) continue;
            executionEntity = entity;
            break;
        }
        ArrayList<TaskEntity> taskEntities = new ArrayList<TaskEntity>();
        ArrayList<ExecutionEntity> executionEntities = new ArrayList<ExecutionEntity>();
        this.getExecutionAndTask(executionEntity, taskEntities, executionEntities);
        this.taskHandle(taskEntities, commandContext, type);
        for (int i = 1; i < executionEntities.size(); ++i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
                this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager, commandContext);
            }
            ExecutionEntity eeParent = ee.getParent();
            while (eeParent != null && eeParent.getExecutions().size() == 1) {
                ee.remove();
                if (ee.getActivityId() != null) {
                    new JumpNodeLeaveAddCcTaskCmd(ee).execute(commandContext);
                    historyManager.recordActivityEnd(ee);
                }
                ee = eeParent;
                eeParent = ee.getParent();
            }
            if (!ee.getTasks().isEmpty()) {
                TaskEntity taskEntity = (TaskEntity)ee.getTasks().get(0);
                this.completeDataPush(taskEntity, taskEntity.getAssignee());
            }
            ee.remove();
            if (ee.getActivityId() == null) continue;
            new JumpNodeLeaveAddCcTaskCmd(ee).execute(commandContext);
            historyManager.recordActivityEnd(ee);
        }
        ExecutionEntity ee = (ExecutionEntity)executionEntities.get(0);
        while (HussarUtils.isNotEmpty((Object)ee.getExecutions())) {
            this.executionHandle((ExecutionEntity)ee.getExecutions().get(0), historyManager, commandContext);
        }
        ExecutionEntity eeParent = ee.getParent();
        while (eeParent != null && eeParent.getExecutions().size() == 1 && !ee.getId().equals(executionEntity.getId())) {
            ee.remove();
            if (ee.getActivityId() != null) {
                new JumpNodeLeaveAddCcTaskCmd(ee).execute(commandContext);
                historyManager.recordActivityEnd(ee);
            }
            ee = eeParent;
            eeParent = ee.getParent();
        }
        if (ee.getActivityId() != null) {
            new JumpNodeLeaveAddCcTaskCmd(ee).execute(commandContext);
            historyManager.recordActivityEnd(ee);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.jumpModel, this.userId, type, this.taskRejectModel != null && this.taskRejectModel.isSubmit(), this.paramvar));
        return null;
    }

    private void getExecutionAndTask(ExecutionEntity executionEntity, List<TaskEntity> taskEntities, List<ExecutionEntity> executionEntities) {
        block6: {
            block5: {
                Collection affectedTasks = this.jumpModel.getAffectedTasks();
                if (affectedTasks != null && executionEntities != null && (executionEntity.getCurrentActivityId() == null || !affectedTasks.contains(executionEntity.getCurrentActivityId()))) break block5;
                if (executionEntity.getTasks() != null) {
                    taskEntities.addAll(executionEntity.getTasks());
                }
                if (executionEntities != null) {
                    executionEntities.add(executionEntity);
                }
                if (executionEntity.getExecutions() == null) break block6;
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, null);
                }
                break block6;
            }
            if (executionEntity.getExecutions() != null) {
                for (ExecutionEntity entity : executionEntity.getExecutions()) {
                    this.getExecutionAndTask(entity, taskEntities, executionEntities);
                }
            }
        }
    }

    private void taskHandle(List<TaskEntity> taskEntities, CommandContext commandContext, String type) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        boolean needDelTask = TaskSourceFlag.isRejectOrRevoke((String)type);
        ArrayList<String> allTimeOutTaskIds = new ArrayList<String>();
        ArrayList<String> delTaskIds = new ArrayList<String>();
        String processKey = null;
        String processDefinitionId = null;
        for (TaskEntity taskEntity : taskEntities) {
            ParamModel paramModel;
            if (taskEntity.isDeleted()) continue;
            List taskEntityList = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(taskEntity.getId());
            if (taskEntityList != null) {
                for (Task task : taskEntityList) {
                    ((TaskEntity)task).getExecution().removeTask((TaskEntity)task);
                    Context.getCommandContext().getTaskEntityManager().deleteTask((TaskEntity)task, null, true);
                }
            }
            if (taskEntity.getDueDate() != null) {
                allTimeOutTaskIds.add(taskEntity.getId());
            }
            if (this.taskId != null && this.taskId.equals(taskEntity.getId())) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.setDeleteType(null);
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                processDefinitionId = taskEntity.getProcessDefinitionId();
                processKey = processDefinitionId.split(":")[0];
                if (HussarUtils.isNotEmpty((Object)this.comment)) {
                    this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                }
                taskEntity.setAssignee(this.userId);
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
                this.completeDataPush(taskEntity, this.userId);
                continue;
            }
            if (needDelTask) {
                paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
                paramModel.mappingToDeleteType(type);
                commandContext.addAttribute("listenerParam", (Object)paramModel);
                taskEntity.fireEvent("complete");
                processKey = taskEntity.getProcessDefinitionId().split(":")[0];
                delTaskIds.add(taskEntity.getId());
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(SysActCcTask::getTaskId, (Object)Long.valueOf(taskEntity.getId()));
                this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
                taskEntityManager.deleteTask(taskEntity, DELETE_REASON, true, this.mandator);
                continue;
            }
            paramModel = (ParamModel)commandContext.getAttribute("listenerParam");
            paramModel.setDeleteType(null);
            commandContext.addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            if (HussarUtils.isNotEmpty((Object)this.comment)) {
                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
            }
            taskEntity.setAssignee(this.userId);
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            taskEntityManager.deleteTask(taskEntity, DELETE_REASON, false, this.mandator);
            this.completeDataPush(taskEntity, this.userId);
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processDefinitionId);
        if (delTaskIds.size() > 0 && this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessKey(processKey);
            dataPush.setTaskIds(delTaskIds);
            this.dataPushService.deleteMultiTask(dataPush);
        }
        if (HussarUtils.isNotEmpty(allTimeOutTaskIds)) {
            this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", allTimeOutTaskIds));
        }
    }

    private void executionHandle(ExecutionEntity executionEntity, HistoryManager historyManager, CommandContext commandContext) {
        while (HussarUtils.isNotEmpty((Object)executionEntity.getExecutions())) {
            this.executionHandle((ExecutionEntity)executionEntity.getExecutions().get(0), historyManager, commandContext);
        }
        executionEntity.remove();
        if (executionEntity.getActivityId() != null) {
            new JumpNodeLeaveAddCcTaskCmd(executionEntity).execute(commandContext);
            historyManager.recordActivityEnd(executionEntity);
        }
    }

    private static String joinStr(List<String> list) {
        return list == null ? null : String.join((CharSequence)",", list);
    }

    public ParamModel getParamModel(ExecutionEntity executionEntity, TaskRejectModel taskRejectModel, String type) {
        ParamModel paramModel = new ParamModel();
        if (HussarUtils.isNotEmpty((Object)this.processEventType) && "process_restart".equals(this.processEventType)) {
            paramModel.setCreateReason("reStartCreate");
            paramModel.setStarter(this.userId);
            return paramModel;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setFrom(ParallelJumpTaskCmd.joinStr(this.jumpModel.getJumpFrom()));
        paramModel.setTo(ParallelJumpTaskCmd.joinStr(this.jumpModel.getJumpTo()));
        if ("endProcess".equals(type) || "revokeProcess".equals(type) || TaskSourceFlag.isComplete((String)type)) {
            paramModel.mappingCompleteType(type);
            paramModel.setFrom(this.currentActivity.getId());
            paramModel.setHandler(this.userId);
            if (TaskSourceFlag.isComplete((String)type)) {
                paramModel.setSendUser(this.userId);
                paramModel.mappingToCreateReason(type);
                paramModel.setLastNodeId(this.currentActivity.getId());
                paramModel.setLastTaskId(this.taskId);
                paramModel.mappingLastCompleteType(type);
                paramModel.setLastNodeHandler(this.userId);
            }
            return paramModel;
        }
        paramModel.mappingCompleteType(type);
        if (HussarUtils.isNotEmpty((Object)taskRejectModel)) {
            Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)executionEntity, "appoint_assignee");
            paramModel.setTargetAssignee(targetAssigneeMap);
            paramModel.setFrom(ParallelJumpTaskCmd.joinStr(this.jumpModel.getJumpFrom()));
            String affectedTaskIds = null;
            affectedTaskIds = this.jumpModel.getAffectedTasks() != null ? String.join((CharSequence)",", this.jumpModel.getAffectedTasks()) : taskRejectModel.getAllAffectedTaskIds();
            paramModel.setAffectedNodeId(affectedTaskIds);
            paramModel.setHandler(taskRejectModel.getUserId());
            paramModel.setSendUser(taskRejectModel.getUserId());
            paramModel.mappingToCreateReason(type);
            if (taskRejectModel.getTask() != null) {
                paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
                paramModel.setLastNodeName(taskRejectModel.getTask().getName());
            }
            paramModel.mappingLastCompleteType(type);
            paramModel.setLastNodeHandler(taskRejectModel.getUserId());
        } else {
            paramModel.mappingCompleteType(type);
            paramModel.setHandler(this.userId);
        }
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }

    private void completeDataPush(TaskEntity task, String userId) {
        String processInstanceId = task.getProcessInstanceId();
        ExecutionEntity processInstance = task.getProcessInstance();
        List identityLinks = processInstance.getIdentityLinks();
        String starter = null;
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            starter = identityLinkEntity.getUserId();
            break;
        }
        HistoricProcessInstance processInst = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isEmpty(starter) && HussarUtils.isNotEmpty((Object)processInst)) {
            starter = processInst.getStartUserId();
        }
        Date date = new Date();
        if (HussarUtils.isNotEmpty((Object)processInst)) {
            date = processInst.getStartTime();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startUser", starter);
        map.put("start_time", date.getTime() / 1000L);
        map.put("processid", processInstanceId);
        map.put("process_name", processInst.getProcessDefinitionName());
        HistoricTaskInstance hisTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId())).singleResult();
        map.put("title", hisTask.getTodoConfiguration());
        ArrayList previousTasks = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)hisTask)) {
            HashMap<String, Object> taskMap = new HashMap<String, Object>();
            taskMap.put("taskid", hisTask.getId());
            StringBuilder formDetailId = new StringBuilder();
            formDetailId.append(hisTask.getProcessDefinitionId()).append(hisTask.getTaskDefinitionKey());
            String formDetailKey = this.taskManagerService.getFormDetailKey(formDetailId.toString());
            String jumpUrl = null;
            String pcJumpUrl = null;
            if (HussarUtils.isNotEmpty((Object)formDetailKey)) {
                String webUrl;
                Map formKeyMap = (Map)JSON.parseObject((String)formDetailKey, Map.class);
                String mobileUrl = (String)formKeyMap.get("mobile");
                if (HussarUtils.isNotEmpty((Object)mobileUrl)) {
                    jumpUrl = CommonCodeUtil.getUrl(mobileUrl, processInstance.getBusinessKey(), hisTask.getId(), processInst.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
                if (HussarUtils.isNotEmpty((Object)(webUrl = (String)formKeyMap.get("web")))) {
                    pcJumpUrl = CommonCodeUtil.getUrl(webUrl, processInstance.getBusinessKey(), hisTask.getId(), processInst.getProcessDefinitionKey(), hisTask.getTaskDefinitionKey());
                }
            }
            taskMap.put("touser", userId);
            if (HussarUtils.isEmpty((Object)task.getAssignee())) {
                ArrayList<String> userIds = new ArrayList<String>();
                for (IdentityLink identityLinkEntity : task.getCandidates()) {
                    userIds.add(identityLinkEntity.getUserId());
                }
                taskMap.put("touser", String.join((CharSequence)",", userIds));
            }
            taskMap.put("jump_url", jumpUrl);
            taskMap.put("pc_jump_url", pcJumpUrl);
            taskMap.put("task_status", 1);
            taskMap.put("assign_time", new Date().getTime() / 1000L);
            previousTasks.add(taskMap);
        }
        map.put("previous_tasks", previousTasks);
        CommonCodeUtil.taskDataPush(task.getTenantId(), map);
    }
}

