/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInstanceProcessStartCmd
implements Command<Void> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected String executionId;
    protected List<CallActivityInfo> callActivityInfos;
    protected int size;

    public MultiInstanceProcessStartCmd(String executionId, List<CallActivityInfo> callActivityInfos, int size) {
        this.executionId = executionId;
        this.callActivityInfos = callActivityInfos;
        this.size = size;
    }

    public Void execute(CommandContext commandContext) {
        ActivityExecution concurrentExecution;
        int loopCounter;
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        ActivityBehavior activityBehavior = ee.getActivity().getActivityBehavior();
        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString(this.callActivityInfos));
        ((ExecutionEntity)execution).addTempVariable("call_activity_info", (Object)array);
        ((ExecutionEntity)execution).setVariable("call_activity_info", (Object)array);
        int num = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        if (num == 0) {
            throw new BpmException(BpmExceptionCodeEnum.EXTERNAL_PROCESS_NOT_MULTI);
        }
        int nrOfInstances = num + this.callActivityInfos.size();
        int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances") + this.callActivityInfos.size();
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        ExecutionEntity newException = ee;
        boolean flag = "callActivity".equals(newException.getActivity().getProperty("type"));
        if (!flag) {
            throw new BpmException("\u5f53\u524d\u5b9e\u4f8b\u4e0d\u662f\u5916\u90e8\u5b50\u6d41\u7a0b");
        }
        this.setLoopVariable((ActivityExecution)newException, "nrOfInstances", nrOfInstances);
        this.setLoopVariable((ActivityExecution)newException, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable((ActivityExecution)newException, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (loopCounter = this.size; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = newException.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            concurrentExecution.setVariable("nrOfInstances", (Object)nrOfInstances);
            concurrentExecution.setVariable("nrOfActiveInstances", (Object)nrOfActiveInstances);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = this.size; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter - this.size);
            if (concurrentExecution.isActive() && !concurrentExecution.isEnded() && !concurrentExecution.getParent().isEnded()) {
                this.setLoopVariable(concurrentExecution, "loopCounter", loopCounter - this.size);
                concurrentExecution.executeActivity(concurrentExecution.getActivity());
                continue;
            }
            ActivityExecution concurrentExecution1 = (ActivityExecution)concurrentExecutions.get(loopCounter - this.size);
            ExecutionEntity ee1 = (ExecutionEntity)concurrentExecution1;
            ActivityBehavior activityBehavior1 = ee1.getActivity().getActivityBehavior();
            if (!(activityBehavior1 instanceof ExtendParallelMultiInstanceBehavior)) continue;
            try {
                ((ExtendParallelMultiInstanceBehavior)activityBehavior).getInnerActivityBehavior().execute(concurrentExecution1);
                continue;
            }
            catch (Exception e) {
                throw new BpmException(BpmExceptionCodeEnum.ERROR_START_EXTERNAL_PROCESS);
            }
        }
        newException.removeVariable("reject_from");
        newException.removeVariable("reject_to");
        newException.removeVariable("reject_execution");
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = newException;
            executionEntity.setActive(false);
        }
        return null;
    }

    protected void setLoopVariable(ActivityExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected void logLoopDetails(ActivityExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '{}' {}. Details: loopCounter={}, nrOrCompletedInstances={},nrOfActiveInstances={},nrOfInstances={}", new Object[]{execution.getActivity(), custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances});
        }
    }
}

