/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.concern.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActHiTaskinstMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuIdentitylinkMapper;
import com.jxdinfo.hussar.workflow.activiti.dao.BpmActRuTaskMapper;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActHiTaskinst;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuTask;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActHiTaskinstService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.concern.dao.SysActProcinstFollowerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.concern.model.SysProcinstFollower;
import com.jxdinfo.hussar.workflow.engine.bpm.concern.service.ISysProcinstFollowerService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.dao.SysActTaskNoticeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.model.SysActTaskNotice;
import com.jxdinfo.hussar.workflow.engine.bpm.notice.service.SysActTaskNoticeService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysProcinstFollowerServiceImpl
extends ServiceImpl<SysActProcinstFollowerMapper, SysProcinstFollower>
implements ISysProcinstFollowerService {
    @Resource
    SysActProcinstFollowerMapper sysActProcinstFollowerMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private BpmActRuTaskMapper bpmActRuTaskMapper;
    @Autowired
    private BpmActRuIdentitylinkMapper bpmActRuIdentitylinkMapper;
    @Autowired
    private SysActTaskNoticeMapper sysActTaskNoticeMapper;
    @Autowired
    private IBpmActRuIdentitylinkService bpmActRuIdentitylinkService;
    @Autowired
    ISysProcinstFollowerService iSysProcinstFollowerService;
    @Autowired
    private BpmActHiTaskinstMapper bpmActHiTaskinstMapper;
    @Autowired
    private IBpmActHiTaskinstService bpmActHiTaskinstService;
    @Autowired
    private SysActTaskNoticeService sysActTaskNoticeService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static final Logger logger = LoggerFactory.getLogger(SysProcinstFollowerServiceImpl.class);

    public BpmResponseResult addConcern(String processInsId, String follower) {
        int i;
        SysProcinstFollower sysProcinstFollower = new SysProcinstFollower();
        sysProcinstFollower.setProcInstId(processInsId);
        sysProcinstFollower.setFollower(follower);
        sysProcinstFollower.setDelFlag("0");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        sysProcinstFollower.setStartTime(timestamp);
        this.iSysProcinstFollowerService.save((Object)sysProcinstFollower);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpmActRuTask::getProcInstId, (Object)processInsId);
        LambdaQueryWrapper hiLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)hiLambdaQueryWrapper.eq(BpmActHiTaskinst::getProcInstId, (Object)processInsId)).isNotNull(BpmActHiTaskinst::getEndTime);
        LambdaQueryWrapper noticeLambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            ((LambdaQueryWrapper)noticeLambdaQueryWrapper.eq(SysActTaskNotice::getProcessInstId, (Object)processInsId)).eq(SysActTaskNotice::getUserId, (Object)follower);
        } else {
            ((LambdaQueryWrapper)noticeLambdaQueryWrapper.eq(SysActTaskNotice::getUserId, (Object)follower)).isNull(SysActTaskNotice::getProcessInstId);
        }
        List lists = this.bpmActRuTaskMapper.selectList((Wrapper)lambdaQueryWrapper);
        List hiTaskinsts = this.bpmActHiTaskinstMapper.selectList((Wrapper)hiLambdaQueryWrapper);
        List noticeTasks = this.sysActTaskNoticeMapper.selectList((Wrapper)noticeLambdaQueryWrapper);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (i = 0; i < lists.size(); ++i) {
            taskIds.add(((BpmActRuTask)lists.get(i)).getId());
        }
        for (i = 0; i < hiTaskinsts.size(); ++i) {
            ((BpmActHiTaskinst)hiTaskinsts.get(i)).setBottomFlag("-1");
        }
        for (SysActTaskNotice sysActTaskNotice : noticeTasks) {
            sysActTaskNotice.setBottomFlag("-1");
        }
        LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(taskIds)) {
            ((LambdaQueryWrapper)lambdaQueryWrapper1.in(BpmActRuIdentitylink::getTaskId, taskIds)).eq(BpmActRuIdentitylink::getUserId, (Object)follower);
            List bpmActRuIdentitylinks = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper1);
            for (BpmActRuIdentitylink bpmActRuIdentitylink : bpmActRuIdentitylinks) {
                bpmActRuIdentitylink.setBottomFlag("-1");
            }
            this.bpmActRuIdentitylinkService.saveOrUpdateBatch(bpmActRuIdentitylinks);
        }
        this.bpmActHiTaskinstService.saveOrUpdateBatch(hiTaskinsts);
        this.sysActTaskNoticeService.saveOrUpdateBatch((Collection)noticeTasks);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteConcern(String procInstId, String userId) {
        int result = this.sysActProcinstFollowerMapper.deleteConcern(procInstId, userId);
        int result2 = this.sysActProcinstFollowerMapper.updateBottom(procInstId, userId);
        int result3 = this.sysActTaskNoticeMapper.updateBottom(procInstId, userId);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpmActRuTask::getProcInstId, (Object)procInstId);
        List lists = this.bpmActRuTaskMapper.selectList((Wrapper)lambdaQueryWrapper);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (int i = 0; i < lists.size(); ++i) {
            taskIds.add(((BpmActRuTask)lists.get(i)).getId());
        }
        LambdaQueryWrapper lambdaQueryWrapper1 = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty(taskIds)) {
            ((LambdaQueryWrapper)lambdaQueryWrapper1.in(BpmActRuIdentitylink::getTaskId, taskIds)).eq(BpmActRuIdentitylink::getUserId, (Object)userId);
            List bpmActRuIdentitylinks = this.bpmActRuIdentitylinkMapper.selectList((Wrapper)lambdaQueryWrapper1);
            for (BpmActRuIdentitylink bpmActRuIdentitylink : bpmActRuIdentitylinks) {
                bpmActRuIdentitylink.setBottomFlag("0");
            }
            this.bpmActRuIdentitylinkService.saveOrUpdateBatch(bpmActRuIdentitylinks);
        }
        if (result == 0 && result2 == 0 && result3 == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorConcern(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryConcernList(String userId, String definitionKey, String type, String startTime, String endTime, Integer page, Integer rows, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setProcessKey(definitionKey);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        long concernTotal = this.sysActProcinstFollowerMapper.countAllConcernTotal(flowTaskQueryModel);
        if (concernTotal == 0L) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", "");
            data.put("count", concernTotal);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add(data);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        Page pages = new Page((long)page.intValue(), (long)rows.intValue());
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(concernTotal);
        List<FlowTask> datas = this.sysActProcinstFollowerMapper.queryAllConcern((Page<FlowTask>)pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> instIds = new ArrayList<Long>();
        for (FlowTask flowTask : datas) {
            if (HussarUtils.isNotEmpty((Object)flowTask.getTaskId())) {
                taskIds.add(Long.parseLong(flowTask.getTaskId()));
            }
            if (!HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId())) continue;
            instIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List<Object> allVariables = new ArrayList();
        List<Object> processMsg = new ArrayList();
        if (!datas.isEmpty()) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.isEmpty()) {
                instIds = null;
            } else {
                processMsg = this.flowTaskMapper.getProcInstMsg(instIds, null);
            }
            allVariables = this.flowTaskMapper.getAllVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(null, instIds));
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(taskIds, instIds));
        }
        HashMap<String, FlowProcess> processMsgMap = new HashMap<String, FlowProcess>();
        for (FlowProcess msg : processMsg) {
            processMsgMap.put(msg.getProcessInsId(), msg);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        for (FlowTask flowTask : datas) {
            if (HussarUtils.isNotEmpty((Object)flowTask.getProcessInsId()) && HussarUtils.isNotEmpty(processMsgMap.get(flowTask.getProcessInsId()))) {
                FlowProcess flowProcess = (FlowProcess)processMsgMap.get(flowTask.getProcessInsId());
                flowTask.setBusinessId(flowProcess.getBusinessId());
                flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
                flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
                flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            } else {
                flowTask.setProcessStartUserId(flowTask.getSendUser());
                flowTask.setProcessStartTime(flowTask.getStartTime());
                flowTask.setProcessEndTime(flowTask.getEndTime());
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : datas) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            if ("1".equals(flowTask.getIsNoticeTask())) {
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            }
            taskManagerQueryVo.setTaskSourceFlag(flowTask.getTaskSourceFlag());
            taskManagerQueryVo.setCreateTime(flowTask.getStartTime() == null ? "" : formatter.format(flowTask.getStartTime()));
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setType(flowTask.getType());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            userIds.add(flowTask.getProcessStartUserId());
            resultData.add(taskManagerQueryVo);
        }
        Map map = this.iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator<Object> iterator = resultData.iterator();
        while (iterator.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setProcessStartUserName(map.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator.next()).getProcessStartUserId()) == null ? "" : (String)map.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("data", resultData);
        data.put("count", Long.valueOf(pages.getTotal()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult editBottomFlag(String bottomType, String taskId, String flag) {
        int result = 0;
        String realTaskId = RealTaskId.getRealTaskId(taskId);
        if ("todo".equals(bottomType)) {
            result = this.sysActProcinstFollowerMapper.addTodoBottom(realTaskId, flag);
        } else if ("done".equals(bottomType)) {
            result = this.sysActProcinstFollowerMapper.addDoneBottom(realTaskId, flag);
        } else {
            InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorBottom(), null);
        }
        if (result == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorBottom(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }
}

