/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmYmlConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
public class LcdpBpmProperties {
    private final IBpmConfigService bpmConfigService;
    private final BpmYmlConfigurationProperties bpmYmlConfigurationProperties;

    public LcdpBpmProperties(IBpmConfigService bpmConfigService, BpmYmlConfigurationProperties bpmYmlConfigurationProperties) {
        this.bpmConfigService = bpmConfigService;
        this.bpmYmlConfigurationProperties = bpmYmlConfigurationProperties;
    }

    public boolean isModifyConfigurationOnline() {
        return true;
    }

    public boolean isEditableOnline() {
        return false;
    }

    public String getDeploymentModel() {
        return this.bpmYmlConfigurationProperties.getDeploymentModel();
    }

    public int getReadTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("read_timeout");
    }

    public int getConnectionTimeOut() {
        return (int)this.bpmConfigService.getLongByKeyUseCache("connection_timeout");
    }

    public String getCompleteHistoryOrderingRule() {
        return this.bpmConfigService.getStringByKeyUseCache("complete_history_ordering_rule");
    }

    public boolean isUseSecurityLevel() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_security_level");
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public String getUnifiedTodoServerName() {
        return this.bpmConfigService.getStringByKeyUseCache("unified_todo_server_name");
    }

    public String getTenantCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("tenant_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }

    public String getAssigneeMode() {
        return this.bpmConfigService.getStringByKeyUseCache("assignee_mode");
    }

    public String getRemoteDBName() {
        return this.bpmConfigService.getStringByKeyUseCache("remote_db_name");
    }

    public String getTenantType() {
        return this.bpmConfigService.getStringByKeyUseCache("tenant_type");
    }

    public boolean isWorkflowPlatformStandalone() {
        return this.bpmYmlConfigurationProperties.isWorkflowPlatformStandalone();
    }

    public boolean isTenantIsBase() {
        return !this.isWorkflowPlatformStandalone() || !"external".equals(this.getTenantType());
    }

    public String getTenantDBPrimaryKeyType() {
        return this.bpmConfigService.getStringByKeyUseCache("tenant_db_primary_key_type");
    }

    public boolean getTenantDBPrimaryKeyIsLong() {
        return "long".equals(this.getTenantDBPrimaryKeyType());
    }

    public boolean isPushIhn() {
        return this.bpmConfigService.getBooleanByKeyUseCache("push_ihn");
    }

    public String getIhnTenantId() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_tenant_id");
    }

    public String getIhnProjectAddress() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_project_address");
    }

    public boolean isIhnIsMqUse() {
        return this.bpmConfigService.getBooleanByKeyUseCache("ihn_is_mq_use");
    }

    public boolean isIhnIsGodAxe() {
        return this.bpmConfigService.getBooleanByKeyUseCache("ihn_is_god_axe");
    }

    public boolean isIhnIsMultiTenant() {
        return this.bpmConfigService.getBooleanByKeyUseCache("ihn_is_multi_tenant");
    }

    public boolean isIhnIsDataPush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("ihn_data_push");
    }

    public String getIhnDatapushTouser() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_data_push_touser");
    }

    public String getIhnDatapushUrl() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_datapush_url");
    }

    public boolean isIhnIsTaskDataPush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("ihn_is_task_data_push");
    }

    public boolean isDataPush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("is_data_push");
    }

    public String getDataPushAddress() {
        return this.bpmConfigService.getStringByKeyUseCache("data_push_address");
    }

    public String getIhnTaskDataPushUrl() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_task_data_push_url");
    }

    public String getIhnDataPushAgentid() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_data_push_agentid");
    }

    public String getIhnDatapushCorpid() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_datapush_corpid");
    }

    public String getIhnDatapushCorpsecret() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_datapush_corpsecret");
    }

    public String getIhnMobileTaskurl() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_mobile_taskurl");
    }

    public String getIhnWebTaskurl() {
        return this.bpmConfigService.getStringByKeyUseCache("ihn_web_taskurl");
    }

    public boolean isPushTaskCenter() {
        return this.bpmConfigService.getBooleanByKeyUseCache("push_task_center");
    }

    public String getTaskCenterDatapushAddress() {
        return this.bpmConfigService.getStringByKeyUseCache("task_center_datapush_address");
    }
}

