/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserAccountModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeModeChooseService assigneeModeChooseService;
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";

    private String getDeploymentModel() {
        return this.lcdpBpmProperties.getDeploymentModel();
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTree(id, isMainPost);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userTree(id, isMainPost);
                }
            }
            return this.workflowAssigneeChooseService.userTree(id, isMainPost, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.deptTree(id, organId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.deptTree(id, organId);
                }
            }
            return this.workflowAssigneeChooseService.deptTree(id, organId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree();
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.roleTree();
                }
            }
            return this.workflowAssigneeChooseService.roleTree();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(id, roleId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.roleTree(id, roleId);
                }
            }
            return this.workflowAssigneeChooseService.roleTree(id, roleId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDetail(userIds);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userDetail(String.join((CharSequence)",", userIds));
                }
            }
            return this.workflowAssigneeChooseService.userDetail(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDeptDetail(userId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return remoteAssigneeChooseService.userDeptDetail(userId);
                }
            }
            return this.workflowAssigneeChooseService.userDeptDetail(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var7_7 = deploymentModel;
        var8_9 = -1;
        switch (var7_7.hashCode()) {
            case -1663673663: {
                if (!var7_7.equals("workflow-platform")) break;
                var8_9 = 0;
                break;
            }
            case 103890628: {
                if (!var7_7.equals("micro")) break;
                var8_9 = 1;
                break;
            }
            case -902265784: {
                if (!var7_7.equals("single")) break;
                var8_9 = 2;
                break;
            }
        }
        switch (var8_9) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsers(condition, securityLevel);
            }
            case 1: {
                ** GOTO lbl45
            }
            default: {
                return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl45:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getCandidateUser(condition, securityLevel, false);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BpmTreeModel> getCandidateUserWithParent(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        serviceName = null;
        deploymentModel = this.getDeploymentModel();
        if ("micro".equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        var7_7 = deploymentModel;
        var8_9 = -1;
        switch (var7_7.hashCode()) {
            case -1663673663: {
                if (!var7_7.equals("workflow-platform")) break;
                var8_9 = 0;
                break;
            }
            case 103890628: {
                if (!var7_7.equals("micro")) break;
                var8_9 = 1;
                break;
            }
            case -902265784: {
                if (!var7_7.equals("single")) break;
                var8_9 = 2;
                break;
            }
        }
        switch (var8_9) {
            case 0: {
                return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, securityLevel);
            }
            case 1: {
                ** GOTO lbl45
            }
            default: {
                return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
            }
        }
        {
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
            }
lbl45:
            // 1 sources

            try {
                assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getCandidateUserWithParent(condition, securityLevel, false);
            }
            catch (Exception e) {}
            {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = this.sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = this.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)SpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
            switch (requestMethod) {
                case "GET": {
                    String response = HttpClient.doGet((String)url, (Map)map);
                    return JSON.parseArray((String)response, String.class);
                }
                case "POST": {
                    String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map));
                    return JSON.parseArray((String)response, String.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getSameLevelDeptIdByUserId(userId);
                }
            }
            return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserId(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getParentDeptIdByUserId(userId);
                }
            }
            return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getSameLevelDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.getParentDeptIdByUserIds(userId);
                }
            }
            return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Integer getSecurityLevel(String userId, String url) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSecurityLevel(userId);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)SpringContextHolder.getApplicationContext().getBean(AssigneeChooseService.class);
                    return Integer.valueOf(remoteAssigneeChooseService.getSecurityLevel(userId));
                }
            }
            return this.workflowAssigneeChooseService.getSecurityLevel(userId, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryDeptTreeByDeptName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByUserName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserTreeByUserName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByUserName(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserListByUserName(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryRoleTreeByRoleName(roleName);
                }
            }
            return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTree(organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserTree(organName);
                }
            }
            return this.workflowAssigneeChooseService.queryUserTree(organName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType());
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType());
                }
            }
            return this.workflowAssigneeChooseService.queryUserListByPage(pages, bpmTreeModel.getId(), bpmTreeModel.getType(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel);
                }
            }
            return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryAssigneeAndDept(users, organName);
                }
            }
            return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryNodeAssigneeListByPage(pages, String.join((CharSequence)",", users), organId, type);
                }
            }
            return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                    return assigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, JSON.toJSONString(users), organId, type);
                }
            }
            return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds);
                }
            }
            return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        String deploymentModel = this.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserMsgByUserIds(userIds);
                }
            }
            return this.workflowAssigneeChooseService.getUserMsgByUserIds(userIds, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryList(page, getListDto);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryList(Long.valueOf(page.getSize()), Long.valueOf(page.getCurrent()), getListDto);
            }
        }
        return this.workflowAssigneeChooseService.queryList(page, getListDto, true);
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryDept(name);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryDept(name);
            }
        }
        return this.workflowAssigneeChooseService.queryDept(name);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryRole(name);
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.queryRole(name);
            }
        }
        return this.workflowAssigneeChooseService.queryRole(name);
    }

    public String queryPlatformModel() {
        String deploymentModel = this.getDeploymentModel();
        if (WORKFLOW_PLATFORM.equals(deploymentModel)) {
            return this.lcdpBpmProperties.getAssigneeMode();
        }
        return deploymentModel;
    }

    public Map<String, String> getUserAccount(List<String> userIds, String tenantId) {
        String deploymentModel;
        List userAccountList = new ArrayList();
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                userAccountList = this.assigneeModeChooseService.getUserAccount(userIds);
                break;
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                userAccountList = assigneeChooseService.getUserAccount(userIds);
                break;
            }
            default: {
                userAccountList = this.workflowAssigneeChooseService.getUserAccount(userIds);
            }
        }
        HashMap<String, String> accountMap = new HashMap<String, String>();
        if (userAccountList != null && userAccountList.size() > 0) {
            for (BpmUserAccountModel bpmUserAccountModel : userAccountList) {
                if (accountMap.containsKey(bpmUserAccountModel.getUserId())) continue;
                accountMap.put(bpmUserAccountModel.getUserId(), bpmUserAccountModel.getUserAccount());
            }
        }
        return accountMap;
    }

    public List<BpmUserAccountModel> getUserAccount(String userId) {
        String deploymentModel;
        switch (deploymentModel = this.getDeploymentModel()) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.getUserAccount(Collections.singletonList(userId));
            }
            case "micro": {
                AssigneeChooseService assigneeChooseService = (AssigneeChooseService)SpringContextHolder.getBean(AssigneeChooseService.class);
                return assigneeChooseService.getUserAccount(Collections.singletonList(userId));
            }
        }
        return this.workflowAssigneeChooseService.getUserAccount(Collections.singletonList(userId));
    }

    private static List<BpmUserAccountModel> execute(Map<String, Object> map, String url) {
        String result = HttpRequestUtil.getResult(url, map);
        return JSONArray.parseArray((String)result, BpmUserAccountModel.class);
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }
}

