/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomFormService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.TaskDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.UserDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Lazy
    @Autowired
    private HistoryService historyService;
    @Autowired
    List<DataPushListener> dataPushListeners;
    @Lazy
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Lazy
    @Autowired
    private ICustomFormService iCustomFormService;
    private final LcdpBpmProperties lcdpBpmProperties;
    private Set<String> processDefinitionIdList = new HashSet<String>();

    public DataPushService(LcdpBpmProperties lcdpBpmProperties) {
        this.lcdpBpmProperties = lcdpBpmProperties;
    }

    public boolean isDataPush(Set<String> processDefinitionIdList) {
        return this.lcdpBpmProperties.isUseDatapush() || this.dataPushListeners.size() > 3 || CommonCodeUtil.isBindTable(processDefinitionIdList);
    }

    public boolean isDataPush() {
        return true;
    }

    public String getServiceName() {
        return this.lcdpBpmProperties.getUnifiedTodoServerName();
    }

    @Cacheable(value={"task_url"}, key="#processDefinitionKey + #taskDefinitionKey", unless="#result == null")
    public String getTaskUrl(String processDefinitionKey, String taskDefinitionKey) {
        String url = "";
        String[] processInfo = processDefinitionKey.split(":");
        String[] types = new String[]{"web", "mobile"};
        for (int i = 0; i < types.length; ++i) {
            SysActFormAuth sysActFormAuth = new SysActFormAuth();
            sysActFormAuth = (SysActFormAuth)this.sysActFormAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getFormType, (Object)"2")).eq(SysActFormAuth::getProcessKey, (Object)processInfo[0])).eq(SysActFormAuth::getProcessVersion, (Object)processInfo[1])).eq(SysActFormAuth::getFormState, (Object)types[i])).eq(SysActFormAuth::getTaskDefinitionKey, (Object)taskDefinitionKey));
            if (sysActFormAuth == null || sysActFormAuth.getFormId() == null) {
                sysActFormAuth = (SysActFormAuth)this.sysActFormAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getFormType, (Object)"8")).eq(SysActFormAuth::getProcessKey, (Object)processInfo[0])).eq(SysActFormAuth::getFormState, (Object)types[i])).eq(SysActFormAuth::getProcessVersion, (Object)processInfo[1])).isNull(SysActFormAuth::getTaskDefinitionKey));
            }
            CustomForm customForm = new CustomForm();
            if (types[i].equals("web")) {
                if (sysActFormAuth != null && sysActFormAuth.getFormId() != null) {
                    customForm = (CustomForm)this.iCustomFormService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomForm::getFormId, (Object)sysActFormAuth.getFormId()));
                    url = "{'web':'" + (customForm != null ? customForm.getFormPath() : "") + "',";
                    String webUrlProps = sysActFormAuth.getInsDisabled().replace("\"", "") + ";" + sysActFormAuth.getInsHidden().replace("\"", "");
                    url = url + "'webUrlProps':'" + webUrlProps + "',";
                    continue;
                }
                url = "{'web':'','webUrlProps':'',";
                continue;
            }
            if (sysActFormAuth != null && sysActFormAuth.getFormId() != null) {
                customForm = (CustomForm)this.iCustomFormService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomForm::getFormId, (Object)sysActFormAuth.getFormId()));
                url = url + "'mobile':'" + (customForm != null ? customForm.getFormPath() : "") + "',";
                String mobileUrlProps = sysActFormAuth.getInsDisabled().replace("\"", "") + ";" + sysActFormAuth.getInsHidden().replace("\"", "");
                url = url + "'mobileUrlProps':'" + mobileUrlProps + "'}";
                continue;
            }
            url = url + "'mobile':'','mobileUrlProps':''}";
        }
        return url;
    }

    public String getCcUrl(String processDefinitionKey, String type) {
        String url = "";
        String[] processInfo = processDefinitionKey.split(":");
        String[] types = new String[]{"web", "mobile"};
        for (int i = 0; i < types.length; ++i) {
            SysActFormAuth sysActFormAuth = new SysActFormAuth();
            sysActFormAuth = (SysActFormAuth)this.sysActFormAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getFormType, (Object)type)).eq(SysActFormAuth::getProcessKey, (Object)processInfo[0])).eq(SysActFormAuth::getFormState, (Object)types[i])).eq(SysActFormAuth::getProcessVersion, (Object)processInfo[1])).isNull(SysActFormAuth::getTaskDefinitionKey));
            CustomForm customForm = new CustomForm();
            if (types[i].equals("web")) {
                if (sysActFormAuth != null && sysActFormAuth.getFormId() != null) {
                    customForm = (CustomForm)this.iCustomFormService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomForm::getFormId, (Object)sysActFormAuth.getFormId()));
                    url = "{'web':'" + (customForm != null ? customForm.getFormPath() : "") + "',";
                    String webUrlProps = sysActFormAuth.getInsDisabled().replace("\"", "") + ";" + sysActFormAuth.getInsHidden().replace("\"", "");
                    url = url + "'webUrlProps':'" + webUrlProps + "',";
                    continue;
                }
                url = "{'web':'','webUrlProps':'',";
                continue;
            }
            if (sysActFormAuth != null && sysActFormAuth.getFormId() != null) {
                customForm = (CustomForm)this.iCustomFormService.getOne((Wrapper)new LambdaQueryWrapper().eq(CustomForm::getFormId, (Object)sysActFormAuth.getFormId()));
                url = url + "'mobile':'" + (customForm != null ? customForm.getFormPath() : "") + "',";
                String mobileUrlProps = sysActFormAuth.getInsDisabled().replace("\"", "") + ";" + sysActFormAuth.getInsHidden().replace("\"", "");
                url = url + "'mobileUrlProps':'" + mobileUrlProps + "'}";
                continue;
            }
            url = url + "'mobile':'','mobileUrlProps':''}";
        }
        return url;
    }

    public void addDataPush(DataPush dataPush, List<UserDataPush> userDataPushes) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addTask(dataPush, userDataPushes);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.completeTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.deleteTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void entrustDataPush(DataPush dataPush, List<UserDataPush> addUserList) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.entrustTask(dataPush, addUserList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.transferUserTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.rejectTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.revokeTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.freeJumpTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addUser(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.deleteMultiTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeSubTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.completeSubTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateSubTask(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateSubTask(deleteDataPushList, addDataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void assigneeUpdate(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.assigneeUpdate(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addSubTask(List<TaskDataPush> dataPushList) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addSubTask(dataPushList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updatePendingTask(List<TaskDataPush> dataPushList, DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updatePendingTask(dataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updatePendingTaskUser(List<TaskDataPush> deleteDataPushList, List<TaskDataPush> addDataPushList, DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updatePendingTaskUser(deleteDataPushList, addDataPushList, dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addCcTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
                if (dataPush.getEndDate() != null) {
                    dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addCcTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addCcTask(List<DataPush> dataPushList) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                for (DataPush dataPush : dataPushList) {
                    dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
                    if (dataPush.getEndDate() == null) continue;
                    dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addCcTask(dataPushList);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void readCcTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.readCcTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void readCcTask(List<DataPush> dataPushs) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                for (DataPush dataPush : dataPushs) {
                    dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.readCcTask(dataPushs);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.deleteCcTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addUrgeTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void endProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.endProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.createProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.transferTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reTransferTask(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.reTransferTask(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeDataPush(Task task, String comment, String userId, String mandator, String taskState, String taskType) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState).setTaskType(taskType);
            this.completeDataPush(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
        }
    }

    public void transferDataPush(Task task, String userId, String consignee) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            this.transferDataPush(dataPush);
        }
    }

    public void addUserDataPush(Task task, String userId) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessInsId(task.getProcessInstanceId());
        this.addUserDataPush(dataPush);
    }

    public void changeProcessStateDataPush(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.changeProcessState(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addStartProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.addStartProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateStartProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateStartProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteStartProcess(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.deleteStartProcess(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateBusinessInfo(DataPush dataPush) {
        if (this.isDataPush(this.processDefinitionIdList)) {
            try {
                for (DataPushListener dataPushListener : this.dataPushListeners) {
                    dataPushListener.updateBusinessInfo(dataPush);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

