/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.platform.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.dto.AddWorkflowDto;
import com.jxdinfo.hussar.workflow.engine.bpm.platform.service.IBpmDesignerService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4e13\u7528\u63a5\u53e3"})
@RequestMapping(value={"/bpm/BpmDesigner"})
public class BpmDesignerController {
    private final SysActAssigneeService sysActAssigneeService;
    private final IBpmDesignerService bpmDesignerService;
    private final SysActProcessFileService sysActProcessFileService;
    private final IDefinitionEngineService definitionEngineService;

    public BpmDesignerController(SysActAssigneeService sysActAssigneeService, IBpmDesignerService bpmDesignerService, SysActProcessFileService sysActProcessFileService, IDefinitionEngineService definitionEngineService) {
        this.sysActAssigneeService = sysActAssigneeService;
        this.bpmDesignerService = bpmDesignerService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.definitionEngineService = definitionEngineService;
    }

    @GetMapping(value={"/getProcessFileByVersion"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7248\u672c\u6d41\u7a0b\u6587\u4ef6", notes="\u83b7\u53d6\u6307\u5b9a\u7248\u672c\u6d41\u7a0b\u6587\u4ef6")
    @AuditLog(moduleName="\u83b7\u53d6\u6307\u5b9a\u7248\u672c\u6d41\u7a0b\u6587\u4ef6", eventDesc="\u83b7\u53d6\u6307\u5b9a\u7248\u672c\u6d41\u7a0b\u6587\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public WorkFlow getProcessFileByVersion(@RequestParam(value="processKey") String processKey, Integer version) {
        return this.sysActProcessFileService.getFileByProcessKey(processKey, version);
    }

    @GetMapping(value={"/getProcessAssignee"})
    @ApiOperation(value="\u6839\u636e\u7248\u672c\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", notes="\u6839\u636e\u7248\u672c\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskDefKey", value="\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="version", value="\u6d41\u7a0b\u7248\u672c", required=false, paramType="query")})
    @AuditLog(moduleName="\u6d41\u7a0b\u7ba1\u7406", eventDesc="\u6839\u636e\u7248\u672c\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public BpmResponseResult getProcessAssigneeByVersion(String procDefKey, String taskDefKey, String version) {
        return this.sysActAssigneeService.getProcessAssigneeByVersion(procDefKey, taskDefKey, version);
    }

    @PostMapping(value={"/addWorkflow"})
    @ApiOperation(value="\u65b0\u589e\u6d41\u7a0b", notes="\u65b0\u589e\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u65b0\u589e\u6d41\u7a0b", eventDesc="\u65b0\u589e\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> addWorkflow(@RequestBody WorkFlow workFlow) {
        return this.bpmDesignerService.addWorkflow(workFlow);
    }

    @GetMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u6d41\u7a0b", notes="\u65b0\u589e\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u65b0\u589e\u6d41\u7a0b", eventDesc="\u65b0\u589e\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> addWorkflow(AddWorkflowDto addWorkflowDto) {
        return this.bpmDesignerService.addWorkflow(addWorkflowDto);
    }

    @GetMapping(value={"/getExtendContent"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u62d3\u5c55\u914d\u7f6e", notes="\u83b7\u53d6\u6d41\u7a0b\u62d3\u5c55\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u6d41\u7a0b\u62d3\u5c55\u914d\u7f6e", eventDesc="\u83b7\u53d6\u6d41\u7a0b\u62d3\u5c55\u914d\u7f6e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<WorkFlow> getExtendContend(String processKey) {
        return this.bpmDesignerService.getExtendContend(processKey);
    }

    @PostMapping(value={"/saveWorkflow"})
    @ApiOperation(value="\u4fdd\u5b58\u6307\u5b9a\u7248\u672c\u6d41\u7a0b", notes="\u4fdd\u5b58\u6307\u5b9a\u7248\u672c\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u4fdd\u5b58\u6307\u5b9a\u7248\u672c\u6d41\u7a0b", eventDesc="\u4fdd\u5b58\u6307\u5b9a\u7248\u672c\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> saveWorkflow(@RequestBody WorkFlow workFlow) {
        return this.bpmDesignerService.saveWorkflow(workFlow);
    }

    @PostMapping(value={"/publishWorkflow"})
    @ApiOperation(value="\u5fae\u8c03\u6d41\u7a0b", notes="\u5fae\u8c03\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u5fae\u8c03\u6d41\u7a0b", eventDesc="\u5fae\u8c03\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> publishWorkflow(@RequestBody WorkFlow workFlow) {
        return this.bpmDesignerService.publishWorkflow(workFlow);
    }

    @PostMapping(value={"/publishNewVersion"})
    @ApiOperation(value="\u53d1\u5e03\u65b0\u7248\u672c", notes="\u53d1\u5e03\u65b0\u7248\u672c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u53d1\u5e03\u65b0\u7248\u672c", eventDesc="\u53d1\u5e03\u65b0\u7248\u672c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> publishNewVersion(@RequestBody WorkFlow workFlow) {
        return this.bpmDesignerService.publishNewVersion(workFlow);
    }

    @GetMapping(value={"/updateProcessKey"})
    @ApiOperation(value="\u4fee\u6539\u6d41\u7a0b\u6807\u8bc6", notes="\u4fee\u6539\u6d41\u7a0b\u6807\u8bc6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="workFlow", value="\u6d41\u7a0b\u4fe1\u606f", required=true, paramType="query")})
    @AuditLog(moduleName="\u4fee\u6539\u6d41\u7a0b\u6807\u8bc6", eventDesc="\u4fee\u6539\u6d41\u7a0b\u6807\u8bc6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> updateProcessKey(String oldProcessKey, String processKey) {
        return this.bpmDesignerService.updateProcessKey(oldProcessKey, processKey);
    }

    @GetMapping(value={"/queryAllProcess"})
    @ApiOperation(value="\u83b7\u53d6\u9664\u672c\u6d41\u7a0b\u5916\u7684\u6240\u6709\u6d41\u7a0b", notes="\u83b7\u53d6\u9664\u672c\u6d41\u7a0b\u5916\u7684\u6240\u6709\u6d41\u7a0b")
    public BpmResponseResult queryAllProcess(String processKey) {
        return this.definitionEngineService.queryAllProcess(processKey);
    }
}

