/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.form.WorkflowAuthConfigQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActFormAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service(value="sysActFormAuthService")
public class SysActFormAuthServiceImpl
extends ServiceImpl<SysActFormAuthMapper, SysActFormAuth>
implements SysActFormAuthService {
    @Resource
    private SysActFormAuthMapper sysActFormAuthMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private HistoryService historyService;
    @Autowired
    private ITaskEngineService taskEngineService;
    @Resource
    private TaskService taskService;
    @Resource
    private RepositoryService repositoryService;
    private static final String DEPLOYMENT_MODEL = "workflow-platform";

    public JSONArray queryFormAuthConfig(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getProcessKey())) {
            flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)workflowAuthConfigQueryDto.getProcessKey());
            Integer version = workflowAuthConfigQueryDto.getVersion();
            if (version == null) {
                Integer conditionVersion = null;
                if (workflowAuthConfigQueryDto.getTaskId() != null) {
                    HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(workflowAuthConfigQueryDto.getTaskId())).singleResult();
                    if (historicTaskInstance == null) {
                        return new JSONArray();
                    }
                    conditionVersion = Integer.valueOf(historicTaskInstance.getProcessDefinitionId().split(":")[1]);
                } else if (workflowAuthConfigQueryDto.isGetLastVersion()) {
                    conditionVersion = Integer.valueOf(this.getProcessVersion(workflowAuthConfigQueryDto.getProcessKey()));
                } else {
                    try {
                        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(workflowAuthConfigQueryDto.getProcessKey(), null);
                        conditionVersion = Integer.valueOf(processDefinitionId.split(":")[1]);
                    }
                    catch (BpmException processDefinitionId) {
                        // empty catch block
                    }
                }
                if (HussarUtils.isNotEmpty(conditionVersion)) {
                    Integer eqVersion = conditionVersion;
                    flowAuthWrapper.and(wrapper -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysActFormAuth::getProcessVersion)).or()).eq(SysActFormAuth::getProcessVersion, (Object)eqVersion);
                    });
                }
            } else {
                flowAuthWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(SysActFormAuth::getProcessVersion)).or()).eq(SysActFormAuth::getProcessVersion, (Object)version);
                });
            }
        }
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormName()), SysActFormAuth::getFormName, (Object)workflowAuthConfigQueryDto.getFormName());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormType()), SysActFormAuth::getFormType, (Object)workflowAuthConfigQueryDto.getFormType());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getTaskDefinitionKey()), SysActFormAuth::getTaskDefinitionKey, (Object)workflowAuthConfigQueryDto.getTaskDefinitionKey());
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)workflowAuthConfigQueryDto.getFormState()), SysActFormAuth::getFormState, (Object)workflowAuthConfigQueryDto.getFormState());
        List result = this.list((Wrapper)flowAuthWrapper);
        JSONArray jsonArray = new JSONArray();
        for (SysActFormAuth sysActFormAuth : result) {
            if (sysActFormAuth.getProcessVersion() == null) continue;
            jsonArray.add((Object)sysActFormAuth);
        }
        if (jsonArray.isEmpty()) {
            jsonArray.addAll((Collection)result);
        }
        return jsonArray;
    }

    public JSONArray initList(String formName, String processKey, String formType, String taskDefinitionKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formName), SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)processKey), SysActFormAuth::getProcessKey, (Object)processKey);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)taskDefinitionKey), SysActFormAuth::getTaskDefinitionKey, (Object)taskDefinitionKey);
        flowAuthWrapper.eq(HussarUtils.isNotEmpty((Object)formState), SysActFormAuth::getFormState, (Object)formState);
        if (HussarUtils.isNotEmpty((Object)processKey)) {
            flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
            String version = this.getProcessVersion(processKey);
            if (version == null) {
                return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
            }
            flowAuthWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
            });
            List result = this.list((Wrapper)flowAuthWrapper);
            JSONArray jsonArray = new JSONArray();
            for (SysActFormAuth sysActFormAuth : result) {
                if (sysActFormAuth.getProcessVersion() == null) continue;
                jsonArray.add((Object)sysActFormAuth);
            }
            if (jsonArray.isEmpty()) {
                jsonArray.addAll((Collection)result);
            }
            return JSON.parseArray((String)JSON.toJSONString((Object)jsonArray));
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.list((Wrapper)flowAuthWrapper)));
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public boolean saveOrUpdateAuth(JSONArray insertAuth) {
        List list = JSONObject.parseArray((String)insertAuth.toJSONString(), SysActFormAuth.class);
        String version = this.getProcessVersion(((SysActFormAuth)list.get(0)).getProcessKey());
        for (SysActFormAuth formAuth : list) {
            formAuth.setProcessVersion(version);
        }
        return this.saveOrUpdateBatch(list);
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public boolean removeAuth(String formName, String formType, String processKey, String formState) {
        LambdaQueryWrapper flowAuthWrapper = new LambdaQueryWrapper();
        flowAuthWrapper.eq(SysActFormAuth::getFormName, (Object)formName);
        flowAuthWrapper.eq(SysActFormAuth::getFormType, (Object)formType);
        flowAuthWrapper.eq(SysActFormAuth::getProcessKey, (Object)processKey);
        String version = this.getProcessVersion(processKey);
        if (version == null) {
            flowAuthWrapper.isNull(SysActFormAuth::getProcessVersion);
        } else {
            flowAuthWrapper.eq(SysActFormAuth::getProcessVersion, (Object)version);
        }
        flowAuthWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getFormState, (Object)formState)).or()).isNull(SysActFormAuth::getFormState);
        });
        return this.remove((Wrapper<SysActFormAuth>)flowAuthWrapper);
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public boolean remove(Wrapper<SysActFormAuth> queryWrapper) {
        return super.remove(queryWrapper);
    }

    private String getProcessVersion(String processKey) {
        try {
            String processDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
            return processDefinitionId.split(":")[1];
        }
        catch (BpmException e) {
            return null;
        }
    }

    public boolean copyAuth(String processKey, String oldProcessKey) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)oldProcessKey));
        for (SysActFormAuth sysActFormAuth : list) {
            sysActFormAuth.setId(null);
            sysActFormAuth.setProcessKey(processKey);
        }
        return this.saveBatch(list);
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public boolean saveOrUpdate(List<SysActFormAuth> sysActFormAuths) {
        return this.saveOrUpdateBatch(sysActFormAuths);
    }

    public List<SysActFormAuth> selectWithOutTaskDefinitionKey(String processDefinitionKey, String version) {
        return this.sysActFormAuthMapper.selectWithOutTaskDefinitionKey(processDefinitionKey, version);
    }

    public BpmResponseResult queryFormAuthConfigs(String formId, String taskId, String formType, String processKey) {
        List<Object> list = new ArrayList();
        JSONObject jsonObject = new JSONObject();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            String processVersion = definitionModel.getVersion();
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(formId, formType, processKey, processVersion);
            jsonObject.put("isFirst", (Object)true);
        } else {
            String procDefId = this.taskEngineService.getProcessIdByTaskId(taskId).getMsg();
            String processVersion = procDefId.split(":")[1];
            list = this.sysActFormAuthMapper.queryFormAuth(taskId, formType, processVersion);
            if ("2".equals(formType)) {
                jsonObject.put("isFirst", (Object)false);
                Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
                String taskDefinitionKey = task.getTaskDefinitionKey();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
                Process process = bpmnModel.getMainProcess();
                Collection flowElements = process.getFlowElements();
                for (FlowElement flowElement : flowElements) {
                    List startOut;
                    String firstUserTask;
                    if (!(flowElement instanceof StartEvent) || !taskDefinitionKey.equals(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef())) continue;
                    jsonObject.put("isFirst", (Object)true);
                    break;
                }
            }
        }
        jsonObject.put("data", (Object)JSONArray.parseArray((String)JSON.toJSONString(list)));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    public BpmResponseResult queryFormAuthConfigs(String taskId, String formType, String processKey) {
        List<Object> list = new ArrayList();
        if (HussarUtils.isEmpty((Object)taskId)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            String processVersion = definitionModel.getVersion();
            list = this.sysActFormAuthMapper.queryFormAuthWithoutTask(formType, processKey, processVersion);
        } else {
            list = this.sysActFormAuthMapper.queryFormAuth(taskId, formType);
        }
        return InstallResult.success((JSONArray)JSONArray.parseArray((String)JSON.toJSONString(list)));
    }

    public BpmResponseResult queryFormAuthConfigsByDto(WorkflowAuthConfigQueryDto workflowAuthConfigQueryDto) {
        return InstallResult.success((JSONArray)this.queryFormAuthConfig(workflowAuthConfigQueryDto));
    }
}

