/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.ProcessStateChangeLis;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.ProcessState;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessCreateListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(ProcessCreateListener.class);
    @Autowired
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    @Lazy
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private ProcessStateChangeLis processStateChangeLis;
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        String originalProcessInsId;
        DataPush dataPush;
        List chosenDayElement;
        List globalTimeOutStrategyElement;
        ExecutionEntity entity = (ExecutionEntity)((ActivitiProcessStartedEventImpl)activitiEvent).getEntity();
        BpmnModel bm = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(entity.getProcessDefinitionId());
        Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        List globalDueDateElement = (List)extensionElementList.get("globalDueDate");
        String globalDueDate = "";
        String globalTimeOutStrategy = "";
        String chosenDay = "";
        if (HussarUtils.isNotEmpty((Object)globalDueDateElement) && HussarUtils.isNotEmpty(((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate"))) {
            globalDueDate = ((ExtensionAttribute)((List)((ExtensionElement)globalDueDateElement.get(0)).getAttributes().get("globalDueDate")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategyElement = (List)extensionElementList.get("globalTimeOutStrategy"))) && HussarUtils.isNotEmpty(((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy"))) {
            globalTimeOutStrategy = ((ExtensionAttribute)((List)((ExtensionElement)globalTimeOutStrategyElement.get(0)).getAttributes().get("globalTimeOutStrategy")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)(chosenDayElement = (List)extensionElementList.get("chosenDay"))) && HussarUtils.isNotEmpty(((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay"))) {
            chosenDay = ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get("chosenDay")).get(0)).getValue();
        }
        if (HussarUtils.isNotEmpty((Object)globalDueDate) || HussarUtils.isNotEmpty((Object)globalTimeOutStrategy) || HussarUtils.isNotEmpty((Object)chosenDay)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "processCreateEnd");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("createTime", simpleDateFormat.format(new Date()));
            map.put("businessId", entity.getBusinessKey());
            map.put("processInsId", entity.getProcessInstanceId());
            map.put("processDefinitionId", entity.getProcessDefinitionId());
            map.put("processDefinitionName", entity.getProcessDefinition().getName());
            List linkEntityList = entity.getIdentityLinks();
            if (!linkEntityList.isEmpty()) {
                map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
            }
            CommonCodeUtil.triggerEventHandleClass(map);
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            Context.getCommandContext().addAttribute("taskSourceFlag", (Object)"main_process_start");
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            dataPush = new DataPush();
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessInsId(entity.getProcessInstanceId());
            dataPush.setProcessStartTime(new Date());
            dataPush.setProcessState("startProcess");
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            dataPush = new DataPush();
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessInsId(entity.getProcessInstanceId());
            dataPush.setProcessName(entity.getProcessDefinition().getName());
            dataPush.setProcessDefinitionId(entity.getProcessDefinitionId());
            dataPush.setProcessStartTime(new Date());
            dataPush.setStartUserId(String.valueOf(entity.getVariable("startUser")));
            String processTitle = entity.getProcessTitle();
            String dataDetail = entity.getDataDetail();
            dataPush.setProcessTitle(processTitle);
            dataPush.setDataDetail(dataDetail);
            Process process = (Process)bm.getProcesses().get(0);
            Collection flowElements = process.getFlowElements();
            String targetNodeId = null;
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                break;
            }
            dataPush.setTaskDefinitionKey(targetNodeId);
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask) || !targetNodeId.equals(flowElement.getId())) continue;
                String formKey = ((UserTask)flowElement).getFormKey();
                dataPush.setUrl(formKey);
                break;
            }
            Model model = (Model)Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().createModelQuery().modelKey(entity.getProcessDefinitionKey()).singleResult();
            dataPush.setAppId(String.valueOf(model.getAppId()));
            this.dataPushService.addStartProcess(dataPush);
        }
        List linkEntityList = entity.getIdentityLinks();
        String sendId = ((IdentityLinkEntity)linkEntityList.get(0)).getUserId();
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(entity.getProcessDefinitionId());
        List sysActCcTaskConfigList = this.sysActCcTaskConfigService.getCcTaskConfig(entity.getProcessDefinitionKey(), Integer.valueOf(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion()), "cc_after_process_start");
        if (HussarUtils.isNotEmpty((Object)sysActCcTaskConfigList)) {
            List<SysActCcTask> ccTaskList = CcTaskUtil.getCcTaskList(entity, sysActCcTaskConfigList, sendId, sendId);
            if (HussarUtils.isNotEmpty(ccTaskList)) {
                String url = this.dataPushService.getCcUrl(entity.getProcessDefinitionId(), "9");
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                for (SysActCcTask sysActCcTask : ccTaskList) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    userIds.add(sysActCcTask.getReceiveUser());
                    Map list1 = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
                    sysActCcTask.setPostId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getPostId());
                    sysActCcTask.setPostOrganId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getDepartmentId());
                    sysActCcTask.setPostUnitId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getUnitId());
                    long id = IdWorker.getId((Object)sysActCcTask);
                    sysActCcTask.setId(Long.valueOf(id));
                    if (!this.dataPushService.isDataPush(processDefinitionIdList)) continue;
                    DataPush dataPush2 = new DataPush();
                    dataPush2.setDataPushId(sysActCcTask.getId().toString());
                    dataPush2.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                    dataPush2.setUserId(sysActCcTask.getReceiveUser());
                    dataPush2.setSendUser(sysActCcTask.getSendUser());
                    dataPush2.setStartDate((Date)sysActCcTask.getSendTime());
                    dataPush2.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                    dataPush2.setBusinessKey(sysActCcTask.getBusinessId());
                    dataPush2.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                    dataPush2.setUrl(url);
                    dataPush2.setProcessKey(sysActCcTask.getProcDefKey());
                    dataPush2.setDeptId(sysActCcTask.getPostOrganId());
                    dataPush2.setUnitId(sysActCcTask.getPostUnitId());
                    dataPush2.setPostId(sysActCcTask.getPostId());
                    dataPushes.add(dataPush2);
                }
                if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                    this.dataPushService.addCcTask(dataPushes);
                }
            }
            this.sysActCcTaskService.saveBatch(ccTaskList);
        }
        if (HussarUtils.isNotEmpty((Object)(originalProcessInsId = this.instanceEngineMapper.selectOriginalProcessInstId(entity.getBusinessKey())))) {
            HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId());
            historicProcessInstance.setOriginalProcInstId(Long.valueOf(Long.parseLong(originalProcessInsId)));
            this.flowTaskService.eliminateRemindersByProcessInstanceId(originalProcessInsId);
        }
        Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId()).setProcessState(ProcessState.RUNNING.getValue());
        this.processStateChangeLis.ProcessStateChange((ProcessInstance)entity.getProcessInstance(), ProcessState.RUNNING);
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u542f\u52a8\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

