/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudExecutionListener")
public class DefaultExecutionListener
implements ExecutionListener {
    private static Logger logger = LogManager.getLogger(DefaultExecutionListener.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private BpmExceptionCodeEnum[] IGNORE_MESSAGE_EXCEPTIONS = new BpmExceptionCodeEnum[]{BpmExceptionCodeEnum.LISTENER_MODEL_ERROR, BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR};

    public void notify(DelegateExecution delegateExecution) throws Exception {
        VariableInstance loopCounter = delegateExecution.getVariableInstanceLocal("loopCounter");
        if (loopCounter != null || ((ExecutionEntity)delegateExecution).getActivity() == null) {
            return;
        }
        Object subProcessKey = delegateExecution.getVariableLocal("sub_process_key");
        if (subProcessKey != null && ((String)subProcessKey).startsWith(((ExecutionEntity)delegateExecution).getActivityId() + ":")) {
            return;
        }
        String beanId = (String)delegateExecution.getVariableLocal("beanId");
        delegateExecution.removeVariableLocal("beanId");
        String listenerModel = (String)delegateExecution.getVariableLocal("listenerModel");
        delegateExecution.removeVariableLocal("listenerModel");
        String requestMethod = (String)delegateExecution.getVariableLocal("requestMethod");
        delegateExecution.removeVariableLocal("listenerModel");
        boolean isAsyn = Boolean.parseBoolean((String)delegateExecution.getVariableLocal("isAsyn"));
        delegateExecution.removeVariableLocal("isAsyn");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> map = new HashMap<String, Object>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        String nodeName = delegateExecution.getCurrentActivityName();
        ActivityImpl activity = ((ExecutionEntity)delegateExecution).getActivity();
        if (HussarUtils.isEmpty((Object)nodeName) && HussarUtils.isNotEmpty((Object)activity) && HussarUtils.isNotEmpty((Object)activity.getProperties()) && HussarUtils.isNotEmpty(activity.getProperties().get("name"))) {
            nodeName = String.valueOf(activity.getProperties().get("name"));
        }
        map.put("nodeName", nodeName);
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        Object listenerType = Context.getCommandContext().getAttribute("listenerType");
        String eventName = delegateExecution.getEventName();
        if (HussarUtils.isEmpty((Object)delegateExecution.getEventName()) && HussarUtils.isNotEmpty((Object)listenerType)) {
            eventName = listenerType.toString();
        }
        if (HussarUtils.isNotEmpty((Object)activity) && HussarUtils.isNotEmpty((Object)activity.getProperties()) && HussarUtils.isNotEmpty(activity.getProperties().get("type"))) {
            String type = String.valueOf(activity.getProperties().get("type"));
            map.put("activityType", type);
        }
        Object taskSourceFlag = null;
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        Object info = Context.getCommandContext().getAttribute("listenerParam");
        ParamModel paramModel = (ParamModel)info;
        if (HussarUtils.isNotEmpty((Object)eventName) && "end".equals(eventName) || "end".equals(delegateExecution.getEventName())) {
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                map.put("endTime", paramModel.getEndTime());
                map.put("endType", paramModel.getCompleteType());
            }
        } else if (HussarUtils.isNotEmpty((Object)eventName) && "start".equals(eventName) || "start".equals(delegateExecution.getEventName())) {
            taskSourceFlag = Context.getCommandContext().getAttribute("taskSourceFlag");
            map.put("createTime", simpleDateFormat.format(new Date()));
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                if (!map.containsKey("starter")) {
                    map.put("starter", paramModel.getStarter());
                }
                map.put("lastNodeId", paramModel.getLastNodeId());
                map.put("lastNodeName", paramModel.getLastNodeName());
                map.put("lastNodeAssignee", paramModel.getLastNodeHandler());
                map.put("createType", paramModel.getCreateReason());
            } else if (HussarUtils.isNotEmpty((Object)taskSourceFlag)) {
                map.put("createType", taskSourceFlag.toString());
            }
        }
        if (beanId != null) {
            try {
                if ("callActivityStart".equals(eventName)) {
                    String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
                    List<CallActivityInfo> result = WorkflowListenerUtils.executionCallActivityListener(listenerModel, requestMethod, beanId, map, serviceName);
                    if (HussarUtils.isNotEmpty(result)) {
                        delegateExecution.setVariableLocal("call_activity_info", result);
                    }
                } else {
                    String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
                    WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, map, serviceName);
                }
            }
            catch (Exception e) {
                if (e instanceof BpmException) {
                    if (this.isPushMessageException((BpmException)((Object)e)).booleanValue()) {
                        throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER, this.buildMessageParam(delegateExecution));
                    }
                    throw e;
                }
                throw new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_EXECUTION_LISTENER, this.buildMessageParam(delegateExecution));
            }
        }
    }

    private BpmExceptionMessageParam buildMessageParam(DelegateExecution delegateExecution) {
        ExecutionEntity execution = (ExecutionEntity)delegateExecution;
        BpmExceptionMessageParam bpmExceptionMessageParam = new BpmExceptionMessageParam();
        bpmExceptionMessageParam.setProcessKey(execution.getProcessDefinition().getKey());
        bpmExceptionMessageParam.setProcessName(execution.getProcessDefinition().getName());
        bpmExceptionMessageParam.setProcessDefinitionId(execution.getProcessDefinition().getId());
        bpmExceptionMessageParam.setTaskDefinitionKey(execution.getActivity().getId());
        bpmExceptionMessageParam.setTaskDefinitionName((String)execution.getActivity().getProperties().get("name"));
        return bpmExceptionMessageParam;
    }

    private Boolean isPushMessageException(BpmException e) {
        Boolean isPushMessage = Boolean.TRUE;
        for (BpmExceptionCodeEnum bpmExceptionCodeEnum : this.IGNORE_MESSAGE_EXCEPTIONS) {
            boolean isExceptionEqual = e.getMessage().equals(bpmExceptionCodeEnum.getMessage());
            boolean isCodeEqual = e.getExceptionCode().equals(bpmExceptionCodeEnum.getCode());
            if (!isExceptionEqual || !isCodeEqual) continue;
            isPushMessage = Boolean.FALSE;
            break;
        }
        return isPushMessage;
    }
}

