/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class ChildTaskCompleteCmd
extends CommonPrepareCmd {
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    protected String comment;

    @Override
    protected void taskAuthentication(TaskEntity task) {
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (task.isSuspended()) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_IS_SUSPENDED);
        }
        if (task.getParentTaskId() == null) {
            throw new BpmException(BpmExceptionCodeEnum.COMMON_TASK_WITH_ASSIST_HANDLE);
        }
    }

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        TaskEntity parentTask = commandContext.getTaskEntityManager().findTaskById(task.getParentTaskId());
        if (parentTask != null) {
            if (this.comment != null) {
                CommentEntity.addComment((String)this.userId, (String)this.taskId, (String)this.comment);
            }
            task.setVariableLocal("complete_from", (Object)task.getTaskDefinitionKey());
            task.setVariableLocal("taskSourceFlag", (Object)"assist_complete");
            if (!task.isDeleted()) {
                task.fireEvent("beforeComplete");
                task.setDeleted(true);
                String taskId = task.getId();
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
                commandContext.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
                commandContext.getHistoryManager().recordTaskAssigneeChange(taskId, this.userId);
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)task, null, (boolean)false));
                commandContext.getHistoryManager().recordTaskEnd(taskId, "complete", this.mandator, this.taskState, ((IdentityLinkEntity)task.getIdentityLinks().get(0)).getAssistInitiator());
                task.fireEvent("complete");
                commandContext.getDbSqlSession().delete((PersistentObject)task);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.ENTITY_DELETED, (Object)task));
                }
            }
        }
        this.dataPushService.completeDataPush((Task)task, this.comment, this.userId, this.mandator, this.taskState, task.getTaskType());
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ccQueryWrapper.eq(SysActCcTask::getTaskDefKey, (Object)task.getTaskDefinitionKey())).eq(SysActCcTask::getProcessInsId, (Object)Long.parseLong(task.getProcessInstanceId()))).in(SysActCcTask::getReceiveUser, new Object[]{this.userId})).eq(SysActCcTask::getTaskState, (Object)"0");
        List ccTaskList = this.iSysActCcTaskService.list((Wrapper)ccQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)ccTaskList)) {
            ArrayList<Long> ccTaskIds = new ArrayList<Long>();
            for (SysActCcTask sysActCcTask : ccTaskList) {
                ccTaskIds.add(sysActCcTask.getId());
            }
            this.iSysActCcTaskService.readBatch(ccTaskIds);
        }
    }

    public ChildTaskCompleteCmd(String taskId, String userId, String comment) {
        super(taskId, userId);
        this.comment = comment;
    }

    public ChildTaskCompleteCmd(String taskId, String userId, String mandator, String comment) {
        super(taskId, userId, mandator);
        this.comment = comment;
    }
}

