/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class AlternativeCommonJumpTaskCmd
implements Command<Void> {
    private String userId;
    private String executionId;
    private String targetNodeIds;
    private String comment;
    private String type;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private String mandator;
    private TaskRejectModel taskRejectModel;
    private ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService iTaskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private BpmActPendingTaskService pendingTaskService = (BpmActPendingTaskService)SpringContextHolder.getBean(BpmActPendingTaskService.class);
    private static Map<String, String> createType = new HashMap<String, String>();
    private static Map<String, String> deleteType = new HashMap<String, String>();

    public Void execute(CommandContext commandContext) {
        boolean needRemoveTask = this.paramvar.get("ADD_HISTORY_TASK_START_TIME") != null;
        boolean reject = this.type.equals("reject");
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType(this.type);
        paramModel.setCreateReason(createType.get(this.type));
        Context.getCommandContext().addAttribute("info", (Object)paramModel);
        List executionEntities = executionEntity.getExecutions();
        for (int i = executionEntities.size() - 1; i >= 0; --i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        if (needRemoveTask) {
            ArrayList<Long> longDelTaskIds = new ArrayList<Long>();
            ArrayList<String> delTaskIds = new ArrayList<String>();
            for (TaskEntity taskEntity : taskEntities) {
                longDelTaskIds.add(Long.parseLong(taskEntity.getId().replace("'", "")));
                delTaskIds.add(taskEntity.getId().replace("'", ""));
            }
            if (HussarUtils.isNotEmpty(delTaskIds)) {
                this.taskEngineService.removeMultiHistoryTask(longDelTaskIds);
                if (this.dataPushService.isDataPush()) {
                    DataPush dataPush = new DataPush();
                    dataPush.setTaskIds(delTaskIds);
                    this.dataPushService.deleteMultiTask(dataPush);
                }
            }
        }
        for (TaskEntity taskEntity : taskEntities) {
            if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("info", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            if (this.taskRejectModel != null) {
                taskEntity.setApprovalType(this.taskRejectModel.getApprovalType());
                if (this.taskRejectModel.getIdentityLink() != null) {
                    taskEntity.setDeptId(this.taskRejectModel.getIdentityLink().getDeptId());
                    taskEntity.setPostId(this.taskRejectModel.getIdentityLink().getPostId());
                }
            }
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "addedFrontNode", false, this.mandator);
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        if (reject) {
            this.paramvar.put("reject_from", this.currentActivity.getId());
            this.paramvar.put("reject_to", this.targetNodeIds);
        }
        this.fireExecutionListener(executionEntity);
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.targetNodeIds, this.userId, this.type, this.paramvar));
        return null;
    }

    public AlternativeCommonJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
    }

    public AlternativeCommonJumpTaskCmd(String userId, String mandator, String executionId, String targetNodeIds, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.targetNodeIds = targetNodeIds;
        this.comment = comment;
        this.type = type;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskRejectModel = taskRejectModel;
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.setCompleteType(this.type);
            paramModel.setFrom(task.getTaskDefinitionKey());
            paramModel.setTo(this.targetNodeIds);
            paramModel.setHandler(this.userId);
            paramModel.setSendUser(this.userId);
            paramModel.setCreateReason(createType.get(this.type));
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.setLastTaskId(task.getId());
            paramModel.setLastCompleteType(this.type);
            paramModel.setLastNodeHandler(this.userId);
            return paramModel;
        }
        paramModel.setComment(this.comment);
        paramModel.setCompleteType(taskRejectModel.getType());
        paramModel.setApprovalType(taskRejectModel.getApprovalType());
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
            }
        } else {
            paramModel.setDeleteType(deleteType.get(taskRejectModel.getType()));
        }
        String targetIds = taskRejectModel.getTargetIds();
        Map<String, String> targetAssigneeMap = new HashMap<String, String>();
        if (taskRejectModel.getMap().containsKey("reject_appoint_assignee")) {
            String targetAssignee = taskRejectModel.getMap().get("reject_appoint_assignee").toString();
            targetAssigneeMap.put(targetIds, targetAssignee);
        } else if (taskRejectModel.getMap().containsKey("appoint_assignee")) {
            targetAssigneeMap = (Map)taskRejectModel.getMap().get("appoint_assignee");
        }
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setTo(taskRejectModel.getTargetIds());
        paramModel.setFrom(task.getTaskDefinitionKey());
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler(this.userId);
        paramModel.setSendUser(taskRejectModel.getUserId());
        if (createType.containsKey(taskRejectModel.getType())) {
            paramModel.setCreateReason(createType.get(taskRejectModel.getType()));
        }
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastTaskId(taskRejectModel.getTask().getId());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.setLastCompleteType(taskRejectModel.getType());
        paramModel.setLastNodeHandler(this.userId);
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            execution.setEventName("end");
            List executionListeners = activity.getExecutionListeners("end");
            ExecutionListener executionListener = (ExecutionListener)executionListeners.get(0);
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        createType.put("reject", "rejectCreate");
        createType.put("revoke", "revokeCreate");
        createType.put("reject_revoke", "revokeCreate");
        createType.put("freejump", "freeJumpCreate");
        createType.put("complete", "completeToRejectCreate");
        deleteType.put("reject", "rejectDeleted");
        deleteType.put("revoke", "revokeDeleted");
        deleteType.put("reject_revoke", "revokeDeleted");
        deleteType.put("freejump", "freeJumpDeleted");
        deleteType.put("endProcess", "endProcessDeleted");
        deleteType.put("revokeProcess", "revokeProcessDeleted");
        deleteType.put("complete", "completeToRejectDeleted");
    }
}

