/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.constant.CustomFormConstant;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.dao.CustomFormMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomCategory;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomFormInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomCategoryService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomFormInfoService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomFormService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.util.CustomFormUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.util.TreeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.CategoryAndFormTreeVo;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.CustomFormDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.CustomFormDumpDto;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class CustomFormServiceImpl
extends HussarServiceImpl<CustomFormMapper, CustomForm>
implements ICustomFormService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ICustomFormInfoService customFormInfoService;
    @Autowired
    private ICustomCategoryService customCategoryService;
    @Autowired
    private WorkflowSnowflakeIDGenerator idGenerator;

    public boolean add(CustomForm customForm) {
        if (HussarUtils.isEmpty((Object)customForm.getCategoryId())) {
            throw new BpmException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        Integer maxOrder = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomForm::getCategoryId, (Object)customForm.getCategoryId())).orderByDesc(CustomForm::getFormOrder)).stream().map(CustomForm::getFormOrder).findFirst().orElseGet(() -> 0);
        if (!this.save((BaseEntity)customForm.setFormOrder(Integer.valueOf(maxOrder + 1)))) {
            return false;
        }
        ArrayList<CustomFormInfo> customFormInfoList = new ArrayList<CustomFormInfo>();
        this.buildAllParentId(null, customForm.getFormInfo(), customFormInfoList, null, customForm.getFormId());
        return this.customFormInfoService.saveBatch(customFormInfoList);
    }

    private void buildAllParentId(Long parentId, List<CustomFormInfo> customFormInfoDtoList, List<CustomFormInfo> addCustomFormInfoList, List<CustomFormInfo> updateCustomFormInfoList, Long formId) {
        for (int i = 0; i < customFormInfoDtoList.size(); ++i) {
            CustomFormInfo customFormInfoDto = customFormInfoDtoList.get(i);
            customFormInfoDto.setParentId(parentId).setFormId(formId).setFormInfoOrder(Integer.valueOf(i + 1));
            if (HussarUtils.isEmpty((Object)customFormInfoDto.getFormInfoId())) {
                customFormInfoDto.setFormInfoId(Long.valueOf(this.idGenerator.getSequence().nextValue()));
                addCustomFormInfoList.add(customFormInfoDto);
            } else if (updateCustomFormInfoList != null) {
                updateCustomFormInfoList.add(customFormInfoDto);
            }
            if (!HussarUtils.isNotEmpty((Object)customFormInfoDto.getChildren())) continue;
            this.buildAllParentId(customFormInfoDto.getFormInfoId(), customFormInfoDto.getChildren(), addCustomFormInfoList, updateCustomFormInfoList, formId);
        }
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public boolean update(CustomForm customForm) {
        if (HussarUtils.isEmpty((Object)customForm.getFormId())) {
            throw new BpmException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (!this.updateById((BaseEntity)customForm)) {
            return false;
        }
        ArrayList<CustomFormInfo> addCustomFormInfoList = new ArrayList<CustomFormInfo>();
        ArrayList<CustomFormInfo> updateCustomFormInfoList = new ArrayList<CustomFormInfo>();
        this.buildAllParentId(null, customForm.getFormInfo(), addCustomFormInfoList, updateCustomFormInfoList, customForm.getFormId());
        if (!updateCustomFormInfoList.isEmpty()) {
            this.customFormInfoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomFormInfo::getFormId, (Object)customForm.getFormId())).notIn(CustomFormInfo::getFormInfoId, (Collection)updateCustomFormInfoList.stream().map(CustomFormInfo::getFormInfoId).collect(Collectors.toList())));
            this.customFormInfoService.updateBatchById(updateCustomFormInfoList);
        }
        if (!addCustomFormInfoList.isEmpty()) {
            this.customFormInfoService.saveBatch(addCustomFormInfoList);
        }
        return true;
    }

    public boolean delete(Long formId) {
        this.customFormInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(CustomFormInfo::getFormId, (Object)formId));
        return this.removeById(formId);
    }

    public CustomForm detail(Long formId) {
        CustomForm customForm = (CustomForm)this.getById(formId);
        if (customForm == null) {
            throw new BpmException("\u8868\u5355\u4e0d\u5b58\u5728");
        }
        List customFormInfoList = ((LambdaQueryChainWrapper)this.customFormInfoService.lambdaQuery().eq(CustomFormInfo::getFormId, (Object)formId)).list();
        if (!customFormInfoList.isEmpty()) {
            customForm.setFormInfo(TreeUtil.flatToTree((Collection)customFormInfoList, customFormInfo -> HussarUtils.isEmpty((Object)customFormInfo.getParentId()) ? null : customFormInfo.getParentId(), CustomFormInfo::getFormInfoId, CustomFormInfo::setChildren, Comparator.comparing(CustomFormInfo::getFormInfoOrder), null));
        }
        return customForm;
    }

    public IPage<CustomForm> queryCustomFormByName(Page<CustomForm> page, Long categoryId, String formName) {
        return this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarUtils.isNotEmpty((Object)categoryId), CustomForm::getCategoryId, (Object)categoryId)).like(HussarUtils.isNotEmpty((Object)formName), CustomForm::getFormName, (Object)formName));
    }

    public List<CategoryAndFormTreeVo> categoryAndFormTree(Long parentId) {
        if (parentId == null) {
            parentId = CustomFormConstant.CATEGORY_ROOT;
        }
        List categoryList = ((LambdaQueryChainWrapper)this.customCategoryService.lambdaQuery().eq(CustomCategory::getParentId, (Object)parentId)).list();
        List formList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomForm::getCategoryId, (Object)parentId)).list();
        ArrayList<CategoryAndFormTreeVo> result = new ArrayList<CategoryAndFormTreeVo>();
        if (!categoryList.isEmpty()) {
            Set hasChildSet = ((LambdaQueryChainWrapper)this.customCategoryService.lambdaQuery().in(CustomCategory::getParentId, (Collection)categoryList.stream().map(CustomCategory::getCategoryId).collect(Collectors.toList()))).list().stream().map(CustomCategory::getParentId).collect(Collectors.toSet());
            categoryList.sort(Comparator.comparing(CustomCategory::getCategoryOrder));
            for (CustomCategory customCategory : categoryList) {
                if (!hasChildSet.contains(customCategory.getCategoryId())) {
                    customCategory.setIsLeaf(true);
                }
                result.add(CategoryAndFormTreeVo.buildVo((CustomCategory)customCategory));
            }
        }
        if (!formList.isEmpty()) {
            formList.sort(Comparator.comparing(CustomForm::getFormOrder));
            for (CustomForm customForm : formList) {
                result.add(CategoryAndFormTreeVo.buildVo((CustomForm)customForm));
            }
        }
        return result;
    }

    public List<CategoryAndFormTreeVo> categoryAndFormTree() {
        return this.buildCategoryAndFormTree(this.customCategoryService.list(), this.list(), true);
    }

    public List<CategoryAndFormTreeVo> categoryAndFormList() {
        ArrayList<CategoryAndFormTreeVo> result = new ArrayList<CategoryAndFormTreeVo>();
        for (CustomCategory customCategory : this.customCategoryService.list()) {
            result.add(CategoryAndFormTreeVo.buildVo((CustomCategory)customCategory));
        }
        for (CustomForm customForm : this.list()) {
            result.add(CategoryAndFormTreeVo.buildVo((CustomForm)customForm));
        }
        return result;
    }

    public List<CategoryAndFormTreeVo> queryCategoryAndFormTreeByFormName(String formName) {
        if (HussarUtils.isEmpty((Object)formName)) {
            return Collections.emptyList();
        }
        List customFormList = ((LambdaQueryChainWrapper)this.lambdaQuery().like(CustomForm::getFormName, (Object)formName)).list();
        if (customFormList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Long, List<CategoryAndFormTreeVo>> customFormMap = new HashMap<Long, List<CategoryAndFormTreeVo>>();
        for (CustomForm customForm : customFormList) {
            customFormMap.computeIfAbsent(customForm.getCategoryId(), k -> new ArrayList()).add(CategoryAndFormTreeVo.buildVo((CustomForm)customForm));
        }
        for (List value : customFormMap.values()) {
            value.sort(Comparator.comparing(CategoryAndFormTreeVo::getSort));
        }
        List categoryList = CustomFormUtil.buildCustomCategoryTreeByNodes(customFormMap.keySet(), (Collection)this.customCategoryService.list());
        ArrayList<CategoryAndFormTreeVo> res = new ArrayList<CategoryAndFormTreeVo>();
        this.buildFullTree(categoryList, res, customFormMap);
        return res;
    }

    private void buildFullTree(List<CustomCategory> categoryList, List<CategoryAndFormTreeVo> categoryAndFormTreeVoList, Map<Long, List<CategoryAndFormTreeVo>> customFormMap) {
        for (CustomCategory customCategory : categoryList) {
            CategoryAndFormTreeVo categoryAndFormTreeVo = CategoryAndFormTreeVo.buildVo((CustomCategory)customCategory);
            categoryAndFormTreeVoList.add(categoryAndFormTreeVo);
            if (!customCategory.getChildren().isEmpty()) {
                ArrayList<CategoryAndFormTreeVo> childCategoryList = new ArrayList<CategoryAndFormTreeVo>();
                categoryAndFormTreeVo.setChildren(childCategoryList);
                this.buildFullTree(customCategory.getChildren(), childCategoryList, customFormMap);
                List<CategoryAndFormTreeVo> childFormList = customFormMap.get(customCategory.getCategoryId());
                if (childFormList == null) continue;
                childCategoryList.addAll(childFormList);
                continue;
            }
            List<CategoryAndFormTreeVo> childFormList = customFormMap.get(customCategory.getCategoryId());
            if (childFormList == null) continue;
            categoryAndFormTreeVo.setChildren(childFormList);
        }
    }

    public CustomFormDumpVo dump(CustomFormDumpDto customFormDumpDto) {
        CustomFormDumpVo customFormDumpVo = new CustomFormDumpVo();
        HashSet<Long> categorySet = new HashSet<Long>();
        if (HussarUtils.isNotEmpty((Object)customFormDumpDto.getFormIdList())) {
            List customFormList = this.list((Wrapper)new LambdaQueryWrapper().in(CustomForm::getFormId, (Collection)customFormDumpDto.getFormIdList()));
            customFormList.forEach(customForm -> categorySet.add(customForm.getCategoryId()));
            List customFormInfoList = this.customFormInfoService.list((Wrapper)new LambdaQueryWrapper().in(CustomFormInfo::getFormId, (Collection)customFormDumpDto.getFormIdList()));
            customFormDumpVo.setFormList(customFormList).setFormInfoList(customFormInfoList);
        }
        if (customFormDumpDto.getCategoryIdList() != null) {
            categorySet.addAll(customFormDumpDto.getCategoryIdList());
        }
        if (HussarUtils.isNotEmpty(categorySet)) {
            customFormDumpVo.setCategoryList(this.getFullCategoryIdList(categorySet));
        }
        return customFormDumpVo;
    }

    private List<CustomCategory> getFullCategoryIdList(Set<Long> categorySet) {
        return TreeUtil.nodeToFlatTree(categorySet, (Collection)this.customCategoryService.list(), CustomCategory::getParentId, CustomCategory::getCategoryId);
    }

    private List<CategoryAndFormTreeVo> buildCategoryAndFormTree(List<CustomCategory> categoryList, List<CustomForm> customFormList, boolean addRoot) {
        ArrayList<CategoryAndFormTreeVo> list = new ArrayList<CategoryAndFormTreeVo>();
        if (addRoot) {
            list.add(CategoryAndFormTreeVo.buildRoot());
        }
        if (HussarUtils.isNotEmpty(categoryList)) {
            for (CustomCategory customCategory : categoryList) {
                list.add(CategoryAndFormTreeVo.buildVo((CustomCategory)customCategory));
            }
        }
        if (HussarUtils.isNotEmpty(customFormList)) {
            for (CustomForm customForm : customFormList) {
                list.add(CategoryAndFormTreeVo.buildVo((CustomForm)customForm));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        List result = TreeUtil.flatToTree(list, CategoryAndFormTreeVo::getParentId, CategoryAndFormTreeVo::getId, CategoryAndFormTreeVo::setChildren, (node1, node2) -> {
            if (Objects.equals(node1.getType(), node2.getType())) {
                return node1.getSort() - node2.getSort();
            }
            return CategoryAndFormTreeVo.getTypeSort((CategoryAndFormTreeVo)node1) - CategoryAndFormTreeVo.getTypeSort((CategoryAndFormTreeVo)node2);
        }, null);
        TreeUtil.ergodicTree((Collection)result, CategoryAndFormTreeVo::getChildren, node -> {
            if (HussarUtils.isEmpty((Object)node.getChildren())) {
                node.setHasChildren(false);
            }
        });
        return result;
    }

    public List<CategoryAndFormTreeVo> preload(CustomFormDumpVo customFormDumpVo) {
        return this.buildCategoryAndFormTree(customFormDumpVo.getCategoryList(), customFormDumpVo.getFormList(), true);
    }

    @CacheEvict(value={"task_url"}, allEntries=true)
    public List<CategoryAndFormTreeVo> load(CustomFormDumpVo customFormDumpVo) {
        if (HussarUtils.isNotEmpty((Object)customFormDumpVo.getCategoryList())) {
            this.customCategoryService.saveOrUpdateBatch((Collection)customFormDumpVo.getCategoryList());
        }
        if (HussarUtils.isNotEmpty((Object)customFormDumpVo.getFormList())) {
            this.saveOrUpdateBatch(customFormDumpVo.getFormList());
            ((LambdaUpdateChainWrapper)this.customFormInfoService.lambdaUpdate().in(CustomFormInfo::getFormId, (Collection)customFormDumpVo.getFormList().stream().map(CustomForm::getFormId).collect(Collectors.toSet()))).remove();
            if (HussarUtils.isNotEmpty((Object)customFormDumpVo.getFormInfoList())) {
                this.customFormInfoService.saveBatch((Collection)customFormDumpVo.getFormInfoList());
            }
        }
        return this.preload(customFormDumpVo);
    }
}

