/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.vo.SysActCcTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.dao.SysActCcTaskConfigMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CcAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends HussarServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DataPushService dataPushService;
    @Lazy
    @Resource
    HistoryService historyService;
    @Lazy
    @Resource
    TaskService taskService;
    @Lazy
    @Resource
    RuntimeService runtimeService;
    @Lazy
    @Resource
    RepositoryService repositoryService;
    @Lazy
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    SysActCcTaskConfigMapper sysActCcTaskConfigMapper;
    private static Logger logger = LoggerFactory.getLogger(SysActCcTaskServiceImpl.class);
    private static final List<String> COMPLETE_HISTORY = new ArrayList<String>();

    public ApiResponse<Page<SysActCcTaskVo>> query(Page<SysActCcTaskVo> pages, SysActCcTaskQueryDto sysActCcTaskQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getStartTime()) ? formatter.parse(sysActCcTaskQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getEndTime()) ? formatter.parse(sysActCcTaskQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long todoTotal = this.sysActCcTaskMapper.countCcTotal(start, end, sysActCcTaskQueryDto);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<SysActCcTaskVo> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, start, end, sysActCcTaskQueryDto);
        if (sysActCcTasks != null && !sysActCcTasks.isEmpty()) {
            List users = sysActCcTasks.stream().map(SysActCcTaskVo::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTaskVo sysActCcTask : sysActCcTasks) {
                JSONObject object;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if ("0".equals(sysActCcTask.getTaskType())) {
                    formDetailKey = sysActCcTask.getFormKey();
                }
                if (!HussarUtils.isNotEmpty((Object)formDetailKey) || !HussarUtils.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWebFormDetailKey(object.getString("web"));
                sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<String> ccTask(SysActCcTaskDto sysActCcTaskDto) {
        List ccFormKeyList;
        Object ccFormKeyMap;
        String taskId = sysActCcTaskDto.getTaskId();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        String assignee = sysActCcTaskDto.getAssignee();
        String userId = sysActCcTaskDto.getUserId();
        if (HussarUtils.isEmpty((Object)assignee)) {
            return ApiResponse.fail((String)"\u63a5\u6536\u4eba\u4e3a\u7a7a");
        }
        ArrayList<String> receiverList = new ArrayList<String>(Arrays.asList(sysActCcTaskDto.getAssignee().split(",")));
        if (receiverList.contains(userId)) {
            return ApiResponse.fail((String)"\u4e0d\u53ef\u4f20\u9605\u7ed9\u81ea\u5df1");
        }
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).taskId(realTaskId.getTaskId())).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
        }
        if (TaskType.isAssist((String)task.getTaskType())) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getAssistTaskWithErrorHandle());
        }
        HashSet users = new HashSet();
        List<HistoricTaskInstance> hisTaskList = this.getHisTask(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        ArrayList<String> errorUserIds = new ArrayList<String>();
        ArrayList<String> hisTaskIds = new ArrayList<String>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            hisTaskIds.add(historicTaskInstance.getId());
            if (historicTaskInstance.getEndTime() == null) {
                List identityLinkList = this.taskService.getIdentityLinksType(historicTaskInstance.getId());
                for (IdentityLink identityLink : identityLinkList) {
                    if (!receiverList.contains(identityLink.getUserId())) continue;
                    errorUserIds.add(identityLink.getUserId());
                }
                continue;
            }
            if (!receiverList.contains(historicTaskInstance.getAssignee())) continue;
            errorUserIds.add(historicTaskInstance.getAssignee());
        }
        List<SysActCcTask> ccTaskList = this.getCcTaskList(Long.valueOf(task.getProcessInstanceId()), task.getTaskDefinitionKey(), task.getSubProcessKey());
        for (SysActCcTask sysActCcTask : ccTaskList) {
            if (!receiverList.contains(sysActCcTask.getReceiveUser())) continue;
            errorUserIds.add(sysActCcTask.getReceiveUser());
        }
        if (HussarUtils.isNotEmpty(errorUserIds)) {
            String string = this.iAssigneeChooseService.getUserNames(errorUserIds);
            return ApiResponse.fail((String)(string + "\u5df2\u5b58\u5728\u8be5\u8282\u70b9\u7684\u4efb\u52a1\u6216\u4f20\u9605\uff0c\u65e0\u6cd5\u6dfb\u52a0\u4e3a\u4f20\u9605\u4eba"));
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
        String formKey = null;
        if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
            formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
        }
        for (String user : receiverList) {
            SysActCcTask sysActCcTask = new SysActCcTask();
            sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
            sysActCcTask.setProcName(historicProcessInstance.getProcessDefinitionName());
            sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            sysActCcTask.setTaskName(task.getName());
            sysActCcTask.setReceiveUser(user);
            sysActCcTask.setSendUser(sysActCcTaskDto.getUserId());
            sysActCcTask.setSendTime(ts);
            sysActCcTask.setFormKey(formKey);
            sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
            sysActCcTask.setProcDefKey(historicProcessInstance.getProcessDefinitionKey());
            sysActCcTask.setBusinessId(historicProcessInstance.getBusinessKey());
            sysActCcTask.setTaskState("0");
            sysActCcTask.setCcMoment("2");
            Map map = task.getTaskLocalVariables();
            if (HussarUtils.isNotEmpty((Object)map)) {
                sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
            }
            list.add(sysActCcTask);
        }
        this.saveBatch(list);
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(realTaskId.getTaskId());
        dataPush.setUserId(String.join((CharSequence)",", receiverList));
        dataPush.setCcMoment("2");
        dataPush.setStartDate((Date)ts);
        String url = this.dataPushService.getCcUrl(task.getProcessDefinitionId(), "9");
        dataPush.setUrl(url);
        this.dataPushService.addCcTask(dataPush);
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        this.processEngine.getManagementService().executeCommand((Command)new CcAddHistoryTaskCmd(execution, sysActCcTaskDto.getComment(), new Date(), sysActCcTaskDto.getUserId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> read(Long ccTaskId) {
        if (ccTaskId == null) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(ccTaskId);
        if (HussarUtils.isEmpty((Object)sysActCcTask)) {
            return ApiResponse.fail((String)"\u6284\u9001\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readByTaskId(Long taskId, String ccMoment, String userId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActCcTask::getTaskId, (Object)taskId);
        lambdaQueryWrapper.eq(SysActCcTask::getReceiveUser, (Object)userId);
        lambdaQueryWrapper.eq(SysActCcTask::getCcMoment, (Object)ccMoment);
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (sysActCcTask == null) {
            return ApiResponse.success();
        }
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readBatch(List<Long> ccTaskIds) {
        if (ccTaskIds == null) {
            throw new BpmException(BpmExceptionCodeEnum.NOT_NULL_PARM_IS_NULL);
        }
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        List sysActCcTasks = this.sysActCcTaskMapper.selectBatchIds(ccTaskIds);
        for (SysActCcTask sysActCcTask : sysActCcTasks) {
            sysActCcTask.setEndTime(endTime);
            sysActCcTask.setTaskState("1");
            DataPush dataPush = new DataPush();
            dataPush.setUserId(sysActCcTask.getReceiveUser());
            dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
            dataPush.setEndDate((Date)sysActCcTask.getEndTime());
            dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
            this.dataPushService.readCcTask(dataPush);
        }
        this.updateBatchById(sysActCcTasks);
        return ApiResponse.success();
    }

    private List<HistoricTaskInstance> getHisTask(String processInsId, String activityId) {
        ArrayList<HistoricTaskInstance> hisTasks = new ArrayList<HistoricTaskInstance>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(activityId)).queryChildTask()).includeTaskLocalVariables()).list();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.sort((o1, o2) -> {
                if (o2.getEndTime() == null) {
                    return 1;
                }
                if (o1.getEndTime() == null) {
                    return -1;
                }
                return o2.getEndTime().compareTo(o1.getEndTime());
            });
            for (int i = 0; i < hisTaskList.size(); ++i) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                if (COMPLETE_HISTORY.contains(historicTaskInstance.getDeleteReason())) continue;
                Date start = historicTaskInstance.getStartTime();
                hisTasks.add(historicTaskInstance);
                for (int j = i + 1; j < hisTaskList.size() && ((historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j)).getEndTime() == null || start.getTime() <= historicTaskInstance.getEndTime().getTime() || "RevokeHistory".equals(historicTaskInstance.getDeleteReason())); ++j) {
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    hisTasks.add(historicTaskInstance);
                }
                break;
            }
        }
        return hisTasks;
    }

    public List<SysActCcTask> getCcTaskList(Long processInsId, String taskDefinitionKey, String subProcessKey) {
        return this.sysActCcTaskMapper.getCcTaskList(processInsId, taskDefinitionKey, subProcessKey);
    }

    public ApiResponse<Page<SysActCcTask>> getPage(Page<SysActCcTask> pages, String startTime, String endTime, String tenantId, String readStatus) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNull((Object)user)) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.getPage(pages, String.valueOf(user.getId()), start, end, readStatus);
        if (HussarUtils.isNotEmpty(sysActCcTasks)) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users);
            Map departmentAndPostMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                sysActCcTask.setStartUser(userName);
                UserDepartmentAndPostModel userDepartmentAndPostModel = (UserDepartmentAndPostModel)departmentAndPostMap.get(sysActCcTask.getSendUser());
                if (!HussarUtils.isNotEmpty((Object)userDepartmentAndPostModel)) continue;
                sysActCcTask.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                sysActCcTask.setUnit(userDepartmentAndPostModel.getUnitName());
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<Page<SysActCcTask>> getPageRemote(Page<SysActCcTask> pages, String startTime, String endTime, String tenantId, String readStatus, String userId) {
        if (userId == null || userId.equals("")) {
            throw new HussarException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List<SysActCcTask> sysActCcTasks = this.sysActCcTaskMapper.getPage(pages, userId, start, end, readStatus);
        if (HussarUtils.isNotEmpty(sysActCcTasks)) {
            List users = sysActCcTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users);
            Map departmentAndPostMap = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTask sysActCcTask : sysActCcTasks) {
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                sysActCcTask.setStartUser(userName);
                UserDepartmentAndPostModel userDepartmentAndPostModel = (UserDepartmentAndPostModel)departmentAndPostMap.get(sysActCcTask.getSendUser());
                if (!HussarUtils.isNotEmpty((Object)userDepartmentAndPostModel)) continue;
                sysActCcTask.setDepartmentName(userDepartmentAndPostModel.getDepartmentName());
                sysActCcTask.setUnit(userDepartmentAndPostModel.getUnitName());
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> read(SysActCcDto sysActCcTaskParam) {
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(sysActCcTaskParam.getId());
        if (HussarUtils.isNull((Object)sysActCcTask)) {
            throw new HussarException("\u6284\u9001\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List unReadList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser()));
        Timestamp timestamp = new Timestamp(new Date().getTime());
        for (SysActCcTask actCcTask : unReadList) {
            actCcTask.setReadStatus("1");
            actCcTask.setReadTime(timestamp);
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        if (this.updateBatchById(unReadList)) {
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                for (SysActCcTask actCcTask : unReadList) {
                    DataPush dataPush = new DataPush();
                    dataPush.setDataPushId(actCcTask.getId().toString());
                    dataPush.setTaskId(actCcTask.getTaskId() != null ? actCcTask.getTaskId().toString() : null);
                    dataPush.setUserId(actCcTask.getReceiveUser());
                    dataPush.setSendUser(actCcTask.getSendUser());
                    dataPush.setStartDate((Date)actCcTask.getSendTime());
                    dataPush.setProcessInsId(actCcTask.getProcessInsId().toString());
                    dataPush.setBusinessKey(actCcTask.getBusinessId());
                    dataPush.setTaskDefinitionKey(actCcTask.getTaskDefKey());
                    dataPush.setUrl(actCcTask.getFormKey());
                    dataPush.setProcessKey(actCcTask.getProcDefKey());
                    dataPush.setDeptId(actCcTask.getPostOrganId());
                    dataPush.setUnitId(actCcTask.getPostUnitId());
                    dataPush.setEndDate((Date)actCcTask.getReadTime());
                    dataPushes.add(dataPush);
                }
                this.dataPushService.readCcTask(dataPushes);
            }
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> reply(SysActCcDto sysActCcTaskParam) {
        if (HussarUtils.isEmpty((Object)sysActCcTaskParam.getReplyContent())) {
            throw new HussarException("\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        List allCcTaskListToUser = this.sysActCcTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getReceiveUser, (Object)sysActCcTaskParam.getSendUser())).eq(SysActCcTask::getIsNeedReply, (Object)"1")).eq(SysActCcTask::getProcessInsId, (Object)sysActCcTaskParam.getProcessInsId())).isNull(SysActCcTask::getReplyContent)).orderByDesc(SysActCcTask::getSendTime));
        if (HussarUtils.isEmpty((Object)allCcTaskListToUser)) {
            throw new HussarException("\u6ca1\u6709\u53ef\u56de\u590d\u7684\u6284\u9001\u6570\u636e");
        }
        SysActCcTask sysActCcTask = (SysActCcTask)allCcTaskListToUser.get(0);
        sysActCcTask.setReplyContent(sysActCcTaskParam.getReplyContent());
        sysActCcTask.setReadTime(new Timestamp(new Date().getTime()));
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(sysActCcTask.getBusinessId()).singleResult();
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        List ccTaskConfigList = this.sysActCcTaskConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)sysActCcTask.getProcDefKey())).eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_all_reply")).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion())));
        if ("0".equals(sysActCcTask.getIsNeedReply()) || "1".equals(sysActCcTask.getIsReplySend())) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        if (HussarUtils.isEmpty((Object)ccTaskConfigList)) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        Long count = this.sysActCcTaskMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getIsReplySend, (Object)"0")).isNull(SysActCcTask::getReplyContent)).ne(SysActCcTask::getId, (Object)sysActCcTask.getId())).eq(SysActCcTask::getIsNeedReply, (Object)"1"));
        if (count > 0L) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        List<SysActCcTask> resultCcTaskList = CcTaskUtil.getCcTaskList(sysActCcTask, ccTaskConfigList, processInstance.getStartUserId());
        if (HussarUtils.isNotEmpty(resultCcTaskList)) {
            this.saveBatch(resultCcTaskList);
            ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
            String url = this.dataPushService.getCcUrl(processDefinition.getId(), "9");
            for (SysActCcTask actCcTask : resultCcTaskList) {
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(actCcTask.getId().toString());
                dataPush.setTaskId(actCcTask.getTaskId() != null ? actCcTask.getTaskId().toString() : null);
                dataPush.setUserId(actCcTask.getReceiveUser());
                dataPush.setSendUser(actCcTask.getSendUser());
                dataPush.setStartDate((Date)actCcTask.getSendTime());
                dataPush.setProcessInsId(actCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(actCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(actCcTask.getTaskDefKey());
                dataPush.setUrl(url);
                dataPush.setProcessKey(actCcTask.getProcDefKey());
                dataPush.setDeptId(actCcTask.getPostOrganId());
                dataPush.setUnitId(actCcTask.getPostUnitId());
                dataPush.setEndDate((Date)actCcTask.getReadTime());
                dataPushes.add(dataPush);
            }
            this.dataPushService.addCcTask(dataPushes);
        }
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> replyRemote(SysActCcTask sysActCcTaskParam, String userId) {
        if (HussarUtils.isEmpty((Object)sysActCcTaskParam.getReplyContent())) {
            throw new HussarException("\u56de\u590d\u5185\u5bb9\u4e3a\u7a7a");
        }
        List allCcTaskListToUser = this.sysActCcTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getReceiveUser, (Object)userId)).eq(SysActCcTask::getIsNeedReply, (Object)"1")).eq(SysActCcTask::getProcessInsId, (Object)sysActCcTaskParam.getProcessInsId())).isNull(SysActCcTask::getReplyContent)).orderByDesc(SysActCcTask::getSendTime));
        if (HussarUtils.isEmpty((Object)allCcTaskListToUser)) {
            throw new HussarException("\u6ca1\u6709\u53ef\u56de\u590d\u7684\u6284\u9001\u6570\u636e");
        }
        SysActCcTask sysActCcTask = (SysActCcTask)allCcTaskListToUser.get(0);
        sysActCcTask.setReplyContent(sysActCcTaskParam.getReplyContent());
        sysActCcTask.setReadTime(new Timestamp(new Date().getTime()));
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(sysActCcTask.getBusinessId()).singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        List ccTaskConfigList = this.sysActCcTaskConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTaskConfig::getProcDefKey, (Object)sysActCcTask.getProcDefKey())).eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_all_reply")).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion())));
        if ("0".equals(sysActCcTask.getIsNeedReply()) || "1".equals(sysActCcTask.getIsReplySend())) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        if (HussarUtils.isEmpty((Object)ccTaskConfigList)) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        Long count = this.sysActCcTaskMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getIsReplySend, (Object)"0")).isNull(SysActCcTask::getReplyContent)).ne(SysActCcTask::getId, (Object)sysActCcTask.getId())).eq(SysActCcTask::getIsNeedReply, (Object)"1"));
        if (count > 0L) {
            int i = this.sysActCcTaskMapper.updateById(sysActCcTask);
            return ApiResponse.success((Object)(i > 0 ? 1 : 0));
        }
        List<SysActCcTask> resultCcTaskList = CcTaskUtil.getCcTaskList(sysActCcTask, ccTaskConfigList, processInstance.getStartUserId());
        if (HussarUtils.isNotEmpty(resultCcTaskList)) {
            this.saveBatch(resultCcTaskList);
        }
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<List<SysActCcTask>> getCcTaskUserList(String processInsId) {
        List postOrganIdList;
        List postIdList;
        List departmentIdAndPostList;
        if (HussarUtils.isEmpty((Object)processInsId)) {
            return ApiResponse.success(new ArrayList());
        }
        List<SysActCcTask> sysActCcTaskList = this.sysActCcTaskMapper.getCcTaskUserList(processInsId);
        if (HussarUtils.isEmpty(sysActCcTaskList)) {
            return ApiResponse.success(new ArrayList());
        }
        List receiveUserIdList = sysActCcTaskList.stream().map(SysActCcTask::getReceiveUser).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        List userMap = this.iAssigneeChooseService.getUserAndAccountListByUserId(receiveUserIdList);
        List departmentIdAndPostListOfMain = this.iAssigneeChooseService.getDepartmentIdAndPost(null, null, receiveUserIdList);
        for (SysActCcTask sysActCcTask : sysActCcTaskList) {
            if ("1".equals(sysActCcTask.getIsNeedReply()) && HussarUtils.isEmpty((Object)sysActCcTask.getReplyContent())) {
                sysActCcTask.setIsNeedReply("1");
            } else {
                sysActCcTask.setIsNeedReply("0");
            }
            for (AssigneeChooseDto userInfo : userMap) {
                String userId = userInfo.getUserId();
                if (!sysActCcTask.getReceiveUser().equals(userId)) continue;
                String userName = userInfo.getUserName();
                String account = userInfo.getUserAccount();
                sysActCcTask.setUserCode(account);
                sysActCcTask.setReceiveName(userName);
            }
            for (Map map : departmentIdAndPostListOfMain) {
                if (!String.valueOf(map.get("userId")).equals(sysActCcTask.getReceiveUser())) continue;
                sysActCcTask.setDepartmentName((String)map.get("departmentName"));
                sysActCcTask.setPostName((String)map.get("postName"));
            }
            ArrayList<String> postUnitId = new ArrayList<String>();
            postUnitId.add(sysActCcTask.getPostUnitId());
            Map unit = this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(postUnitId);
            sysActCcTask.setUnit((String)this.iAssigneeChooseService.getDepartmentNameBydepartmentIds(postUnitId).get(sysActCcTask.getPostUnitId()));
        }
        List partCcTasks = sysActCcTaskList.stream().filter(s -> HussarUtils.isNotEmpty((Object)s.getPostId()) && HussarUtils.isNotEmpty((Object)s.getPostOrganId())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(partCcTasks) && HussarUtils.isNotEmpty((Object)(departmentIdAndPostList = this.iAssigneeChooseService.getDepartmentIdAndPost(postIdList = partCcTasks.stream().map(SysActCcTask::getPostId).collect(Collectors.toList()), postOrganIdList = partCcTasks.stream().map(SysActCcTask::getPostOrganId).collect(Collectors.toList()), null)))) {
            for (SysActCcTask sysActCcTask : partCcTasks) {
                for (Map map : departmentIdAndPostList) {
                    if (!String.valueOf(map.get("postId")).equals(sysActCcTask.getPostId()) || !String.valueOf(map.get("postOrganId")).equals(sysActCcTask.getPostOrganId())) continue;
                    sysActCcTask.setDepartmentName((String)map.get("departmentName"));
                    sysActCcTask.setPostName((String)map.get("postName"));
                }
            }
        }
        return ApiResponse.success(sysActCcTaskList);
    }

    @HussarTransactional
    public ApiResponse<SysActCcTask> saveCcTask(SysActCcDto sysActCcTaskDto) {
        SysActCcTask sysActCcTask = (SysActCcTask)BeanUtil.copyProperties((Object)sysActCcTaskDto, SysActCcTask.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser());
        List ccTaskList = this.list((Wrapper)queryWrapper);
        if (ccTaskList.size() > 0) {
            return ApiResponse.success((int)10001, (String)"\u5b58\u5728\u91cd\u590d\u7684\u6284\u9001\u4fe1\u606f\uff0c\u6dfb\u52a0\u5931\u8d25");
        }
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        if (HussarUtils.isNull((Object)processInstance)) {
            throw new HussarException("\u83b7\u53d6\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        if (HussarUtils.isNull((Object)processDefinition)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcDefKey(processDefinition.getKey());
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(sysActCcTask.getProcDefKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        if (HussarUtils.isNull((Object)definitionModel)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcName(definitionModel.getName());
        sysActCcTask.setSendTime(new Timestamp(new Date().getTime()));
        sysActCcTask.setFormKey(definitionModel.getViewFormAddress());
        sysActCcTask.setBusinessId(processInstance.getBusinessKey());
        sysActCcTask.setReadStatus("0");
        sysActCcTask.setIsNeedReply("1");
        sysActCcTask.setIsReplySend("1");
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostId())) {
            sysActCcTask.setPostId(null);
        }
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostOrganId())) {
            sysActCcTask.setPostOrganId(null);
        }
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(definitionModel.getId());
        boolean flag = this.save((BaseEntity)sysActCcTask);
        if (flag) {
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(sysActCcTask.getId().toString());
                dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setSendUser(sysActCcTask.getSendUser());
                dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                String url = this.dataPushService.getCcUrl(processDefinition.getId(), "9");
                dataPush.setUrl(url);
                dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                dataPush.setDeptId(sysActCcTask.getPostOrganId());
                dataPush.setUnitId(sysActCcTask.getPostUnitId());
                dataPush.setPostId(sysActCcTask.getPostId());
                dataPushes.add(dataPush);
                this.dataPushService.addCcTask(dataPushes);
            }
            return ApiResponse.success((Object)sysActCcTask);
        }
        return ApiResponse.success((Object)new SysActCcTask());
    }

    @HussarTransactional
    public ApiResponse<SysActCcTask> saveCcTaskRemote(SysActCcTask sysActCcTask, String userId, String userName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SysActCcTask::getProcessInsId, (Object)sysActCcTask.getProcessInsId())).eq(SysActCcTask::getReceiveUser, (Object)sysActCcTask.getReceiveUser());
        List ccTaskList = this.list((Wrapper)queryWrapper);
        if (ccTaskList.size() > 0) {
            return ApiResponse.success((int)10001, (String)"\u5b58\u5728\u91cd\u590d\u7684\u6284\u9001\u4fe1\u606f\uff0c\u6dfb\u52a0\u5931\u8d25");
        }
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        if (HussarUtils.isNull((Object)processInstance)) {
            throw new HussarException("\u83b7\u53d6\u5386\u53f2\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        ProcessDefinition processDefinition = (ProcessDefinition)defaultProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        if (HussarUtils.isNull((Object)processDefinition)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcDefKey(processDefinition.getKey());
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(sysActCcTask.getProcDefKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        if (HussarUtils.isNull((Object)definitionModel)) {
            throw new HussarException("\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25");
        }
        sysActCcTask.setProcName(definitionModel.getName());
        sysActCcTask.setSendUser(userId);
        sysActCcTask.setSendUserName(userName);
        sysActCcTask.setSendTime(new Timestamp(new Date().getTime()));
        sysActCcTask.setFormKey(definitionModel.getViewFormAddress());
        sysActCcTask.setBusinessId(processInstance.getBusinessKey());
        sysActCcTask.setReadStatus("0");
        sysActCcTask.setIsNeedReply("1");
        sysActCcTask.setIsReplySend("1");
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostId())) {
            sysActCcTask.setPostId(null);
        }
        if (HussarUtils.isEmpty((Object)sysActCcTask.getPostOrganId())) {
            sysActCcTask.setPostOrganId(null);
        }
        boolean flag = this.save((BaseEntity)sysActCcTask);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(definitionModel.getId());
        if (flag) {
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                DataPush dataPush = new DataPush();
                dataPush.setDataPushId(sysActCcTask.getId().toString());
                dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setSendUser(sysActCcTask.getSendUser());
                dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                String url = this.dataPushService.getCcUrl(processDefinition.getId(), "9");
                dataPush.setUrl(url);
                dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                dataPush.setDeptId(sysActCcTask.getPostOrganId());
                dataPush.setUnitId(sysActCcTask.getPostUnitId());
                dataPushes.add(dataPush);
                this.dataPushService.addCcTask(dataPushes);
            }
            return ApiResponse.success((Object)sysActCcTask);
        }
        return ApiResponse.success((Object)new SysActCcTask());
    }

    public void buildCcTaskList(List<SysActCcTask> sysActCcTasks, ProcessInstance processInstance, String userId, String userName) {
        ProcessDefinition processDefinition = (ProcessDefinition)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        DefinitionModel definitionModel = this.processDefinitionsMapper.getDefinitionModel(processInstance.getProcessDefinitionKey(), processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion(), "0");
        HashSet userSet = new HashSet();
        sysActCcTasks.removeIf(sysActCcTask -> !userSet.add(sysActCcTask.getReceiveUser()));
        for (SysActCcTask sysActCcTask2 : sysActCcTasks) {
            sysActCcTask2.setProcessInsId(Long.valueOf(processInstance.getId()));
            sysActCcTask2.setProcName(definitionModel.getName());
            sysActCcTask2.setSendUser(userId);
            sysActCcTask2.setUserCode(userId);
            sysActCcTask2.setSendUserName(userName);
            sysActCcTask2.setSendTime(new Timestamp(new Date().getTime()));
            sysActCcTask2.setFormKey(definitionModel.getViewFormAddress());
            sysActCcTask2.setBusinessId(processInstance.getBusinessKey());
            sysActCcTask2.setReadStatus("0");
            sysActCcTask2.setIsNeedReply("1");
            sysActCcTask2.setIsReplySend("1");
            if (HussarUtils.isEmpty((Object)sysActCcTask2.getPostId())) {
                sysActCcTask2.setPostId(null);
            }
            if (!HussarUtils.isEmpty((Object)sysActCcTask2.getPostOrganId())) continue;
            sysActCcTask2.setPostOrganId(null);
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteCcTask(SysActCcDto sysActCcTask) {
        ProcessEngine defaultProcessEngine = ProcessEngines.getDefaultProcessEngine();
        HistoryService historyService = defaultProcessEngine.getHistoryService();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(sysActCcTask.getProcessInsId().toString()).singleResult();
        SysActCcTask actCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(sysActCcTask.getId());
        if (HussarUtils.isNull((Object)actCcTask)) {
            throw new HussarException("\u8be5\u6284\u9001\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        int i = this.sysActCcTaskMapper.deleteById(sysActCcTask.getId());
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(processInstance.getProcessDefinitionId());
        if (this.dataPushService.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setDataPushId(sysActCcTask.getId().toString());
            this.dataPushService.deleteCcTask(dataPush);
        }
        return ApiResponse.success((Object)(i > 0 ? 1 : 0));
    }

    static {
        COMPLETE_HISTORY.add("CcTaskHistory");
        COMPLETE_HISTORY.add("AssistHistory");
        COMPLETE_HISTORY.add("TransferHistory");
    }
}

