/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.vo.SysActCcTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6284\u9001\u7ba1\u7406"})
@RequestMapping(value={"/bpm/ccManage"})
public class CcManageController {
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u6284\u9001\u67e5\u8be2", notes="\u6284\u9001\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u6284\u9001\u7ba1\u7406", eventDesc="\u6284\u9001\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysActCcTaskVo>> list(Page<SysActCcTaskVo> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskManageQueryDto.getSendUserId();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String state = taskManageQueryDto.getState();
        SysActCcTaskQueryDto sysActCcTaskQueryDto = new SysActCcTaskQueryDto(processKey, sendUserId, startTime, endTime, userId, state, null, null);
        return this.sysActCcTaskService.query(pages, sysActCcTaskQueryDto);
    }

    @PostMapping(value={"/read"})
    @ApiOperation(value="\u9605\u8bfb", notes="\u9605\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ccTaskId", value="\u4f20\u9605\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb", eventDesc="\u9605\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> read(@RequestBody Long ccTaskId) {
        if (ccTaskId == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        return this.sysActCcTaskService.read(ccTaskId);
    }

    @PostMapping(value={"/readByTaskId"})
    @ApiOperation(value="\u9605\u8bfb", notes="\u9605\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb", eventDesc="\u9605\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> readByTaskId(@RequestBody String taskId) {
        if (taskId == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = String.valueOf(securityUser.getId());
        return this.sysActCcTaskService.readByTaskId(Long.valueOf(taskId.split(":")[0]), taskId.split(":")[1], userId);
    }

    @PostMapping(value={"/readBatch"})
    @ApiOperation(value="\u6279\u91cf\u5df2\u8bfb", notes="\u6279\u91cf\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ccTaskIds", value="\u4f20\u9605\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u5df2\u8bfb", eventDesc="\u5df2\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> revoke(@RequestBody List<Long> ccTaskIds) {
        if (ccTaskIds == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        return this.sysActCcTaskService.readBatch(ccTaskIds);
    }
}

