/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.processinst.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.dto.TaskCommentDto;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.vo.TaskCommentVO;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.EndProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.RestartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u56fe\u5b9e\u4f8b\u7ba1\u7406"})
@RequestMapping(value={"/bpm/processInst"})
public class ProcessInstController {
    @Autowired
    private ProcessInstService processInstService;

    @GetMapping(value={"/getProcessList"})
    @ApiOperation(value="\u5c55\u793a\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868", notes="\u5c55\u793a\u6d41\u7a0b\u5b9e\u65bd\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5c55\u793a\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<ProcessInst>> getRunningProcessList(Page<ProcessInst> page, ProcessListDto processListDto) {
        if (HussarUtils.isNotEmpty((Object)processListDto)) {
            if (HussarUtils.isNotEmpty((Object)processListDto.getProcessName())) {
                processListDto.setProcessName(processListDto.getProcessName().replace("%", "\\%").replace("_", "\\_"));
            }
            if (HussarUtils.isNotEmpty((Object)processListDto.getBusinessId())) {
                processListDto.setBusinessId(processListDto.getBusinessId().replace("%", "\\%").replace("_", "\\_"));
            }
        }
        return ApiResponse.success((Object)this.processInstService.getProcessList(page, processListDto));
    }

    @PostMapping(value={"/deleteProcessById"})
    @ApiOperation(value="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5220\u9664\u9009\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteProcessById(@RequestBody String processInsId) {
        return this.processInstService.deleteProcessInstance(processInsId);
    }

    @PostMapping(value={"/deleteFinishedProcessById"})
    @ApiOperation(value="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5220\u9664\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteFinishedProcessById(@RequestBody String processInsId) {
        return this.processInstService.deleteFinishedProcessInstance(processInsId);
    }

    @PostMapping(value={"/suspendProcessById"})
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> suspendProcessById(@RequestBody String processInsId) {
        return this.processInstService.suspendProcessInstanceById(processInsId);
    }

    @PostMapping(value={"/activateProcessById"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> activateProcessById(@RequestBody String processInsId) {
        return this.processInstService.activateProcessById(processInsId);
    }

    @GetMapping(value={"/getProcessDetailList"})
    @ApiOperation(value="\u5c55\u793a\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u529e\u4efb\u52a1\u5217\u8868", notes="\u5c55\u793a\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u529e\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDto", value="\u6d41\u7a0b\u4fe1\u606f", required=false, paramType="query")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u5c55\u793a\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u529e\u4efb\u52a1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<TaskCommentVO>> getProcessDetailList(ProcessDto processDto) {
        return this.processInstService.getProcessDetailList(processDto);
    }

    @PostMapping(value={"/updateComments"})
    @ApiOperation(value="\u4fee\u6539\u610f\u89c1", notes="\u4fee\u6539\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskComments", value="\u610f\u89c1\u5217\u8868", required=true, paramType="body")})
    @AuditLog(moduleName="\u5b9e\u4f8b\u7ba1\u7406", eventDesc="\u4fee\u6539\u610f\u89c1", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateComments(@RequestBody List<TaskCommentDto> taskComments) {
        return this.processInstService.updateComments(taskComments);
    }

    @PostMapping(value={"/endProcessByProcessInsId"})
    @ApiOperation(value="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b", notes="\u7ec8\u7ed3\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="endProcessDto", value="\u7ec8\u7ed3\u6d41\u7a0b\u76f8\u5173\u6570\u636e", required=true, paramType="body")})
    public BpmResponseResult endProcessByProcessInsId(@RequestBody EndProcessDto endProcessDto) {
        if (HussarUtils.isEmpty((Object)endProcessDto.getUserId())) {
            String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
            endProcessDto.setUserId(userId);
        }
        return this.processInstService.endProcessByProcessInsId(endProcessDto);
    }

    @PostMapping(value={"/reStartProcess"})
    @ApiOperation(value="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9", notes="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="restartProcessDto", value="\u91cd\u542f\u6d41\u7a0b\u6570\u636e", required=false, paramType="body")})
    public BpmResponseResult reStartProcess(@RequestBody RestartProcessDto restartProcessDto) {
        if (HussarUtils.isEmpty((Object)restartProcessDto.getUserId())) {
            String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
            restartProcessDto.setUserId(userId);
        }
        return this.processInstService.reStartProcess(restartProcessDto);
    }
}

