/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendCommonConverterUtil;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.StartEventJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendStartEventJsonConverter
extends StartEventJsonConverter {
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        ExtendCommonConverterUtil.commonConvertElementToJson(propertiesNode, baseElement);
        StartEvent startEvent = (StartEvent)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            propertiesNode.put("initiator", startEvent.getInitiator());
        }
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            propertiesNode.put("formkeydefinition", startEvent.getFormKey());
        }
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        StartEvent startEvent = new StartEvent();
        ExtendCommonConverterUtil.commonConvertJsonToElement((FlowElement)startEvent, elementNode);
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                startEvent.setFormKey(formKey);
            }
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        }
        return startEvent;
    }
}

