/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    private List<String> assignees;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ISysActCcTaskService sysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)SpringContextHolder.getBean(SysActCcTaskMapper.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId, List<String> assignees) {
        this.executionId = executionId;
        this.taskId = taskId;
        this.assignees = assignees;
    }

    public Void execute(CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        int num = 1;
        if (nrOfInstances == 1) {
            throw new PublicClientException(BpmConstantEnum.THE_ONLY_ASSIGNEE_IN_MULTI.getMessage(), Boolean.valueOf(false));
        }
        String processKey = ee.getProcessDefinitionKey();
        if (this.assignees != null && !this.assignees.isEmpty()) {
            Iterator longUpdateTaskIds;
            List list;
            List executionEntities = ee.getParent().getExecutions();
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<Long> longTaskIds = new ArrayList<Long>();
            ArrayList<Object> entities = new ArrayList<Object>();
            String unDelTaskId = null;
            block0: for (Object entity : executionEntities) {
                if (HussarUtils.isNotEmpty((Object)entity.getTasks()) && this.isTaskAssignee((ExecutionEntity)entity)) {
                    longTaskIds.add(Long.parseLong(((TaskEntity)entity.getTasks().get(0)).getId()));
                    taskIds.add(((TaskEntity)entity.getTasks().get(0)).getId());
                    entities.add(entity);
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks()) || unDelTaskId != null) continue;
                for (TaskEntity task : entity.getTasks()) {
                    if (task.getParentTaskId() != null) continue;
                    unDelTaskId = task.getId();
                    continue block0;
                }
            }
            num = entities.size();
            if (nrOfInstances == num) {
                throw new PublicClientException(BpmConstantEnum.THE_ONLY_ASSIGNEE_IN_MULTI.getMessage(), Boolean.valueOf(false));
            }
            if (num == 0) {
                return null;
            }
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActCcTask::getTaskId, longTaskIds);
            this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
            for (String string : taskIds) {
                commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(string);
            }
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(taskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
            if (HussarUtils.isNotEmpty((Object)unDelTaskId) && HussarUtils.isNotEmpty((Object)(list = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().in(SysActCcTask::getTaskId, (Collection)((Object)(longUpdateTaskIds = taskIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()))))))) && !list.isEmpty()) {
                this.sysActCcTaskService.updateBatchById((Collection)list);
                if (this.dataPushService.isDataPush()) {
                    ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
                    for (SysActCcTask ccTask : list) {
                        DataPush dataPush = new DataPush();
                        dataPush.setUserId(ccTask.getReceiveUser());
                        dataPush.setTaskId(unDelTaskId);
                        dataPush.setStartDate((Date)ccTask.getSendTime());
                        dataPush.setEndDate((Date)ccTask.getEndTime());
                        dataPush.setCcMoment(ccTask.getCcMoment() == null ? "0" : ccTask.getCcMoment());
                        dataPushList.add(dataPush);
                    }
                    this.dataPushService.addCcTask(dataPushList);
                }
            }
            for (TaskEntity taskEntity : ((ExecutionEntity)entities.get(0)).getTasks()) {
                if (taskEntity.getParentTaskId() != null || taskEntity.getDueDate() == null) continue;
                this.activityRedisTimerService.delTimeOutModel(String.join((CharSequence)",", taskIds));
                break;
            }
            ee = (ExecutionEntity)entities.get(0);
            for (ExecutionEntity executionEntity : entities) {
                executionEntity.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
            }
        } else {
            List ccTasks;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysActCcTask::getTaskId, (Object)Long.parseLong(this.taskId));
            this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
            commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(this.taskId);
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(new ArrayList<String>(Collections.singletonList(this.taskId)));
                this.dataPushService.deleteMultiTask(dataPush);
            }
            List executionEntities = ee.getParent().getExecutions();
            String unDelTaskId = null;
            block6: for (ExecutionEntity entity : executionEntities) {
                if (!HussarUtils.isNotEmpty((Object)entity.getTasks())) continue;
                for (TaskEntity task : entity.getTasks()) {
                    if (task.getParentTaskId() != null || this.taskId.equals(task.getId())) continue;
                    unDelTaskId = task.getId();
                    break block6;
                }
            }
            if (HussarUtils.isNotEmpty(unDelTaskId) && HussarUtils.isNotEmpty((Object)(ccTasks = this.sysActCcTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActCcTask::getTaskId, (Object)Long.parseLong(this.taskId)))))) {
                this.sysActCcTaskService.updateBatchById((Collection)ccTasks);
                if (this.dataPushService.isDataPush()) {
                    ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
                    for (SysActCcTask ccTask : ccTasks) {
                        DataPush dataPush = new DataPush();
                        dataPush.setUserId(ccTask.getReceiveUser());
                        dataPush.setTaskId(unDelTaskId);
                        dataPush.setStartDate((Date)ccTask.getSendTime());
                        dataPush.setEndDate((Date)ccTask.getEndTime());
                        dataPush.setCcMoment(ccTask.getCcMoment() == null ? "0" : ccTask.getCcMoment());
                        dataPushList.add(dataPush);
                    }
                    this.dataPushService.addCcTask(dataPushList);
                }
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - num);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        if (num > 1) {
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances - num + 1);
        }
        if ((activityBehavior = ee.getActivity().getActivityBehavior()) instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }

    private boolean isTaskAssignee(ExecutionEntity entity) {
        for (TaskEntity task : entity.getTasks()) {
            if (task.getParentTaskId() != null || !this.assignees.contains(((IdentityLinkEntity)task.getIdentityLinks().get(0)).getUserId()) && !this.assignees.contains(task.getAssignee())) continue;
            return true;
        }
        return false;
    }
}

