/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.util.Date;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class CcAddHistoryTaskCmd
implements Command<Void> {
    protected String comment;
    protected Date startTime;
    protected String userId;
    protected TaskEntity task;
    protected DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ExecutionEntity executionEntity;

    public CcAddHistoryTaskCmd(ExecutionEntity executionEntity, String comment, Date startTime, String userId) {
        this.comment = comment;
        this.startTime = startTime;
        this.userId = userId;
        this.executionEntity = executionEntity;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity task = this.getTask();
        ExecutionEntity execution = task.getExecution();
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        IdGenerator idGenerator = pec.getIdGenerator();
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setCreateTime(this.startTime);
        taskEntity.setTaskDefinition(task.getTaskDefinition());
        taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        taskEntity.setTaskDefinitionKey(task.getTaskDefinitionKey());
        taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
        taskEntity.setExecutionId(this.executionEntity.getId());
        taskEntity.setName(task.getName());
        taskEntity.setNameTranslateId(task.getNameTranslateId());
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(this.executionEntity);
        taskEntity.setFormKey(task.getFormKey());
        taskEntity.setVariableLocal("sendUser", (Object)this.userId);
        taskEntity.setVariableLocal("todoConfiguration", task.getVariableLocal("todoConfiguration"));
        taskEntity.setVariableLocal("complete_from", (Object)task.getTaskDefinitionKey());
        taskEntity.setSubProcessKey(task.getSubProcessKey());
        taskEntity.insert(taskEntity.getExecution());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)taskEntity));
        }
        taskEntity.fireEvent("create");
        taskEntity.fireEvent("start");
        taskEntity.setAssignee(this.userId);
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(taskEntity.getId());
        dataPush.setTaskDefinitionName(taskEntity.getName());
        dataPush.setTaskDefinitionNameTranslateId(taskEntity.getNameTranslateId());
        dataPush.setUserId(this.userId);
        dataPush.setBusinessKey(execution.getBusinessKey());
        dataPush.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        dataPush.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(this.userId);
        dataPush.setStartDate(this.startTime);
        dataPush.setEndDate(new Date());
        dataPush.setUrl(taskEntity.getFormKey());
        dataPush.setDescription((String)task.getVariableLocal("todoConfiguration"));
        dataPush.setProcessName(execution.getProcessDefinitionName());
        dataPush.setProcessNameTranslateId(ActivitiTranslateUtil.getTranslateId((String)taskEntity.getProcessDefinitionId(), (String)taskEntity.getTaskDefinitionKey()));
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            dataPush.setComment(this.comment);
        }
        dataPush.setProcessInsId(taskEntity.getProcessInstanceId());
        this.dataPushService.completeDataPush(dataPush);
        taskEntity.fireEvent("beforeComplete");
        taskEntity.setVariableLocal("taskSourceFlag", (Object)"CcTask");
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
        Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "CcTaskHistory", false, new Date());
        taskEntity.fireEvent("complete");
        return null;
    }

    protected TaskEntity getTask() {
        List taskEntities = this.executionEntity.getTasks();
        List entityList = this.executionEntity.getExecutions();
        if (entityList != null && !entityList.isEmpty()) {
            this.executionEntity = (ExecutionEntity)entityList.get(0);
            entityList = this.executionEntity.getExecutions();
            if (entityList != null && !entityList.isEmpty()) {
                taskEntities = ((ExecutionEntity)this.executionEntity.getExecutions().get(0)).getTasks();
            }
            this.executionEntity = this.executionEntity.createExecution();
            this.executionEntity.setScope(false);
            this.executionEntity.setConcurrent(true);
            this.executionEntity.setActive(false);
        }
        TaskEntity task = (TaskEntity)taskEntities.get(0);
        for (int i = 1; i < taskEntities.size(); ++i) {
            if (!((TaskEntity)taskEntities.get(i)).getCreateTime().after(task.getCreateTime())) continue;
            task = (TaskEntity)taskEntities.get(i);
        }
        if (this.executionEntity.getVariable("sub_process_key") != null && task.getSubProcessKey() == null) {
            task.setSubProcessKey((String)this.executionEntity.getVariable("sub_process_key"));
        }
        this.task = task;
        return task;
    }
}

