/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class DefinitionEngineServiceImpl
implements IDefinitionEngineService {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ModelMapper modelMapper;

    public BpmResponseResult queryProcessName(String processKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        object.put("processName", (Object)this.processDefinitionsService.getMainOrNew(processKey).getName());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public int queryLatestVersion(String processKey) {
        return this.processDefinitionsService.queryLatestVersion(processKey);
    }

    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List deployments = this.processDefinitionsService.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinitionModel item : deployments) {
            if (item.getResourceName() != null) {
                String[] sourceArr = item.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (item.getDiagramResourceName() != null) {
                String[] diagramArr = item.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(item.getDeploymentTime());
                String timeStr = sdf.format(date);
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        object.put("data", result);
        object.put("count", (Object)result.size());
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessMainOrNew(String processKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List deployments = this.processDefinitionsService.getProcessMainOrNew(processKey);
        ArrayList result = new ArrayList(deployments.size());
        for (ProcessDefinitionModel item : deployments) {
            HashMap<String, String> processDefMap = new HashMap<String, String>();
            processDefMap.put("processDefinitionId", item.getId());
            processDefMap.put("processDefinitionName", item.getProcessName());
            processDefMap.put("process_key", item.getKey());
            processDefMap.put("description", item.getDescription());
            processDefMap.put("version", item.getVersion());
            processDefMap.put("deploymentId", item.getDeploymentId());
            processDefMap.put("isSuspended", item.getIsSuspended());
            processDefMap.put("mainProcess", item.getMainProcess());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(item.getDeploymentTime());
                String timeStr = sdf.format(date);
                processDefMap.put("deploymentTime", timeStr);
                json.add(processDefMap);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefList(String processName) {
        JSONArray json = new JSONArray();
        List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + processName + "%").orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(deployment.getId());
            item.setProcessName(deployment.getName());
            item.setVersion(Integer.toString(deployment.getVersion()));
            item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        json.add(result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessDefList(String processKey) {
        JSONArray json = new JSONArray();
        List<ProcessDefinitionModel> processDefinitionModels = this.processDefinitionsMapper.getProcessMainOrNew(processKey);
        for (ProcessDefinitionModel processDefinitionModel : processDefinitionModels) {
            JSONObject item = new JSONObject();
            item.put("processDefinitionId", (Object)processDefinitionModel.getId());
            item.put("processDefinitionName", (Object)processDefinitionModel.getProcessName());
            item.put("version", (Object)processDefinitionModel.getVersion());
            item.put("isSuspended", (Object)processDefinitionModel.getIsSuspended());
            item.put("description", (Object)processDefinitionModel.getDescription());
            item.put("deploymentId", (Object)processDefinitionModel.getDeploymentId());
            item.put("mainProcess", (Object)processDefinitionModel.getMainProcess());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(processDefinitionModel.getDeploymentTime());
                String timeStr = sdf.format(date);
                item.put("deploymentTime", (Object)timeStr);
                json.add((Object)item);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessByKeyAndVersion(String processKey, String version) {
        int newVersion = 0;
        if (HussarUtils.isNotEmpty((Object)version)) {
            newVersion = Integer.parseInt(version);
        }
        this.processDefinitionsMapper.updateSuspensionState(processKey, newVersion, BpmConstant.ACTIVATE_STATE);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult suspendProcessByKeyAndVersion(String processKey, String version) {
        int newVersion = 0;
        if (HussarUtils.isNotEmpty((Object)version)) {
            newVersion = Integer.parseInt(version);
        }
        this.processDefinitionsMapper.updateSuspensionState(processKey, newVersion, BpmConstant.SUSPEND_STATE);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        if (processDefinitionId == null) {
            return InstallResult.getResult((String)"0", (String)BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(String.valueOf(processDefinitionId)).singleResult();
        if (HussarUtils.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult((String)"0", (String)BpmConstantEnum.PROCESS_NOT_FOUND.getMessage(), null);
        }
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId))) {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        return InstallResult.getResult((String)"0", (String)BpmConstantEnum.DELETE_RUNNING_FAIL.getMessage(), null);
    }

    public BpmResponseResult deleteProcessDefinitionByKeyAndVersion(String processKey, String version) {
        if (HussarUtils.isEmpty((Object)processKey)) {
            return InstallResult.getResult((String)"0", (String)BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage(), null);
        }
        if (HussarUtils.isEmpty((Object)version)) {
            String modelId = this.modelMapper.getIdByIdentity(processKey);
            if ("0".equals(this.modelMapper.getRunningCountWithModelId(Long.parseLong(modelId), null))) {
                this.repositoryService.deleteModel(modelId);
                this.sysActAssigneeService.delAssignee(processKey);
                this.modelMapper.deleteModelDef(Long.parseLong(modelId), null);
                this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getModelId, (Object)Long.parseLong(modelId)));
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
        }
        Integer newVersion = Integer.parseInt(version);
        List<String> processDefinitionId = this.processDefinitionsMapper.getProcessDefinitionId(processKey, newVersion);
        if (processDefinitionId.size() != 0) {
            this.processDefinitionsService.canModelDeleteWithVersion(processKey);
            if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId.get(0)))) {
                String oldMainProcDefId = this.processDefinitionsService.getStartProcessDefinitionId(processKey);
                this.modelMapper.deleteModelDef(null, processDefinitionId.get(0));
                this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefinitionId.get(0)));
                if (processDefinitionId.get(0).equals(oldMainProcDefId)) {
                    this.processDefinitionsService.setNotMain(processKey);
                    this.sysActProcessFileService.copyFiles(processKey, null);
                }
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
        }
        return InstallResult.getResult((String)"0", (String)BpmConstantEnum.PROCESS_NOT_FOUND.getMessage(), null);
    }

    public BpmResponseResult queryProcess() {
        JSONArray json = new JSONArray();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            for (Model model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                try {
                    String temp = new String(arg0, StandardCharsets.UTF_8).replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes(StandardCharsets.UTF_8));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    Process process = bpmnModel.getMainProcess();
                    object.put("id", (Object)process.getId());
                    object.put("name", (Object)process.getName());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessLink(String processKey) {
        JSONArray json = new JSONArray();
        String processDefinitionId = this.processDefinitionsService.getStartProcessDefinitionId(processKey);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof UserTask) {
                    JSONObject object = new JSONObject();
                    object.put("id", (Object)flowElement.getId());
                    object.put("name", (Object)flowElement.getName());
                    object.put("nodeNameTranslateId", (Object)ActivitiTranslateUtil.getTranslateId((String)processDefinitionId, (String)flowElement.getId()));
                    json.add((Object)object);
                    continue;
                }
                if (!(flowElement instanceof SubProcess)) continue;
                for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(element instanceof UserTask)) continue;
                    JSONObject object = new JSONObject();
                    object.put("id", (Object)element.getId());
                    object.put("name", (Object)element.getName());
                    object.put("nodeNameTranslateId", (Object)ActivitiTranslateUtil.getTranslateId((String)processDefinitionId, (String)flowElement.getId()));
                    json.add((Object)object);
                }
            }
            BpmWorkflowTranslateUtil.translateJsonArray(json, o -> o.getString("nodeNameTranslateId"), (o, e) -> o.put("name", e));
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)BpmConstantEnum.MODEL_NOT_FOUND.getMessage(), null);
    }

    public BpmResponseResult queryStartFormUrl(String processKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(this.processDefinitionsService.getStartProcessDefinitionId(processKey));
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
            break;
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryAllNodeFormKey(String processKey, String version) {
        if (HussarUtils.isEmpty((Object)processKey)) {
            return InstallResult.getResult((String)"0", (String)BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage(), null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bpmnModel = null;
        if (HussarUtils.isEmpty((Object)version)) {
            List processDefinitionModel = this.processDefinitionsService.getProcessMainOrNew(processKey);
            bpmnModel = this.repositoryService.getBpmnModel(((ProcessDefinitionModel)processDefinitionModel.get(0)).getId());
        } else {
            Integer newVersion = Integer.parseInt(version);
            List<String> processDefinitionIds = this.processDefinitionsMapper.getProcessDefinitionId(processKey, newVersion);
            if (processDefinitionIds.size() == 0) {
                return InstallResult.getResult((String)"0", (String)BpmConstantEnum.PROCESS_NOT_FOUND.getMessage(), null);
            }
            bpmnModel = this.repositoryService.getBpmnModel(processDefinitionIds.get(0));
        }
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            String formUrl;
            JSONObject jsonObject = new JSONObject();
            if (flowElement instanceof StartEvent) {
                formUrl = ((StartEvent)flowElement).getFormKey();
                jsonObject.put("taskDefinitionKey", (Object)flowElement.getId());
                jsonObject.put("taskDefinitionName", (Object)flowElement.getName());
                jsonObject.put("taskDefinitionType", (Object)"StartEvent");
                jsonObject.put("formKey", (Object)formUrl);
                jsonArray.add((Object)jsonObject);
                continue;
            }
            if (flowElement instanceof UserTask) {
                formUrl = ((UserTask)flowElement).getFormKey();
                jsonObject.put("taskDefinitionKey", (Object)flowElement.getId());
                jsonObject.put("taskDefinitionName", (Object)flowElement.getName());
                jsonObject.put("flowFormDetailKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue());
                List assistFormKeys = (List)flowElement.getExtensionElements().get("assistFormKey");
                List assistFlowFormDetailKeys = (List)flowElement.getExtensionElements().get("assistFlowFormDetailKey");
                List ccFormKeys = (List)flowElement.getExtensionElements().get("ccFormKey");
                List ccFlowFormDetailKeys = (List)flowElement.getExtensionElements().get("ccFlowFormDetailKey");
                if (assistFormKeys != null && ((ExtensionElement)assistFormKeys.get(0)).getAttributes().size() > 0) {
                    jsonObject.put("assistFormKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("assistFormKey")).get(0)).getAttributes().get("assistFormKey")).get(0)).getValue());
                }
                if (assistFlowFormDetailKeys != null && ((ExtensionElement)assistFlowFormDetailKeys.get(0)).getAttributes().size() > 0) {
                    String assistFlowFormDetailKey = ((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("assistFlowFormDetailKey")).get(0)).getAttributes().get("assistFlowFormDetailKey")).get(0)).getValue();
                    jsonObject.put("assistFlowFormDetailKey", (Object)assistFlowFormDetailKey);
                }
                if (ccFormKeys != null && ((ExtensionElement)ccFormKeys.get(0)).getAttributes().size() > 0) {
                    jsonObject.put("ccFormKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("ccFormKey")).get(0)).getAttributes().get("ccFormKey")).get(0)).getValue());
                }
                if (ccFlowFormDetailKeys != null && ((ExtensionElement)ccFlowFormDetailKeys.get(0)).getAttributes().size() > 0) {
                    String ccFlowFormDetailKey = ((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("ccFlowFormDetailKey")).get(0)).getAttributes().get("ccFlowFormDetailKey")).get(0)).getValue();
                    jsonObject.put("ccFlowFormDetailKey", (Object)ccFlowFormDetailKey);
                }
                jsonObject.put("taskDefinitionType", (Object)"UserTask");
                jsonObject.put("formKey", (Object)formUrl);
                jsonArray.add((Object)jsonObject);
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                String formUrl2;
                JSONObject jsonObject1 = new JSONObject();
                if (element instanceof StartEvent) {
                    formUrl2 = ((StartEvent)element).getFormKey();
                    jsonObject1.put("taskDefinitionKey", (Object)element.getId());
                    jsonObject1.put("taskDefinitionName", (Object)element.getName());
                    jsonObject1.put("taskDefinitionType", (Object)"StartEvent");
                    jsonObject1.put("subTaskDefinitionKey", (Object)flowElement.getId());
                    jsonObject1.put("subTaskDefinitionName", (Object)flowElement.getName());
                    jsonObject1.put("formKey", (Object)formUrl2);
                    jsonArray.add((Object)jsonObject1);
                    continue;
                }
                if (!(element instanceof UserTask)) continue;
                formUrl2 = ((UserTask)element).getFormKey();
                jsonObject1.put("taskDefinitionKey", (Object)element.getId());
                jsonObject1.put("taskDefinitionName", (Object)element.getName());
                jsonObject1.put("flowFormDetailKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue());
                List assistFormKeys = (List)element.getExtensionElements().get("assistFormKey");
                List assistFlowFormDetailKeys = (List)element.getExtensionElements().get("assistFlowFormDetailKey");
                List ccFormKeys = (List)element.getExtensionElements().get("ccFormKey");
                List ccFlowFormDetailKeys = (List)element.getExtensionElements().get("ccFlowFormDetailKey");
                if (assistFormKeys != null && ((ExtensionElement)assistFormKeys.get(0)).getAttributes().size() > 0) {
                    jsonObject1.put("assistFormKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("assistFormKey")).get(0)).getAttributes().get("assistFormKey")).get(0)).getValue());
                }
                if (assistFlowFormDetailKeys != null && ((ExtensionElement)assistFlowFormDetailKeys.get(0)).getAttributes().size() > 0) {
                    String assistFlowFormDetailKey = ((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("assistFlowFormDetailKey")).get(0)).getAttributes().get("assistFlowFormDetailKey")).get(0)).getValue();
                    jsonObject1.put("assistFlowFormDetailKey", (Object)assistFlowFormDetailKey);
                }
                if (ccFormKeys != null && ((ExtensionElement)ccFormKeys.get(0)).getAttributes().size() > 0) {
                    jsonObject1.put("ccFormKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("ccFormKey")).get(0)).getAttributes().get("ccFormKey")).get(0)).getValue());
                }
                if (ccFlowFormDetailKeys != null && ((ExtensionElement)ccFlowFormDetailKeys.get(0)).getAttributes().size() > 0) {
                    String ccFlowFormDetailKey = ((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("ccFlowFormDetailKey")).get(0)).getAttributes().get("ccFlowFormDetailKey")).get(0)).getValue();
                    jsonObject1.put("ccFlowFormDetailKey", (Object)ccFlowFormDetailKey);
                }
                jsonObject1.put("taskDefinitionType", (Object)"UserTask");
                jsonObject1.put("formKey", (Object)formUrl2);
                jsonObject1.put("subTaskDefinitionKey", (Object)flowElement.getId());
                jsonObject1.put("subTaskDefinitionName", (Object)flowElement.getName());
                jsonArray.add((Object)jsonObject1);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public boolean queryIsPublish(String processKey) {
        List list = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).list();
        return list != null && !list.isEmpty();
    }

    public BpmResponseResult judgeProcessName(String processName) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelName(processName).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult judgeProcDefKey(String procDefKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        boolean isRepeat = false;
        long num = this.repositoryService.createModelQuery().modelKey(procDefKey).count();
        if (num > 0L) {
            isRepeat = true;
        }
        jsonObject.put("isRepeat", (Object)isRepeat);
        jsonArray.add((Object)jsonObject);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNodeInfoByProcessKeyAndVersion(String processKey, String version) {
        if (HussarUtils.isEmpty((Object)processKey)) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        JSONArray json = new JSONArray();
        List processDefinitionIds = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)version)) {
            Integer newVersion = Integer.parseInt(version);
            processDefinitionIds = this.processDefinitionsService.getProcessDefinitionId(processKey, newVersion);
        } else {
            List<DefinitionModel> definitionModels = this.processDefinitionsMapper.getMainOrNew(processKey);
            processDefinitionIds.add(definitionModels.get(0).getId());
        }
        if (HussarUtils.isNotEmpty(processDefinitionIds)) {
            for (int i = 0; i < processDefinitionIds.size(); ++i) {
                HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
                ArrayList<JSONObject> nodeList = new ArrayList<JSONObject>();
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel((String)processDefinitionIds.get(i));
                if (bpmnModel != null) {
                    Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
                    for (FlowElement flowElement : flowElements) {
                        JSONObject object = new JSONObject();
                        object.put("taskDefinitionKey", (Object)flowElement.getId());
                        object.put("taskDefinitionName", (Object)flowElement.getName());
                        if (flowElement instanceof UserTask) {
                            object.put("taskDefinitionType", (Object)"UserTask");
                            object.put("formKey", (Object)((UserTask)flowElement).getFormKey());
                            if (HussarUtils.isNotEmpty(flowElement.getExtensionElements().get("flowFormDetailKey")) && HussarUtils.isNotEmpty(((ExtensionElement)((List)flowElement.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey"))) {
                                object.put("flowFormDetailKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)flowElement.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue());
                            }
                            nodeList.add(object);
                            continue;
                        }
                        if (flowElement instanceof StartEvent) {
                            object.put("taskDefinitionType", (Object)"StartEvent");
                            object.put("formKey", (Object)((StartEvent)flowElement).getFormKey());
                            nodeList.add(object);
                            continue;
                        }
                        if (flowElement instanceof EndEvent) {
                            object.put("taskDefinitionType", (Object)"EndEvent");
                            nodeList.add(object);
                            continue;
                        }
                        if (flowElement instanceof ReceiveTask) {
                            object.put("taskDefinitionType", (Object)"ReceiveTask");
                            nodeList.add(object);
                            continue;
                        }
                        if (flowElement instanceof ServiceTask) {
                            object.put("taskDefinitionType", (Object)"ServiceTask");
                            nodeList.add(object);
                            continue;
                        }
                        if (flowElement instanceof CallActivity) {
                            object.put("taskDefinitionType", (Object)"CallActivity");
                            nodeList.add(object);
                            continue;
                        }
                        if (!(flowElement instanceof SubProcess)) continue;
                        ArrayList<JSONObject> subNode = new ArrayList<JSONObject>();
                        object.put("taskDefinitionType", (Object)"SubProcess");
                        for (FlowElement element : ((SubProcess)flowElement).getFlowElements()) {
                            JSONObject object1 = new JSONObject();
                            object1.put("taskDefinitionKey", (Object)element.getId());
                            object1.put("taskDefinitionName", (Object)element.getName());
                            object1.put("subTaskDefinitionKey", (Object)flowElement.getId());
                            object1.put("subTaskDefinitionName", (Object)flowElement.getName());
                            if (element instanceof UserTask) {
                                object1.put("taskDefinitionType", (Object)"UserTask");
                                object1.put("formKey", (Object)((UserTask)element).getFormKey());
                                if (HussarUtils.isNotEmpty(element.getExtensionElements().get("flowFormDetailKey")) && HussarUtils.isNotEmpty(((ExtensionElement)((List)element.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey"))) {
                                    object1.put("flowFormDetailKey", (Object)((ExtensionAttribute)((List)((ExtensionElement)((List)element.getExtensionElements().get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue());
                                }
                                subNode.add(object1);
                                continue;
                            }
                            if (element instanceof StartEvent) {
                                object1.put("taskDefinitionType", (Object)"StartEvent");
                                object1.put("formKey", (Object)((StartEvent)element).getFormKey());
                                subNode.add(object1);
                                continue;
                            }
                            if (element instanceof EndEvent) {
                                object1.put("taskDefinitionType", (Object)"EndEvent");
                                subNode.add(object1);
                                continue;
                            }
                            if (element instanceof ReceiveTask) {
                                object1.put("taskDefinitionType", (Object)"ReceiveTask");
                                subNode.add(object1);
                                continue;
                            }
                            if (element instanceof ServiceTask) {
                                object1.put("taskDefinitionType", (Object)"ServiceTask");
                                subNode.add(object1);
                                continue;
                            }
                            if (!(element instanceof CallActivity)) continue;
                            object1.put("taskDefinitionType", (Object)"CallActivity");
                            subNode.add(object1);
                        }
                        object.put("subProcessNode", subNode);
                        nodeList.add(object);
                    }
                } else {
                    return InstallResult.getResult((String)"0", (String)BpmConstantEnum.MODEL_NOT_FOUND.getMessage(), null);
                }
                nodeInfo.put("processDefinitionName", ((Process)bpmnModel.getProcesses().get(0)).getName());
                nodeInfo.put("processDefinitionId", processDefinitionIds.get(i));
                nodeInfo.put("nodeInfo", nodeList);
                json.add(nodeInfo);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)BpmConstantEnum.PROCESS_NOT_FOUND.getMessage(), null);
    }
}

