/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.context.i18n.LocaleContextHolder;

public class BpmWorkflowTranslateUtil {
    private static ISysMultiLangMgtService sysMultiLangMgtService = BpmWorkflowTranslateUtil.initSysMultiLangMgtService();
    private static final String DEFAULT_LANGLE = "zh_CN";

    private static ISysMultiLangMgtService initSysMultiLangMgtService() {
        try {
            return (ISysMultiLangMgtService)SpringContextHolder.getBean(ISysMultiLangMgtService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void translateJsonArray(JSONArray jsonArray, Function<JSONObject, String> getTranslateTagFunction, BiConsumer<JSONObject, String> setProcessNameFunction) {
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toString();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String translateTag = getTranslateTagFunction.apply(jsonObject);
            String newName = BpmWorkflowTranslateUtil.getTranslateName(translateTag);
            if (!HussarUtils.isNotEmpty((Object)newName)) continue;
            setProcessNameFunction.accept(jsonObject, newName);
        }
    }

    public static <T> void translate(List<T> list, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toString();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        for (T t : list) {
            String translateTag = getTranslateTagFunction.apply(t);
            String newName = BpmWorkflowTranslateUtil.getTranslateName(translateTag);
            if (!HussarUtils.isNotEmpty((Object)newName)) continue;
            setProcessNameFunction.accept(t, newName);
        }
    }

    public static <T> void translate(T entity, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toString();
        if (DEFAULT_LANGLE.equals(lang)) {
            return;
        }
        String translateTag = getTranslateTagFunction.apply(entity);
        String newName = BpmWorkflowTranslateUtil.getTranslateName(translateTag);
        if (HussarUtils.isNotEmpty((Object)newName)) {
            setProcessNameFunction.accept(entity, newName);
        }
    }

    public static String getTranslateName(String translateTag) {
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.toLanguageTag();
        if (HussarUtils.isEmpty((Object)translateTag) || sysMultiLangMgtService == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(translateTag).getData();
        if (HussarUtils.isEmpty(langMap.get("langText")) || HussarUtils.isEmpty(((Map)langMap.get("langText")).get(lang))) {
            return null;
        }
        return (String)((Map)langMap.get("langText")).get(lang);
    }
}

