/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assist.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assist.service.IAssistService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ChildTaskCompleteCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ChildTaskCreateCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.cmd.DeleteCommentCmd;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssistServiceImpl
implements IAssistService {
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;

    public BpmResponseResult createAssistTask(String taskId, String assistInitiator, String userIds, String comment, boolean isPrivate) {
        if (taskId == null || userIds == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        this.processEngine.getManagementService().executeCommand((Command)new CommonPrepareCmd(realTaskId.getTaskId(), assistInitiator, realTaskId.getMandatary()));
        this.processEngine.getManagementService().executeCommand((Command)new ChildTaskCreateCmd(realTaskId.getTaskId(), assistInitiator, new HashSet<String>(Arrays.asList(userIds.split(","))), comment, isPrivate ? "3" : "2"));
        return InstallResult.success();
    }

    public BpmResponseResult completeAssistTask(String taskId, String userId, String comment) {
        if (taskId == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        return this.completeAssistTask(taskId, userId, comment, true);
    }

    public BpmResponseResult completeAssistTask(String taskId, String userId, String comment, boolean isAuditAuthority) {
        this.processEngine.getManagementService().executeCommand((Command)new ChildTaskCompleteCmd(taskId, userId, comment).isAuditAuthority(isAuditAuthority));
        return InstallResult.success();
    }

    public BpmResponseResult editAssistTaskComment(String taskId, String userId, String comment) {
        if (taskId == null || userId == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = commandContext.getHistoricTaskInstanceEntityManager();
            HistoricTaskInstanceEntity historicTaskInstance = historicTaskInstanceEntityManager.findHistoricTaskInstanceById(taskId);
            if (historicTaskInstance == null) {
                throw new PublicClientException(BpmConstantEnum.TASK_NOT_FOUND.getMessage());
            }
            if (historicTaskInstance.getParentTaskId() == null || !TaskType.isAssist((String)historicTaskInstance.getTaskType())) {
                throw new PublicClientException(BpmConstantEnum.COMMON_TASK_WITH_ASSIST_HANDLE.getMessage());
            }
            if (!userId.equals(historicTaskInstance.getAssignee())) {
                throw new PublicClientException(BpmConstantEnum.USER_NO_PROCESS_PERMISSION.getMessage());
            }
            if (historicTaskInstance.getEndTime() == null) {
                throw new PublicClientException(BpmConstantEnum.ERROR_HANDLE_WITH_RUNNING_ASSIST_TASK.getMessage());
            }
            HistoricTaskInstanceEntity parentTask = historicTaskInstanceEntityManager.findHistoricTaskInstanceById(historicTaskInstance.getParentTaskId());
            if (parentTask == null || parentTask.getEndTime() != null) {
                throw new PublicClientException(BpmConstantEnum.ERROR_UPDATE_ASSIST_COMMENT_WITH_MAIN_TASK_FINISHED.getMessage());
            }
            List commentList = commandContext.getCommentEntityManager().findCommentsByTaskIdAndType(taskId, "complete");
            for (Comment delComment : commentList) {
                commandContext.getCommentEntityManager().delete((PersistentObject)((CommentEntity)delComment));
            }
            new DeleteCommentCmd(taskId, null, null).execute(commandContext);
            if (HussarUtils.isNotEmpty((Object)comment)) {
                CommentEntity.addComment((String)userId, (String)taskId, (String)comment);
            }
            return null;
        });
        return InstallResult.success();
    }

    public BpmResponseResult assistTaskAddAssignee(String taskId, final String userIds, final boolean isDelete) {
        if (userIds == null) {
            throw new PublicClientException(BpmConstantEnum.NOT_NULL_PARAM_IS_NULL.getMessage());
        }
        final HashSet<String> userIdSet = new HashSet<String>(Arrays.asList(userIds.split(",")));
        this.processEngine.getManagementService().executeCommand((Command)new NeedsActiveTaskCmd<Void>(taskId){

            protected Void execute(CommandContext commandContext, TaskEntity task) {
                List identityLinkEntityList;
                if (task.getParentTaskId() == null || !TaskType.isAssist((String)task.getTaskType())) {
                    throw new PublicClientException(BpmConstantEnum.COMMON_TASK_WITH_ASSIST_HANDLE.getMessage());
                }
                TaskEntity parentTask = commandContext.getTaskEntityManager().findTaskById(task.getParentTaskId());
                if (task.isSuspended()) {
                    throw new PublicClientException(BpmConstantEnum.TASK_IS_SUSPENDED.getMessage());
                }
                HashSet<String> existUserIds = new HashSet<String>();
                if (parentTask.getExecution().getActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
                    List tasks = parentTask.getExecution().getSuperExecution().getTasks();
                    for (TaskEntity taskEntity : tasks) {
                        Object identityLinkEntityList2;
                        if (taskEntity.getTaskType() != null) continue;
                        if (taskEntity.getAssignee() != null && userIdSet.contains(taskEntity.getAssignee())) {
                            existUserIds.add(taskEntity.getAssignee());
                        }
                        if ((identityLinkEntityList2 = taskEntity.getIdentityLinks()) == null) continue;
                        Iterator iterator = identityLinkEntityList2.iterator();
                        while (iterator.hasNext()) {
                            IdentityLinkEntity identityLink = (IdentityLinkEntity)iterator.next();
                            if (!userIdSet.contains(identityLink.getUserId())) continue;
                            existUserIds.add(identityLink.getUserId());
                        }
                    }
                } else {
                    identityLinkEntityList = parentTask.getIdentityLinks();
                    for (IdentityLinkEntity identityLink : identityLinkEntityList) {
                        if (!userIdSet.contains(identityLink.getUserId())) continue;
                        existUserIds.add(identityLink.getUserId());
                    }
                }
                identityLinkEntityList = task.getIdentityLinks();
                String assistInitiator = ((IdentityLinkEntity)identityLinkEntityList.get(0)).getAssistInitiator();
                List childTask = Context.getCommandContext().getTaskEntityManager().findTasksByParentTaskId(task.getParentTaskId());
                if (isDelete) {
                    commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(this.taskId);
                }
                if (childTask != null && !childTask.isEmpty()) {
                    for (Task taskEntity : childTask) {
                        if (!TaskType.isAssist((String)taskEntity.getTaskType()) || isDelete && taskEntity.getId().equals(task.getId())) continue;
                        List identityLinkEntities = ((TaskEntity)taskEntity).getIdentityLinks();
                        for (IdentityLinkEntity identityLink : identityLinkEntities) {
                            if (!userIds.contains(identityLink.getUserId()) || !assistInitiator.equals(identityLink.getAssistInitiator())) continue;
                            existUserIds.add(identityLink.getUserId());
                        }
                    }
                }
                if (!existUserIds.isEmpty()) {
                    String userNames = AssistServiceImpl.this.iAssigneeChooseService.getUserNames(new ArrayList(existUserIds));
                    throw new PublicClientException(userNames + BpmConstantEnum.CANNOT_ADD_ASSIGNEE.getMessage());
                }
                for (String userId : userIdSet) {
                    task.addCandidateUser(userId, null, null, assistInitiator);
                }
                AssistServiceImpl.this.dataPushService.entrustDataPush((Task)task, userIds, isDelete ? String.join((CharSequence)",", identityLinkEntityList.stream().map(IdentityLinkEntity::getUserId).collect(Collectors.toSet())) : null);
                return null;
            }
        });
        return InstallResult.success();
    }
}

