/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudTaskListener")
public class DefaultTaskListener
implements TaskListener {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void notify(DelegateTask delegateTask) {
        BpmnModel bm = repositoryService.getBpmnModel(delegateTask.getProcessDefinitionId());
        FlowElement flowElement = bm.getFlowElement(delegateTask.getTaskDefinitionKey());
        String beanId = (String)delegateTask.getVariableLocal("beanId");
        delegateTask.removeVariableLocal("beanId");
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String businessId = ((TaskEntity)delegateTask).getProcessInstance().getBusinessKey();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", delegateTask.getTaskDefinitionKey());
        map.put("nodeName", flowElement.getName());
        map.put("businessId", businessId);
        map.put("processInsId", delegateTask.getProcessInstanceId());
        map.put("processDefinitionId", delegateTask.getProcessDefinitionId());
        map.put("processKey", delegateTask.getProcessDefinitionId().split(":")[0]);
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateTask.getExecution()).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processName", ((ExecutionEntity)delegateTask.getExecution()).getProcessDefinition().getName());
        map.put("taskId", delegateTask.getId());
        Object info = Context.getCommandContext().getAttribute("listenerParam");
        ParamModel paramModel = (ParamModel)info;
        if ("complete".equals(delegateTask.getEventName())) {
            Object tasksourceFlag = Context.getCommandContext().getAttribute("taskSourceFlag");
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                map.put("completeType", paramModel.getCompleteType());
                map.put("deleteType", paramModel.getDeleteType());
                map.put("createTime", simpleDateFormat.format(delegateTask.getCreateTime()));
                map.put("endTime", paramModel.getEndTime());
                map.put("sourcesTaskDefinitionIds", paramModel.getFrom());
                map.put("targetIds", paramModel.getTo());
                map.put("targetNodeAssignee", paramModel.getTargetAssignee());
                map.put("affectedNodeId", paramModel.getAffectedNodeId());
                map.put("assignee", paramModel.getHandler());
            } else {
                map.put("completeType", tasksourceFlag.toString());
                map.put("assignee", delegateTask.getAssignee());
            }
        } else if ("create".equals(delegateTask.getEventName())) {
            List identityLinks = ((TaskEntity)delegateTask).getIdentityLinks();
            String assignee = "";
            for (IdentityLinkEntity identity : identityLinks) {
                assignee = assignee + "," + identity.getUserId();
            }
            if (HussarUtils.isNotEmpty((Object)assignee)) {
                assignee = assignee.substring(1);
            }
            map.put("assignee", assignee);
            Object tasksourceFlag = Context.getCommandContext().getAttribute("taskSourceFlag");
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                if (!map.containsKey("starter")) {
                    map.put("starter", paramModel.getStarter());
                }
                map.put("sendUser", paramModel.getSendUser());
                map.put("createReason", paramModel.getCreateReason());
                map.put("lastNodeId", paramModel.getLastNodeId());
                map.put("lastTaskId", paramModel.getLastTaskId());
                map.put("lastNodeName", paramModel.getLastNodeName());
                map.put("lastCompleteType", paramModel.getLastCompleteType());
                map.put("lastNodeAssignee", paramModel.getLastNodeHandler());
            } else {
                map.put("createReason", tasksourceFlag.toString());
            }
            map.put("createTime", simpleDateFormat.format(new Date()));
        }
        if (beanId != null) {
            try {
                if (!this.lcdpBpmProperties.isStartAlone()) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                map.put("beanId", beanId);
                String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
                WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                workflowListenerService.executeListener(map, serviceName);
            }
            catch (Exception e) {
                throw new PublicClientException(BpmConstantEnum.ERROR_TASK_LISTENER.getMessage());
            }
        }
    }
}

