/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Execution;

public class ProcessUpdateCheckCmd
implements Command<Void> {
    private String procDefId;
    private BpmnModel bpmnModel;
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public ProcessUpdateCheckCmd(String procDefId, BpmnModel bpmnModel) {
        this.procDefId = procDefId;
        this.bpmnModel = bpmnModel;
    }

    public Void execute(CommandContext commandContext) {
        List list = commandContext.getProcessEngineConfiguration().getRuntimeService().createExecutionQuery().processDefinitionId(this.procDefId).list();
        HashMap<String, HashSet<Object>> targetNodeMap = new HashMap<String, HashSet<Object>>();
        if (list.size() > 1) {
            for (Execution execution : list) {
                HashSet<Object> targetNodes;
                Object targetNode;
                if (execution.getParentId() == null || (targetNode = execution.getActivityId()) == null) continue;
                String activityType = (String)((ExecutionEntity)execution).getActivity().getProperty("type");
                if (activityType.endsWith("Gateway")) {
                    String prevNode = ((String)((ExecutionEntity)execution).getVariableLocal("all_prev_node")).replace("'", "");
                    targetNode = (String)targetNode + ":" + prevNode;
                }
                if ((targetNodes = (HashSet<Object>)targetNodeMap.get(execution.getProcessInstanceId())) == null) {
                    targetNodes = new HashSet<Object>();
                }
                targetNodes.add(targetNode);
                targetNodeMap.put(execution.getProcessInstanceId(), targetNodes);
            }
            HashSet<String> allTargetNode = new HashSet<String>();
            ArrayList<Set<String>> targetNodeSet = new ArrayList<Set<String>>();
            for (String procInstId : targetNodeMap.keySet()) {
                if (((Set)targetNodeMap.get(procInstId)).size() <= 1) continue;
                targetNodeSet.add((Set<String>)targetNodeMap.get(procInstId));
                allTargetNode.addAll((Collection)targetNodeMap.get(procInstId));
            }
            for (int i = 0; i < targetNodeSet.size(); ++i) {
                for (int j = i + 1; j < targetNodeSet.size(); ++j) {
                    if (((Set)targetNodeSet.get(i)).containsAll((Collection)targetNodeSet.get(j))) {
                        targetNodeSet.remove(j);
                        --j;
                        continue;
                    }
                    if (!((Set)targetNodeSet.get(j)).containsAll((Collection)targetNodeSet.get(i))) continue;
                    targetNodeSet.remove(i);
                    --i;
                }
            }
            if (targetNodeSet.isEmpty()) {
                return null;
            }
            if (!this.canRejectToAnyNodePlus(this.bpmnModel.getMainProcess(), allTargetNode, targetNodeSet)) {
                throw new PublicClientException(BpmConstantEnum.ERR_UPDATE_PROCESS_WITH_AFFECTED_TASKS.getMessage());
            }
        }
        return null;
    }

    public boolean canRejectToAnyNodePlus(Process process, Set<String> allTargetNode, List<Set<String>> targetNodeSet) {
        ArrayList<String> targetNodes = new ArrayList<String>(allTargetNode);
        HashMap<String, ArrayList<List<String>>> targetNodePathMap = new HashMap<String, ArrayList<List<String>>>();
        for (String targetNode : targetNodes) {
            FlowNode userTask;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (targetNode.contains(":")) {
                arrayList.add(targetNode.split(":")[0]);
                userTask = (FlowNode)process.getFlowElement(targetNode.split(":")[1]);
            } else {
                arrayList.add(targetNode);
                userTask = (FlowNode)process.getFlowElement(targetNode);
            }
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            this.getAllHisNodeList(process, userTask.getIncomingFlows(), arrayList, lists);
            if (lists.isEmpty()) {
                return false;
            }
            targetNodePathMap.put(targetNode, lists);
        }
        ArrayList<String> canRejectNodeIds = new ArrayList<String>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof Gateway) || flowElement instanceof ExclusiveGateway) continue;
            canRejectNodeIds.add(flowElement.getId());
        }
        for (Set set : targetNodeSet) {
            ArrayList targetNode = new ArrayList(set);
            for (int i = 0; i < targetNode.size(); ++i) {
                for (int j = i + 1; j < targetNode.size(); ++j) {
                    String targetNode1 = (String)targetNode.get(i);
                    String targetNode2 = (String)targetNode.get(j);
                    List nodePathList1 = (List)targetNodePathMap.get(targetNode1);
                    List nodePathList2 = (List)targetNodePathMap.get(targetNode2);
                    String errorNode = null;
                    if (targetNode1.contains(":") && !targetNode2.contains(":")) {
                        errorNode = targetNode1.split(":")[0];
                    } else if (!targetNode1.contains(":") && targetNode2.contains(":")) {
                        errorNode = targetNode2.split(":")[0];
                    }
                    for (List path1 : nodePathList1) {
                        block6: for (List path2 : nodePathList2) {
                            for (String node : path1) {
                                if (!path2.contains(node)) continue;
                                if (canRejectNodeIds.contains(node) && !node.equals(errorNode)) continue block6;
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private void getAllHisNodeList(Process process, List<SequenceFlow> incomingFlows, List<String> goneNode, List<List<String>> allHisNode) {
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(goneNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            this.getAllHisNodeList(process, ((FlowNode)flowElement).getIncomingFlows(), goneNodeSave, allHisNode);
        }
    }
}

