/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FireEvent {
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private static final Logger logger = LoggerFactory.getLogger(FireEvent.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void fireEvent(ExecutionEntity executionEntity, String processEventType, String eventType) {
        BpmnModel bpmnModel;
        if (processEventType != null && (bpmnModel = Context.getProcessEngineConfiguration().getRepositoryService().getBpmnModel(executionEntity.getProcessDefinitionId())) != null) {
            Process process = bpmnModel.getMainProcess();
            List executionListeners = process.getExecutionListeners();
            for (ActivitiListener activitiListener : executionListeners) {
                Object fieldExtension2;
                String event = activitiListener.getEvent();
                if (!processEventType.equals(event)) continue;
                String beanId = activitiListener.getImplementation();
                boolean isAsyn = false;
                List fieldExtensions = activitiListener.getFieldExtensions();
                for (Object fieldExtension2 : fieldExtensions) {
                    if (!"isAsyn".equals(fieldExtension2.getFieldName())) continue;
                    isAsyn = Boolean.parseBoolean(fieldExtension2.getStringValue());
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("businessId", executionEntity.getProcessBusinessKey());
                map.put("processInsId", executionEntity.getProcessInstanceId());
                map.put("processDefinitionId", executionEntity.getProcessDefinitionId());
                map.put("processKey", executionEntity.getProcessDefinition().getKey());
                fieldExtension2 = executionEntity.getProcessInstance().getIdentityLinks().iterator();
                while (fieldExtension2.hasNext()) {
                    IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)fieldExtension2.next();
                    if (!"starter".equals(identityLinkEntity.getType())) continue;
                    map.put("starter", identityLinkEntity.getUserId());
                    break;
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                map.put("createTime", simpleDateFormat.format(new Date()));
                map.put("processName", executionEntity.getProcessDefinition().getName());
                map.put("eventType", eventType);
                if (beanId == null) continue;
                try {
                    if (!lcdpBpmProperties.isStartAlone()) {
                        HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                        workflowListenerVisitor.notify(map);
                        return;
                    }
                    map.put("beanId", beanId);
                    String serviceName = String.valueOf(modelService.getServiceName(executionEntity.getProcessDefinitionId().split(":")[0]));
                    WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                    workflowListenerService.executeListener(map, serviceName);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (isAsyn) continue;
                    throw new PublicClientException(BpmConstantEnum.ERROR_EXECUTION_LISTENER.getMessage());
                }
            }
        }
    }
}

