/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.vo.SysActCcTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.RealTaskId;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CcAddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstantEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends HussarServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DataPushService dataPushService;
    @Lazy
    @Resource
    HistoryService historyService;
    @Lazy
    @Resource
    TaskService taskService;
    @Lazy
    @Resource
    RuntimeService runtimeService;
    @Lazy
    @Resource
    RepositoryService repositoryService;
    @Lazy
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static Logger logger = LoggerFactory.getLogger(SysActCcTaskServiceImpl.class);

    public ApiResponse<Page<SysActCcTaskVo>> query(Page<SysActCcTaskVo> pages, SysActCcTaskQueryDto sysActCcTaskQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getStartTime()) ? formatter.parse(sysActCcTaskQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)sysActCcTaskQueryDto.getEndTime()) ? formatter.parse(sysActCcTaskQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        long todoTotal = this.sysActCcTaskMapper.countCcTotal(start, end, sysActCcTaskQueryDto);
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List<SysActCcTaskVo> sysActCcTasks = this.sysActCcTaskMapper.queryOutside(pages, start, end, sysActCcTaskQueryDto);
        if (sysActCcTasks != null && !sysActCcTasks.isEmpty()) {
            List users = sysActCcTasks.stream().map(SysActCcTaskVo::getSendUser).collect(Collectors.toList());
            HashMap map = this.iAssigneeChooseService.getUserListByUserId(users);
            if (map == null) {
                map = new HashMap();
            }
            for (SysActCcTaskVo sysActCcTask : sysActCcTasks) {
                JSONObject object;
                String userName = (String)map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if ("0".equals(sysActCcTask.getTaskType())) {
                    formDetailKey = sysActCcTask.getFormKey();
                }
                if (!HussarUtils.isNotEmpty((Object)formDetailKey) || !HussarUtils.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWebFormDetailKey(object.getString("web"));
                sysActCcTask.setMobileFormDetailKey(object.getString("mobile"));
            }
        }
        pages.setRecords(sysActCcTasks);
        return ApiResponse.success(pages);
    }

    public ApiResponse<String> ccTask(SysActCcTaskDto sysActCcTaskDto) {
        List ccFormKeyList;
        Object ccFormKeyMap;
        String taskId = sysActCcTaskDto.getTaskId();
        RealTaskId realTaskId = RealTaskId.getRealTaskIdAndMandatary(taskId);
        String assignee = sysActCcTaskDto.getAssignee();
        String userId = sysActCcTaskDto.getUserId();
        if (HussarUtils.isEmpty((Object)assignee)) {
            return ApiResponse.fail((String)BpmConstantEnum.NULL_RECEIVER.getMessage());
        }
        ArrayList<String> receiverList = new ArrayList<String>(Arrays.asList(sysActCcTaskDto.getAssignee().split(",")));
        if (receiverList.contains(userId)) {
            return ApiResponse.fail((String)BpmConstantEnum.CANNOT_CC_ONESELF.getMessage());
        }
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().queryChildTask()).taskId(realTaskId.getTaskId())).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            return ApiResponse.fail((String)BpmConstantEnum.TASK_NOT_FOUND.getMessage());
        }
        if (TaskType.isAssist((String)task.getTaskType())) {
            return ApiResponse.fail((String)BpmConstantEnum.ASSIST_TASK_WITH_ERROR_HANDLE.getMessage());
        }
        HashSet users = new HashSet();
        List<HistoricTaskInstance> hisTaskList = this.getHisTask(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        ArrayList<String> errorUserIds = new ArrayList<String>();
        ArrayList<String> hisTaskIds = new ArrayList<String>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            hisTaskIds.add(historicTaskInstance.getId());
            if (historicTaskInstance.getEndTime() == null) {
                List identityLinkList = this.taskService.getIdentityLinksType(historicTaskInstance.getId());
                for (IdentityLink identityLink : identityLinkList) {
                    if (!receiverList.contains(identityLink.getUserId())) continue;
                    errorUserIds.add(identityLink.getUserId());
                }
                continue;
            }
            if (!receiverList.contains(historicTaskInstance.getAssignee())) continue;
            errorUserIds.add(historicTaskInstance.getAssignee());
        }
        List<SysActCcTask> ccTaskList = this.getCcTaskList(Long.valueOf(task.getProcessInstanceId()), task.getTaskDefinitionKey(), task.getSubProcessKey());
        for (SysActCcTask sysActCcTask : ccTaskList) {
            if (!receiverList.contains(sysActCcTask.getReceiveUser())) continue;
            errorUserIds.add(sysActCcTask.getReceiveUser());
        }
        if (HussarUtils.isNotEmpty(errorUserIds)) {
            String string = this.iAssigneeChooseService.getUserNames(errorUserIds);
            return ApiResponse.fail((String)(string + BpmConstantEnum.CANNOT_ADD_CC_USER_EXISTED_TASK_OR_CC.getMessage()));
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        List ccElement = (List)bpmnModel.getFlowElement(task.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
        String formKey = null;
        if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
            formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
        }
        for (String user : receiverList) {
            SysActCcTask sysActCcTask = new SysActCcTask();
            sysActCcTask.setProcessInsId(Long.valueOf(Long.parseLong(task.getProcessInstanceId())));
            sysActCcTask.setProcName(historicProcessInstance.getProcessDefinitionName());
            sysActCcTask.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            sysActCcTask.setTaskName(task.getName());
            sysActCcTask.setReceiveUser(user);
            sysActCcTask.setSendUser(sysActCcTaskDto.getUserId());
            sysActCcTask.setSendTime(ts);
            sysActCcTask.setFormKey(formKey);
            sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
            sysActCcTask.setProcDefKey(historicProcessInstance.getProcessDefinitionKey());
            sysActCcTask.setBusinessId(historicProcessInstance.getBusinessKey());
            sysActCcTask.setTaskState("0");
            sysActCcTask.setCcMoment("2");
            Map map = task.getTaskLocalVariables();
            if (HussarUtils.isNotEmpty((Object)map)) {
                sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
            }
            list.add(sysActCcTask);
        }
        this.saveBatch(list);
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(realTaskId.getTaskId());
        dataPush.setUserId(String.join((CharSequence)",", receiverList));
        dataPush.setCcMoment("2");
        dataPush.setStartDate((Date)ts);
        this.dataPushService.addCcTask(dataPush);
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        this.processEngine.getManagementService().executeCommand((Command)new CcAddHistoryTaskCmd(execution, sysActCcTaskDto.getComment(), new Date(), sysActCcTaskDto.getUserId()));
        return ApiResponse.success();
    }

    public ApiResponse<String> read(Long ccTaskId) {
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectById(ccTaskId);
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readByTaskId(Long taskId, String ccMoment, String userId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysActCcTask::getTaskId, (Object)taskId);
        lambdaQueryWrapper.eq(SysActCcTask::getReceiveUser, (Object)userId);
        lambdaQueryWrapper.eq(SysActCcTask::getCcMoment, (Object)ccMoment);
        SysActCcTask sysActCcTask = (SysActCcTask)this.sysActCcTaskMapper.selectOne((Wrapper)lambdaQueryWrapper);
        if (sysActCcTask == null) {
            return ApiResponse.success();
        }
        sysActCcTask.setTaskState("1");
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        sysActCcTask.setEndTime(endTime);
        this.sysActCcTaskMapper.updateById(sysActCcTask);
        DataPush dataPush = new DataPush();
        dataPush.setUserId(sysActCcTask.getReceiveUser());
        dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
        dataPush.setEndDate((Date)sysActCcTask.getEndTime());
        dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
        this.dataPushService.readCcTask(dataPush);
        return ApiResponse.success();
    }

    public ApiResponse<String> readBatch(List<Long> ccTaskIds) {
        Date date = new Date();
        Timestamp endTime = new Timestamp(date.getTime());
        List sysActCcTasks = this.sysActCcTaskMapper.selectBatchIds(ccTaskIds);
        for (SysActCcTask sysActCcTask : sysActCcTasks) {
            sysActCcTask.setEndTime(endTime);
            sysActCcTask.setTaskState("1");
            DataPush dataPush = new DataPush();
            dataPush.setUserId(sysActCcTask.getReceiveUser());
            dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
            dataPush.setEndDate((Date)sysActCcTask.getEndTime());
            dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
            this.dataPushService.readCcTask(dataPush);
        }
        this.updateBatchById(sysActCcTasks);
        return ApiResponse.success();
    }

    private List<HistoricTaskInstance> getHisTask(String processInsId, String activityId) {
        ArrayList<HistoricTaskInstance> hisTasks = new ArrayList<HistoricTaskInstance>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(activityId)).queryChildTask()).includeTaskLocalVariables()).list();
        if (hisTaskList != null && !hisTaskList.isEmpty()) {
            hisTaskList.sort((o1, o2) -> {
                if (o2.getEndTime() == null) {
                    return 1;
                }
                if (o1.getEndTime() == null) {
                    return -1;
                }
                return o2.getEndTime().compareTo(o1.getEndTime());
            });
            for (int i = 0; i < hisTaskList.size(); ++i) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                if ("CcTaskHistory".equals(historicTaskInstance.getDeleteReason()) || "AssistHistory".equals(historicTaskInstance.getDeleteReason())) continue;
                Date start = historicTaskInstance.getStartTime();
                hisTasks.add(historicTaskInstance);
                for (int j = i + 1; j < hisTaskList.size() && ((historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j)).getEndTime() == null || start.getTime() <= historicTaskInstance.getEndTime().getTime() || "RevokeHistory".equals(historicTaskInstance.getDeleteReason())); ++j) {
                    if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                        start = historicTaskInstance.getCreateTime();
                    }
                    hisTasks.add(historicTaskInstance);
                }
                break;
            }
        }
        return hisTasks;
    }

    public List<SysActCcTask> getCcTaskList(Long processInsId, String taskDefinitionKey, String subProcessKey) {
        return this.sysActCcTaskMapper.getCcTaskList(processInsId, taskDefinitionKey, subProcessKey);
    }
}

