/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;

public class EntrustAssigneeCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getApplicationContext().getBean(BpmMsgPushService.class);
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.addCandidateUser(this.mandatary);
            this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
        } else {
            if (this.isSame) {
                taskEntity.deleteCandidateUser(this.userId);
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, null);
                return null;
            }
            List identityLinks = taskEntity.getCandidates();
            if (HussarUtils.isNotEmpty((Object)this.userId)) {
                taskEntity.deleteCandidateUser(this.userId);
                taskEntity.addCandidateUsers(Arrays.asList(this.mandatary.split(",")));
                this.dataPushService.entrustDataPush((Task)taskEntity, this.userId, this.mandatary);
            } else {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.mandatary.split(",")));
                ArrayList<String> currentUsers = new ArrayList<String>();
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId());
                    currentUsers.add(identityLink.getUserId());
                }
                if (!users.isEmpty()) {
                    taskEntity.addCandidateUsers(users);
                    if (this.isAdd) {
                        this.dataPushService.addUserDataPush(this.dataPush((Task)taskEntity, String.join((CharSequence)",", users)));
                        this.messagePush(taskEntity, users);
                    } else {
                        this.entrustDataPush((Task)taskEntity, String.join((CharSequence)",", currentUsers), String.join((CharSequence)",", users), taskEntity.getCreateTime(), new Date());
                    }
                }
            }
        }
        return null;
    }

    private DataPush dataPush(Task task, String userId) {
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessInsId(task.getProcessInstanceId());
        dataPush.setBusinessKey(((TaskEntity)task).getProcessInstance().getBusinessKey());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee, Date startTime, Date endTime) {
        this.messagePush((TaskEntity)task, new ArrayList<String>(Arrays.asList(userId.split(","))));
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(startTime);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(endTime);
            }
            this.dataPushService.entrustDataPush(dataPush);
        }
    }

    private void messagePush(TaskEntity taskEntity, List<String> users) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        bpmActMsgDetail.setProcessKey(taskEntity.getProcessDefinitionId().split(":")[0]);
        bpmActMsgDetail.setProcessName(taskEntity.getProcessInstance().getProcessDefinition().getName());
        bpmActMsgDetail.setProcessDefinitionId(taskEntity.getProcessDefinitionId());
        bpmActMsgDetail.setTaskDefKey(taskEntity.getTaskDefinitionKey());
        bpmActMsgDetail.setTaskDefName(taskEntity.getName());
        bpmActMsgDetail.setReceive(users);
        bpmActMsgDetail.setChannelType(null);
        bpmActMsgDetail.setSceneCode("todo");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }
}

