/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityElement;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExeListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendActivitiListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendFieldExtension;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequenceXy;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowTodoCondition;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.TimeOutStrategy;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormObjectVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.SubProcessVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ProcessValidatorFactory;
import org.activiti.validation.ValidationError;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@HussarTokenDs
public class Bpm2XMLServiceImpl
implements Bpm2XMLService {
    private static final Logger logger = LoggerFactory.getLogger(Bpm2XMLServiceImpl.class);
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    private Bpm2XMLMapper bpm2XMLMapper;
    private final RepositoryService repositoryService;
    private SysActProcessFileService sysActProcessFileService;
    private SysActProcessFileMapper sysActProcessFileMapper;
    private SysActAssigneeService sysActAssigneeService;
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private static final String COMPLETE_STATE = "finish";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    @Autowired
    public Bpm2XMLServiceImpl(UpdateByteArrayModelMapper updateByteArrayModelMapper, Bpm2XMLMapper bpm2XMLMapper, LcdpBpmProperties lcdpBpmProperties, RepositoryService repositoryService, SysActProcessFileService sysActProcessFileService, SysActProcessFileMapper sysActProcessFileMapper, SysActAssigneeService sysActAssigneeService) {
        this.updateByteArrayModelMapper = updateByteArrayModelMapper;
        this.bpm2XMLMapper = bpm2XMLMapper;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.repositoryService = repositoryService;
        this.sysActProcessFileService = sysActProcessFileService;
        this.sysActProcessFileMapper = sysActProcessFileMapper;
        this.sysActAssigneeService = sysActAssigneeService;
    }

    public Long formDataToXml(String identityKey) throws BpmException, IOException, XMLStreamException {
        FlowModel flowModel = this.readModel(identityKey);
        return this.genXMLByFlowModel(flowModel, identityKey);
    }

    private BpmnModel getXmlByFlowModel(FlowModel flowModel, String identityKey, WorkFlow workFlow, boolean updateVersion) throws BpmException, IOException, XMLStreamException {
        List taskListeners;
        ExtendTaskListener executionListener;
        OriginalTaskListener originalExecutionListener;
        TimeOutStrategy globalTimeOutStrategy;
        if (flowModel == null) {
            return null;
        }
        ProcessDefinition latestProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(identityKey).latestVersion().singleResult();
        int processDefinitionVersion = latestProcessDefinition != null ? (updateVersion ? latestProcessDefinition.getVersion() + 1 : latestProcessDefinition.getVersion()) : 1;
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        String processKeyDefault = "key-" + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String processKey = workFlow.getIdentity();
        String modelName = workFlow.getName();
        process.setDocumentation(flowModel.getProps().getDesc());
        process.setName(HussarUtils.isEmpty((Object)modelName) ? "" : modelName);
        process.setId(HussarUtils.isEmpty((Object)processKey) ? processKeyDefault : processKey);
        FlowTodoCondition flowTodoCondition = flowModel.getProps().getTodoConfiguration();
        if (flowTodoCondition != null) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", flowTodoCondition.getModalValue()));
        } else {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("todoConfiguration", ""));
        }
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("version", String.valueOf(processDefinitionVersion)));
        String width = flowModel.getWidth();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasWidth", width));
        String height = flowModel.getHeight();
        process.addExtensionElement(FormBpmnUtil.addExtensionElement("canvasHeight", height));
        String globalDueDate = flowModel.getProps().getGlobalDueDate();
        if (HussarUtils.isNotEmpty((Object)globalDueDate)) {
            process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalDueDate", globalDueDate));
        }
        if (HussarUtils.isNotEmpty((Object)(globalTimeOutStrategy = flowModel.getProps().getGlobalTimeOutStrategy())) && HussarUtils.isNotEmpty((Object)globalTimeOutStrategy.getTimeoutStrategyType()) && !"unHandle".equals(globalTimeOutStrategy.getTimeoutStrategyType())) {
            String timeoutStrategyType = globalTimeOutStrategy.getTimeoutStrategyType();
            if ("outInterface".equals(timeoutStrategyType)) {
                String path = globalTimeOutStrategy.getOutInterface();
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", path));
            } else if (!"".equals(timeoutStrategyType)) {
                process.addExtensionElement(FormBpmnUtil.addExtensionElement("globalTimeOutStrategy", timeoutStrategyType));
            }
        }
        if (HussarUtils.isNotEmpty((Object)(originalExecutionListener = flowModel.getProps().getOriginalExecutionListener()))) {
            ArrayList<ActivitiListener> taskListeners2 = new ArrayList<ActivitiListener>();
            List extendActivitiListeners = originalExecutionListener.getFlowListener();
            for (ExtendActivitiListener extendActivitiListener : extendActivitiListeners) {
                ActivitiListener activitiListener = new ActivitiListener();
                activitiListener.setEvent(extendActivitiListener.getEvent());
                activitiListener.setImplementationType(extendActivitiListener.getImplementationType());
                activitiListener.setImplementation(extendActivitiListener.getImplementation());
                ArrayList<FieldExtension> fieldExtensionList = new ArrayList<FieldExtension>();
                for (ExtendFieldExtension extendFieldExtension : extendActivitiListener.getFieldExtensions()) {
                    FieldExtension fileExtension = new FieldExtension();
                    fileExtension.setStringValue(extendFieldExtension.getStringValue());
                    fileExtension.setFieldName(extendFieldExtension.getFieldName());
                    fileExtension.setExpression(extendFieldExtension.getExpression());
                    fieldExtensionList.add(fileExtension);
                }
                activitiListener.setFieldExtensions(fieldExtensionList);
                activitiListener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                taskListeners2.add(activitiListener);
            }
            process.setExecutionListeners(taskListeners2);
        }
        if (HussarUtils.isNotEmpty((Object)(executionListener = flowModel.getProps().getExecutionListener())) && HussarUtils.isNotEmpty((Object)(taskListeners = executionListener.getFlowListener()))) {
            for (ExeListener exeListener : taskListeners) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(exeListener.getTrigger());
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(exeListener.getRequestMode());
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(exeListener.getRequestPath());
                extensionElement.addAttribute(urlAttribute);
                process.addExtensionElement(extensionElement);
            }
        }
        this.packageProcess(flowModel, process, processKey, model);
        return this.convertXMLandValidate(model);
    }

    /*
     * WARNING - void declaration
     */
    private Long genXMLByFlowModel(FlowModel flowModel, String identityKey) throws BpmException, IOException, XMLStreamException {
        if (flowModel == null) {
            return null;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, Integer.valueOf(0));
        BpmnModel bpmnModel = this.getXmlByFlowModel(flowModel, identityKey, workFlow, true);
        if (this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            ArrayList<Object> list = new ArrayList<Object>();
            List elements = flowModel.getSlots().getElement();
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            List flowSequences = flowModel.getSlots().getPath() != null ? flowModel.getSlots().getPath() : new ArrayList();
            String startTaskKey = null;
            block0: for (FlowObject flowObject : elements) {
                if (!"com.jxdinfo.workflow.Start".equals(flowObject.getName())) continue;
                String outPath = (String)flowObject.getGoOutPathes().get(0);
                for (FlowSequence flowSequence : flowSequences) {
                    if (!outPath.equals(flowSequence.getInstanceKey())) continue;
                    startTaskKey = flowSequence.getEnd().getKey();
                    break block0;
                }
            }
            block2: for (FlowElement flowElement : flowElements) {
                void var13_21;
                String condAssignee;
                SysActAssignee modelAssignee;
                SysActAssignee startTaskModel;
                if (flowElement instanceof UserTask) {
                    if (flowElement.getId().equals(startTaskKey)) {
                        startTaskModel = new SysActAssignee();
                        startTaskModel.setProcDefKey(identityKey);
                        startTaskModel.setContentType("defaultAssign");
                        startTaskModel.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                        list.add(startTaskModel);
                    }
                    modelAssignee = new SysActAssignee();
                    modelAssignee.setProcDefKey(identityKey);
                    modelAssignee.setContentType("defaultAssign");
                    modelAssignee.setTaskDefKey(flowElement.getId());
                    modelAssignee.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                    String string = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultAssign");
                    modelAssignee.setContent(string == null ? "".getBytes(StandardCharsets.UTF_8) : string.getBytes(StandardCharsets.UTF_8));
                    list.add(modelAssignee);
                    SysActAssignee conditionAssignee2 = new SysActAssignee();
                    conditionAssignee2.setProcDefKey(identityKey);
                    conditionAssignee2.setContentType("conditionAssign");
                    conditionAssignee2.setTaskDefKey(flowElement.getId());
                    conditionAssignee2.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                    String string2 = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionAssign");
                    conditionAssignee2.setContent(string2 == null ? "".getBytes(StandardCharsets.UTF_8) : string2.getBytes(StandardCharsets.UTF_8));
                    list.add(conditionAssignee2);
                    SysActAssignee ccAssignee = new SysActAssignee();
                    ccAssignee.setProcDefKey(identityKey);
                    ccAssignee.setContentType("defaultCcAssign");
                    ccAssignee.setTaskDefKey(flowElement.getId());
                    String ccAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultCcAssign");
                    ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccAssignee);
                    SysActAssignee ccConditionAssignee = new SysActAssignee();
                    ccConditionAssignee.setProcDefKey(identityKey);
                    ccConditionAssignee.setContentType("conditionCcAssign");
                    ccConditionAssignee.setTaskDefKey(flowElement.getId());
                    String ccConditionAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionCcAssign");
                    ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccConditionAssignee);
                    SysActAssignee ccEndAssignee = new SysActAssignee();
                    ccEndAssignee.setProcDefKey(identityKey);
                    ccEndAssignee.setContentType("defaultCcEndAssign");
                    ccEndAssignee.setTaskDefKey(flowElement.getId());
                    String ccEndAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "defaultCcEndAssign");
                    ccEndAssignee.setContent(ccEndAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccEndAssignee);
                    SysActAssignee ccEndConditionAssignee = new SysActAssignee();
                    ccEndConditionAssignee.setProcDefKey(identityKey);
                    ccEndConditionAssignee.setContentType("conditionCcEndAssign");
                    ccEndConditionAssignee.setTaskDefKey(flowElement.getId());
                    String ccEndConditionAssigneeValue = flowElement.getAttributeValue("http://activiti.org/bpmn", "conditionCcEndAssign");
                    ccEndConditionAssignee.setContent(ccEndConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccEndConditionAssignee);
                    for (FlowObject object : elements) {
                        if (!flowElement.getId().equals(object.getId())) continue;
                        SysActAssignee assigneeModel = new SysActAssignee();
                        assigneeModel.setProcDefKey(identityKey);
                        assigneeModel.setContentType("assign_model");
                        assigneeModel.setTaskDefKey(flowElement.getId());
                        assigneeModel.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                        assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                        list.add(assigneeModel);
                        SysActAssignee ccAssigneeModel = new SysActAssignee();
                        ccAssigneeModel.setProcDefKey(identityKey);
                        ccAssigneeModel.setContentType("cc_assign_model");
                        ccAssigneeModel.setTaskDefKey(flowElement.getId());
                        ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                        list.add(ccAssigneeModel);
                        SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                        ccEndAssigneeModel.setProcDefKey(identityKey);
                        ccEndAssigneeModel.setContentType("cc_end_assign_model");
                        ccEndAssigneeModel.setTaskDefKey(flowElement.getId());
                        ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                        list.add(ccEndAssigneeModel);
                        continue block2;
                    }
                    continue;
                }
                if (flowElement instanceof CallActivity) {
                    if (flowElement.getId().equals(startTaskKey)) {
                        startTaskModel = new SysActAssignee();
                        startTaskModel.setProcDefKey(identityKey);
                        startTaskModel.setContentType("defaultAssign");
                        startTaskModel.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                        list.add(startTaskModel);
                    }
                    Map map = flowElement.getExtensionElements();
                    SysActAssignee sysActAssignee = new SysActAssignee();
                    sysActAssignee.setProcDefKey(identityKey);
                    sysActAssignee.setContentType("defaultCallAssignee");
                    sysActAssignee.setTaskDefKey(flowElement.getId());
                    sysActAssignee.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                    String assignee2 = null;
                    if (map.get("defaultCallAssignee") != null) {
                        assignee2 = ((ExtensionElement)((List)flowElement.getExtensionElements().get("defaultCallAssignee")).get(0)).getAttributeValue(null, "defaultCallAssignee");
                    }
                    sysActAssignee.setContent(assignee2 == null ? "".getBytes(StandardCharsets.UTF_8) : assignee2.getBytes(StandardCharsets.UTF_8));
                    list.add(sysActAssignee);
                    SysActAssignee sysActAssignee2 = new SysActAssignee();
                    sysActAssignee2.setProcDefKey(identityKey);
                    sysActAssignee2.setContentType("conditionCallAssign");
                    sysActAssignee2.setTaskDefKey(flowElement.getId());
                    sysActAssignee2.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                    condAssignee = null;
                    if (map.get("conditionCallAssign") != null) {
                        condAssignee = ((ExtensionElement)((List)flowElement.getExtensionElements().get("conditionCallAssign")).get(0)).getAttributeValue(null, "conditionCallAssign");
                    }
                    sysActAssignee2.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                    list.add(sysActAssignee2);
                    SysActAssignee ccAssignee = new SysActAssignee();
                    ccAssignee.setProcDefKey(identityKey);
                    ccAssignee.setContentType("defaultCallProcessKey");
                    ccAssignee.setTaskDefKey(flowElement.getId());
                    String processKey = null;
                    if (map.get("defaultCallProcessKey") != null) {
                        processKey = ((ExtensionElement)((List)flowElement.getExtensionElements().get("defaultCallProcessKey")).get(0)).getAttributeValue(null, "defaultCallProcessKey");
                    }
                    ccAssignee.setContent(processKey == null ? "".getBytes(StandardCharsets.UTF_8) : processKey.getBytes(StandardCharsets.UTF_8));
                    list.add(ccAssignee);
                    SysActAssignee ccConditionAssignee = new SysActAssignee();
                    ccConditionAssignee.setProcDefKey(identityKey);
                    ccConditionAssignee.setContentType("conditionCallProcessKey");
                    ccConditionAssignee.setTaskDefKey(flowElement.getId());
                    String ccConditionAssigneeValue = null;
                    if (map.get("conditionCallProcessKey") != null) {
                        ccConditionAssigneeValue = ((ExtensionElement)((List)flowElement.getExtensionElements().get("conditionCallProcessKey")).get(0)).getAttributeValue(null, "conditionCallProcessKey");
                    }
                    ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccConditionAssignee);
                    for (FlowObject object : elements) {
                        if (!flowElement.getId().equals(object.getId())) continue;
                        SysActAssignee assigneeModel = new SysActAssignee();
                        assigneeModel.setProcDefKey(identityKey);
                        assigneeModel.setContentType("assign_model");
                        assigneeModel.setTaskDefKey(flowElement.getId());
                        assigneeModel.setMessageType(flowElement.getAttributeValue("http://activiti.org/bpmn", "messageType"));
                        assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowSelector()).getBytes(StandardCharsets.UTF_8));
                        list.add(assigneeModel);
                        continue block2;
                    }
                    continue;
                }
                if (!(flowElement instanceof SubProcess)) continue;
                block5: for (FlowElement flowElement2 : ((SubProcess)flowElement).getFlowElements()) {
                    if (!(flowElement2 instanceof UserTask)) continue;
                    SysActAssignee modelAssignee3 = new SysActAssignee();
                    modelAssignee3.setProcDefKey(identityKey);
                    modelAssignee3.setContentType("defaultAssign");
                    modelAssignee3.setTaskDefKey(flowElement2.getId());
                    String string = flowElement2.getAttributeValue("http://activiti.org/bpmn", "defaultAssign");
                    modelAssignee3.setContent(string == null ? "".getBytes(StandardCharsets.UTF_8) : string.getBytes(StandardCharsets.UTF_8));
                    list.add(modelAssignee3);
                    SysActAssignee conditionAssignee3 = new SysActAssignee();
                    conditionAssignee3.setProcDefKey(identityKey);
                    conditionAssignee3.setContentType("conditionAssign");
                    conditionAssignee3.setTaskDefKey(flowElement2.getId());
                    String condAssignee3 = flowElement2.getAttributeValue("http://activiti.org/bpmn", "conditionAssign");
                    conditionAssignee3.setContent(condAssignee3 == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee3.getBytes(StandardCharsets.UTF_8));
                    list.add(conditionAssignee3);
                    SysActAssignee ccAssignee = new SysActAssignee();
                    ccAssignee.setProcDefKey(identityKey);
                    ccAssignee.setContentType("defaultCcAssign");
                    ccAssignee.setTaskDefKey(flowElement2.getId());
                    String ccAssigneeValue = flowElement2.getAttributeValue("http://activiti.org/bpmn", "defaultCcAssign");
                    ccAssignee.setContent(ccAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccAssignee);
                    SysActAssignee ccConditionAssignee = new SysActAssignee();
                    ccConditionAssignee.setProcDefKey(identityKey);
                    ccConditionAssignee.setContentType("conditionCcAssign");
                    ccConditionAssignee.setTaskDefKey(flowElement2.getId());
                    String ccConditionAssigneeValue = flowElement2.getAttributeValue("http://activiti.org/bpmn", "conditionCcAssign");
                    ccConditionAssignee.setContent(ccConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccConditionAssignee);
                    SysActAssignee ccEndAssignee = new SysActAssignee();
                    ccEndAssignee.setProcDefKey(identityKey);
                    ccEndAssignee.setContentType("defaultCcEndAssign");
                    ccEndAssignee.setTaskDefKey(flowElement2.getId());
                    String ccEndAssigneeValue = flowElement2.getAttributeValue("http://activiti.org/bpmn", "defaultCcEndAssign");
                    ccEndAssignee.setContent(ccEndAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccEndAssignee);
                    SysActAssignee ccEndConditionAssignee = new SysActAssignee();
                    ccEndConditionAssignee.setProcDefKey(identityKey);
                    ccEndConditionAssignee.setContentType("conditionCcEndAssign");
                    ccEndConditionAssignee.setTaskDefKey(flowElement2.getId());
                    String ccEndConditionAssigneeValue = flowElement2.getAttributeValue("http://activiti.org/bpmn", "conditionCcEndAssign");
                    ccEndConditionAssignee.setContent(ccEndConditionAssigneeValue == null ? "".getBytes(StandardCharsets.UTF_8) : ccEndConditionAssigneeValue.getBytes(StandardCharsets.UTF_8));
                    list.add(ccEndConditionAssignee);
                    for (FlowObject object : elements) {
                        if (!flowElement2.getId().equals(object.getId())) continue;
                        SysActAssignee assigneeModel = new SysActAssignee();
                        assigneeModel.setProcDefKey(identityKey);
                        assigneeModel.setContentType("assign_model");
                        assigneeModel.setTaskDefKey(flowElement2.getId());
                        assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                        list.add(assigneeModel);
                        SysActAssignee ccAssigneeModel = new SysActAssignee();
                        ccAssigneeModel.setProcDefKey(identityKey);
                        ccAssigneeModel.setContentType("cc_assign_model");
                        ccAssigneeModel.setTaskDefKey(flowElement2.getId());
                        ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                        list.add(ccAssigneeModel);
                        SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                        ccEndAssigneeModel.setProcDefKey(identityKey);
                        ccEndAssigneeModel.setContentType("cc_end_assign_model");
                        ccEndAssigneeModel.setTaskDefKey(flowElement2.getId());
                        ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                        list.add(ccEndAssigneeModel);
                        continue block5;
                    }
                }
                modelAssignee = new SysActAssignee();
                modelAssignee.setProcDefKey(identityKey);
                modelAssignee.setContentType("defaultAssign");
                modelAssignee.setTaskDefKey(flowElement.getId());
                Object var13_19 = null;
                List defaultAssignee = (List)flowElement.getExtensionElements().get("defaultAssign");
                if (defaultAssignee != null) {
                    String string = ((ExtensionElement)defaultAssignee.get(0)).getAttributeValue(null, "defaultAssign");
                }
                modelAssignee.setContent(var13_21 == null ? "".getBytes(StandardCharsets.UTF_8) : var13_21.getBytes(StandardCharsets.UTF_8));
                list.add(modelAssignee);
                SysActAssignee sysActAssignee = new SysActAssignee();
                sysActAssignee.setProcDefKey(identityKey);
                sysActAssignee.setContentType("conditionAssign");
                sysActAssignee.setTaskDefKey(flowElement.getId());
                condAssignee = null;
                List conditionAssigneeElement = (List)flowElement.getExtensionElements().get("conditionAssign");
                if (conditionAssigneeElement != null) {
                    condAssignee = ((ExtensionElement)conditionAssigneeElement.get(0)).getAttributeValue(null, "conditionAssign");
                }
                sysActAssignee.setContent(condAssignee == null ? "".getBytes(StandardCharsets.UTF_8) : condAssignee.getBytes(StandardCharsets.UTF_8));
                list.add(sysActAssignee);
                for (FlowObject object : elements) {
                    if (!flowElement.getId().equals(object.getId())) continue;
                    SysActAssignee assigneeModel = new SysActAssignee();
                    assigneeModel.setProcDefKey(identityKey);
                    assigneeModel.setContentType("assign_model");
                    assigneeModel.setTaskDefKey(flowElement.getId());
                    assigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowAssignment()).getBytes(StandardCharsets.UTF_8));
                    list.add(assigneeModel);
                    SysActAssignee ccAssigneeModel = new SysActAssignee();
                    ccAssigneeModel.setProcDefKey(identityKey);
                    ccAssigneeModel.setContentType("cc_assign_model");
                    ccAssigneeModel.setTaskDefKey(flowElement.getId());
                    ccAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowRecipients()).getBytes(StandardCharsets.UTF_8));
                    list.add(ccAssigneeModel);
                    SysActAssignee ccEndAssigneeModel = new SysActAssignee();
                    ccEndAssigneeModel.setProcDefKey(identityKey);
                    ccEndAssigneeModel.setContentType("cc_end_assign_model");
                    ccEndAssigneeModel.setTaskDefKey(flowElement.getId());
                    ccEndAssigneeModel.setContent(JSON.toJSONString((Object)object.getProps().getFlowEndRecipients()).getBytes(StandardCharsets.UTF_8));
                    list.add(ccEndAssigneeModel);
                    continue block2;
                }
            }
            ArrayList<SysActAssignee> addList = new ArrayList<SysActAssignee>();
            QueryChainWrapper queryWrapper = this.sysActAssigneeService.query();
            for (SysActAssignee sysActAssignee : list) {
                String procDefKey = sysActAssignee.getProcDefKey();
                String string = sysActAssignee.getTaskDefKey();
                String contentType = sysActAssignee.getContentType();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                if (HussarUtils.isEmpty((Object)string)) {
                    queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).isNull((Object)"TASK_DEF_KEY")).eq((Object)"CONTENT_TYPE", (Object)contentType);
                    continue;
                }
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_KEY", (Object)procDefKey)).eq((Object)"TASK_DEF_KEY", (Object)string)).eq((Object)"CONTENT_TYPE", (Object)contentType);
            }
            List sameList = queryWrapper.list();
            ArrayList<SysActAssignee> arrayList = new ArrayList<SysActAssignee>();
            for (SysActAssignee sysActAssignee : list) {
                boolean isadd = true;
                for (SysActAssignee actAssignee : sameList) {
                    if (HussarUtils.isEmpty((Object)sysActAssignee.getTaskDefKey())) {
                        if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !HussarUtils.isEmpty((Object)actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                        sysActAssignee.setId(actAssignee.getId());
                        arrayList.add(sysActAssignee);
                        isadd = false;
                        break;
                    }
                    if (!sysActAssignee.getProcDefKey().equals(actAssignee.getProcDefKey()) || !sysActAssignee.getTaskDefKey().equals(actAssignee.getTaskDefKey()) || !sysActAssignee.getContentType().equals(actAssignee.getContentType())) continue;
                    sysActAssignee.setId(actAssignee.getId());
                    arrayList.add(sysActAssignee);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActAssignee);
            }
            this.sysActAssigneeService.updateBatchById(arrayList);
            this.sysActAssigneeService.saveBatch(addList);
        }
        return this.completeAndDeployModel(bpmnModel, workFlow.getName(), flowModel.getModelId(), flowModel.getProps().getDesc(), identityKey);
    }

    private void packageProcess(FlowModel flowModel, Process process, String processKeyPath, BpmnModel model) throws BpmException {
        FormBpmnUtil.createSequence(flowModel.getSlots().getPath(), flowModel.getSlots().getElement(), processKeyPath, (FlowElementsContainer)process, model);
        for (FlowObject element : flowModel.getSlots().getElement()) {
            element.setProcessKeyPath(processKeyPath);
            FormObjectVisitor formObjectVisitor = FormObjectVisitorBeanUtil.getVisitorBean(element.getName());
            if (formObjectVisitor instanceof SubProcessVisitor) {
                ((SubProcessVisitor)formObjectVisitor).setModel(model);
                formObjectVisitor.visit(element, (FlowElementsContainer)process, flowModel, (FlowObject)flowModel);
            } else {
                formObjectVisitor.visit(element, (FlowElementsContainer)process, flowModel, (FlowObject)flowModel);
            }
            GraphicInfo graphicInfo = FormBpmnUtil.createGraphicInfo(element);
            model.addGraphicInfo(element.getId(), graphicInfo);
        }
        model.addProcess(process);
    }

    private FlowModel readModel(String identityKey) throws BpmException {
        if (HussarUtils.isEmpty((Object)identityKey)) {
            throw new BpmException("\u6587\u4ef6\u4e0d\u5b58\u5728", "FILE ID: " + identityKey);
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, Integer.valueOf(0));
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            if (HussarUtils.isNotEmpty((Object)workFlow)) {
                flowModel.setModelId(workFlow.getModelId());
            }
            return flowModel;
        }
        return null;
    }

    public boolean updateModel(String identityKey, boolean updateVersion) {
        if (HussarUtils.isEmpty((Object)identityKey)) {
            return false;
        }
        WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(identityKey, Integer.valueOf(0));
        try {
            String procDefId = this.bpm2XMLMapper.getActDefIdByModelId(workFlow.getModelId());
            BpmnModel bpmnModel = this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow, updateVersion);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            if (HussarUtils.isNotEmpty((Object)workFlow)) {
                UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                updateByteArrayModel.setBytes(bpmnBytes);
                updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(workFlow.getModelId()));
                this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                SysActProcessFile sysActProcessFile = new SysActProcessFile();
                sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
                queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
                this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
                sysActProcessFile = new SysActProcessFile();
                workFlow.setData(null);
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
                queryWrapper.eq(SysActProcessFile::getType, (Object)"meta");
                this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
                this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
                return true;
            }
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean updateModel(WorkFlow workFlow, BpmnModel bpmnModel, String procDefId) {
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(bpmnBytes);
            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelByProcDefId(procDefId));
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            SysActProcessFile sysActProcessFile = new SysActProcessFile();
            sysActProcessFile.setContent(workFlow.getData().getBytes(StandardCharsets.UTF_8));
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            this.sysActProcessFileMapper.update(sysActProcessFile, (Wrapper<SysActProcessFile>)queryWrapper);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(procDefId));
            return true;
        }
        return false;
    }

    public BpmnModel getBpmnModel(WorkFlow workFlow, String identityKey) {
        try {
            return this.getXmlByFlowModel((FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class), identityKey, workFlow, true);
        }
        catch (BpmException | IOException | XMLStreamException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    private BpmnModel convertXMLandValidate(BpmnModel model) throws XMLStreamException, BpmException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        byte[] bytes = converter.convertToXML(model, "utf-8");
        XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
        InputStreamReader in = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
        XMLStreamReader xtr = xif.createXMLStreamReader(in);
        BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        ProcessValidatorFactory processValidatorFactory = new ProcessValidatorFactory();
        ProcessValidator defaultProcessValidator = processValidatorFactory.createDefaultProcessValidator();
        List validate = defaultProcessValidator.validate(bpmnModel);
        if (!CollectionUtils.isEmpty((Collection)validate)) {
            StringBuilder errorMsg = new StringBuilder();
            for (int i = 0; i < validate.size(); ++i) {
                errorMsg.append(((ValidationError)validate.get(i)).getDefaultDescription()).append(',').append(((ValidationError)validate.get(i)).getActivityId());
                if (i == validate.size() - 1) continue;
                errorMsg.append(';');
            }
            throw new BpmException("\u5de5\u4f5c\u6d41xml\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25", errorMsg.toString());
        }
        return bpmnModel;
    }

    private Model newModel(ObjectNode modelObjectNode, String modelName, String key) {
        Model modelData = this.repositoryService.newModel();
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setKey(StringUtils.defaultString((String)key));
        modelData.setName(modelName);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Model updateModel(ObjectNode modelObjectNode, String modelName, Long modelId) {
        Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
        modelObjectNode.put("revision", modelData.getVersion());
        modelData.setMetaInfo(modelObjectNode.toString());
        modelData.setName(modelName);
        this.repositoryService.saveModel(modelData);
        return modelData;
    }

    private Long deployModel(BpmnModel bpmnModel, Model modelData, Long modelId) {
        ExtendBpmnJsonConverter child = new ExtendBpmnJsonConverter();
        child.updateConvertersToBpmnMap();
        child.updateConvertersToJsonMap();
        ObjectNode editorNode = child.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelData.getId(), editorNode.toString().getBytes(StandardCharsets.UTF_8));
        return modelId;
    }

    private Long completeAndDeployModel(BpmnModel bpmnModel, String modelName, Long modelId, String flowDesc, String identityKey) {
        Model modelData;
        Long newModelId = modelId;
        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
        modelObjectNode.put("name", modelName);
        modelObjectNode.put("description", flowDesc);
        if (HussarUtils.isEmpty((Object)newModelId) || HussarUtils.isEmpty((Object)this.repositoryService.getModel(String.valueOf(newModelId)))) {
            modelData = this.newModel(modelObjectNode, modelName, identityKey);
            newModelId = Long.parseLong(modelData.getId());
        } else {
            modelData = this.updateModel(modelObjectNode, modelName, newModelId);
        }
        return this.deployModel(bpmnModel, modelData, newModelId);
    }

    public String getActDefIdByModelId(Long modelId) {
        return this.bpm2XMLMapper.getActDefIdByModelId(modelId);
    }

    public JSONObject getProcessInfoByFile(String processKey, String processId, boolean isGetMainOrNew) {
        WorkFlow workFlow;
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (isGetMainOrNew && HussarUtils.equals((Object)processId, (Object)processKey)) {
            try {
                processId = this.processDefinitionsService.getStartProcessDefinitionId(processKey);
            }
            catch (PublicClientException e) {
                return new JSONObject();
            }
        }
        if (HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKeyAndProcessId(processKey, processId)))) {
            JSONObject object;
            String xml = workFlow.getData();
            FlowModel flowModel = (FlowModel)JSON.parseObject((String)xml, FlowModel.class);
            List flowSequences = flowModel.getSlots().getPath();
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                String realName;
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
                object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
                object.put(WIDTH, (Object)Double.parseDouble(flowObject.getWidth()));
                object.put(HEIGHT, (Object)Double.parseDouble(flowObject.getHeight()));
                String[] name = flowObject.getName().split("\\.");
                String subName = name[name.length - 1];
                if (HussarUtils.equals((Object)"Start", (Object)subName)) {
                    realName = "startEvent";
                } else if (HussarUtils.equals((Object)"Exclusive", (Object)subName)) {
                    realName = "exclusiveGateway";
                } else if (HussarUtils.equals((Object)"Parallel", (Object)subName)) {
                    realName = "parallelGateway";
                } else if (HussarUtils.equals((Object)"Inclusive", (Object)subName)) {
                    realName = "inclusiveGateway";
                } else if (HussarUtils.equals((Object)"End", (Object)subName)) {
                    realName = "endEvent";
                } else if (HussarUtils.equals((Object)"ReceiveTask", (Object)subName)) {
                    realName = "receiveTask";
                } else if (HussarUtils.equals((Object)"CallActivity", (Object)subName)) {
                    realName = "callActivity";
                    List callActivityElements = flowObject.getProps().getFlowSelectorArr();
                    JSONArray json = new JSONArray();
                    if (HussarUtils.isNotEmpty((Object)callActivityElements)) {
                        for (CallActivityElement callActivityElement : callActivityElements) {
                            JSONObject jo = new JSONObject();
                            jo.put("superProcessKey", (Object)callActivityElement.getProcessDefinitionKey());
                            jo.put("superProcessName", (Object)callActivityElement.getName());
                            json.add((Object)jo);
                        }
                    }
                    object.put("callActivityElement", (Object)json);
                } else if (HussarUtils.equals((Object)"SubProcess", (Object)subName)) {
                    realName = "subProcess";
                    object.put("subProcessElements", (Object)this.getSubProcessMsg(flowObject));
                } else {
                    realName = HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign()) && flowObject.getProps().getFlowCountersign().isCountersign() ? "multiUserTask" : "userTask";
                }
                object.put("type", (Object)realName);
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            for (FlowObject flowObject : flowSequences) {
                object = new JSONObject();
                object.put("id", (Object)flowObject.getNodeId());
                object.put("name", (Object)flowObject.getProps().getFlowName());
                object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
                object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
                if (((FlowSequence)flowObject).getLineConfig().getWidth() != null) {
                    object.put(WIDTH, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getWidth()));
                } else {
                    object.put(WIDTH, null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getHeight() != null) {
                    object.put(HEIGHT, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getHeight()));
                } else {
                    object.put(HEIGHT, null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getX() != null) {
                    object.put("x", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getX()));
                } else {
                    object.put("x", null);
                }
                if (((FlowSequence)flowObject).getLineConfig().getY() != null) {
                    object.put("y", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getY()));
                } else {
                    object.put("y", null);
                }
                List xyList = flowObject.getPoints();
                Double[] xPoints = new Double[xyList.size()];
                Double[] yPoints = new Double[xyList.size()];
                for (int i = 0; i < xyList.size(); ++i) {
                    xPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getX());
                    yPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getY());
                }
                object.put("xPoints", (Object)xPoints);
                object.put("yPoints", (Object)yPoints);
                List lineNameList = ((FlowSequence)flowObject).getLineConfig().getLineName();
                if (lineNameList != null) {
                    String[] strs = new String[lineNameList.size()];
                    for (int i = 0; i < lineNameList.size(); ++i) {
                        strs[i] = (String)lineNameList.get(i);
                    }
                    object.put("lineName", (Object)strs);
                } else {
                    object.put("lineName", null);
                }
                object.put("type", (Object)"sequenceFlow");
                object.put("state", (Object)COMPLETE_STATE);
                jsonArray.add((Object)object);
            }
            jsonObject.put("data", (Object)jsonArray);
            jsonObject.put(WIDTH, (Object)flowModel.getWidth());
            jsonObject.put(HEIGHT, (Object)flowModel.getHeight());
            return jsonObject;
        }
        return jsonObject;
    }

    private JSONArray getSubProcessMsg(FlowObject subProcess) {
        JSONObject object;
        JSONArray jsonArray = new JSONArray();
        for (FlowObject flowObject : subProcess.getSlots().getElement()) {
            String realName;
            object = new JSONObject();
            object.put("id", (Object)flowObject.getNodeId());
            object.put("name", (Object)flowObject.getProps().getFlowName());
            object.put("x", (Object)Double.parseDouble(flowObject.getLeft()));
            object.put("y", (Object)Double.parseDouble(flowObject.getTop()));
            object.put(WIDTH, (Object)Double.parseDouble(flowObject.getWidth()));
            object.put(HEIGHT, (Object)Double.parseDouble(flowObject.getHeight()));
            String[] name = flowObject.getName().split("\\.");
            String subName = name[name.length - 1];
            if (HussarUtils.equals((Object)"Start", (Object)subName)) {
                realName = "startEvent";
            } else if (HussarUtils.equals((Object)"Exclusive", (Object)subName)) {
                realName = "exclusiveGateway";
            } else if (HussarUtils.equals((Object)"Parallel", (Object)subName)) {
                realName = "parallelGateway";
            } else if (HussarUtils.equals((Object)"Inclusive", (Object)subName)) {
                realName = "inclusiveGateway";
            } else if (HussarUtils.equals((Object)"End", (Object)subName)) {
                realName = "endEvent";
            } else if (HussarUtils.equals((Object)"ReceiveTask", (Object)subName)) {
                realName = "receiveTask";
            } else if (HussarUtils.equals((Object)"CallActivity", (Object)subName)) {
                realName = "callActivity";
                List callActivityElements = flowObject.getProps().getFlowSelectorArr();
                JSONArray json = new JSONArray();
                if (HussarUtils.isNotEmpty((Object)callActivityElements)) {
                    for (CallActivityElement callActivityElement : callActivityElements) {
                        JSONObject jo = new JSONObject();
                        jo.put("superProcessKey", (Object)callActivityElement.getProcessDefinitionKey());
                        jo.put("superProcessName", (Object)callActivityElement.getName());
                        json.add((Object)jo);
                    }
                }
                object.put("callActivityElement", (Object)json);
            } else {
                realName = HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign()) && flowObject.getProps().getFlowCountersign().isCountersign() ? "multiUserTask" : "userTask";
            }
            object.put("type", (Object)realName);
            object.put("state", (Object)COMPLETE_STATE);
            jsonArray.add((Object)object);
        }
        for (FlowObject flowObject : subProcess.getSlots().getPath()) {
            object = new JSONObject();
            object.put("id", (Object)flowObject.getNodeId());
            object.put("name", (Object)flowObject.getProps().getFlowName());
            object.put("rotate", (Object)((FlowSequence)flowObject).getLineConfig().getRotate());
            object.put("dx", (Object)((FlowSequence)flowObject).getLineConfig().getDx());
            if (((FlowSequence)flowObject).getLineConfig().getWidth() != null) {
                object.put(WIDTH, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getWidth()));
            } else {
                object.put(WIDTH, null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getHeight() != null) {
                object.put(HEIGHT, (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getHeight()));
            } else {
                object.put(HEIGHT, null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getX() != null) {
                object.put("x", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getX()));
            } else {
                object.put("x", null);
            }
            if (((FlowSequence)flowObject).getLineConfig().getY() != null) {
                object.put("y", (Object)Double.parseDouble(((FlowSequence)flowObject).getLineConfig().getY()));
            } else {
                object.put("y", null);
            }
            List xyList = flowObject.getPoints();
            Double[] xPoints = new Double[xyList.size()];
            Double[] yPoints = new Double[xyList.size()];
            for (int i = 0; i < xyList.size(); ++i) {
                xPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getX());
                yPoints[i] = Double.parseDouble(((FlowSequenceXy)xyList.get(i)).getY());
            }
            object.put("xPoints", (Object)xPoints);
            object.put("yPoints", (Object)yPoints);
            List lineNameList = ((FlowSequence)flowObject).getLineConfig().getLineName();
            if (lineNameList != null) {
                String[] strs = new String[lineNameList.size()];
                for (int i = 0; i < lineNameList.size(); ++i) {
                    strs[i] = (String)lineNameList.get(i);
                }
                object.put("lineName", (Object)strs);
            } else {
                object.put("lineName", null);
            }
            object.put("type", (Object)"sequenceFlow");
            object.put("state", (Object)COMPLETE_STATE);
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }
}

