/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private BpmMsgPushService msgPushService;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (!entity.getTasks().isEmpty()) {
            for (TaskEntity taskEntity : entity.getTasks()) {
                this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
            }
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            if ("endProcess".equals(Context.getCommandContext().getAttribute("taskSourceFlag"))) {
                this.endProcessMsgPush(map);
            } else {
                this.completeProcessMsgPush(map);
            }
        }
        new ProcessActionCmd(entity.getId(), 1).execute(Context.getCommandContext());
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(entity.getId());
            dataPush.setBusinessKey(entity.getBusinessKey());
            dataPush.setProcessKey(entity.getProcessDefinitionKey());
            dataPush.setProcessEndTime(new Date());
            Long userId = BaseSecurityUtil.getUser().getId();
            dataPush.setUserId(String.valueOf(userId));
            dataPush.setDescription("endProcess");
            this.dataPushService.changeProcessStateDataPush(dataPush);
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void endProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("terminated");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void completeProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("complete");
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void addMessage(Map<String, Object> map, BpmActMsgDetail bpmActMsgDetail) {
        bpmActMsgDetail.setProcessName(map.get("processDefinitionName").toString());
        bpmActMsgDetail.setProcessDefinitionId(map.get("processDefinitionId").toString());
        bpmActMsgDetail.setProcessKey(map.get("processDefinitionId").toString().split(":")[0]);
        ArrayList<String> user = new ArrayList<String>();
        user.add(map.get("starter").toString());
        bpmActMsgDetail.setReceive(user);
    }
}

