/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.task.Task;

public class TaskCompleteCmd
implements Command<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getBean(ISysActCcTaskService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private Boolean notNeedCheckAssignee;
    private Boolean isNotAdd;

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskEntity execute(CommandContext commandContext) {
        commandContext.addAttribute("notNeedCheckAssignee", (Object)this.notNeedCheckAssignee);
        commandContext.addAttribute("isNotAdd", (Object)this.isNotAdd);
        if (this.variables.containsKey("bpm_next_node")) {
            commandContext.addAttribute("bpm_next_node", this.variables.get("bpm_next_node"));
            this.variables.remove("bpm_next_node");
        }
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        this.variables.put("sendUser", HussarUtils.isEmpty((Object)this.mandator) ? this.userId : this.mandator);
        this.variables.put("bpm_submit_source", task.getTaskDefinitionKey());
        task.setVariableLocalWithOutQuery("taskSourceFlag", (Object)"complete", true);
        task.getExecution().setVariableLocal("all_prev_node", (Object)("'" + task.getTaskDefinitionKey() + "'"));
        Map<String, Object> appointAssignee = new HashMap();
        if (this.variables.get("appoint_assignee") != null) {
            appointAssignee = (Map)this.variables.get("appoint_assignee");
        }
        if (HussarUtils.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            this.variables.put("appoint_assignee", appointAssignee);
        }
        this.variables.put("reject_appoint_assignee", null);
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List childTasks = taskEntityManager.findTasksByParentTaskId(this.taskId);
        String processKey = null;
        ExecutionEntity execution = task.getExecution();
        if (!childTasks.isEmpty()) {
            ArrayList childTaskIds = new ArrayList();
            childTasks.forEach(childTask -> {
                execution.removeTask((TaskEntity)childTask);
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            processKey = ((Task)childTasks.get(0)).getProcessDefinitionId().split(",")[0];
            if (this.dataPushService.isDataPush()) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setTaskIds(childTaskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ccQueryWrapper.eq(SysActCcTask::getTaskDefKey, (Object)task.getTaskDefinitionKey())).eq(SysActCcTask::getProcessInsId, (Object)Long.parseLong(task.getProcessInstanceId()))).in(SysActCcTask::getReceiveUser, new Object[]{this.userId})).eq(SysActCcTask::getTaskState, (Object)"0");
        List ccTaskList = this.iSysActCcTaskService.list((Wrapper)ccQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)ccTaskList)) {
            ArrayList<Long> ccTaskIds = new ArrayList<Long>();
            for (SysActCcTask sysActCcTask : ccTaskList) {
                ccTaskIds.add(sysActCcTask.getId());
            }
            this.iSysActCcTaskService.readBatch(ccTaskIds);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.setCompleteType("complete");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.setLastCompleteType("complete");
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }
}

