/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.Task;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class AnalyticalModelUtil {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ISysActEntrustService sysActEntrustService = (ISysActEntrustService)SpringContextHolder.getBean(ISysActEntrustService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    private static HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
    private static SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)SpringContextHolder.getBean(SysActAssigneeService.class);
    private static final String STARTER = "starter";
    private static final String SEND_USER = "sendUser";
    private static final Pattern REGEX = Pattern.compile("\\$\\{([^}])*\\}");

    public static List<Map<String, String>> getEntrustCandidateUser(BpmnModel bm, String taskDefinitionKey, ActivityExecution execution, boolean flag, Set<String> set, List<String> messageType) {
        List<String> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, messageType);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement;
            break;
        }
        List sequenceFlowList = startEvent.getOutgoingFlows();
        String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
        FlowElement flowElement = bm.getFlowElement(targetRef);
        ArrayList<String> firstTaskDefinitionKey = new ArrayList<String>();
        if (flowElement instanceof UserTask) {
            firstTaskDefinitionKey.add(flowElement.getId());
        }
        ParallelGateway parallelGateway = new ParallelGateway();
        if (flowElement instanceof ParallelGateway) {
            parallelGateway = (ParallelGateway)flowElement;
            List outgoingFlows = parallelGateway.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : outgoingFlows) {
                String targetNode = sequenceFlow.getTargetRef();
                firstTaskDefinitionKey.add(targetNode);
            }
        }
        if (HussarUtils.isEmpty(users) && execution.getProcessInstance().getSuperExecutionId() == null && firstTaskDefinitionKey.contains(taskDefinitionKey)) {
            String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstance().getId()).getStartUserId();
            users.add(startUserId);
        }
        if (HussarUtils.isEmpty(users)) {
            return new ArrayList<Map<String, String>>();
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        Map userMap = sysActEntrustService.queryByUsers(users, processKey, taskDefinitionKey, 0);
        ArrayList<Map<String, String>> assigneeMapList = new ArrayList<Map<String, String>>();
        for (String userIds : users) {
            List<String> userIdList = Arrays.asList(userIds.split(","));
            ArrayList<Object> userSet = new ArrayList<Object>();
            HashMap assigneeMap = new HashMap();
            for (String userId : userIdList) {
                if (userMap.containsKey(userId)) {
                    assigneeMap.put(userId, userMap.get(userId));
                    userSet.add(userMap.get(userId));
                    continue;
                }
                assigneeMap.put(userId, null);
                userSet.add(userId);
            }
            if (set != null) {
                set.addAll(userSet);
            }
            assigneeMapList.add(assigneeMap);
        }
        return assigneeMapList;
    }

    public static List<String> getConfigUser(BpmnModel bm, ActivityExecution execution, boolean flag, List<String> messageType) {
        JSONObject inExpressions;
        String defaultAssign;
        boolean flowStarter;
        Map map;
        Object appointAssignees;
        String activityId = execution.getActivity().getId();
        List<Object> users = new ArrayList();
        List<Object> userList = new ArrayList();
        Map extensionElementsNode = bm.getFlowElement(activityId).getExtensionElements();
        String allowSetParticipantRepetition = "";
        if (extensionElementsNode.get("allowSetParticipant") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant");
            String string = allowSetParticipantRepetition = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "true";
        }
        if (!"false".equals(allowSetParticipantRepetition)) {
            Object rejectAssignees = execution.getVariableLocal("reject_appoint_assignee") == null ? "" : execution.getVariableLocal("reject_appoint_assignee");
            boolean isLocal = true;
            if (HussarUtils.isEmpty((Object)rejectAssignees) && execution.getVariable("reject_appoint_assignee") != null) {
                isLocal = false;
                rejectAssignees = execution.getVariable("reject_appoint_assignee");
            }
            if (HussarUtils.isNotEmpty((Object)rejectAssignees)) {
                if (isLocal) {
                    execution.removeVariableLocal("reject_appoint_assignee");
                } else {
                    execution.removeVariable("reject_appoint_assignee");
                }
                if (rejectAssignees instanceof List) {
                    for (Object o : (List)rejectAssignees) {
                        if (!HussarUtils.isNotEmpty(o) || users.contains(o.toString())) continue;
                        users.add(String.valueOf(o));
                    }
                } else {
                    List<String> userIdList = Arrays.asList(String.valueOf(rejectAssignees).split(","));
                    users = userIdList.stream().distinct().collect(Collectors.toList());
                }
                return users;
            }
            Map map2 = execution.getVariableLocal("appoint_assignee") == null ? new HashMap() : (Map)execution.getVariableLocal("appoint_assignee");
            isLocal = true;
            if (HussarUtils.isEmpty(map2) && execution.getVariable("appoint_assignee") != null) {
                isLocal = false;
                map2 = (Map)execution.getVariable("appoint_assignee");
            }
            Object assignee = map2.get(activityId);
            List<Object> appointAssignees2 = new ArrayList();
            if (HussarUtils.isNotEmpty(assignee) && HussarUtils.isNotEmpty(appointAssignees2 = assignee instanceof List ? (List)assignee : new ArrayList<String>(Arrays.asList(((String)assignee).split(","))))) {
                List<String> appointAssignee = AnalyticalModelUtil.getAppointAssignee(execution, appointAssignees2, isLocal);
                if (HussarUtils.isNotEmpty(appointAssignee)) {
                    return appointAssignee;
                }
                userList = appointAssignees2;
            }
            if (HussarUtils.isEmpty(userList)) {
                assignee = map2.get("static_appoint_assignee");
                List<String> staticAppointAssignees = new ArrayList<String>();
                if (HussarUtils.isNotEmpty(assignee)) {
                    staticAppointAssignees = assignee instanceof List ? (List)assignee : new ArrayList<String>(Arrays.asList(((String)assignee).split(",")));
                }
                if (HussarUtils.isNotEmpty(staticAppointAssignees)) {
                    List<String> appointAssignee = AnalyticalModelUtil.getAppointAssignee(execution, staticAppointAssignees, isLocal);
                    if (HussarUtils.isNotEmpty(appointAssignee)) {
                        return appointAssignee;
                    }
                    userList = staticAppointAssignees;
                }
            }
        }
        if (HussarUtils.isEmpty(userList) && HussarUtils.isNotEmpty(appointAssignees = (map = execution.getVariable("public_appoint_assignee") == null ? new HashMap() : (Map)execution.getVariable("public_appoint_assignee")).get(activityId))) {
            users = appointAssignees instanceof List ? (List)appointAssignees : Arrays.asList(String.valueOf(appointAssignees).split(","));
            return users.stream().distinct().collect(Collectors.toList());
        }
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        if (!(bm.getFlowElement(activityId) instanceof SubProcess) && (flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue()))) {
            users.add(userId);
            return users;
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, 0, messageType);
        if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
            inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
        }
        users = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        users.addAll(0, userList);
        if (HussarUtils.isNotEmpty(users)) {
            users = users.stream().distinct().collect(Collectors.toList());
        }
        return users;
    }

    private static List<String> getAppointAssignee(ActivityExecution execution, List<String> appointAssignees, boolean isLocal) {
        if (isLocal) {
            execution.removeVariableLocal("appoint_assignee");
        }
        for (String appointAssignee : appointAssignees) {
            if (!appointAssignee.contains(",")) continue;
            return appointAssignees.stream().distinct().collect(Collectors.toList());
        }
        Object isNotAdd = Context.getCommandContext().getAttribute("isNotAdd");
        if (HussarUtils.isEmpty((Object)isNotAdd) || ((Boolean)isNotAdd).booleanValue()) {
            return appointAssignees.stream().distinct().collect(Collectors.toList());
        }
        return null;
    }

    private static Set<String> getVariableNameList(String defaultAssign, JSONObject inExpressions) {
        HashSet<String> variableNameList = new HashSet<String>();
        if (HussarUtils.isNotEmpty((Object)defaultAssign)) {
            Matcher matcher = REGEX.matcher(defaultAssign);
            while (matcher.find()) {
                String variableName = matcher.group();
                variableNameList.add(variableName.substring(2, variableName.length() - 1));
            }
        }
        if (HussarUtils.isNotEmpty((Object)inExpressions)) {
            for (Object conditionAssign : inExpressions.values()) {
                if (!HussarUtils.isNotEmpty(conditionAssign)) continue;
                Matcher matcher = REGEX.matcher((String)conditionAssign);
                while (matcher.find()) {
                    String variableName = matcher.group();
                    variableNameList.add(variableName.substring(2, variableName.length() - 1));
                }
            }
        }
        return variableNameList;
    }

    private static Map<String, Object> getAssignmentNodeMap(Set<String> variableNameList, BpmnModel bm, String processInsId, String sendUser, String subProcessKey) {
        ArrayList<String> nodeIdList = new ArrayList<String>();
        for (String variableName : variableNameList) {
            if (bm.getFlowElement(variableName) == null) continue;
            nodeIdList.add(variableName);
        }
        HashMap<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        if (!nodeIdList.isEmpty()) {
            List hisTaskList = new ArrayList();
            String node = null;
            if (nodeIdList.size() == 1) {
                node = (String)nodeIdList.get(0);
            }
            hisTaskList = Context.getCommandContext() != null ? Context.getCommandContext().getTaskEntityManager().findAllHistoricTask(processInsId, node, subProcessKey) : ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(node)).subProcessKey(subProcessKey)).includeTaskLocalVariables()).list();
            for (String nodeId : nodeIdList) {
                List hisTaskEntityList = hisTaskList.stream().filter(hi -> hi.getTaskDefinitionKey().equals(nodeId)).collect(Collectors.toList());
                hisTaskEntityList.sort((o1, o2) -> {
                    if (o2.getEndTime() == null) {
                        return 1;
                    }
                    if (o1.getEndTime() == null) {
                        return -1;
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                StringBuilder assignee = new StringBuilder();
                if (hisTaskEntityList != null && !hisTaskEntityList.isEmpty()) {
                    boolean isUnfinished = ((HistoricTaskInstanceEntity)hisTaskEntityList.get(0)).getEndTime() == null;
                    HistoricTaskInstance historicTaskInstance = null;
                    block2: for (int i = 0; i < hisTaskEntityList.size(); ++i) {
                        String taskSourceFlag;
                        historicTaskInstance = (HistoricTaskInstance)hisTaskEntityList.get(i);
                        if (isUnfinished && i < hisTaskEntityList.size() - 1 && ((HistoricTaskInstanceEntity)hisTaskEntityList.get(i + 1)).getEndTime() == null || !"complete".equals(taskSourceFlag = (String)historicTaskInstance.getTaskLocalVariables().get("taskSourceFlag")) && !"freejump".equals(taskSourceFlag) && !"complete_leap".equals(taskSourceFlag) && !"skip".equals(taskSourceFlag)) continue;
                        Date start = historicTaskInstance.getStartTime();
                        assignee.append(historicTaskInstance.getOriginalAssignee());
                        for (int j = i + 1; j < hisTaskEntityList.size(); ++j) {
                            historicTaskInstance = (HistoricTaskInstance)hisTaskEntityList.get(j);
                            if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block2;
                            if (historicTaskInstance.getCreateTime().compareTo(start) < 0) {
                                start = historicTaskInstance.getCreateTime();
                            }
                            if (assignee.length() > 0) {
                                assignee.append(",");
                            }
                            assignee.append(historicTaskInstance.getOriginalAssignee());
                        }
                        break;
                    }
                    if (isUnfinished && sendUser != null) {
                        if (assignee.length() == 0) {
                            assignee.append(sendUser);
                        } else {
                            assignee.append(",").append(sendUser);
                        }
                    }
                }
                if (HussarUtils.isNotEmpty((Object)assignee.toString())) {
                    assignmentNodeMap.put(nodeId, assignee.toString());
                    continue;
                }
                assignmentNodeMap.put(nodeId, "");
            }
        }
        return assignmentNodeMap;
    }

    private static JSONObject getConditionAssign(BpmnModel bm, String activityId, String type) {
        JSONObject inExpressions = new JSONObject(true);
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement instanceof SubProcess) {
            List extensionElements = (List)flowElement.getExtensionElements().get(type);
            if (extensionElements != null) {
                return JSON.parseObject((String)((ExtensionElement)extensionElements.get(0)).getAttributeValue(null, type));
            }
            return null;
        }
        Map extensionAttribute = flowElement.getAttributes();
        List inCandidate = (List)extensionAttribute.get(type);
        if (inCandidate != null && !inCandidate.isEmpty()) {
            inExpressions = ((ExtensionAttribute)inCandidate.get(0)).getValue() == null ? null : JSON.parseObject((String)((ExtensionAttribute)inCandidate.get(0)).getValue());
        }
        return inExpressions;
    }

    private static String getDefaultAssign(BpmnModel bm, String activityId, String type) {
        String defaultAssign = "";
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement instanceof SubProcess) {
            List extensionElements = (List)flowElement.getExtensionElements().get(type);
            if (extensionElements != null) {
                return ((ExtensionElement)extensionElements.get(0)).getAttributeValue(null, type);
            }
            return "";
        }
        Map extensionAttribute = flowElement.getAttributes();
        List defaultCandidate = (List)extensionAttribute.get(type);
        if (defaultCandidate != null && !defaultCandidate.isEmpty()) {
            defaultAssign = ((ExtensionAttribute)defaultCandidate.get(0)).getValue() == null ? "" : ((ExtensionAttribute)defaultCandidate.get(0)).getValue();
        }
        return defaultAssign;
    }

    private static String getCallMessage(BpmnModel bm, String activityId, String name) {
        Map extensionElementsNode = bm.getFlowElement(activityId).getExtensionElements();
        if (HussarUtils.isNotEmpty((Object)extensionElementsNode) && extensionElementsNode.get(name) != null && HussarUtils.isNotEmpty((Object)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes())) {
            return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes().get(name)).get(0)).getValue();
        }
        return "";
    }

    private static String getFlowStarter(ActivityExecution execution) {
        Object sendUser;
        HistoricProcessInstance historicProcessInstance;
        String userId = "";
        List identityLink = ((ExecutionEntity)execution).getIdentityLinks();
        for (IdentityLinkEntity il : identityLink) {
            if (!STARTER.equals(il.getType())) continue;
            userId = il.getUserId() == null ? "" : il.getUserId();
            break;
        }
        if ("".equals(userId) && HussarUtils.isNotEmpty((Object)(historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult())) && HussarUtils.isNotEmpty((Object)historicProcessInstance.getStartUserId())) {
            userId = historicProcessInstance.getStartUserId();
        }
        if (HussarUtils.isEmpty((Object)userId) && HussarUtils.isNotEmpty((Object)(sendUser = execution.getVariableLocal(SEND_USER)))) {
            userId = sendUser.toString();
        }
        return userId;
    }

    public static Map<String, Object> getCcUser(BpmnModel bm, ActivityExecution execution) {
        String sendUserId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> ccUsers = execution.getVariable("cc_user") == null ? new ArrayList() : (List)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable(SEND_USER) == null ? "" : (String)execution.getVariable(SEND_USER);
        if (ccUsers != null && !ccUsers.isEmpty()) {
            execution.removeVariable("cc_user");
        } else {
            JSONObject inExpressions;
            String defaultAssign;
            String activityId = execution.getActivity().getId();
            String userId = AnalyticalModelUtil.getFlowStarter(execution);
            Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, 1, null);
            if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultCcAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionCcAssign")), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcAssign");
            }
            ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        }
        if (HussarUtils.isNotEmpty(ccUsers)) {
            ccUsers = ccUsers.stream().distinct().collect(Collectors.toList());
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    public static Map<String, Object> getCcEndUser(BpmnModel bm, ActivityExecution execution) {
        String sendUserId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> ccUsers = execution.getVariable("cc_user") == null ? new ArrayList() : (List)execution.getVariable("cc_user");
        String string = sendUserId = execution.getVariable(SEND_USER) == null ? "" : (String)execution.getVariable(SEND_USER);
        if (ccUsers != null && !ccUsers.isEmpty()) {
            execution.removeVariable("cc_user");
        } else {
            JSONObject inExpressions;
            String defaultAssign;
            String activityId = execution.getActivity().getId();
            String userId = AnalyticalModelUtil.getFlowStarter(execution);
            Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, 3, null);
            if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultCcEndAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionCcEndAssign")), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcEndAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcEndAssign");
            }
            ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        }
        if (HussarUtils.isNotEmpty(ccUsers)) {
            ccUsers = ccUsers.stream().distinct().collect(Collectors.toList());
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    private static List<String> getAssigneeByConfiguration(ActivityExecution execution, String userId, String defaultAssign, JSONObject conditionAssign, BpmnModel bm) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, conditionAssign})) {
            return new ArrayList<String>();
        }
        HashMap<String, Object> formData = execution.getVariables();
        Map sendUserMap = (Map)Context.getCommandContext().getAttribute("sendUserMap");
        if (sendUserMap != null) {
            formData.put(SEND_USER, sendUserMap.get(execution.getCurrentActivityId()));
        }
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, conditionAssign);
        Map<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        if (!variableNameList.isEmpty()) {
            String subProcessKey = (String)formData.get("sub_process_key");
            String sendUser = (String)formData.get(SEND_USER);
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, execution.getProcessInstanceId(), sendUser, subProcessKey);
        }
        if (formData != null && !formData.isEmpty()) {
            formData.putAll(assignmentNodeMap);
        } else {
            formData = assignmentNodeMap;
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        return AnalyticalModelUtil.getNextAssigneeByConfiguration(processKey, userId, defaultAssign, conditionAssign, variableNameList, formData, AnalyticalModelUtil.getProcessInfo(execution));
    }

    public static Map<String, String> getCallActivityAssignee(BpmnModel bm, ActivityExecution execution, Map<String, Object> map) {
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        String activityId = execution.getCurrentActivityId();
        Map modelAssignee = sysActAssigneeService.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, 2, null);
        String callAssignee = null;
        String callProcessKey = null;
        JSONObject conditionCallAssignee = null;
        JSONObject conditionCallProcessKey = null;
        String defaultCallAssignee = null;
        String defaultCallProcessKey = null;
        if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
            callAssignee = (String)modelAssignee.get("conditionCallAssign");
            callProcessKey = (String)modelAssignee.get("conditionCallProcessKey");
            conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
            conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
            defaultCallAssignee = (String)modelAssignee.get("defaultCallAssignee");
            defaultCallProcessKey = (String)modelAssignee.get("defaultCallProcessKey");
        } else {
            callAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallAssign");
            callProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallProcessKey");
            conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
            conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
            defaultCallAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallAssignee");
            defaultCallProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallProcessKey");
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultCallAssignee, conditionCallAssignee})) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("assignee", "");
            result.put("processKey", defaultCallProcessKey);
        }
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultCallAssignee, conditionCallAssignee);
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultCallAssignee, conditionCallAssignee})) {
            String subProcessKey = (String)execution.getVariable("sub_process_key");
            String sendUser = (String)execution.getVariable(SEND_USER);
            Map sendUserMap = (Map)Context.getCommandContext().getAttribute("sendUserMap");
            if (sendUserMap != null) {
                sendUser = (String)sendUserMap.get(execution.getCurrentActivityId());
            }
            map.putAll(AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, execution.getProcessInstanceId(), sendUser, subProcessKey));
        }
        AnalyticalModelUtil.setBpmWorkflowVariable(userId, variableNameList, map);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionCallAssignee != null && !conditionCallAssignee.isEmpty()) {
            for (Object k : conditionCallAssignee.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                HashMap<String, String> result = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)conditionCallAssignee.get(k))) {
                    List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable((String)conditionCallAssignee.get(k), userId, map), execution.getProcessDefinitionId().split(":")[0], (Integer)execution.getVariables().get("security_level"), AnalyticalModelUtil.getProcessInfo(execution));
                    result.put("assignee", String.join((CharSequence)",", users));
                }
                result.put("processKey", (String)conditionCallProcessKey.get(k));
                return result;
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)defaultCallAssignee)) {
            List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(defaultCallAssignee, userId, map), execution.getProcessDefinitionId().split(":")[0], (Integer)execution.getVariables().get("security_level"), AnalyticalModelUtil.getProcessInfo(execution));
            result.put("assignee", String.join((CharSequence)",", users));
        }
        result.put("processKey", defaultCallProcessKey);
        return result;
    }

    public static Map<String, String> getToDoConfiguration(String processDefinitionId, String taskDefinitionKey) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String todo = "";
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            Map extensionElementsNode = bm.getFlowElement(taskDefinitionKey).getExtensionElements();
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            map.put("todoConfiguration", todo);
        }
        Map extensionElements = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        if (HussarUtils.isEmpty((Object)todo)) {
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElements.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
            if (HussarUtils.isNotEmpty((Object)todo)) {
                map.put("todoConfiguration", todo);
            } else {
                map.put("todoConfiguration", "");
            }
        }
        return map;
    }

    public static String getTodo(Map<String, Object> variables, String todoConfig) {
        if (HussarUtils.isEmpty((Object)todoConfig)) {
            return "";
        }
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(variables);
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, todoConfig, String.class);
        return valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
    }

    private static void setBpmWorkflowVariable(String userId, Set<String> variableNameList, Map<String, Object> map) {
        if (variableNameList.contains("flow_starter_dept")) {
            map.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId));
        }
        if (variableNameList.contains("flow_sameLevel_dept")) {
            map.put("flow_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserId(userId));
        }
        if (variableNameList.contains("flow_parent_dept")) {
            map.put("flow_parent_dept", iAssigneeChooseService.getParentDeptIdByUserId(userId));
        }
        if (variableNameList.contains("flow_submiter_dept")) {
            map.put("flow_submiter_dept", iAssigneeChooseService.getDeptIdByUserIds(map.get(SEND_USER).toString()));
        }
        if (variableNameList.contains("flow_submiter_sameLevel_dept")) {
            map.put("flow_submiter_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserIds(map.get(SEND_USER).toString()));
        }
        if (variableNameList.contains("flow_submiter_parent_dept")) {
            map.put("flow_submiter_parent_dept", iAssigneeChooseService.getParentDeptIdByUserIds(map.get(SEND_USER).toString()));
        }
    }

    private static List<String> getNextAssigneeByConfiguration(String processKey, String userId, String defaultAssign, JSONObject conditionAssign, Set<String> variableNameList, Map<String, Object> map, Map<String, String> processInfo) {
        String realSql;
        List<String> users = new ArrayList<String>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        AnalyticalModelUtil.setBpmWorkflowVariable(userId, variableNameList, map);
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        if (HussarUtils.isEmpty((Object)(realSql = sql.toString())) || "null".equals(realSql)) {
            return users;
        }
        List list = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(realSql, userId, map), processKey, (Integer)map.get("security_level"), processInfo);
        if (list == null || list.isEmpty()) {
            return users;
        }
        users = list.stream().distinct().collect(Collectors.toList());
        return users;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!map.containsKey("bpm_submit_source")) {
            map.put("bpm_submit_source", "");
        }
        for (String k : map.keySet()) {
            if (map.get(k.toString()) != null) {
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
        }
        return context;
    }

    private static String replaceNextBuiltinVariable(String sql, String starterUserId, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "null");
        return "and (" + finalSql.replaceFirst("and", "") + ")";
    }

    public static String queryFirstNodeAssigneeConfig(String userId, String processDefinitionId, String businessId, Map<String, Object> variables) {
        Map<String, Object> result;
        JSONObject conditionAssign;
        String defaultAssign;
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        StringBuilder sql = new StringBuilder();
        String taskDefinitionKey = "";
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        boolean condition = false;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = bm.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = AnalyticalModelUtil.getFirstNode(flowElement, process, variables);
        }
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            return "";
        }
        Map modelAssignee = sysActAssigneeService.getAssignee(processDefinitionId.split(":")[0], taskDefinitionKey, 0, null);
        if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
            defaultAssign = (String)modelAssignee.get("defaultAssign");
            conditionAssign = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, taskDefinitionKey, "defaultAssign");
            conditionAssign = AnalyticalModelUtil.getConditionAssign(bm, taskDefinitionKey, "conditionAssign");
        }
        if (HussarUtils.isEmpty((Object)defaultAssign) && HussarUtils.isEmpty((Object)conditionAssign)) {
            return "";
        }
        boolean isGetFlowStarterDept = false;
        boolean isRequestVisit = false;
        if (defaultAssign.contains("$")) {
            isRequestVisit = true;
        }
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        }
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (isGetFlowStarterDept && isRequestVisit) break;
                if (!isRequestVisit && (k.toString().contains("$") || ((String)conditionAssign.get((Object)k.toString())).contains("$"))) {
                    isRequestVisit = true;
                }
                if (isGetFlowStarterDept || !k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
            }
        }
        HashMap<String, Object> newVariables = variables == null ? new HashMap<String, Object>() : variables;
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, conditionAssign);
        if (!variableNameList.isEmpty()) {
            Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, null, null, null);
            newVariables.putAll(nodeMap);
        }
        if (isRequestVisit && HussarUtils.isNotEmpty(result = CommonCodeUtil.getGodAxeResult(taskDefinitionKey, businessId, processDefinitionId))) {
            newVariables.putAll(result);
        }
        if (isGetFlowStarterDept) {
            newVariables.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return "";
            }
        }
        String finalSql = "";
        if (HussarUtils.isNotEmpty((Object)sql)) {
            finalSql = AnalyticalModelUtil.replaceNextBuiltinVariable(sql.toString(), userId, newVariables);
        }
        return finalSql;
    }

    private static boolean getResultByELAndFormData(String el, Map<String, Object> formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Map.Entry<String, Object> k : formData.entrySet()) {
            if (k.getValue() != null) {
                context.setVariable(k.getKey(), factory.createValueExpression(k.getValue(), k.getValue().getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(k.getValue(), Object.class));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE);
        return (Boolean)e.getValue((ELContext)context);
    }

    private static String getFirstNode(FlowElement flowElement, Process process, Map<String, Object> variables) {
        SequenceFlow sequenceFlow;
        String targetRef;
        FlowElement fe;
        String taskDefinitionKey = "";
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
        String flow = exclusiveGateway.getDefaultFlow();
        List sf = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow s : sf) {
            String ce = s.getConditionExpression();
            if (!HussarUtils.isNotEmpty((Object)ce) || !AnalyticalModelUtil.getResultByELAndFormData(ce, variables)) continue;
            flow = s.getId();
            break;
        }
        if (HussarUtils.isNotEmpty((Object)flow) && (fe = process.getFlowElement(targetRef = (sequenceFlow = (SequenceFlow)process.getFlowElement(flow)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = fe.getId();
        }
        return taskDefinitionKey;
    }

    public static List<String> getNextCandidateUser(String processInsId, String processDefinitionId, BpmnModel bm, String activityId, String subProcessKey, Map<String, Object> map, Task task) {
        List instanceModeNode;
        String instanceMode;
        String processKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        List<String> users = new ArrayList<String>();
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement == null) {
            throw new PublicClientException(bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        if (flowElement instanceof ReceiveTask || flowElement instanceof ServiceTask) {
            return users;
        }
        if (flowElement instanceof SubProcess && !(instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)(instanceModeNode = (List)flowElement.getExtensionElements().get("instanceMode")).get(0)).getAttributes().get("instanceMode")).get(0)).getValue()).equals("assignee")) {
            return users;
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (!extensionElementsNode.isEmpty()) {
            Map<String, Object> result;
            Set<String> variableNameList;
            JSONObject inExpressions;
            String defaultAssign;
            Map modelAssignee = sysActAssigneeService.getAssignee(processKey, activityId, 0, null);
            if (HussarUtils.isNotEmpty((Object)modelAssignee)) {
                defaultAssign = (String)modelAssignee.get("defaultAssign");
                inExpressions = (JSONObject)JSONObject.parse((String)((String)modelAssignee.get("conditionAssign")), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            }
            if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                return users;
            }
            String businessId = null;
            String startUserId = HussarUtils.isEmpty((Object)map.get("userId")) ? "" : (String)map.get("userId");
            newMap.put(SEND_USER, startUserId);
            if (subProcessKey != null && !"".equals(subProcessKey)) {
                newMap.put("sub_process_separate_variable", subProcessKey.split(":")[1]);
            }
            if (processInsId != null) {
                HistoricProcessInstance hpi = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
                businessId = hpi.getBusinessKey();
                startUserId = hpi.getStartUserId();
            }
            if (!(variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, inExpressions)).isEmpty()) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, processInsId, startUserId, subProcessKey);
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions) && HussarUtils.isNotEmpty(result = CommonCodeUtil.getGodAxeResult(activityId, businessId, processDefinitionId))) {
                newMap.putAll(result);
            }
            if (map != null) {
                newMap.putAll(map);
            }
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(processKey, startUserId, defaultAssign, inExpressions, variableNameList, newMap, AnalyticalModelUtil.getProcessInfo(task, flowElement, processDefinitionId));
        }
        return users;
    }

    private static Map<String, String> getProcessInfo(Task task, FlowElement flowElement, String processDefId) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowTaskDefinitionKey", flowElement.getId());
        processInfo.put("workflowTaskDefinitionName", flowElement.getName());
        if (task != null) {
            processInfo.put("workflowProcessKey", task.getProcessDefinitionId().split(":")[0]);
            processInfo.put("workflowProcessInsId", task.getProcessInstanceId());
            processInfo.put("workflowProcessDefinitionId", task.getProcessDefinitionId());
        } else if (processDefId != null) {
            processInfo.put("workflowProcessDefinitionId", processDefId);
            processInfo.put("workflowProcessKey", processDefId.split(":")[0]);
        }
        return processInfo;
    }

    private static Map<String, String> getProcessInfo(ActivityExecution execution) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowProcessKey", execution.getProcessDefinitionId().split(":")[0]);
        processInfo.put("workflowProcessInsId", execution.getProcessInstanceId());
        processInfo.put("workflowProcessDefinitionId", execution.getProcessDefinitionId());
        processInfo.put("workflowBusinessId", execution.getProcessBusinessKey());
        processInfo.put("workflowTaskDefinitionKey", execution.getCurrentActivityId());
        processInfo.put("workflowTaskDefinitionName", execution.getCurrentActivityName());
        return processInfo;
    }

    private static boolean isGetVisitor(String defaultAssign, JSONObject conditionAssign) {
        if (defaultAssign.contains("$")) {
            return true;
        }
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("$") && !((String)conditionAssign.get((Object)k.toString())).contains("$")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getMultiInstanceUser(List<HistoricTaskInstanceEntity> hisTaskList) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
        Date start = historicTaskInstance.getStartTime();
        ArrayList<String> userIds = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < hisTaskList.size(); ++i) {
            Integer n;
            Integer n2;
            HistoricTaskInstance taskInstance = (HistoricTaskInstance)hisTaskList.get(i);
            if (start.getTime() > taskInstance.getEndTime().getTime() && !"RevokeHistory".equals(taskInstance.getDeleteReason())) break;
            if (taskInstance.getCreateTime().compareTo(start) < 0) {
                start = taskInstance.getCreateTime();
            }
            Integer count = map.getOrDefault(taskInstance.getAssignee(), 0);
            if ("RevokeHistory".equals(taskInstance.getDeleteReason())) {
                n2 = count;
                n = count = Integer.valueOf(count - 1);
            } else {
                n2 = count;
                n = count = Integer.valueOf(count + 1);
            }
            map.put(taskInstance.getAssignee(), count);
        }
        for (String userId : map.keySet()) {
            if ((Integer)map.get(userId) <= 0) continue;
            userIds.add(userId);
        }
        return userIds;
    }

    private AnalyticalModelUtil() {
    }
}

