/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskUrgeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.SysActUrgeTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5df2\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpm/doneManage"})
@HussarTokenDs
public class DoneManageController {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private FlowEventsService flowEventsService;

    @GetMapping(value={"/list"})
    @ResponseBody
    @ApiOperation(value="\u5df2\u529e\u67e5\u8be2", notes="\u5df2\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u5df2\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskManagerQueryVo>> list(Page<FlowTask> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        return this.flowEventsService.doneList(pages, userId, processKey, null, null, message, sendUserId, startTime, endTime);
    }

    @PostMapping(value={"/revoke"})
    @ApiOperation(value="\u64a4\u56de", notes="\u64a4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u64a4\u56de", eventDesc="\u64a4\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> revoke(@RequestBody String taskId) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (taskId == null || userId == null) {
            throw new PublicClientException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        return this.flowEventsService.revokeTask(taskId, userId);
    }

    @PostMapping(value={"/urge"})
    @ApiOperation(value="\u50ac\u529e", notes="\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u50ac\u529e", eventDesc="\u6dfb\u52a0\u50ac\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> urge(@RequestBody TaskUrgeDto taskUrgeDto) {
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (taskUrgeDto.getProcessInsId() == null || userId == null) {
            throw new PublicClientException("");
        }
        BpmResponseResult bpmResponseResult = SysActUrgeTaskService.save((String)taskUrgeDto.getProcessInsId(), (String)taskUrgeDto.getTaskId(), (String)userId);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

