/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.activiti.config;

import com.jxdinfo.hussar.workflow.activiti.config.HussarProcessEngineConfiguration;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.spring.SpringAsyncExecutor;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.boot.AbstractProcessEngineAutoConfiguration;
import org.activiti.spring.boot.ProcessEngineConfigurationConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

public abstract class AbstractHussarProcessEngineAutoConfiguration
extends AbstractProcessEngineAutoConfiguration {
    @Autowired
    private ResourcePatternResolver resourceLoader;
    @Autowired(required=false)
    private ProcessEngineConfigurationConfigurer processEngineConfigurationConfigurer;

    protected SpringProcessEngineConfiguration baseSpringProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, SpringAsyncExecutor springAsyncExecutor) throws IOException {
        List procDefResources = this.discoverProcessDefinitionResources(this.resourceLoader, this.activitiProperties.getProcessDefinitionLocationPrefix(), this.activitiProperties.getProcessDefinitionLocationSuffixes(), this.activitiProperties.isCheckProcessDefinitions());
        SpringProcessEngineConfiguration conf = this.processEngineConfigurationBean(procDefResources.toArray(new Resource[procDefResources.size()]), dataSource, platformTransactionManager, springAsyncExecutor);
        conf.setDeploymentName(this.defaultText(this.activitiProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDatabaseSchema(this.defaultText(this.activitiProperties.getDatabaseSchema(), conf.getDatabaseSchema()));
        conf.setDatabaseSchemaUpdate(this.defaultText(this.activitiProperties.getDatabaseSchemaUpdate(), conf.getDatabaseSchemaUpdate()));
        conf.setDbIdentityUsed(this.activitiProperties.isDbIdentityUsed());
        conf.setDbHistoryUsed(this.activitiProperties.isDbHistoryUsed());
        conf.setJobExecutorActivate(this.activitiProperties.isJobExecutorActivate());
        conf.setAsyncExecutorEnabled(this.activitiProperties.isAsyncExecutorEnabled());
        conf.setAsyncExecutorActivate(this.activitiProperties.isAsyncExecutorActivate());
        conf.setMailServerHost(this.activitiProperties.getMailServerHost());
        conf.setMailServerPort(this.activitiProperties.getMailServerPort());
        conf.setMailServerUsername(this.activitiProperties.getMailServerUserName());
        conf.setMailServerPassword(this.activitiProperties.getMailServerPassword());
        conf.setMailServerDefaultFrom(this.activitiProperties.getMailServerDefaultFrom());
        conf.setMailServerUseSSL(this.activitiProperties.isMailServerUseSsl());
        conf.setMailServerUseTLS(this.activitiProperties.isMailServerUseTls());
        conf.setHistoryLevel(this.activitiProperties.getHistoryLevel());
        if (this.activitiProperties.getCustomMybatisMappers() != null) {
            conf.setCustomMybatisMappers(this.getCustomMybatisMapperClasses(this.activitiProperties.getCustomMybatisMappers()));
        }
        if (this.activitiProperties.getCustomMybatisXMLMappers() != null) {
            conf.setCustomMybatisXMLMappers(new HashSet(this.activitiProperties.getCustomMybatisXMLMappers()));
        }
        if (this.processEngineConfigurationConfigurer != null) {
            this.processEngineConfigurationConfigurer.configure(conf);
        }
        return conf;
    }

    private String defaultText(String deploymentName, String deploymentName1) {
        if (StringUtils.hasText((String)deploymentName)) {
            return deploymentName;
        }
        return deploymentName1;
    }

    private Set<Class<?>> getCustomMybatisMapperClasses(List<String> customMyBatisMappers) {
        HashSet mybatisMappers = new HashSet();
        for (String customMybatisMapperClassName : customMyBatisMappers) {
            try {
                Class<?> customMybatisClass = Class.forName(customMybatisMapperClassName);
                mybatisMappers.add(customMybatisClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class " + customMybatisMapperClassName + " has not been found.", e);
            }
        }
        return mybatisMappers;
    }

    public SpringProcessEngineConfiguration processEngineConfigurationBean(Resource[] processDefinitions, DataSource dataSource, PlatformTransactionManager transactionManager, SpringAsyncExecutor springAsyncExecutor) {
        HussarProcessEngineConfiguration engine = new HussarProcessEngineConfiguration();
        if (processDefinitions != null && processDefinitions.length > 0) {
            engine.setDeploymentResources(processDefinitions);
        }
        engine.setDataSource(dataSource);
        engine.setTransactionManager(transactionManager);
        if (null != springAsyncExecutor) {
            engine.setAsyncExecutorEnabled(true);
            engine.setAsyncExecutor((AsyncExecutor)springAsyncExecutor);
        }
        return engine;
    }
}

