/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.SubProcessEndCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.Execution;

public class ProcessEndCmd
implements Command<Void> {
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private RuntimeService runtimeService = (RuntimeService)SpringContextHolder.getApplicationContext().getBean(RuntimeService.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private String taskId;
    private String userId;
    private String mandator;
    private String comment;
    private String instanceId;
    private String type;
    private boolean isMainEndProcess;

    public ProcessEndCmd(String userId, String mandator, String comment, String instanceId, String type) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.type = type;
        this.isMainEndProcess = true;
    }

    public ProcessEndCmd(String userId, String mandator, String comment, String instanceId, String type, boolean isMainEndProcess) {
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public ProcessEndCmd(String taskId, String userId, String mandator, String comment, String instanceId, String type, boolean isMainEndProcess) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandator = mandator;
        this.comment = comment;
        this.instanceId = instanceId;
        this.type = type;
        this.isMainEndProcess = isMainEndProcess;
    }

    public Void execute(CommandContext commandContext) {
        List list;
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setProcessInsId(this.instanceId);
            dataPush.setUserId(this.userId);
            dataPush.setComment(this.comment);
            dataPush.setConsignor(this.mandator);
            this.dataPushService.endProcess(dataPush);
        }
        if (!(list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(this.instanceId).unfinished().list()).isEmpty()) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                TaskEngineServiceImpl.getCallRejectList().add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                new ProcessEndCmd(this.userId, this.mandator, this.comment, historicActivityInstance.getCalledProcessInstanceId(), this.type, false).execute(commandContext);
                TaskEngineServiceImpl.getCallRejectList().remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(historicActivityInstance.getProcessDefinitionId());
            String procInsId = ((HistoricActivityInstance)list.get(0)).getProcessInstanceId();
            List executions = this.runtimeService.createExecutionQuery().variableValueNotEquals("sub_process_key", null).processInstanceId(procInsId).list();
            for (Execution execution : executions) {
                String subProcessKey = (String)((ExecutionEntity)execution).getVariableLocal("sub_process_key");
                String nodeId = subProcessKey.split(":")[0];
                TaskEngineServiceImpl.getSubProcessRejectList().add(procInsId + nodeId);
                new SubProcessEndCmd(this.taskId, bm, this.userId, this.mandator, this.comment, procInsId, subProcessKey, this.type, this.isMainEndProcess).execute(commandContext);
                TaskEngineServiceImpl.getSubProcessRejectList().remove(procInsId + nodeId);
            }
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findChildExecutionsByProcessInstanceId(procInsId).get(0);
            while (executionEntity.getExecutions() != null && !executionEntity.getExecutions().isEmpty()) {
                executionEntity = (ExecutionEntity)executionEntity.getExecutions().get(0);
            }
            ParallelJumpTaskCmd parallelJumpTaskCmd = new ParallelJumpTaskCmd(this.taskId, this.userId, this.mandator, executionEntity.getId(), destinationActivity.getId(), this.comment, this.type, null, new HashMap<String, Object>(), currentActivity);
            if ("endProcess".equals(this.type)) {
                parallelJumpTaskCmd.setProcessEventType("process_end");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_end");
                }
            }
            if ("revokeProcess".equals(this.type)) {
                parallelJumpTaskCmd.setProcessEventType("process_revoke");
                if (!this.isMainEndProcess) {
                    parallelJumpTaskCmd.addParam("sub_process", "sub_process_revoke");
                }
            }
            parallelJumpTaskCmd.execute(commandContext);
            if ("revokeProcess".equals(this.type)) {
                HistoricProcessInstanceEntity historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.instanceId);
                historicProcessInstance.setDeleteReason("revokeProcess");
            }
            return null;
        }
        return null;
    }
}

