/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TenantSyncDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmOrganView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmPostView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmRolesView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserPostConcurrentlyView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserPostMainView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.model.HussarBpmUserRoleView;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmOrganService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmPostService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmRolesService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmUserPostConcurrentlyService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmUserPostMainService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.HussarBpmUserRoleService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenantsyncdata.service.TenantSyncDataService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantSyncDataServiceImpl
implements TenantSyncDataService {
    @Autowired
    private HussarBpmOrganService hussarBpmOrganService;
    @Autowired
    private HussarBpmPostService hussarBpmPostService;
    @Autowired
    private HussarBpmRolesService hussarBpmRolesService;
    @Autowired
    private HussarBpmUserPostConcurrentlyService hussarBpmUserPostConcurrentlyService;
    @Autowired
    private HussarBpmUserPostMainService hussarBpmUserPostMainService;
    @Autowired
    private HussarBpmUserRoleService hussarBpmUserRoleService;

    public boolean syncHussarBpmOrgan(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getOrganList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmOrganView::getOrganId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmOrganView::getOrganId, idList);
        List oldList = this.hussarBpmOrganService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(HussarBpmOrganView::getOrganId, HussarBpmOrganView::getBpmOrganId));
        }
        for (HussarBpmOrganView hussarBpmOrganView : list) {
            Long bpmOrganId = (Long)idMap.get(hussarBpmOrganView.getOrganId());
            if (!HussarUtils.isNotEmpty((Object)bpmOrganId)) continue;
            hussarBpmOrganView.setBpmOrganId(bpmOrganId);
        }
        return this.hussarBpmOrganService.saveOrUpdateBatch((Collection)list);
    }

    public boolean syncHussarBpmPost(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getPostList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmPostView::getPostId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmPostView::getPostId, idList);
        List oldList = this.hussarBpmPostService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(HussarBpmPostView::getPostId, HussarBpmPostView::getBpmPostId));
        }
        for (HussarBpmPostView hussarBpmPostView : list) {
            Long bpmPostId = (Long)idMap.get(hussarBpmPostView.getPostId());
            if (!HussarUtils.isNotEmpty((Object)bpmPostId)) continue;
            hussarBpmPostView.setBpmPostId(bpmPostId);
        }
        return this.hussarBpmPostService.saveOrUpdateBatch((Collection)list);
    }

    public boolean syncHussarBpmRoles(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getRolesList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmRolesView::getRoleId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmRolesView::getRoleId, idList);
        List oldList = this.hussarBpmRolesService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(HussarBpmRolesView::getRoleId, HussarBpmRolesView::getBpmRolesId));
        }
        for (HussarBpmRolesView hussarBpmRolesView : list) {
            Long bpmPostId = (Long)idMap.get(hussarBpmRolesView.getRoleId());
            if (!HussarUtils.isNotEmpty((Object)bpmPostId)) continue;
            hussarBpmRolesView.setBpmRolesId(bpmPostId);
        }
        return this.hussarBpmRolesService.saveOrUpdateBatch((Collection)list);
    }

    public boolean syncHussarBpmUserPostConcurrently(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getUserPostConcurrentlyList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmUserPostConcurrentlyView::getUserId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmUserPostConcurrentlyView::getUserId, idList);
        List oldList = this.hussarBpmUserPostConcurrentlyService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(view -> view.getUserId() + "&" + view.getPostId(), HussarBpmUserPostConcurrentlyView::getBpmUserPostConcurrentlyId));
        }
        for (HussarBpmUserPostConcurrentlyView hussarBpmUserPostConcurrentlyView : list) {
            Long bpmPostId = (Long)idMap.get(hussarBpmUserPostConcurrentlyView.getUserId() + "&" + hussarBpmUserPostConcurrentlyView.getPostId());
            if (!HussarUtils.isNotEmpty((Object)bpmPostId)) continue;
            hussarBpmUserPostConcurrentlyView.setBpmUserPostConcurrentlyId(bpmPostId);
        }
        return this.hussarBpmUserPostConcurrentlyService.saveOrUpdateBatch((Collection)list);
    }

    public boolean syncHussarBpmUserPostMain(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getUserPostMainList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmUserPostMainView::getUserId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmUserPostMainView::getUserId, idList);
        List oldList = this.hussarBpmUserPostMainService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(HussarBpmUserPostMainView::getUserId, HussarBpmUserPostMainView::getBpmUserPostMainId));
        }
        for (HussarBpmUserPostMainView hussarBpmUserPostMainView : list) {
            Long bpmPostId = (Long)idMap.get(hussarBpmUserPostMainView.getUserId());
            if (!HussarUtils.isNotEmpty((Object)bpmPostId)) continue;
            hussarBpmUserPostMainView.setBpmUserPostMainId(bpmPostId);
        }
        return this.hussarBpmUserPostMainService.saveOrUpdateBatch((Collection)list);
    }

    public boolean syncHussarBpmUserRole(TenantSyncDataDto tenantSyncDataDto) {
        List list = tenantSyncDataDto.getUserRoleList();
        if (HussarUtils.isEmpty((Object)list)) {
            return true;
        }
        List idList = list.stream().map(HussarBpmUserRoleView::getUserId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(HussarBpmUserRoleView::getUserId, idList);
        List oldList = this.hussarBpmUserRoleService.list((Wrapper)queryWrapper);
        Map<Object, Object> idMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            idMap = oldList.stream().collect(Collectors.toMap(HussarBpmUserRoleView::getUserId, HussarBpmUserRoleView::getBpmUserRoleId));
        }
        for (HussarBpmUserRoleView hussarBpmUserRoleView : list) {
            Long bpmPostId = (Long)idMap.get(hussarBpmUserRoleView.getUserId());
            if (!HussarUtils.isNotEmpty((Object)bpmPostId)) continue;
            hussarBpmUserRoleView.setBpmUserRoleId(bpmPostId);
        }
        return this.hussarBpmUserRoleService.saveOrUpdateBatch((Collection)list);
    }
}

