/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.frontAction.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.config.HussarClientFrontActionConfigs;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.dto.FrontActionParamDto;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.service.FrontActionService;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.util.FrontActionHttpClientUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.frontAction.util.FrontActionTokenUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontActionServiceImpl
implements FrontActionService {
    private static final Logger logger = LoggerFactory.getLogger(FrontActionServiceImpl.class);
    private static final String FRONT_ACTION_URL_ERROR = "\u672a\u914d\u7f6e\u524d\u7f6e\u52a8\u4f5c\u63a5\u53e3 url";
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Autowired
    private FrontActionTokenUtil frontActionTokenUtil;

    public boolean execute(FrontActionParamDto frontActionParam) {
        String clientToken;
        String processDefinitionId = frontActionParam.getProcessDefinitionId();
        String nodeId = frontActionParam.getNodeId();
        SysActExtendProperties extendProperties = this.extendPropertiesService.queryList(nodeId, processDefinitionId);
        if (!this.isOpenFrontAction(extendProperties)) {
            return true;
        }
        String url = extendProperties.getFrontActionUrl();
        if (url == null || url.length() == 0) {
            logger.error(FRONT_ACTION_URL_ERROR);
            throw new PublicClientException(FRONT_ACTION_URL_ERROR);
        }
        String sendJson = JSONObject.toJSONString((Object)frontActionParam);
        String result = FrontActionHttpClientUtil.postJson(sendJson, url, clientToken = this.getToken(extendProperties));
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class);
        if (apiResponse != null && apiResponse.getCode() == ResultCode.SUCCESS.getCode()) {
            String data = JSONObject.toJSONString((Object)apiResponse.getData());
            return (Boolean)JSONObject.parseObject((String)data, Boolean.class);
        }
        String errorMsg = apiResponse != null ? JSONObject.toJSONString((Object)apiResponse.getData()) : "\u8bf7\u6c42\u54cd\u5e94\u4e3a\u7a7a";
        throw new PublicClientException(errorMsg);
    }

    private boolean isOpenFrontAction(SysActExtendProperties extendProperties) {
        if (extendProperties != null) {
            return extendProperties.isAheadActionIsUsed();
        }
        return false;
    }

    private String getToken(SysActExtendProperties extendProperties) {
        boolean hussarSystem = extendProperties.isHussarSystem();
        if (hussarSystem) {
            HussarClientFrontActionConfigs hussarClientFrontActionConfigs = this.getFrontActionConfigsBy(extendProperties);
            return this.frontActionTokenUtil.getHussarToken(hussarClientFrontActionConfigs);
        }
        return this.frontActionTokenUtil.getThirdPartyToken();
    }

    private HussarClientFrontActionConfigs getFrontActionConfigsBy(SysActExtendProperties extendProperties) {
        HussarClientFrontActionConfigs hussarClientFrontActionConfigs = new HussarClientFrontActionConfigs();
        if (extendProperties != null) {
            String hussarAuthServer = extendProperties.getCertifiedAddress();
            String hussarClientId = extendProperties.getClientId();
            String hussarClientSecret = extendProperties.getClientSecretKey();
            String hussarScope = extendProperties.getContractOwnership();
            String hussarGrantType = extendProperties.getAuthenticationType();
            hussarClientFrontActionConfigs.setHussarAuthServer(hussarAuthServer);
            hussarClientFrontActionConfigs.setHussarClientId(hussarClientId);
            hussarClientFrontActionConfigs.setHussarClientSecret(hussarClientSecret);
            hussarClientFrontActionConfigs.setHussarScope(hussarScope);
            hussarClientFrontActionConfigs.setHussarGrantType(hussarGrantType);
            hussarClientFrontActionConfigs.setEnableAuth(!hussarClientFrontActionConfigs.isEmpty());
        }
        return hussarClientFrontActionConfigs;
    }
}

