/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.task.Task;

public class TaskCompleteCmd
extends AddAttributeCmd<TaskEntity> {
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getBean(DataPushService.class);
    private String taskId;
    private String userId;
    private String mandator;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private String comment;
    private Boolean notNeedCheckAssignee;
    private Boolean isNotAdd;
    private String approvalType;

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskCompleteCmd setApprovalType(String approvalType) {
        this.approvalType = approvalType;
        return this;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables, Boolean notNeedCheckAssignee, Boolean isNotAdd) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
        this.notNeedCheckAssignee = notNeedCheckAssignee;
        this.isNotAdd = isNotAdd;
    }

    public TaskEntity execute(CommandContext commandContext) {
        this.addAttribute(commandContext);
        commandContext.addAttribute("approvalType", (Object)this.approvalType);
        commandContext.addAttribute("notNeedCheckAssignee", (Object)this.notNeedCheckAssignee);
        commandContext.addAttribute("isNotAdd", (Object)this.isNotAdd);
        TaskEntity task = commandContext.getTaskEntityManager().findTaskById(this.taskId);
        this.addExecutionAttribute(task.getProcessInstance());
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(this.taskId);
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        commandContext.addAttribute("bpm_submit_source", (Object)task.getTaskDefinitionKey());
        task.getExecution().setAllPrevNode(task.getTaskDefinitionKey());
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        List childTasks = taskEntityManager.findTasksByParentTaskId(this.taskId);
        String processKey = null;
        String processDefinitionId = null;
        ExecutionEntity execution = task.getExecution();
        if (!childTasks.isEmpty()) {
            ArrayList childTaskIds = new ArrayList();
            childTasks.forEach(childTask -> {
                execution.removeTask((TaskEntity)childTask);
                taskEntityManager.deleteTask((TaskEntity)childTask, null, true);
                childTaskIds.add(childTask.getId());
            });
            processKey = ((Task)childTasks.get(0)).getProcessDefinitionId().split(",")[0];
            processDefinitionId = ((Task)childTasks.get(0)).getProcessDefinitionId();
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(processDefinitionId);
            if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                DataPush dataPush = new DataPush();
                dataPush.setProcessKey(processKey);
                dataPush.setProcessDefinitionId(processDefinitionId);
                dataPush.setTaskIds(childTaskIds);
                this.dataPushService.deleteMultiTask(dataPush);
            }
        }
        if (task.getDelegationState() != null) {
            task.resolve();
        }
        task.fireEvent("beforeComplete");
        if (task.getExecutionId() != null) {
            task.setExecutionVariables(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(task, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        task.setApprovalType(this.approvalType);
        task.complete(this.variables, false, this.mandator);
        if (HussarUtils.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(this.taskId);
        }
        return task;
    }

    public TaskCompleteCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, Map<String, Object> variables) {
        this(taskId, userId);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public TaskCompleteCmd(String taskId, String userId, String comment) {
        this(taskId, userId);
        this.comment = comment;
    }

    public TaskCompleteCmd(String taskId, String userId, String mandator, String comment, Map<String, Object> variables) {
        this(taskId, userId, comment);
        this.mandator = mandator;
        if (variables != null) {
            this.variables = variables;
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.mappingCompleteType(BpmAttribute.getTaskSourceFlag(task));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.mappingLastCompleteType(BpmAttribute.getTaskSourceFlag(task));
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        paramModel.setApprovalType(this.approvalType);
        return paramModel;
    }
}

