/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;

public class MultiInstanceRevokeTaskCmd
implements Command<Void> {
    private HistoricTaskInstance currTask;
    private String comment;
    private Date endTime;
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActEntrustService entrustService = (ISysActEntrustService)SpringContextHolder.getBean(ISysActEntrustService.class);

    public MultiInstanceRevokeTaskCmd(HistoricTaskInstance currTask, String comment, Date endTime) {
        this.currTask = currTask;
        this.comment = comment;
        this.endTime = endTime;
    }

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        RepositoryService repositoryService = pec.getRepositoryService();
        ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().processInstanceId(this.currTask.getProcessInstanceId()).activityId(this.currTask.getTaskDefinitionKey()).list().get(0);
        TaskDefinition taskDefinition = null;
        for (ExecutionEntity executionEntity : execution.getParent().getExecutions()) {
            if (!HussarUtils.isNotEmpty((Object)executionEntity.getTasks())) continue;
            taskDefinition = ((TaskEntity)executionEntity.getTasks().get(0)).getTaskDefinition();
        }
        IdGenerator idGenerator = pec.getIdGenerator();
        execution = execution.getParent().createExecution();
        execution.setActive(true);
        execution.setConcurrent(true);
        execution.setScope(false);
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.copyTaskProperty((TaskInfo)this.currTask);
        taskEntity.setCreateTime(new Date());
        taskEntity.setTaskDefinition(taskDefinition);
        taskEntity.setExecutionId(execution.getId());
        taskEntity.setCompleteType(BpmAttribute.getTaskSourceFlag((ActivityExecution)execution));
        String taskId = idGenerator.getNextId();
        taskEntity.setId(taskId);
        taskEntity.setExecution(execution);
        Map entrustMap = this.entrustService.queryByUsers(Collections.singletonList(this.currTask.getOriginalAssignee()), this.currTask.getProcessDefinitionId().split(":")[0], this.currTask.getTaskDefinitionKey(), 0);
        if (HussarUtils.isEmpty((Object)entrustMap)) {
            taskEntity.addCandidateUser(this.currTask.getOriginalAssignee());
        } else {
            taskEntity.addEntrustCandidateUser(entrustMap);
        }
        if (HussarUtils.isNotEmpty((Object)this.currTask.getDueDate())) {
            String outTimeType;
            BpmnModel bm = repositoryService.getBpmnModel(this.currTask.getProcessDefinitionId());
            FlowElement element = bm.getFlowElement(this.currTask.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (HussarUtils.isNotEmpty((Object)this.currTask.getDueDate()) && HussarUtils.isNotEmpty((Object)timeOutStrategy) && HussarUtils.isNotEmpty((Object)(outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue()))) {
                long dueTime = this.currTask.getDueDate().getTime() - this.currTask.getCreateTime().getTime();
                taskEntity.setDueDate(new Date(taskEntity.getCreateTime().getTime() + dueTime));
                TimeOutModel timeOutModel = new TimeOutModel();
                timeOutModel.setId(Long.valueOf(Long.parseLong(taskId)));
                timeOutModel.setCreateTime(taskEntity.getCreateTime());
                timeOutModel.setDueTime(taskEntity.getDueDate());
                timeOutModel.setAssignee(this.currTask.getAssignee());
                timeOutModel.setTimeOutType(outTimeType);
                if (timeOutModel.getTimeOutType().startsWith("http")) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", taskEntity.getName());
                    map.put("processInstanceId", taskEntity.getProcessInstanceId());
                    map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
                    map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
                    map.put("formKey", taskEntity.getFormKey());
                    ExecutionEntity entity = execution.getParent();
                    while (entity.getParent() != null) {
                        entity = entity.getParent();
                    }
                    map.put("businessKey", entity.getProcessBusinessKey());
                    map.put("processName", entity.getProcessDefinition().getName());
                    map.put("todoConfiguration", taskEntity.getTodoConfiguration());
                    map.put("sendUser", taskEntity.getSendUser());
                    timeOutModel.setMap(JSON.toJSONString(map));
                }
                this.activityRedisTimerService.addTimeOutModel(timeOutModel);
            }
        }
        this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(execution, "nrOfCompletedInstances");
        int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(execution, "nrOfActiveInstances");
        MultiInstancePercentUtils.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        MultiInstancePercentUtils.setLoopVariable(execution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        return null;
    }
}

