/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.check.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.check.model.NodeMessage;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ProcessCheckUtil {
    /*
     * WARNING - void declaration
     */
    public static ApiResponse<String> checkWorkflow(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        void var8_11;
        String nodeId;
        List nodeList;
        ApiResponse<String> apiResponse;
        Map<String, NodeMessage> newNodeMessgeMap = ProcessCheckUtil.getNodeMessageMap(workFlow);
        boolean containsEnd = false;
        for (NodeMessage nodeMessage : newNodeMessgeMap.values()) {
            if (!BpmNodeTypeEnum.BPM_END.getType().equals(nodeMessage.getNodeType())) continue;
            if (containsEnd) {
                return ApiResponse.fail((String)"\u6d41\u7a0b\u4e0d\u80fd\u5b58\u5728\u591a\u4e2a\u7ed3\u675f\u8282\u70b9");
            }
            containsEnd = true;
        }
        Map<String, NodeMessage> nodeMessgeMap = ProcessCheckUtil.getNodeMessageMap(oldWorkFlow);
        HashMap<String, List<List<String>>> distributeGateWayNextNodeListMap = new HashMap<String, List<List<String>>>();
        ArrayList<String> distributeGateWayNodeIds = new ArrayList<String>();
        for (NodeMessage nodeMessage : nodeMessgeMap.values()) {
            if (nodeMessage.isDistributeGateWay()) {
                distributeGateWayNodeIds.add(nodeMessage.getNodeId());
            }
            if (!nodeMessage.isDistributeGateWay() && !nodeMessage.isMergeGateWay()) continue;
            ProcessCheckUtil.getNodeListBetweenGateWay(nodeMessgeMap, new ArrayList<String>(), nodeMessage.getNodeId(), distributeGateWayNextNodeListMap);
        }
        HashMap<String, ArrayList<List<String>>> nodeBetweenGateWay = new HashMap<String, ArrayList<List<String>>>();
        for (String nodeId2 : distributeGateWayNodeIds) {
            String target = ProcessCheckUtil.getFinalMergeNodeId(nodeMessgeMap, nodeId2);
            ArrayList<List<String>> pathBetweenGateWay = new ArrayList<List<String>>();
            ProcessCheckUtil.getNodeBetweenGateWay(distributeGateWayNextNodeListMap, nodeId2, target, new ArrayList<String>(), pathBetweenGateWay);
            nodeBetweenGateWay.put(nodeId2, pathBetweenGateWay);
        }
        ApiResponse apiResponse2 = ApiResponse.success();
        Iterator iterator = nodeBetweenGateWay.keySet().iterator();
        while (iterator.hasNext() && (apiResponse = ProcessCheckUtil.checkNodeGetOutFromGateWay(nodeList = (List)nodeBetweenGateWay.get(nodeId = (String)iterator.next()), newNodeMessgeMap)).isSuccess()) {
        }
        return var8_11;
    }

    private static ApiResponse<String> checkNodeGetOutFromGateWay(List<List<String>> nodeList, Map<String, NodeMessage> newNodeMessgeMap) {
        String start = nodeList.get(0).get(0);
        String end = nodeList.get(0).get(nodeList.get(0).size() - 1);
        Set<String> allNewNodeIds = newNodeMessgeMap.keySet();
        HashSet<String> allNodeBetweenGateWay = new HashSet<String>();
        for (List<String> list : nodeList) {
            allNodeBetweenGateWay.addAll(list);
        }
        if (!allNewNodeIds.contains(start) || !allNewNodeIds.contains(end)) {
            return ApiResponse.fail((String)"\u7981\u6b62\u5220\u9664\u5408\u5e76\u3001\u5206\u6563\u7684\u7f51\u5173");
        }
        if (!ProcessCheckUtil.checkNodeGetOutFromGatWay(allNodeBetweenGateWay, start, end, true, end, newNodeMessgeMap)) {
            return ApiResponse.fail((String)"\u5408\u5e76\u7f51\u5173\u5185\u7684\u8282\u70b9\u7981\u6b62\u79fb\u81f3\u5408\u5e76\u7f51\u5173\u5916");
        }
        if (!ProcessCheckUtil.checkNodeGetOutFromGatWay(allNodeBetweenGateWay, start, end, false, start, newNodeMessgeMap)) {
            return ApiResponse.fail((String)"\u5408\u5e76\u7f51\u5173\u5185\u7684\u8282\u70b9\u7981\u6b62\u79fb\u81f3\u5408\u5e76\u7f51\u5173\u5916");
        }
        ProcessCheckUtil.getNewCheckList(nodeList, allNewNodeIds, allNodeBetweenGateWay);
        HashSet<String> newNodes = new HashSet<String>(allNewNodeIds);
        newNodes.removeAll(allNodeBetweenGateWay);
        HashSet<String> goneNode = new HashSet<String>();
        goneNode.add(start);
        ArrayList<List<String>> allPath = new ArrayList<List<String>>();
        ArrayList<String> pathNode = new ArrayList<String>();
        pathNode.add(start);
        ProcessCheckUtil.getAllPath(newNodeMessgeMap, start, goneNode, pathNode, allPath);
        for (List list : allPath) {
            List<String> containsPath = null;
            for (List<String> node : nodeList) {
                if (!list.containsAll(node)) continue;
                containsPath = node;
                break;
            }
            if (containsPath == null) {
                if (newNodes.containsAll(list)) continue;
                HashSet nodes = new HashSet(list);
                nodes.removeAll(newNodes);
                boolean check = false;
                for (List list2 : nodeList) {
                    if (!list2.containsAll(nodes)) continue;
                    check = true;
                }
                if (check) continue;
                return ApiResponse.fail((String)"\u7981\u6b62\u4fee\u6539\u8282\u70b9\u5e76\u4e32\u884c\u5173\u7cfb");
            }
            for (List<String> node : nodeList) {
                for (String string : node) {
                    if (!list.contains(string) || containsPath.contains(string)) continue;
                    return ApiResponse.fail((String)"\u7981\u6b62\u4fee\u6539\u8282\u70b9\u5e76\u4e32\u884c\u5173\u7cfb");
                }
            }
        }
        return ApiResponse.success();
    }

    private static void getNewCheckList(List<List<String>> nodeList, Set<String> allNewNodeIds, Set<String> allNodeBetweenGateWay) {
        HashSet<String> delNode = new HashSet<String>(allNodeBetweenGateWay);
        delNode.removeAll(allNewNodeIds);
        for (int i = nodeList.size() - 1; i >= 0; --i) {
            nodeList.get(i).removeAll(delNode);
            if (nodeList.get(i).size() != 0) continue;
            nodeList.remove(i);
        }
    }

    private static boolean checkNodeGetOutFromGatWay(Set<String> allNode, String start, String end, boolean isGoToNext, String currentNode, Map<String, NodeMessage> newNodeMessgeMap) {
        NodeMessage nodeMessage = newNodeMessgeMap.get(currentNode);
        List<Object> nextCheckNode = new ArrayList();
        nextCheckNode = isGoToNext ? nodeMessage.getNextNodeIds() : nodeMessage.getPrevNodeIds();
        if (nextCheckNode.isEmpty()) {
            return true;
        }
        for (String string : nextCheckNode) {
            if (string.equals(start) || string.equals(end)) {
                return true;
            }
            if (allNode.contains(string)) {
                return false;
            }
            if (ProcessCheckUtil.checkNodeGetOutFromGatWay(allNode, start, end, isGoToNext, string, newNodeMessgeMap)) continue;
            return false;
        }
        return true;
    }

    private static void getNodeBetweenGateWay(Map<String, List<List<String>>> distributeGateWayNextNodeListMap, String start, String target, List<String> path, List<List<String>> result) {
        List<List<String>> nextNodeList = distributeGateWayNextNodeListMap.get(start);
        if (HussarUtils.isNotEmpty(nextNodeList)) {
            for (List<String> list : nextNodeList) {
                ArrayList<String> newPath = new ArrayList<String>(path);
                if (!HussarUtils.isNotEmpty(list)) continue;
                String end = list.get(list.size() - 1);
                if (end.equals(target)) {
                    newPath.addAll(list);
                    result.add(newPath);
                    continue;
                }
                newPath.addAll(list);
                newPath.remove(newPath.size() - 1);
                ProcessCheckUtil.getNodeBetweenGateWay(distributeGateWayNextNodeListMap, end, target, newPath, result);
            }
        }
    }

    private static String getFinalMergeNodeId(Map<String, NodeMessage> nodeMessgeMap, String startNode) {
        HashSet<String> goneNode = new HashSet<String>();
        goneNode.add(startNode);
        ArrayList<List<String>> allPath = new ArrayList<List<String>>();
        ProcessCheckUtil.getAllPath(nodeMessgeMap, startNode, goneNode, new ArrayList<String>(), allPath);
        List<String> finalPath = (List<String>)allPath.get(0);
        for (int i = 1; i < allPath.size(); ++i) {
            finalPath = ProcessCheckUtil.getMergePath(finalPath, (List)allPath.get(i));
        }
        if (finalPath.isEmpty()) {
            return null;
        }
        return (String)finalPath.get(0);
    }

    private static List<String> getMergePath(List<String> pathFirst, List<String> pathSecond) {
        ArrayList<String> path1 = new ArrayList<String>(pathFirst);
        ArrayList<String> path2 = new ArrayList<String>(pathSecond);
        ArrayList<String> result = new ArrayList<String>(path1);
        path1.removeAll(path2);
        path2.removeAll(result);
        result.removeAll(path1);
        result.removeAll(path2);
        return result;
    }

    private static void getAllPath(Map<String, NodeMessage> nodeMessgeMap, String currentNode, Set<String> goneNode, List<String> path, List<List<String>> allPath) {
        List<String> list = nodeMessgeMap.get(currentNode).getNextNodeIds();
        if (list.isEmpty()) {
            allPath.add(path);
        }
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            HashSet<String> newGoneNode = new HashSet<String>(goneNode);
            String next = iterator.next();
            if (!newGoneNode.add(next)) continue;
            ArrayList<String> newPath = new ArrayList<String>(path);
            newPath.add(next);
            ProcessCheckUtil.getAllPath(nodeMessgeMap, next, newGoneNode, newPath, allPath);
        }
    }

    private static Map<String, NodeMessage> getNodeMessageMap(WorkFlow workflow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workflow.getData(), FlowModel.class);
        HashMap<String, NodeMessage> result = new HashMap<String, NodeMessage>();
        List elements = flowModel.getSlots().getElement();
        for (FlowObject flowObject : elements) {
            result.put(flowObject.getInstanceKey(), new NodeMessage(flowObject.getInstanceKey(), flowObject.getName()));
        }
        List flowSequences = flowModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            String start = flowSequence.getStart().getKey();
            String end = flowSequence.getEnd().getKey();
            NodeMessage startNodeMessage = (NodeMessage)result.get(start);
            startNodeMessage.getNextNodeIds().add(end);
            NodeMessage endNodeMessage = (NodeMessage)result.get(end);
            endNodeMessage.getPrevNodeIds().add(start);
        }
        return result;
    }

    private static void getNodeListBetweenGateWay(Map<String, NodeMessage> nodeMessages, List<String> goneNodeList, String currentNodeId, Map<String, List<List<String>>> result) {
        NodeMessage nodeMessage = nodeMessages.get(currentNodeId);
        List<String> nextCheckNodes = nodeMessage.getNextNodeIds();
        for (String nextCheckNode : nextCheckNodes) {
            ArrayList<String> nodeList = new ArrayList<String>(goneNodeList);
            if (nodeList.contains(currentNodeId)) {
                return;
            }
            nodeList.add(currentNodeId);
            if (nodeMessages.get(nextCheckNode).isUnRunNode()) {
                nodeList.add(nextCheckNode);
                List nodeIds = result.computeIfAbsent((String)nodeList.get(0), (Function<String, List<List<String>>>)((Function<String, List>)k -> new ArrayList()));
                nodeIds.add(nodeList);
                continue;
            }
            ProcessCheckUtil.getNodeListBetweenGateWay(nodeMessages, nodeList, nextCheckNode, result);
        }
    }
}

