/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Func;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuIdentitylink;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuTask;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuIdentitylinkService;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuTaskService;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddHistoryTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dao.ProcessTransferMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.service.impl.AsyncTransferTask;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.vo.TransferProgressInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.processtransfer.IProcessTransferService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessTransferServiceImpl
implements IProcessTransferService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IBpmActRuIdentitylinkService identityLinkService;
    @Resource
    private IBpmActRuTaskService taskService;
    @Resource
    private ProcessTransferMapper processTransferMapper;
    @Resource
    private ProcessEngine processEngine;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Autowired
    private DataPushService dataPushService;
    private AsyncTransferTask asyncTransferTask;
    private static final int MAX_IN_LIST_SIZE = 1000;
    private static final int MAX_SERIAL_SIZE = 1;
    @Autowired
    private WorkflowSnowflakeIDGenerator idGenerator;

    @Autowired
    public void setAsyncTransferTask(AsyncTransferTask asyncTransferTask) {
        this.asyncTransferTask = asyncTransferTask;
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        if (transferDto == null || HussarUtils.hasEmpty((Object[])new Object[]{transferDto.getMandatary(), transferDto.getUserId()}) || HussarUtils.isAllEmpty((Object[])new Object[]{transferDto.getTaskIds(), transferDto.getProcessKeys()})) {
            throw new BpmException(this.bpmConstantProperties.getNotNullParamIsNull());
        }
        if (Objects.equals(transferDto.getMandatary(), transferDto.getUserId())) {
            throw new BpmException(this.bpmConstantProperties.getNoMultiTransferTaskOneself());
        }
        Set<Long> identityLinkIdSet = this.getIdentityLinkIdList(transferDto);
        Set taskIdLongSet = transferDto.getTaskIdLongSet();
        int allTaskNum = identityLinkIdSet.size() + taskIdLongSet.size();
        if (allTaskNum <= 1) {
            identityLinkIdSet.forEach(identityLinkId -> this.transferSingleTask((Long)identityLinkId, transferDto.getMandatary(), transferDto.getUserId()));
            taskIdLongSet.forEach(taskId -> this.transferSingleTaskByTaskId((Long)taskId, transferDto.getMandatary(), transferDto.getUserId()));
            return InstallResult.success();
        }
        long transferId = this.idGenerator.getSequence().nextValue();
        this.asyncTransferTask.asyncTransferTask(identityLinkIdSet, taskIdLongSet, transferDto.getMandatary(), transferDto.getUserId(), transferId);
        return InstallResult.success((Object)transferId);
    }

    private <QW extends Func<QW, R> & Join<QW>, T, R> QW buildOverSizeListWrapper(Collection<T> collection, QW qw, R column) {
        if (collection.size() <= 1000) {
            qw.in(column, collection);
        } else {
            ArrayList<T> list = collection instanceof ArrayList ? (ArrayList<T>)collection : new ArrayList<T>(collection);
            ArrayList<List<T>> queryList = new ArrayList<List<T>>();
            int size = list.size();
            for (int i = 0; i < size; i += 1000) {
                queryList.add(list.subList(i, Math.min(size, i + 1000)));
            }
            for (List list2 : queryList) {
                ((Func)((Join<QW>)qw).or()).in(column, (Collection)list2);
            }
        }
        return qw;
    }

    private Set<Long> getIdentityLinkIdList(TransferDto transferDto) {
        HashSet<Long> identityLinkIdSet = new HashSet<Long>();
        ArrayList<Long> allTaskId = new ArrayList<Long>();
        HashSet<Long> taskIdLongSet = new HashSet<Long>();
        transferDto.setTaskIdLongSet(taskIdLongSet);
        String userId = transferDto.getUserId();
        if (HussarUtils.isNotEmpty((Object)transferDto.getTaskIds())) {
            HashMap<String, List> ownerTaskMap = new HashMap<String, List>();
            for (String taskId : transferDto.getTaskIds()) {
                int i = taskId.indexOf(58);
                if (i != -1 && i != taskId.length() - 1) {
                    String owner = taskId.substring(i + 1);
                    taskId = taskId.substring(0, i);
                    ownerTaskMap.computeIfAbsent(owner, key -> new ArrayList()).add(Long.valueOf(taskId));
                } else {
                    ownerTaskMap.computeIfAbsent(null, key -> new ArrayList()).add(Long.valueOf(taskId));
                }
                allTaskId.add(Long.valueOf(taskId));
            }
            LambdaQueryChainWrapper lambdaQuery = this.identityLinkService.lambdaQuery();
            lambdaQuery.nested(queryWrapper -> {
                for (Map.Entry entry : ownerTaskMap.entrySet()) {
                    String owner = (String)entry.getKey();
                    List taskIdList = (List)entry.getValue();
                    queryWrapper.or();
                    if (owner == null) {
                        queryWrapper.isNull(BpmActRuIdentitylink::getMandator);
                    } else {
                        queryWrapper.eq(BpmActRuIdentitylink::getMandator, (Object)owner);
                    }
                    if (taskIdList.size() == 1) {
                        queryWrapper.eq(BpmActRuIdentitylink::getTaskId, taskIdList.get(0));
                        continue;
                    }
                    queryWrapper.and(qw -> this.buildOverSizeListWrapper(taskIdList, qw, BpmActRuIdentitylink::getTaskId));
                }
            });
            List identitylinkList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)lambdaQuery.eq(BpmActRuIdentitylink::getType, (Object)"candidate")).eq(BpmActRuIdentitylink::getUserId, (Object)userId)).select(new SFunction[]{BpmActRuIdentitylink::getId}).list();
            for (BpmActRuIdentitylink bpmActRuIdentitylink : identitylinkList) {
                identityLinkIdSet.add(bpmActRuIdentitylink.getId());
            }
            List taskList = this.taskService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(qw -> this.buildOverSizeListWrapper(allTaskId, qw, BpmActRuTask::getId))).eq(BpmActRuTask::getAssignee, (Object)userId));
            taskList.forEach(task -> taskIdLongSet.add(task.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)transferDto.getProcessKeys())) {
            List<Long> taskIdList;
            List<Long> identityLinkIdList = this.processTransferMapper.getIdentityLinkIdListByCondition(userId, transferDto.getProcessKeys());
            if (!identityLinkIdList.isEmpty()) {
                identityLinkIdSet.addAll(identityLinkIdList);
            }
            if (!(taskIdList = this.processTransferMapper.getTaskIdListByCondition(userId, transferDto.getProcessKeys())).isEmpty()) {
                taskIdLongSet.addAll(taskIdList);
            }
        }
        return identityLinkIdSet;
    }

    @HussarTransactional
    public void transferSingleTask(Long identityLinkId, String mandatary, String userId) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            IdentityLinkEntity identityLink = (IdentityLinkEntity)commandContext.getDbSqlSession().selectById(IdentityLinkEntity.class, identityLinkId.toString());
            if (identityLink == null) {
                throw new BpmException("\u65e0\u6743\u5904\u7406\u8be5\u4efb\u52a1\uff01");
            }
            if (!Objects.equals(identityLink.getUserId(), userId)) {
                throw new BpmException("\u65e0\u6743\u529e\u7406\u8be5\u4efb\u52a1\uff01");
            }
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(identityLink.getTaskId());
            if (task == null) {
                throw new BpmException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
            }
            if (TaskType.isAssist((String)task.getTaskType())) {
                throw new BpmException(this.bpmConstantProperties.getAssistTaskWithErrorHandle());
            }
            Iterator iterator = task.getIdentityLinks().iterator();
            while (iterator.hasNext()) {
                IdentityLinkEntity next = (IdentityLinkEntity)iterator.next();
                if (!next.getId().equals(identityLink.getId())) continue;
                iterator.remove();
                commandContext.getIdentityLinkEntityManager().deleteIdentityLink(next, true);
                break;
            }
            String owner = identityLink.getMandator() == null ? userId : identityLink.getMandator();
            task.addCandidateUser(mandatary, Objects.equals(owner, mandatary) ? null : owner, "3");
            this.subsequent(mandatary, userId, commandContext, task, owner);
            return null;
        });
    }

    private void subsequent(final String mandatary, String userId, CommandContext commandContext, TaskEntity task, final String owner) {
        String taskId = task.getId();
        new AddHistoryTaskCmd(task, null, userId, "multiTransfer"){
            {
                super(task, comment, userId, taskType);
                this.endTime = this.startTime;
            }

            @Override
            protected TaskEntity initTask(CommandContext commandContext, TaskEntity task, ExecutionEntity execution) {
                TaskEntity taskEntity = super.initTask(commandContext, task, execution);
                taskEntity.setTaskType("6");
                taskEntity.setParentTaskId(task.getId());
                taskEntity.setOwner(owner);
                taskEntity.setReceiver(mandatary);
                return taskEntity;
            }
        }.execute(commandContext);
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, userId, 0);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.sysActUrgeTaskService.lambdaUpdate().eq(SysActUrgeTask::getTaskId, (Object)Long.parseLong(taskId))).eq(SysActUrgeTask::getReceiveUser, (Object)userId)).set(SysActUrgeTask::getReceiveUser, (Object)mandatary);
        this.dataPushService.entrustDataPush((Task)task, userId, mandatary);
    }

    @HussarTransactional
    public void transferSingleTaskByTaskId(Long taskId, String mandatary, String userId) {
        this.processEngine.getManagementService().executeCommand(commandContext -> {
            TaskEntity task = commandContext.getTaskEntityManager().findTaskById(String.valueOf(taskId));
            if (task == null) {
                throw new BpmException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
            }
            task.setAssignee(null);
            task.addCandidateUser(userId, userId, "3");
            this.subsequent(userId, mandatary, commandContext, task, userId);
            return null;
        });
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        TransferProgressInfo transferProgressInfo = (TransferProgressInfo)HussarCacheUtil.get((String)"transferProgressInfo", (Object)transferId);
        if (transferProgressInfo == null) {
            return InstallResult.success();
        }
        return InstallResult.success((Object)transferProgressInfo);
    }
}

