/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ApprovalExtendPropertiesVo;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.dao.SysActExtendPropertiesMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.constant.ApprovalTypeEnum;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysActExtendPropertiesServiceImpl
extends HussarServiceImpl<SysActExtendPropertiesMapper, SysActExtendProperties>
implements ISysActExtendPropertiesService {
    @Resource
    SysActExtendPropertiesMapper sysActExtendPropertiesMapper;

    @Cacheable(value={"task_extend_properties"}, key="#processDefId + #taskDefKey", unless="#result == null")
    public SysActExtendProperties queryList(String taskDefKey, String processDefId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefKey);
        ew.eq(SysActExtendProperties::getProcDefId, (Object)processDefId);
        SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)this.sysActExtendPropertiesMapper.selectOne((Wrapper)ew);
        return sysActExtendProperties;
    }

    @CacheEvict(value={"task_extend_properties_list", "task_extend_properties"}, allEntries=true)
    public boolean updateBatchById(Collection<SysActExtendProperties> entityList) {
        return super.updateBatchById(entityList);
    }

    @Cacheable(value={"form_detail_key"}, key="'form_detail_key:'+#processDefinitionId+'-'+#taskDefinitionKey", unless="#result == null || #result == ''")
    public String getFormDetailKey(String processDefinitionId, String taskDefinitionKey) {
        String formDetailKey = null;
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId)).eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefinitionKey);
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesMapper.selectOne((Wrapper)extendPropertiesWrapper);
        if (ToolUtil.isNotEmpty((Object)extendProperties)) {
            formDetailKey = String.valueOf(extendProperties.getFormDetailKey());
        }
        return formDetailKey;
    }

    public JSONArray getApprovalType(String procDefId, String taskDefKey) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysActExtendProperties::getProcDefId, (Object)procDefId);
        ew.eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefKey);
        SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)this.sysActExtendPropertiesMapper.selectOne((Wrapper)ew);
        if (HussarUtils.isEmpty((Object)sysActExtendProperties)) {
            return new JSONArray();
        }
        return ApprovalTypeEnum.approvalTypeMap((String)sysActExtendProperties.getApprovalType());
    }

    public ApprovalExtendPropertiesVo getApprovalExtendProperties(String procDefKey, String taskDefKey) {
        ApprovalExtendPropertiesVo approvalExtendPropertiesVo = new ApprovalExtendPropertiesVo();
        SysActExtendProperties extendProperties = this.queryList(taskDefKey.startsWith("jxd_bpm_custom_node") ? taskDefKey.split("-")[3] : taskDefKey, procDefKey);
        BeanUtils.copyProperties((Object)extendProperties, (Object)approvalExtendPropertiesVo);
        return approvalExtendPropertiesVo;
    }

    @Cacheable(value={"task_extend_properties_list"}, key="#procDefId", unless="#result == null")
    public List<SysActExtendProperties> queryList(String procDefId) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysActExtendProperties::getProcDefId, (Object)procDefId)).list();
    }

    @Cacheable(value={"process_has_alter_task"}, key="#procDefId", unless="#result == null")
    public boolean hasAlterTask(String procDefId) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SysActExtendProperties::getProcDefId, (Object)procDefId)).list();
        if (HussarUtils.isEmpty((Object)list)) {
            return false;
        }
        return list.stream().anyMatch(a -> HussarUtils.isNotEmpty((Object)a.getAllowAlterTask()) || HussarUtils.isNotEmpty((Object)a.getAllowAlterTaskToOther()));
    }
}

