/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganOrPostInfo;
import com.jxdinfo.hussar.workflow.assignee.model.Personnel;
import com.jxdinfo.hussar.workflow.assignee.model.SysDepartment;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.assignee.model.UserMainInfo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeDSChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssignModeChooseServiceImpl
implements IAssigneeModeChooseService {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private IAssigneeDSChooseService assigneeDSChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    public static final String IMPORT = "import";
    public static final String REMOTE_INTERFACE = "remote-interface";
    public static final String REMOTE_DATA_SOURCE = "remote-datasource";

    private String connName() {
        return this.lcdpBpmProperties.getRemoteDBName();
    }

    private String getAssigneeMode() {
        return this.lcdpBpmProperties.getAssigneeMode();
    }

    private boolean getIdType() {
        String assigneeModel = this.getAssigneeMode();
        if (IMPORT.equals(assigneeModel)) {
            return !"workflow-platform".equals(this.lcdpBpmProperties.getDeploymentModel());
        }
        return this.lcdpBpmProperties.getTenantDBPrimaryKeyIsLong();
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userTree(id, isMainPost, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("isMainPost", JSON.toJSONString((Object)isMainPost));
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userTree(id, isMainPost, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> deptTree(String id, String organId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.deptTree(id, organId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/deptTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("organId", organId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.deptTree(id, organId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> deptTrees() {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.deptTrees();
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/deptTree";
                url = this.dealPath(url);
                String result2 = HttpClient.doGet((String)url, null);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.deptTrees(this.connName());
    }

    public List<BpmTreeModel> roleTree() {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree();
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTreeWithOutId";
                url = this.dealPath(url);
                HashMap params = new HashMap();
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(this.connName());
    }

    public List<BpmTreeModel> roleTree(String id, String roleId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.roleTree(id, roleId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/roleTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", id);
                params.put("roleId", roleId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result2 = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result2)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result2, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.roleTree(id, roleId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> userDeptDetail(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDeptDetail(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDeptDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDeptDetail(userId, this.connName(), this.getIdType());
    }

    public List<String> getCandidateUsers(String condition, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUser";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<String>();
                }
                return JSONArray.parseArray((String)result, String.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUser(condition, securityLevel, this.connName());
    }

    public List<BpmTreeModel> getCandidateUsersWithParent(String condition, Integer securityLevel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getCandidateUserWithParent";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("condition", condition);
                params.put("securityLevel", securityLevel == null ? null : securityLevel.toString());
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.getCandidateUserWithParent(condition, securityLevel, this.connName());
    }

    public String getParentDeptIdByUserId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserId(userId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> userDetail(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDetail(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.userDetail(userIds, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> organDetail(List<String> organIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.userDetail(organIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/userDetail";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = organIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.organDetail(organIds, this.connName(), this.getIdType());
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserId(userId, this.connName(), this.getIdType());
    }

    public String getDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public String getUserIdByUserAccount(String userCode) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserIdByUserAccount(userCode);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserIdByUserAccount";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userCode", userCode);
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getUserIdByUserAccount(userCode, this.connName());
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSameLevelDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getSameLevelDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public String getParentDeptIdByUserIds(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getParentDeptIdByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                return HttpClient.doGet((String)url, params);
            }
        }
        return this.assigneeDSChooseService.getParentDeptIdByUserIds(userId, this.connName(), this.getIdType());
    }

    public Integer getSecurityLevel(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getSecurityLevel(userId, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getSecurityLevel";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", userId);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return Integer.parseInt(result);
            }
        }
        return this.assigneeDSChooseService.getSecurityLevel(userId, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByDeptName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByDeptName(organName, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTreeByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeByUserName(organName, this.connName());
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByUserName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTreeByUserName(organName, this.connName());
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRoleTreeByRoleName";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("roleName", roleName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryRoleTreeByRoleName(roleName, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryUserTree(String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserTree(organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserTree";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return new ArrayList<BpmTreeModel>();
                }
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryUserTree(organName, this.connName());
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, String organId, String type) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryUserListByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                if (StringUtil.isEmpty((String)result)) {
                    return pages;
                }
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryUserListByPage(pages, organId, type, this.connName(), this.getIdType());
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDeptTreeByChildren";
                url = this.dealPath(url);
                Map params = new HashMap();
                params = (Map)JSON.parseObject((String)JSON.toJSONString((Object)bpmTreeModel), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryDeptTreeByChildren(bpmTreeModel, this.connName());
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryAssigneeAndDept";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = users.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("users", newUserIds);
                params.put("organName", organName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmTreeModel.class);
            }
        }
        return this.assigneeDSChooseService.queryAssigneeAndDept(users, organName, this.connName(), this.getIdType());
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> userIds, String organId, String type) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, userIds, organId, type, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("userIds", String.join((CharSequence)",", userIds));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListByPage(pages, userIds, organId, type, this.connName(), this.getIdType());
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> userIds, String organId, String type, String organName) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, organId, type, this.getIdType(), organName);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryNodeAssigneeListWithParentByPage";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("size", String.valueOf(pages.getSize()));
                params.put("current", String.valueOf(pages.getCurrent()));
                params.put("userIds", JSON.toJSONString(userIds));
                params.put("organId", organId);
                params.put("type", type);
                params.put("longIdType", String.valueOf(this.getIdType()));
                params.put("organName", organName);
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryNodeAssigneeListWithParentByPage(pages, userIds, organId, type, this.connName(), this.getIdType(), organName);
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserAndAccountListByUserId";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = "";
                if (HussarUtils.isNotEmpty(userIds)) {
                    newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, AssigneeChooseDto.class);
            }
        }
        return this.assigneeDSChooseService.getUserAndAccountListByUserId(userIds, this.connName(), this.getIdType());
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserMsgByUserIds(userIds, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/getUserMsgByUserIds";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String newUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                params.put("userIds", newUserIds);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return JSONArray.parseArray((String)result, BpmUserInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.getUserMsgByUserIds(userIds, this.connName(), this.getIdType());
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryList(page, getListDto, this.getIdType());
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/list";
                url = this.dealPath(url);
                HashMap<String, String> params = new HashMap<String, String>();
                String userName = getListDto.getUserName();
                String deptId = getListDto.getDeptId();
                String roleId = getListDto.getRoleId();
                String deptName = getListDto.getDeptName();
                String roleName = getListDto.getRoleName();
                params.put("size", String.valueOf(page.getSize()));
                params.put("current", String.valueOf(page.getCurrent()));
                params.put("userName", userName);
                params.put("deptId", deptId);
                params.put("roleId", roleId);
                params.put("deptName", deptName);
                params.put("roleName", roleName);
                params.put("longIdType", String.valueOf(this.getIdType()));
                String result = HttpClient.doGet((String)url, params);
                return (Page)JSON.parseObject((String)result, Page.class);
            }
        }
        return this.assigneeDSChooseService.queryList(page, getListDto, this.connName(), this.getIdType());
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryDept(name);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryDept";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryDept(name, this.connName());
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.queryRole(name);
            }
            case "remote-interface": {
                String url = "/hussarBpm/assignee/obtain/queryRole";
                url = this.dealPath(url);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("name", name);
                String result = HttpClient.doGet((String)url, param);
                return JSONArray.parseArray((String)result, AssigneeManageInfoVo.class);
            }
        }
        return this.assigneeDSChooseService.queryRole(name, this.connName());
    }

    public List<UserDepartmentAndPostModel> getUserMainInfo(Collection<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserMainInfo(userIds);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserMainInfo(userIds, this.connName());
    }

    public Map<String, Object> getDeptParamsByUserId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDeptParamsByUserId(userId);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getDeptParamsByUserId(userId, this.connName());
    }

    public List<Personnel> getPersonnelByDepartmentId(String organType, String departmentId) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getPersonnelByDepartmentId(organType, departmentId);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getPersonnelByDepartmentId(organType, departmentId, this.connName());
    }

    public List<Personnel> getPersonnelByUserName(String userName) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getPersonnelByUserName(userName);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getPersonnelByUserName(userName, this.connName());
    }

    public List<UserDepartmentAndPostModel> getUserDepartmentAndPostModelByUserIds(List<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserDepartmentAndPostModelByUserIds(userIds, this.connName());
    }

    public List<UserMainInfo> getUserOutMainInfo(HashSet<String> userIds, String userIdType) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserOutMainInfo(userIds, userIdType);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserOutMainInfo(userIds, userIdType, this.connName());
    }

    public List<OrganOrPostInfo> getUserOutOrganInfo(HashSet<String> userIds, String userIdType) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserOutOrganInfo(userIds, userIdType);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserOutOrganInfo(userIds, userIdType, this.connName());
    }

    public List<OrganOrPostInfo> getUserOutPostInfo(HashSet<String> userIds) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserOutPostInfo(userIds);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserOutPostInfo(userIds, this.connName());
    }

    public List<Map<String, Object>> getDepartmentNameBydepartmentIds(List<String> departmentIds) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDepartmentNameBydepartmentIds(departmentIds);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getDepartmentNameBydepartmentIds(departmentIds, this.connName());
    }

    public List<Map<String, Object>> getPostNameBypostIds(List<String> postIds) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getPostNameBypostIds(postIds);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getPostNameBypostIds(postIds, this.connName());
    }

    public List<Map<String, String>> getDepartmentIdAndPost(List<String> postIdList, List<String> postOrganIdList, List<String> userIdList) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getDepartmentIdAndPost(postIdList, postOrganIdList, userIdList, this.connName());
    }

    public List<Map<String, String>> getAllOrgansBysk() {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getAllOrgansBysk();
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getAllOrgansBysk(this.connName());
    }

    public List<UserDepartmentAndPostModel> getUserInfoByPost(List<String> departmentIdList, List<Long> postIdList) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserInfoByPost(departmentIdList, postIdList);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserInfoByPost(departmentIdList, postIdList, this.connName());
    }

    public Collection<String> getUserIdsByUserName(String userName) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserIdsByUserName(userName);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserIdsByUserName(userName, this.connName());
    }

    public Collection<String> getPostIdsByPostName(String postName) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getPostIdsByPostName(postName);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getPostIdsByPostName(postName, this.connName());
    }

    public Collection<String> getDeptIdsByDeptName(String deptName) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDeptIdsByDeptName(deptName);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getDeptIdsByDeptName(deptName, this.connName());
    }

    public String getUserIdByUserNumber(String userNumber) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getUserIdByUserNumber(userNumber);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getUserIdByUserNumber(userNumber, this.connName());
    }

    public List<BpmTreeModel> deptName(List<Long> ids) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.deptName(ids);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.deptName(ids, this.connName());
    }

    public List<String> getListStringSqlResult(String sql) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getListStringSqlResult(sql);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getListStringSqlResult(sql, this.connName());
    }

    public List<Map<String, String>> getListMapSqlResult(String sql) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getListMapSqlResult(sql);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getListMapSqlResult(sql, this.connName());
    }

    public Boolean getBooleanSqlResult(String sql) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getBooleanSqlResult(sql);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getBooleanSqlResult(sql, this.connName());
    }

    public String getParentId(String userId) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getparentId(userId);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getParentId(userId, this.connName());
    }

    public List<SysDepartment> getDepartmentList() {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getDepartmentList();
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getDepartmentList(this.connName());
    }

    public String getOrganIdByOutOrganId(String outOrganId) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getOrganIdByOutOrganId(outOrganId);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getOrganIdByOutOrganId(outOrganId, this.connName());
    }

    public String getOrganIdByOutStruId(String outStruId) {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.getOrganIdByOutStruId(outStruId);
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.getOrganIdByOutStruId(outStruId, this.connName());
    }

    public List<BpmTreeModel> postTree() {
        String assigneeModel;
        switch (assigneeModel = this.lcdpBpmProperties.getAssigneeMode()) {
            case "import": {
                return this.workflowAssigneeChooseService.postTree();
            }
            case "remote-interface": {
                throw new HussarException("\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6e90\u6216\u5bfc\u5165\u6a21\u5f0f\u83b7\u53d6\u4eba\u5458\u4fe1\u606f");
            }
        }
        return this.assigneeDSChooseService.postTree(this.connName());
    }
}

