/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.migration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.model.AlternativeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.alternativetask.service.IAlternativeTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.model.BpmBusinessModule;
import com.jxdinfo.hussar.workflow.engine.bpm.businessmodule.service.ISysBusinessModuleService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.util.TreeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ImportDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.vo.ProcessDefinitionVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActPostAction;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActPostActionService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.formdata.model.SysActFormData;
import com.jxdinfo.hussar.workflow.engine.bpm.formdata.service.SysActFormDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowLoadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowPreloadDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.IWorkflowMigrationService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowLoadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowMigrationPreloadVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.WorkflowMigrationMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.model.SysActProcessDept;
import com.jxdinfo.hussar.workflow.engine.bpm.processdept.service.ISysActProcessDeptService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.model.ProcessGroup;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.service.IProcessGroupService;
import com.jxdinfo.hussar.workflow.engine.bpm.processgroup.vo.ProcessGroupVo;
import com.jxdinfo.hussar.workflow.engine.bpm.rectification.model.BpmActRectificationAction;
import com.jxdinfo.hussar.workflow.engine.bpm.rectification.model.ReturnToRectification;
import com.jxdinfo.hussar.workflow.engine.bpm.rectification.service.IRectificationAction;
import com.jxdinfo.hussar.workflow.engine.bpm.rectification.service.IReturnToRectificationService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class WorkflowMigrationServiceImpl
implements IWorkflowMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActHandleAuthService handleAuthService;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private ModelMapper modelMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private WorkflowMigrationMapper workflowMigrationMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private IAlternativeTaskService alternativeTaskService;
    @Autowired
    private ISysActCcTaskConfigService ccTaskConfigService;
    @Autowired
    private ISysActPostActionService postActionService;
    @Autowired
    private ISysBusinessModuleService businessModuleService;
    @Autowired
    private SysActFormDataService formDataService;
    @Autowired
    private IReturnToRectificationService returnToRectificationService;
    @Autowired
    private IRectificationAction rectificationAction;
    @Autowired
    private ISysBusinessModuleService sysBusinessModuleService;
    @Autowired
    private IProcessGroupService processGroupService;
    @Autowired
    private ISysActProcessDeptService sysActProcessDeptService;

    public List<WorkflowDumpVo> dump(List<WorkflowDumpDto> workflowDumpDtos) {
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            processKeys.add(workflowDumpDto.getProcessKey());
        }
        List<ExportModel> list = this.modelMapper.selectModelNames(processKeys);
        HashMap<String, String> serviceNameMap = new HashMap<String, String>();
        for (ExportModel exportModel : list) {
            serviceNameMap.put(exportModel.getBusinessId(), exportModel.getCategory());
        }
        ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
        for (WorkflowDumpDto workflowDumpDto : workflowDumpDtos) {
            WorkflowDumpVo workflowDumpVo;
            String processKey = workflowDumpDto.getProcessKey();
            int version = workflowDumpDto.getVersion();
            if (workflowDumpDto.getExportData().getAssigneeData().booleanValue()) {
                List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).eq(SysActAssignee::getProcessVersion, (Object)version));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActAssignees), "\u53c2\u4e0e\u8005.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getFormAuthData().booleanValue()) {
                List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)processKey)).eq(SysActFormAuth::getProcessVersion, (Object)version));
                workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActFormAuths), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(workflowDumpVo);
            }
            if (workflowDumpDto.getExportData().getWorkflowData().booleanValue()) {
                List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)workflowDumpDto.getProcessDefId()));
                WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActExtendProperties), "\u62d3\u5c55.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(extendPropertiesDumpVo);
                List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)workflowDumpDto.getProcessDefId()));
                WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActProcessFiles), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(sysActProcessFilesDumpVo);
                InputStream resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(workflowDumpDto.getProcessDefId());
                String xmlByteString = null;
                try {
                    int temp;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    while ((temp = resourceAsStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, temp);
                    }
                    byte[] finalBytes = outputStream.toByteArray();
                    xmlByteString = new String(finalBytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(workflowDumpDto, xmlByteString, "bpmn20.xml", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(xmlDumpVo);
                List sysActPostActions = ((LambdaQueryChainWrapper)this.postActionService.lambdaQuery().eq(SysActPostAction::getProcDefId, (Object)workflowDumpDto.getProcessDefId())).list();
                WorkflowDumpVo postActionDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)sysActPostActions), "\u540e\u7f6e\u52a8\u4f5c\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(postActionDumpVo);
                List ccTaskConfigList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.ccTaskConfigService.lambdaQuery().eq(SysActCcTaskConfig::getProcDefKey, (Object)processKey)).eq(SysActCcTaskConfig::getProcVersion, (Object)version)).list();
                WorkflowDumpVo ccTaskConfigDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)ccTaskConfigList), "\u6284\u9001\u914d\u7f6e\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(ccTaskConfigDumpVo);
                List alternativeTaskList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.alternativeTaskService.lambdaQuery().eq(AlternativeTask::getProcessKey, (Object)processKey)).eq(AlternativeTask::getProcessDefinitionVersion, (Object)version)).list();
                WorkflowDumpVo alternativeTaskDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)alternativeTaskList), "\u5907\u9009\u8282\u70b9\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(alternativeTaskDumpVo);
                List formDataList = ((LambdaQueryChainWrapper)this.formDataService.lambdaQuery().eq(SysActFormData::getProcessId, (Object)workflowDumpDto.getProcessDefId())).list();
                WorkflowDumpVo formDataDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)formDataList), "\u8fd4\u56de\u6574\u6539\u8868\u5355\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(formDataDumpVo);
                ReturnToRectification returnToRectification = this.returnToRectificationService.selectByProcessId(workflowDumpDto.getProcessDefId());
                List<ReturnToRectification> returnToRectificationList = null;
                if (returnToRectification != null) {
                    returnToRectificationList = Collections.singletonList(returnToRectification);
                }
                WorkflowDumpVo returnToRectificationDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(returnToRectificationList), "\u8fd4\u56de\u6574\u6539\u914d\u7f6e\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(returnToRectificationDumpVo);
                BpmActRectificationAction rectificationAct = this.rectificationAction.selectByProcessId(workflowDumpDto.getProcessDefId());
                List<BpmActRectificationAction> rectificationActions = null;
                if (rectificationAct != null) {
                    rectificationActions = Collections.singletonList(rectificationAct);
                }
                WorkflowDumpVo rectificationActionDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(rectificationActions), "\u8fd4\u56de\u6574\u6539\u52a8\u4f5c\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(rectificationActionDumpVo);
                String businessModuleId = workflowDumpDto.getBusinessModuleId();
                List allBpmBusinessModules = this.sysBusinessModuleService.list();
                List<BpmBusinessModule> bpmBusinessModules = null;
                if (allBpmBusinessModules != null) {
                    bpmBusinessModules = this.neatenBusinessModulesTree(allBpmBusinessModules, businessModuleId);
                }
                WorkflowDumpVo bpmBusinessModuleDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(bpmBusinessModules), "\u4e1a\u52a1\u6a21\u5757\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(bpmBusinessModuleDumpVo);
                ProcessExtendProperties processExtendProperties = (ProcessExtendProperties)((LambdaQueryChainWrapper)this.processDefinitionsService.lambdaQuery().eq(ProcessExtendProperties::getId, (Object)workflowDumpDto.getProcessDefId())).one();
                List<ProcessExtendProperties> processExtendPropertiesList = null;
                if (processExtendProperties != null) {
                    processExtendPropertiesList = Collections.singletonList(processExtendProperties);
                }
                WorkflowDumpVo processExtendPropertiesDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString(processExtendPropertiesList), "\u6d41\u7a0b\u5b9a\u4e49\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(processExtendPropertiesDumpVo);
                String procGroupNumber = processExtendProperties.getProcGroupNumber();
                List processGroupList = ((LambdaQueryChainWrapper)this.processGroupService.lambdaQuery().eq(ProcessGroup::getGroupNumber, (Object)procGroupNumber)).list();
                WorkflowDumpVo processGroupDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)processGroupList), "\u6d41\u7a0b\u5206\u7ec4\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(processGroupDumpVo);
                List processDepts = ((LambdaQueryChainWrapper)this.sysActProcessDeptService.lambdaQuery().eq(SysActProcessDept::getProcGroupNumber, (Object)procGroupNumber)).list();
                WorkflowDumpVo processDeptDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)processDepts), "\u6d41\u7a0b\u90e8\u95e8\u6587\u4ef6.json", (String)serviceNameMap.get(processKey));
                workflowDumpVoList.add(processDeptDumpVo);
            }
            if (!workflowDumpDto.getExportData().getHandleAuthData().booleanValue()) continue;
            List handleAuthList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.handleAuthService.lambdaQuery().eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).list();
            workflowDumpVo = new WorkflowDumpVo(workflowDumpDto, IdempotentJsonUtils.toString((Object)handleAuthList), "\u8868\u5355\u6743\u9650.json", (String)serviceNameMap.get(processKey));
            workflowDumpVoList.add(workflowDumpVo);
        }
        return workflowDumpVoList;
    }

    private List<BpmBusinessModule> neatenBusinessModulesTree(List<BpmBusinessModule> allBpmBusinessModules, String businessModuleId) {
        return TreeUtil.nodeToFlatTree(Collections.singletonList(Long.parseLong(businessModuleId)), allBpmBusinessModules, BpmBusinessModule::getParentId, BpmBusinessModule::getBusinessModuleId);
    }

    public List<WorkflowMigrationPreloadVo> preload(List<WorkflowPreloadDto> workflowPreloadDtos) {
        ArrayList<WorkflowMigrationPreloadVo> result = new ArrayList<WorkflowMigrationPreloadVo>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            processKeys.add(workflowPreloadDto.getProcessKey());
        }
        List<DefinitionModel> list = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DefinitionModel definitionModel : list) {
            map.put(definitionModel.getMykey(), Integer.parseInt(definitionModel.getVersion()));
        }
        for (WorkflowPreloadDto workflowPreloadDto : workflowPreloadDtos) {
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = new WorkflowMigrationPreloadVo(workflowPreloadDto, (Integer)map.get(workflowPreloadDto.getProcessKey()));
            result.add(workflowMigrationPreloadVo);
        }
        return result;
    }

    @CacheEvict(value={"assignee_info", "task_extend_properties_list", "task_extend_properties", "task_url", "post_action", "workflow_file_by_key", "workflow_file_by_id", "get_file_by_process_key_and_id"}, allEntries=true)
    public List<WorkflowLoadVo> load(WorkflowLoadDto workflowLoadDto) {
        this.importAssignee(workflowLoadDto);
        this.importFormAuth(workflowLoadDto);
        this.importHandleAuth(workflowLoadDto);
        Map importMap = workflowLoadDto.getImportMsgMap();
        Map serviceNameMap = workflowLoadDto.getServiceNameMap();
        if (importMap != null) {
            for (String processKey : importMap.keySet()) {
                Map workflowFile = (Map)workflowLoadDto.getWorkflowFiles().get(processKey);
                if (workflowFile == null) continue;
                String lcpbBpmFile = (String)workflowFile.get("\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
                String xml = (String)workflowFile.get("bpmn20.xml");
                String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
                if ("unable".equals(type)) continue;
                this.importModel(xml, lcpbBpmFile, (String)serviceNameMap.get(processKey), "override".equals(type));
            }
        }
        this.importExtendProperties(workflowLoadDto);
        this.importPostActions(workflowLoadDto);
        this.importCcTaskConfigs(workflowLoadDto);
        this.importAlternativeTasks(workflowLoadDto);
        this.importFormDatas(workflowLoadDto);
        this.importReturnToRectifications(workflowLoadDto);
        this.importRectificationActions(workflowLoadDto);
        this.importBusinessModules(workflowLoadDto);
        this.importProcessGroups(workflowLoadDto);
        this.importProcessDepts(workflowLoadDto);
        this.importProcessDefinitions(workflowLoadDto);
        ArrayList<WorkflowLoadVo> workflowLoadVos = new ArrayList<WorkflowLoadVo>();
        for (WorkflowMigrationPreloadVo workflowMigrationPreloadVo : workflowLoadDto.getImportMsgs()) {
            workflowLoadVos.add(new WorkflowLoadVo(workflowMigrationPreloadVo));
        }
        return workflowLoadVos;
    }

    private void importAssignee(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importAssignee = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getAssigneeData().booleanValue()) continue;
            importAssignee.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importAssignee.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.sysActAssigneeService.lambdaUpdate();
            for (Map.Entry entry : importAssignee.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActAssignee::getProcDefKey, formAuthImport.getKey())).eq(SysActAssignee::getProcessVersion, formAuthImport.getValue());
                });
            }
            removeWrapper.remove();
            if (!workflowLoadDto.getAssigneeMsgs().isEmpty()) {
                ArrayList actAssignees = new ArrayList();
                for (String assignee : workflowLoadDto.getAssigneeMsgs()) {
                    actAssignees.addAll(JSON.parseArray((String)assignee, SysActAssignee.class));
                }
                if (!actAssignees.isEmpty()) {
                    for (SysActAssignee sysActAssignee : actAssignees) {
                        sysActAssignee.setId(null);
                    }
                    this.sysActAssigneeService.saveBatch(actAssignees);
                }
            }
        }
    }

    private void importFormAuth(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importFormAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getFormAuthData().booleanValue()) continue;
            importFormAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importFormAuth.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.sysActFormAuthService.lambdaUpdate();
            for (Map.Entry entry : importFormAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActFormAuth::getProcessKey, formAuthImport.getKey())).eq(SysActFormAuth::getProcessVersion, formAuthImport.getValue());
                });
            }
            removeWrapper.remove();
            if (!workflowLoadDto.getFormAuthMsgs().isEmpty()) {
                ArrayList formAuths = new ArrayList();
                for (String formAuth : workflowLoadDto.getFormAuthMsgs()) {
                    formAuths.addAll(JSON.parseArray((String)formAuth, SysActFormAuth.class));
                }
                if (!formAuths.isEmpty()) {
                    for (String formAuth : formAuths) {
                        formAuth.setId(null);
                    }
                    this.sysActFormAuthService.saveBatch(formAuths);
                }
            }
        }
    }

    private void importHandleAuth(WorkflowLoadDto workflowLoadDto) {
        HashMap<String, Integer> importHandleAuth = new HashMap<String, Integer>();
        for (Object workflow : workflowLoadDto.getImportMsgs()) {
            if (!workflow.getExportData().getHandleAuthData().booleanValue()) continue;
            importHandleAuth.put(workflow.getProcessKey(), workflow.getImportVersion());
        }
        if (!importHandleAuth.isEmpty()) {
            LambdaUpdateChainWrapper removeWrapper = this.handleAuthService.lambdaUpdate();
            for (Map.Entry entry : importHandleAuth.entrySet()) {
                removeWrapper.or(wp -> {
                    LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)wp.eq(SysActHandleAuth::getProcessKey, formAuthImport.getKey())).eq(SysActHandleAuth::getProcessVersion, formAuthImport.getValue());
                });
            }
            if (!workflowLoadDto.getHandleAuthMsgs().isEmpty()) {
                ArrayList handleAuths = new ArrayList();
                for (String handleAuth : workflowLoadDto.getHandleAuthMsgs()) {
                    handleAuths.addAll(JSON.parseArray((String)handleAuth, SysActHandleAuth.class));
                }
                if (!handleAuths.isEmpty()) {
                    this.handleAuthService.saveBatch(handleAuths);
                }
            }
        }
    }

    private void importExtendProperties(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList<Map<String, Object>> process = new ArrayList<Map<String, Object>>();
        ArrayList newSysActExtendProperties = new ArrayList();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties)) continue;
            String processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
            String processKey = processId.split(":")[0];
            Integer version = Integer.parseInt(processId.split(":")[1]);
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = (WorkflowMigrationPreloadVo)importMap.get(processKey);
            String importType = workflowMigrationPreloadVo.getImportType();
            if ("unable".equals(importType)) continue;
            HashMap<String, Object> processMap = new HashMap<String, Object>();
            processMap.put("processKey", processKey);
            processMap.put("version", version);
            process.add(processMap);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (!process.isEmpty()) {
            List<ImportDefinitionModel> newProcessMap = this.processDefinitionsMapper.getProcessDefinitions(process);
            for (ImportDefinitionModel importDefinitionModelMap : newProcessMap) {
                map.put(importDefinitionModelMap.getProcessKey(), importDefinitionModelMap.getProcessDefinition());
            }
        }
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String extendPropertie : workflowLoadDto.getExpandMsgs()) {
            List extendProperties = JSON.parseArray((String)extendPropertie, SysActExtendProperties.class);
            if (HussarUtils.isEmpty((Object)extendProperties)) continue;
            String processId = ((SysActExtendProperties)extendProperties.get(0)).getProcDefId();
            String proDefKey = processId.split(":")[0];
            WorkflowMigrationPreloadVo workflowMigrationPreloadVo = (WorkflowMigrationPreloadVo)importMap.get(proDefKey);
            String type = ((WorkflowMigrationPreloadVo)importMap.get(proDefKey)).getImportType();
            if ("unable".equals(type)) continue;
            String procDefId = (String)map.get(proDefKey);
            importProcessIds.add(procDefId);
            for (SysActExtendProperties sysActExtendProperties : extendProperties) {
                sysActExtendProperties.setProcDefId((String)map.get(proDefKey));
                sysActExtendProperties.setId(null);
            }
            newSysActExtendProperties.addAll(extendProperties);
        }
        if (newSysActExtendProperties.isEmpty()) {
            return;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, importProcessIds);
        this.sysActExtendPropertiesService.remove((Wrapper)lambdaQueryWrapper);
        this.sysActExtendPropertiesService.saveBatch(newSysActExtendProperties);
    }

    private void importPostActions(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newPostActions = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String postActionMsg : workflowLoadDto.getPostActionMsgs()) {
            List postActions = JSON.parseArray((String)postActionMsg, SysActPostAction.class);
            if (!HussarUtils.isNotEmpty((Object)postActions)) continue;
            String processDefinitionId = ((SysActPostAction)postActions.get(0)).getProcDefId();
            String processKey = processDefinitionId.split(":")[0];
            Integer version = Integer.parseInt(processDefinitionId.split(":")[1]);
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (SysActPostAction postAction : postActions) {
                postAction.setProcDefId(newProcessDefinitionId);
                postAction.setId(null);
            }
            newPostActions.addAll(postActions);
        }
        if (!newPostActions.isEmpty()) {
            this.postActionService.remove((Wrapper)new LambdaQueryWrapper().in(SysActPostAction::getProcDefId, importProcessIds));
            this.postActionService.saveBatch(newPostActions);
        }
    }

    private void importCcTaskConfigs(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newCcTaskConfigs = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String ccTaskConfigMsg : workflowLoadDto.getCcTaskConfigMsgs()) {
            List ccTaskConfigs = JSON.parseArray((String)ccTaskConfigMsg, SysActCcTaskConfig.class);
            if (!HussarUtils.isNotEmpty((Object)ccTaskConfigs)) continue;
            String processKey = ((SysActCcTaskConfig)ccTaskConfigs.get(0)).getProcDefKey();
            Integer version = ((SysActCcTaskConfig)ccTaskConfigs.get(0)).getProcVersion();
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (SysActCcTaskConfig ccTaskConfig : ccTaskConfigs) {
                ccTaskConfig.setId(null);
            }
            newCcTaskConfigs.addAll(ccTaskConfigs);
        }
        if (!newCcTaskConfigs.isEmpty()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (String importProcessId : importProcessIds) {
                queryWrapper.or(qu -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qu.eq(SysActCcTaskConfig::getProcDefKey, (Object)importProcessId.split(":")[0])).eq(SysActCcTaskConfig::getProcVersion, (Object)importProcessId.split(":")[1]);
                });
            }
            this.ccTaskConfigService.remove((Wrapper)queryWrapper);
            this.ccTaskConfigService.saveBatch(newCcTaskConfigs);
        }
    }

    private void importAlternativeTasks(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newAlternativeTasks = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String alternativeTaskMsg : workflowLoadDto.getAlternativeTaskMsgs()) {
            List alternativeTasks = JSON.parseArray((String)alternativeTaskMsg, AlternativeTask.class);
            if (!HussarUtils.isNotEmpty((Object)alternativeTasks)) continue;
            String processKey = ((AlternativeTask)alternativeTasks.get(0)).getProcessKey();
            Integer version = ((AlternativeTask)alternativeTasks.get(0)).getProcessDefinitionVersion();
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (AlternativeTask alternativeTask : alternativeTasks) {
                alternativeTask.setAlternativeTaskId(null);
            }
            newAlternativeTasks.addAll(alternativeTasks);
        }
        if (!newAlternativeTasks.isEmpty()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (String importProcessId : importProcessIds) {
                queryWrapper.or(qu -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)qu.eq(AlternativeTask::getProcessKey, (Object)importProcessId.split(":")[0])).eq(AlternativeTask::getProcessDefinitionVersion, (Object)importProcessId.split(":")[1]);
                });
            }
            this.alternativeTaskService.remove((Wrapper)queryWrapper);
            this.alternativeTaskService.saveBatch(newAlternativeTasks);
        }
    }

    private void importFormDatas(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newFormDatas = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String formDataMsg : workflowLoadDto.getFormDataMsgs()) {
            List formDatas = JSON.parseArray((String)formDataMsg, SysActFormData.class);
            if (!HussarUtils.isNotEmpty((Object)formDatas)) continue;
            String processDefinitionId = ((SysActFormData)formDatas.get(0)).getProcessId();
            String processKey = processDefinitionId.split(":")[0];
            Integer version = Integer.parseInt(processDefinitionId.split(":")[1]);
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (SysActFormData formData : formDatas) {
                formData.setProcessId(newProcessDefinitionId);
                formData.setId(null);
            }
            newFormDatas.addAll(formDatas);
        }
        if (!newFormDatas.isEmpty()) {
            this.formDataService.remove((Wrapper)new LambdaQueryWrapper().in(SysActFormData::getProcessId, importProcessIds));
            this.formDataService.saveBatch(newFormDatas);
        }
    }

    private void importReturnToRectifications(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newReturnToRectifications = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String returnToRectificationMsg : workflowLoadDto.getReturnToRectificationMsgs()) {
            List returnToRectifications = JSON.parseArray((String)returnToRectificationMsg, ReturnToRectification.class);
            if (!HussarUtils.isNotEmpty((Object)returnToRectifications)) continue;
            String processDefinitionId = ((ReturnToRectification)returnToRectifications.get(0)).getProcessId();
            String processKey = processDefinitionId.split(":")[0];
            Integer version = Integer.parseInt(processDefinitionId.split(":")[1]);
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (ReturnToRectification returnToRectification : returnToRectifications) {
                returnToRectification.setProcessId(newProcessDefinitionId);
                returnToRectification.setId(null);
            }
            newReturnToRectifications.addAll(returnToRectifications);
        }
        if (!newReturnToRectifications.isEmpty()) {
            this.returnToRectificationService.remove((Wrapper)new LambdaQueryWrapper().in(ReturnToRectification::getProcessId, importProcessIds));
            this.returnToRectificationService.saveBatch(newReturnToRectifications);
        }
    }

    private void importRectificationActions(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newRectificationActions = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String rectificationActionMsg : workflowLoadDto.getRectificationActionMsgs()) {
            List rectificationActions = JSON.parseArray((String)rectificationActionMsg, BpmActRectificationAction.class);
            if (!HussarUtils.isNotEmpty((Object)rectificationActions)) continue;
            String processDefinitionId = ((BpmActRectificationAction)rectificationActions.get(0)).getProcessId();
            String processKey = processDefinitionId.split(":")[0];
            Integer version = Integer.parseInt(processDefinitionId.split(":")[1]);
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            for (BpmActRectificationAction rectificationAction : rectificationActions) {
                rectificationAction.setProcessId(newProcessDefinitionId);
                rectificationAction.setId(null);
            }
            newRectificationActions.addAll(rectificationActions);
        }
        if (!newRectificationActions.isEmpty()) {
            this.rectificationAction.remove((Wrapper)new LambdaQueryWrapper().in(BpmActRectificationAction::getProcessId, importProcessIds));
            this.rectificationAction.saveBatch(newRectificationActions);
        }
    }

    private void importBusinessModules(WorkflowLoadDto workflowLoadDto) {
        ArrayList newBusinessModules = new ArrayList();
        for (String businessModuleMsg : workflowLoadDto.getBusinessModuleMsgs()) {
            List businessModules = JSON.parseArray((String)businessModuleMsg, BpmBusinessModule.class);
            if (!HussarUtils.isNotEmpty((Object)businessModules)) continue;
            newBusinessModules.addAll(businessModules);
        }
        HashSet tempSet = new HashSet();
        List unduplicatedBusinessModules = newBusinessModules.stream().filter(o -> tempSet.add(o.getBusinessModuleId())).collect(Collectors.toList());
        if (!unduplicatedBusinessModules.isEmpty()) {
            this.businessModuleService.remove((Wrapper)new LambdaQueryWrapper().in(BpmBusinessModule::getBusinessModuleId, tempSet));
            this.businessModuleService.saveBatch(unduplicatedBusinessModules);
        }
    }

    private void importProcessGroups(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newProcessGroups = new ArrayList();
        ArrayList<String> processGroupNumbers = new ArrayList<String>();
        for (String processGroupMsg : workflowLoadDto.getProcessGroupMsgs()) {
            List processGroups = JSON.parseArray((String)processGroupMsg, ProcessGroup.class);
            if (!HussarUtils.isNotEmpty((Object)processGroups)) continue;
            String processKey = ((ProcessGroup)processGroups.get(0)).getProcessKey();
            Integer version = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportVersion();
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            for (ProcessGroup processGroup : processGroups) {
                processGroup.setMainProcDefId(newProcessDefinitionId);
                processGroup.setProcGroupId(null);
                processGroupNumbers.add(processGroup.getGroupNumber());
            }
            newProcessGroups.addAll(processGroups);
        }
        if (!newProcessGroups.isEmpty()) {
            this.processGroupService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessGroup::getGroupNumber, processGroupNumbers));
            this.processGroupService.saveBatch(newProcessGroups);
        }
    }

    private void importProcessDepts(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newProcessDepts = new ArrayList();
        ArrayList<String> processGroupNumbers = new ArrayList<String>();
        for (String processDeptMsg : workflowLoadDto.getProcessDeptMsgs()) {
            String processKey;
            String type;
            List processDepts = JSON.parseArray((String)processDeptMsg, SysActProcessDept.class);
            if (!HussarUtils.isNotEmpty((Object)processDepts) || "unable".equals(type = ((WorkflowMigrationPreloadVo)importMap.get(processKey = ((SysActProcessDept)processDepts.get(0)).getProcessKey())).getImportType())) continue;
            for (SysActProcessDept processDept : processDepts) {
                processDept.setId(null);
                processGroupNumbers.add(processDept.getProcGroupNumber());
            }
            newProcessDepts.addAll(processDepts);
        }
        if (!newProcessDepts.isEmpty()) {
            this.sysActProcessDeptService.remove((Wrapper)new LambdaQueryWrapper().in(SysActProcessDept::getProcGroupNumber, processGroupNumbers));
            this.sysActProcessDeptService.saveBatch(newProcessDepts);
        }
    }

    private void importProcessDefinitions(WorkflowLoadDto workflowLoadDto) {
        Map importMap = workflowLoadDto.getImportMsgMap();
        ArrayList newProcessDefinitions = new ArrayList();
        ArrayList<String> importProcessIds = new ArrayList<String>();
        for (String processDefinitionMsg : workflowLoadDto.getProcessDefinitionMsgs()) {
            List processDefinitions = JSON.parseArray((String)processDefinitionMsg, ProcessExtendProperties.class);
            if (!HussarUtils.isNotEmpty((Object)processDefinitions)) continue;
            String processKey = ((ProcessExtendProperties)processDefinitions.get(0)).getProcessKey();
            Integer version = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportVersion();
            String type = ((WorkflowMigrationPreloadVo)importMap.get(processKey)).getImportType();
            if ("unable".equals(type)) continue;
            String newProcessDefinitionId = this.processDefinitionsMapper.getProcessDefIdByVersion(processKey, version);
            importProcessIds.add(newProcessDefinitionId);
            ProcessExtendProperties newProcessDefinition = (ProcessExtendProperties)((LambdaQueryChainWrapper)this.processDefinitionsService.lambdaQuery().eq(ProcessExtendProperties::getId, (Object)newProcessDefinitionId)).one();
            for (ProcessExtendProperties processDefinition : processDefinitions) {
                processDefinition.setId(newProcessDefinitionId);
                processDefinition.setDeploymentId(newProcessDefinition.getDeploymentId());
            }
            newProcessDefinitions.addAll(processDefinitions);
        }
        if (!newProcessDefinitions.isEmpty()) {
            this.processDefinitionsService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessExtendProperties::getId, importProcessIds));
            this.processDefinitionsService.saveBatch(newProcessDefinitions);
        }
    }

    private Boolean importModel(String xml, String lcdpbpm, String serviceName, boolean isOverride) {
        List oldSysActProcessFiles;
        String processKey;
        BpmnModel bpmnModel = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            XMLStreamReader xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String identityId = this.modelMapper.getIdByIdentity(modelKey);
        List sysActProcessFiles = JSON.parseArray((String)lcdpbpm, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        boolean needModify = false;
        String workFlowName = null;
        String processId = null;
        if (!isOverride) {
            List oldSysActProcessFiles2 = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles2)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles2) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            if (HussarUtils.isEmpty((Object)identityId)) {
                Model modelData = this.repositoryService.newModel();
                ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                modelObjectNode.put("name", impModelName);
                modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                modelObjectNode.put("revision", 1);
                modelData.setMetaInfo(modelObjectNode.toString());
                modelData.setName(impModelName);
                modelData.setKey(modelKey);
                modelData.setCategory(serviceName);
                this.repositoryService.saveModel(modelData);
                identityId = modelData.getId();
            }
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
            this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
            if (workFlow == null) {
                logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
            }
            workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
            this.sysActProcessFileService.updateFile(workFlow, Integer.valueOf(0));
            processId = this.modelService.deployModel(Long.valueOf(Long.parseLong(identityId)));
        } else {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(processKey);
            int version = Integer.parseInt(((SysActProcessFile)sysActProcessFiles.get(0)).getProcessId().split(":")[1]);
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)version)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            int overVersion = Integer.parseInt(this.processDefinitionsMapper.getMainOrNew(processKey).get(0).getVersion());
            needModify = overVersion == version;
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        processId = String.valueOf(oldSysActProcessFile.getProcessId());
                        file.setProcessId(processId);
                        file.setVersion(Integer.valueOf(version));
                        if ("wfd".equals(file.getType())) {
                            wfdList.add(file);
                            continue;
                        }
                        metaList.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(version));
                if ("wfd".equals(file.getType())) {
                    wfdList.add(file);
                    continue;
                }
                metaList.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metaList) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                workFlowName = workFlow.getName();
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfdList);
            addList.addAll(metaList);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getModelId(version, processKey)) ? Long.valueOf(this.bpm2XMLMapper.getModelId(version, processKey)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.updateProcessName(processId, workFlowName);
            this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processId));
        }
        if (needModify) {
            processKey = ((SysActProcessFile)sysActProcessFiles.get(0)).getProcessKey();
            ArrayList<SysActProcessFile> wfds = new ArrayList<SysActProcessFile>();
            ArrayList<SysActProcessFile> metas = new ArrayList<SysActProcessFile>();
            oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)modelKey));
            for (SysActProcessFile file : sysActProcessFiles) {
                if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                    for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                        if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                        file.setId(oldSysActProcessFile.getId());
                        file.setVersion(Integer.valueOf(0));
                        file.setProcessId(null);
                        if ("wfd".equals(file.getType())) {
                            wfds.add(file);
                            continue;
                        }
                        metas.add(file);
                    }
                    continue;
                }
                file.setId(null);
                file.setVersion(Integer.valueOf(0));
                file.setProcessId(null);
                if ("wfd".equals(file.getType())) {
                    wfds.add(file);
                    continue;
                }
                metas.add(file);
            }
            for (SysActProcessFile sysActProcessFile : metas) {
                WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                if (HussarUtils.isNotEmpty((Object)identityId)) {
                    workFlow.setModelId(Long.valueOf(identityId));
                    workFlow.setProcDefId(processId);
                }
                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            for (SysActProcessFile sysActProcessFile : wfdList) {
                if (!HussarUtils.isNotEmpty((Object)identityId)) continue;
                sysActProcessFile.setModelId(Long.valueOf(identityId));
            }
            ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
            addList.addAll(wfds);
            addList.addAll(metas);
            this.sysActProcessFileService.saveOrUpdateBatch(addList);
            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
            Long id = HussarUtils.isNotEmpty((Object)this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId))) ? this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)) : null;
            updateByteArrayModel.setId(id);
            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
            this.processDefinitionsMapper.setNameAndDeploymentId(workFlowName, null, processKey);
        }
        return true;
    }

    public BpmResponseResult selectByName(WorkflowQueryDto workflowQueryDto) {
        List<WorkflowQueryVo> workflowQueryList = this.queryModelList((Page<WorkflowQueryVo>)workflowQueryDto.getPage(), workflowQueryDto.getName());
        Set<String> processKeys = this.listProcessKeysByWorkflowQueryVos(workflowQueryList);
        List<ProcessDefinitionVo> processDefinitions = this.listProcessDefinitonsByProcessKeys(processKeys);
        Set<String> processGroupNumbers = this.listProcessGroupNumbersByProcessDefinitions(processDefinitions);
        List<ProcessGroup> processGroups = this.listProcessGroupsByProcessGroupNumbers(processGroupNumbers);
        this.neatenWorkflowQueryVo(workflowQueryList, processDefinitions, processGroups);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)workflowQueryDto.getPage().setRecords(workflowQueryList));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public List<WorkflowQueryVo> queryModelList(Page<WorkflowQueryVo> page, String processName) {
        return this.workflowMigrationMapper.queryModelList(page, processName);
    }

    private Set<String> listProcessKeysByWorkflowQueryVos(List<WorkflowQueryVo> workflowQueryList) {
        if (workflowQueryList != null) {
            return workflowQueryList.stream().map(WorkflowQueryVo::getProcessKey).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private List<ProcessDefinitionVo> listProcessDefinitonsByProcessKeys(Set<String> processKeys) {
        return this.processDefinitionsService.listProcessByProcessKeys(new ArrayList<String>(processKeys));
    }

    private Set<String> listProcessGroupNumbersByProcessDefinitions(List<ProcessDefinitionVo> processDefinitions) {
        if (processDefinitions != null) {
            return processDefinitions.stream().map(ProcessDefinitionVo::getProcessGroupNumber).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private List<ProcessGroup> listProcessGroupsByProcessGroupNumbers(Set<String> processGroupNumbers) {
        if (processGroupNumbers.size() != 0) {
            return ((LambdaQueryChainWrapper)this.processGroupService.lambdaQuery().in(ProcessGroup::getGroupNumber, processGroupNumbers)).list();
        }
        return new ArrayList<ProcessGroup>();
    }

    private void neatenWorkflowQueryVo(List<WorkflowQueryVo> workflowQueryList, List<ProcessDefinitionVo> processDefinitions, List<ProcessGroup> processGroups) {
        Map<String, List<ProcessGroup>> processGroupsUnderSameProcessKey = this.groupProcessGroupByProcessKey(processGroups);
        Map<String, List<ProcessDefinitionVo>> processDefinitionUnderSameGroup = this.groupProcessDefinitionByGroupNumber(processDefinitions);
        for (WorkflowQueryVo workflowQueryVo : workflowQueryList) {
            String processKey = workflowQueryVo.getProcessKey();
            List processGroupNumbers = processGroupsUnderSameProcessKey.get(processKey).stream().map(ProcessGroup::getGroupNumber).collect(Collectors.toList());
            Map<String, ProcessGroupVo> processGroupMap = this.assembleProcessGroupMap(processGroupsUnderSameProcessKey, processDefinitionUnderSameGroup, processKey);
            String defaultProcessGroupNumber = (String)processGroupNumbers.get(0);
            ProcessGroupVo defaultProcessGroup = processGroupMap.get(defaultProcessGroupNumber);
            String defaultProcessDefinitionId = (String)defaultProcessGroup.getProcessDefinitionIds().get(0);
            workflowQueryVo.setProcessDefinitionId(defaultProcessDefinitionId);
            workflowQueryVo.setDefaultProcessGroupNumber(defaultProcessGroupNumber);
            workflowQueryVo.setProcessGroupNumbers(processGroupNumbers);
            workflowQueryVo.setProcessGroup(processGroupMap);
        }
    }

    private Map<String, List<ProcessGroup>> groupProcessGroupByProcessKey(List<ProcessGroup> processGroups) {
        if (processGroups != null) {
            return processGroups.stream().collect(Collectors.groupingBy(ProcessGroup::getProcessKey, Collectors.toList()));
        }
        return new HashMap<String, List<ProcessGroup>>();
    }

    private Map<String, List<ProcessDefinitionVo>> groupProcessDefinitionByGroupNumber(List<ProcessDefinitionVo> processDefinitions) {
        if (processDefinitions != null) {
            return processDefinitions.stream().collect(Collectors.groupingBy(ProcessDefinitionVo::getProcessGroupNumber, Collectors.toList()));
        }
        return new HashMap<String, List<ProcessDefinitionVo>>();
    }

    private Map<String, ProcessGroupVo> assembleProcessGroupMap(Map<String, List<ProcessGroup>> processGroupsUnderSameProcessKey, Map<String, List<ProcessDefinitionVo>> processDefinitionUnderSameGroup, String processKey) {
        HashMap<String, ProcessGroupVo> processGroupVos = new HashMap<String, ProcessGroupVo>();
        List<ProcessGroup> processGroups = processGroupsUnderSameProcessKey.get(processKey);
        for (ProcessGroup processGroup : processGroups) {
            String processGroupNumber = processGroup.getGroupNumber();
            String processGroupName = processGroup.getGroupName();
            List<ProcessDefinitionVo> processDefinitions = processDefinitionUnderSameGroup.get(processGroupNumber);
            ProcessGroupVo processGroupVo = this.assembleProcessGroupVo(processDefinitions, processGroupNumber, processGroupName);
            processGroupVos.put(processGroupNumber, processGroupVo);
        }
        return processGroupVos;
    }

    private ProcessGroupVo assembleProcessGroupVo(List<ProcessDefinitionVo> processDefinitions, String processGroupNumber, String processGroupName) {
        ArrayList processDefinitionIds = new ArrayList();
        HashMap processGroupVersionMap = new HashMap();
        HashMap processVersionMap = new HashMap();
        processDefinitions.forEach(processDefinition -> {
            String processDefinitionId = processDefinition.getProcessDefinitionId();
            Integer processGroupVersion = processDefinition.getProcessGroupVersion();
            Integer processVersion = Integer.parseInt(processDefinition.getProcessVersion());
            processDefinitionIds.add(processDefinitionId);
            processGroupVersionMap.put(processDefinitionId, processGroupVersion);
            processVersionMap.put(processDefinitionId, processVersion);
        });
        List processDefinitionIdsAfterSort = processDefinitionIds.stream().sorted(Comparator.comparing(st -> st)).collect(Collectors.toList());
        ProcessGroupVo processGroupVo = new ProcessGroupVo();
        processGroupVo.setProcessGroupNumber(processGroupNumber);
        processGroupVo.setProcessGroupName(processGroupName);
        processGroupVo.setProcessDefinitionIds(processDefinitionIdsAfterSort);
        processGroupVo.setProcessGroupVersion(processGroupVersionMap);
        processGroupVo.setProcessVersion(processVersionMap);
        return processGroupVo;
    }
}

