/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.model.UserDepartmentAndPostModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.utils.CcTaskUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.model.SysActCcTaskConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.cctaskconfig.service.ISysActCcTaskConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.ProcessStateChangeLis;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.ProcessState;
import com.jxdinfo.hussar.workflow.godaxe.service.SysActFormDataApiService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private BpmMsgPushService msgPushService;
    @Autowired
    private ISysActCcTaskService sysActCcTaskService;
    @Autowired
    private ISysActCcTaskConfigService sysActCcTaskConfigService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private SysActFormDataApiService sysActFormDataApiService;
    @Resource
    private SeqBuilder seqBuilder;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private ProcessStateChangeLis processStateChangeLis;
    private static Logger logger = LogManager.getLogger(ProcessCompleteListener.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        logger.info("ProcessCompleteListener\u5f00\u59cb------------------------------");
        String sendId = "";
        ExecutionEntity entity = (ExecutionEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "processCompleteEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("completeTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("processInsId", entity.getId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        map.put("businessId", entity.getBusinessKey());
        List linkEntityList = entity.getIdentityLinks();
        if (!linkEntityList.isEmpty()) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
            sendId = ((IdentityLinkEntity)linkEntityList.get(0)).getUserId();
        }
        logger.info("\u5904\u7406\u8d85\u65f6\u4efb\u52a1\u5f00\u59cb------------------------------");
        CommonCodeUtil.triggerEventHandleClass(map);
        logger.info("\u5904\u7406\u8d85\u65f6\u4efb\u52a1\u7ed3\u675f------------------------------");
        ProcessState processState = null;
        if (!entity.getTasks().isEmpty()) {
            logger.info("\u5220\u9664\u50ac\u529e\u4fe1\u606f------------------------------");
            for (TaskEntity taskEntity : entity.getTasks()) {
                this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
            }
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            logger.info("\u6d88\u606f\u63a8\u9001------------------------------");
            if ("endProcess".equals(BpmAttribute.getTaskSourceFlag((ActivityExecution)entity))) {
                this.endProcessMsgPush(map);
            } else {
                this.completeProcessMsgPush(map);
            }
        }
        logger.info("\u89e6\u53d1\u6d41\u7a0b\u64cd\u4f5c\u76d1\u542c\u5668\u5f00\u59cb------------------------------");
        new ProcessActionCmd(entity.getId(), 1).execute(Context.getCommandContext());
        logger.info("\u89e6\u53d1\u6d41\u7a0b\u64cd\u4f5c\u76d1\u542c\u5668\u7ed3\u675f------------------------------");
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(entity.getProcessDefinitionId());
        logger.info("\u7edf\u4e00\u4ee3\u529e\u53c2\u6570\u83b7\u53d6\u5f00\u59cb------------------------------");
        DataPush dataPush = new DataPush().setProcessInsId(entity.getProcessInstanceId()).setEndDate(new Date());
        logger.error(dataPush.toString());
        HistoricProcessInstanceEntity processInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId());
        if (HussarUtils.isNotEmpty((Object)processInstance)) {
            logger.info("StartUserId:{}ProcessName:{}ProcessStartTime:{}TenantCode:{}", (Object)processInstance.getStartUserId(), (Object)processInstance.getName(), (Object)processInstance.getStartUserId(), (Object)processInstance.getStartUserId(), (Object)processInstance.getTenantCode());
            dataPush.setStartUserId(processInstance.getStartUserId()).setProcessName(processInstance.getName()).setProcessStartTime(processInstance.getStartTime()).setTenantCode(processInstance.getTenantCode());
        }
        if (entity.getProcessInstance().getSuperExecution() == null && "rectification".equals(Context.getCommandContext().getAttribute("approvalType"))) {
            logger.info("\u8fd4\u56de\u6574\u6539\u76f8\u5173------------------------------");
            map.remove("type");
            map.put("approvalType", "rectification");
            HistoricProcessInstanceEntity historicProcessInstance = this.rectificationProcess(map, processInstance);
            processState = ProcessState.RECTIFICATION;
            dataPush.setUrl(historicProcessInstance.getRectificationFormKey());
            dataPush.setBusinessKey(historicProcessInstance.getRectificationBusinessKey());
        }
        if (entity.getProcessInstance().getSuperExecution() == null) {
            logger.info("\u6d41\u7a0b\u6b63\u5e38\u7ed3\u675f------------------------------");
            String endUserId = "";
            if (!linkEntityList.isEmpty()) {
                endUserId = ((IdentityLinkEntity)linkEntityList.get(linkEntityList.size() - 1)).getUserId();
            }
            ProcessDefinition processDefinition = (ProcessDefinition)ProcessEngines.getDefaultProcessEngine().getRepositoryService().createProcessDefinitionQuery().processDefinitionId(entity.getProcessDefinitionId()).singleResult();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(SysActCcTaskConfig::getProcDefKey, (Object)entity.getProcessDefinitionKey())).eq(SysActCcTaskConfig::getProcVersion, (Object)(processDefinition.getRealVersion() != null ? processDefinition.getRealVersion().intValue() : processDefinition.getVersion()));
            if ("skip".equals(Context.getCommandContext().getAttribute("skip")) || "accept".equals(Context.getCommandContext().getAttribute("approvalType")) || "agree".equals(Context.getCommandContext().getAttribute("approvalType"))) {
                queryWrapper.eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_pass");
                processState = ProcessState.APPROVED;
                this.sendCcTask(sendId, entity, (LambdaQueryWrapper<SysActCcTaskConfig>)queryWrapper);
            } else if ("disagree".equals(Context.getCommandContext().getAttribute("approvalType"))) {
                queryWrapper.eq(SysActCcTaskConfig::getChanceType, (Object)"cc_after_process_un_pass");
                processState = ProcessState.UNAPPROVED;
                this.sendCcTask(sendId, entity, (LambdaQueryWrapper<SysActCcTaskConfig>)queryWrapper);
            } else if ("suspend".equals(Context.getCommandContext().getAttribute("approvalType"))) {
                processState = ProcessState.SUSPEND;
            }
        }
        if (processState == null) {
            processState = ProcessState.UNKNOWN;
        }
        this.updateProcessState(entity, processState);
        this.dataPushService.updateProcess(dataPush.setProcessState(processState.getValue()));
    }

    private void updateProcessState(ExecutionEntity entity, ProcessState processState) {
        Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(entity.getProcessInstanceId()).setProcessState(processState.getValue());
        this.processStateChangeLis.ProcessStateChange((ProcessInstance)entity.getProcessInstance(), processState);
    }

    private HistoricProcessInstanceEntity rectificationProcess(Map<String, Object> map, HistoricProcessInstanceEntity historicProcessInstance) {
        try {
            String processDefinitionId = map.get("processDefinitionId").toString();
            ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionById(processDefinitionId);
            if (processDefinition.getRealVersion() != null) {
                processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionByKeyAndVersion(processDefinition.getKey(), processDefinition.getRealVersion());
                processDefinitionId = processDefinition.getId();
            }
            ProcessExtendProperties processExtendProperties = this.processDefinitionsMapper.getProcessExtendProperties(processDefinitionId);
            String rectificationBusinessId = null;
            rectificationBusinessId = this.generateRectificationBusinessId();
            try {
                this.sysActFormDataApiService.copyDateBase(processDefinitionId, rectificationBusinessId, map.get("businessId").toString(), historicProcessInstance.getProcessInstanceId());
            }
            catch (Exception e) {
                logger.error("\u8fd4\u56de\u6574\u6539\u64cd\u4f5c\u6267\u884c\u5931\u8d25", (Throwable)e);
            }
            historicProcessInstance.setRectificationBusinessKey(rectificationBusinessId);
            historicProcessInstance.setRectificationFormKey(processExtendProperties.getEditFormAddress());
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u8fd4\u56de\u6574\u6539\u76d1\u542c\u5668\u5931\u8d25", (Throwable)e);
        }
        return historicProcessInstance;
    }

    private String generateRectificationBusinessId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    private void sendCcTask(String sendId, ExecutionEntity entity, LambdaQueryWrapper<SysActCcTaskConfig> queryWrapper) {
        List configList = this.sysActCcTaskConfigService.list(queryWrapper);
        if (HussarUtils.isNotEmpty((Object)configList)) {
            List<SysActCcTask> ccTaskList = CcTaskUtil.getCcTaskList(entity, configList, sendId, sendId);
            HashSet<String> processDefinitionIdList = new HashSet<String>();
            processDefinitionIdList.add(entity.getProcessDefinitionId());
            if (HussarUtils.isNotEmpty(ccTaskList)) {
                ArrayList<DataPush> dataPushes = new ArrayList<DataPush>();
                String url = this.dataPushService.getCcUrl(entity.getProcessDefinitionId(), "9");
                for (SysActCcTask sysActCcTask : ccTaskList) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    userIds.add(sysActCcTask.getReceiveUser());
                    Map list1 = this.iAssigneeChooseService.getUserDepartmentAndPostModelByUserIds(userIds);
                    sysActCcTask.setPostId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getPostId());
                    sysActCcTask.setPostOrganId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getDepartmentId());
                    sysActCcTask.setPostUnitId(((UserDepartmentAndPostModel)list1.get(sysActCcTask.getReceiveUser())).getUnitId());
                    long id = IdWorker.getId((Object)sysActCcTask);
                    sysActCcTask.setId(Long.valueOf(id));
                    if (!this.dataPushService.isDataPush(processDefinitionIdList)) continue;
                    DataPush dataPush = new DataPush();
                    dataPush.setDataPushId(sysActCcTask.getId().toString());
                    dataPush.setTaskId(sysActCcTask.getTaskId() != null ? sysActCcTask.getTaskId().toString() : null);
                    dataPush.setUserId(sysActCcTask.getReceiveUser());
                    dataPush.setSendUser(sysActCcTask.getSendUser());
                    dataPush.setStartDate((Date)sysActCcTask.getSendTime());
                    dataPush.setProcessInsId(sysActCcTask.getProcessInsId().toString());
                    dataPush.setBusinessKey(sysActCcTask.getBusinessId());
                    dataPush.setTaskDefinitionKey(sysActCcTask.getTaskDefKey());
                    dataPush.setUrl(url);
                    dataPush.setProcessKey(sysActCcTask.getProcDefKey());
                    dataPush.setDeptId(sysActCcTask.getPostOrganId());
                    dataPush.setUnitId(sysActCcTask.getPostUnitId());
                    dataPush.setPostId(sysActCcTask.getPostId());
                    dataPushes.add(dataPush);
                }
                this.sysActCcTaskService.saveBatch(ccTaskList);
                if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                    this.dataPushService.addCcTask(dataPushes);
                }
            }
        }
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void endProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("terminated");
        if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
        }
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void completeProcessMsgPush(Map<String, Object> map) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        this.addMessage(map, bpmActMsgDetail);
        bpmActMsgDetail.setSceneCode("complete");
        if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            bpmActMsgDetail.setTenantId(BaseSecurityUtil.getUser().getTenantId());
        }
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }

    private void addMessage(Map<String, Object> map, BpmActMsgDetail bpmActMsgDetail) {
        bpmActMsgDetail.setProcessName(map.get("processDefinitionName").toString());
        bpmActMsgDetail.setProcessDefinitionId(map.get("processDefinitionId").toString());
        bpmActMsgDetail.setProcessKey(map.get("processDefinitionId").toString().split(":")[0]);
        ArrayList<String> user = new ArrayList<String>();
        user.add(map.get("starter").toString());
        bpmActMsgDetail.setReceive(user);
    }
}

