/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.TaskRejectModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpNodeLeaveAddCcTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.JumpToTargetNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.model.BpmActPendingTask;
import com.jxdinfo.hussar.workflow.engine.bpm.pendingtask.service.BpmActPendingTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class CommonJumpTaskCmd
extends AddAttributeCmd<Void> {
    private String userId;
    private String executionId;
    private String taskId;
    private JumpModel jumpModel;
    private String comment;
    private String type;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private TaskRejectModel taskRejectModel;
    private String mandator;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getBean(TaskEngineMapper.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);
    private ProcessEngine processEngine = (ProcessEngine)SpringContextHolder.getApplicationContext().getBean(ProcessEngine.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ITaskEngineService iTaskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private SysActCcTaskMapper sysActCcTaskMapper = (SysActCcTaskMapper)SpringContextHolder.getBean(SysActCcTaskMapper.class);
    private BpmActPendingTaskService pendingTaskService = (BpmActPendingTaskService)SpringContextHolder.getBean(BpmActPendingTaskService.class);

    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        this.addExecutionAttribute(executionEntity);
        this.type = BpmAttribute.getTaskSourceFlag((ActivityExecution)executionEntity);
        boolean needRemoveTask = "revoke".equals(this.type) || "reject_revoke".equals(this.type);
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        ParamModel paramModel = new ParamModel();
        paramModel.mappingCompleteType(this.type);
        paramModel.mappingToCreateReason(this.type);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        List executionEntities = executionEntity.getExecutions();
        for (int i = executionEntities.size() - 1; i >= 0; --i) {
            ExecutionEntity ee = (ExecutionEntity)executionEntities.get(i);
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        if (needRemoveTask) {
            ArrayList<Long> longDelTaskIds = new ArrayList<Long>();
            ArrayList<String> delTaskIds = new ArrayList<String>();
            for (TaskEntity taskEntity : taskEntities) {
                longDelTaskIds.add(Long.parseLong(taskEntity.getId().replace("'", "")));
                delTaskIds.add(taskEntity.getId().replace("'", ""));
            }
            if (!delTaskIds.isEmpty()) {
                this.iTaskEngineService.removeMultiHistoryTask(longDelTaskIds);
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(SysActCcTask::getTaskId, longDelTaskIds);
                this.sysActCcTaskMapper.delete((Wrapper)lambdaQueryWrapper);
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                processDefinitionIdList.add(executionEntity.getProcessDefinitionId());
                if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                    DataPush dataPush = new DataPush();
                    dataPush.setProcessKey(executionEntity.getProcessDefinitionKey());
                    dataPush.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
                    dataPush.setTaskIds(delTaskIds);
                    dataPush.setComment(this.comment);
                    this.dataPushService.deleteMultiTask(dataPush);
                }
            }
        }
        ArrayList<BpmActPendingTask> pendingTasks = new ArrayList<BpmActPendingTask>();
        for (TaskEntity taskEntity : taskEntities) {
            if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            if (taskEntity.getParentTaskId() != null) {
                Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, null, true);
                continue;
            }
            if (taskEntity.getId().equals(this.taskId) && taskEntity.getAssignee() == null && this.userId != null) {
                taskEntity.setAssignee(this.userId, true, true);
            }
            paramModel = this.getParamModel(taskEntity, this.taskRejectModel);
            Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
            taskEntity.fireEvent("complete");
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityWithVariablesEvent((ActivitiEventType)ActivitiEventType.TASK_COMPLETED, (Object)taskEntity, null, (boolean)false));
            if (this.taskRejectModel != null) {
                taskEntity.setApprovalType(this.taskRejectModel.getApprovalType());
                if (this.taskRejectModel.getIdentityLink() != null) {
                    taskEntity.setDeptId(this.taskRejectModel.getIdentityLink().getDeptId());
                    taskEntity.setPostId(this.taskRejectModel.getIdentityLink().getPostId());
                    taskEntity.setUnitId(this.taskRejectModel.getIdentityLink().getUnitId());
                }
                if ("reject".equals(this.taskRejectModel.getApprovalType())) {
                    for (IdentityLinkEntity identityLink : taskEntity.getIdentityLinks()) {
                        BpmActPendingTask bpmActPendingTask = new BpmActPendingTask();
                        bpmActPendingTask.setTaskDefKey(taskEntity.getTaskDefinitionKey());
                        bpmActPendingTask.setTaskName(taskEntity.getName());
                        bpmActPendingTask.setFormKey(taskEntity.getFormKey());
                        bpmActPendingTask.setProcDefId(executionEntity.getProcessDefinitionId());
                        bpmActPendingTask.setProcessKey(executionEntity.getProcessDefinitionKey());
                        bpmActPendingTask.setBusinessId(executionEntity.getBusinessKey());
                        bpmActPendingTask.setPendingType("1");
                        bpmActPendingTask.setIsMain("1");
                        bpmActPendingTask.setOwner(identityLink.getMandator() != null ? identityLink.getMandator() : identityLink.getUserId());
                        bpmActPendingTask.setAssignee(identityLink.getUserId());
                        bpmActPendingTask.setPosition(identityLink.getPostId());
                        bpmActPendingTask.setDeptId(identityLink.getDeptId());
                        pendingTasks.add(bpmActPendingTask);
                    }
                }
            }
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "CommonJumpTaskCmd-Completed", needRemoveTask, this.mandator);
        }
        if (!pendingTasks.isEmpty()) {
            this.pendingTaskService.saveBatch(pendingTasks);
        }
        if (HussarUtils.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        if (executionEntity.getActivityId() != null) {
            new JumpNodeLeaveAddCcTaskCmd(executionEntity).execute(commandContext);
        }
        this.processEngine.getManagementService().executeCommand((Command)new JumpToTargetNodeCmd(executionEntity, this.comment, this.jumpModel, this.userId, this.type, this.taskRejectModel != null && this.taskRejectModel.isSubmit(), this.paramvar));
        return null;
    }

    public CommonJumpTaskCmd(String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.type = type;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskRejectModel = taskRejectModel;
    }

    public CommonJumpTaskCmd(String taskId, String userId, String mandator, String executionId, JumpModel jumpModel, String comment, String type, Map<String, Object> paramvar, ActivityImpl currentActivity, TaskRejectModel taskRejectModel) {
        this.taskId = taskId;
        this.userId = userId;
        this.executionId = executionId;
        this.jumpModel = jumpModel;
        this.comment = comment;
        this.type = type;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.taskRejectModel = taskRejectModel;
    }

    private static String joinStr(List<String> list) {
        return list == null ? null : String.join((CharSequence)",", list);
    }

    public ParamModel getParamModel(TaskEntity task, TaskRejectModel taskRejectModel) {
        ParamModel paramModel = new ParamModel();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setFrom(CommonJumpTaskCmd.joinStr(this.jumpModel.getJumpFrom()));
        paramModel.setTo(CommonJumpTaskCmd.joinStr(this.jumpModel.getJumpTo()));
        if (HussarUtils.isEmpty((Object)taskRejectModel)) {
            paramModel.mappingCompleteType(this.type);
            paramModel.setHandler(this.userId);
            paramModel.setSendUser(this.userId);
            paramModel.mappingToCreateReason(this.type);
            paramModel.setLastNodeId(task.getTaskDefinitionKey());
            paramModel.setLastNodeName(task.getName());
            paramModel.setLastTaskId(task.getId());
            paramModel.mappingLastCompleteType(this.type);
            paramModel.setLastNodeHandler(this.userId);
            return paramModel;
        }
        paramModel.setComment(this.comment);
        paramModel.mappingCompleteType(this.type);
        paramModel.setApprovalType(taskRejectModel.getApprovalType());
        if (HussarUtils.isNotEmpty((Object)taskRejectModel.getTaskId())) {
            if (!task.getId().equals(taskRejectModel.getTaskId())) {
                paramModel.mappingToDeleteType(this.type);
            }
        } else {
            paramModel.mappingToDeleteType(this.type);
        }
        Map targetAssigneeMap = (Map)BpmAttribute.getExecutionAttribute((ActivityExecution)task.getProcessInstance(), "appoint_assignee");
        paramModel.setTargetAssignee(targetAssigneeMap);
        paramModel.setTo(taskRejectModel.getTargetIds());
        paramModel.setFrom(task.getTaskDefinitionKey());
        paramModel.setAffectedNodeId(taskRejectModel.getAllAffectedTaskIds());
        paramModel.setHandler(this.userId);
        paramModel.setSendUser(taskRejectModel.getUserId());
        paramModel.setLastNodeId(taskRejectModel.getTask().getTaskDefinitionKey());
        paramModel.setLastTaskId(taskRejectModel.getTask().getId());
        paramModel.setLastNodeName(taskRejectModel.getTask().getName());
        paramModel.mappingLastCompleteType(this.type);
        paramModel.setLastNodeHandler(this.userId);
        return paramModel;
    }

    public void fireExecutionListener(ExecutionEntity execution) {
        execution.setEventName("end");
        List executionListeners = execution.getActivity().getExecutionListeners("end");
        for (ExecutionListener executionListener : executionListeners) {
            try {
                executionListener.notify((DelegateExecution)execution);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BpmException("\u76d1\u542c\u5668\u6267\u884c\u5931\u8d25");
            }
        }
    }
}

